; $Id: debug.asm , cstrotm $
;
;  RAF Commander - A free File Manager for Atari 8bit
;  Copyright (C) 1999-2000 Regionalgruppe Atari Frankfurt / RAF
;
;  This program is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License
;  as published by the Free Software Foundation; either version 2
;  of the License, or (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;  or visit http://www.gnu.org

; Debugging Routines


; >>>>>>> RAFCDEBUG <<<<<<<
; --
.IF FORTH
NFA_RAFCDEBUG .CBYTE $82, "##"
LFA_RAFCDEBUG .WORD NFA_PREV  ; UPLINK
CFA_RAFCDEBUG .WORD PFA_RAFCDEBUG
NFA_PREF = NFA_RAFCDEBUG
PFA_RAFCDEBUG
    JSR RAFCDEBUG
    JMP NEXT
.ENDIF

RAFCDEBUG
    STX XSAVELOCAL
    LDA #0
    STA COLCRS
    STA ROWCRS
    TXA
    JSR HEX2   
    TSX
    TXA
    JSR HEX2 
    LDX XSAVELOCAL
    RTS

; print accum as two hex digits
HEX2    PHA
        LSR     A
        LSR     A
        LSR     A
        LSR     A
        JSR     HEX2A
        PLA
HEX2A   AND     #$0F
        JSR     HXDGT
        JMP     OUTCH
;
;convert hex digit to ASCII
;
HXDGT   CMP     #$0A
        BCC     HXDGT1
        CLC
        ADC     #7
HXDGT1  ADC     #'0
        RTS


.IF BETA
BETAMSG1    .CBYTE " RAF Commander 2000 BETA V1 "
BETAMSG2    .CBYTE "  25.3.2000 NF ATARI DOS    "
BETAMSG3    .CBYTE "Report Bugs / Suggestions to"
BETAMSG4    .CBYTE "   rafcbugs@strotmann.de    "
BETAMSG5    .CBYTE "  RAF Commander Homepage    "
BETAMSG6    .CBYTE "http://www.strotmann.de/rafc"
BETAMSG7    .CBYTE "Released u. GPL, www.gnu.org"
P_BETAMSG1  .WORD BETAMSG1
P_BETAMSG2  .WORD BETAMSG2
P_BETAMSG3  .WORD BETAMSG3
P_BETAMSG4  .WORD BETAMSG4
P_BETAMSG5  .WORD BETAMSG5
P_BETAMSG6  .WORD BETAMSG6
P_BETAMSG7  .WORD BETAMSG7

BETAMESSAGE
    M_FRAME 4,5,28,9
    M_POS 5,6
    M_PRINT P_BETAMSG1
    M_POS 5,7
    M_PRINT P_BETAMSG2
    M_POS 5,9
    M_PRINT P_BETAMSG3
    M_POS 5,10
    M_PRINT P_BETAMSG4
    M_POS 5,11
    M_PRINT P_BETAMSG5
    M_POS 5,12
    M_PRINT P_BETAMSG6
    M_POS 5,13
    M_PRINT P_BETAMSG7
    JSR GETCH
    M_CHOUT clrscr
    RTS

.ENDIF

