; $Id: equ.asm , cstrotm $
;
;  RAF Commander - A free File Manager for Atari 8bit
;  Copyright (C) 1999-2000 Regionalgruppe Atari Frankfurt / RAF
;
;  This program is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License
;  as published by the Free Software Foundation; either version 2
;  of the License, or (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;  or visit http://www.gnu.org

; Equates and Definitions

cioopen     = 3

ciogetrec   = 5
ciogetchar  = 7
cioputrec   = 8
cioputchar  = 11
cioclose    = 12
ciodelete   = 33
ciolock     = 35
ciounlock   = 36
ciopoint    = 37
cionote     = 38
cioload     = 40
ciosave     = 41
cioformat   = 254

.IF MY_DOS
ciocreatedir = 34
ciochangedir = 41
.ENDIF

.IF SPARTA23 .OR SPARTA_X
ciolockdisk  = 34
ciogetfilelen= 39
ciocreatedir = 42
ciodeletedir = 43
ciochangedir = 44
ciosetboot   = 45
ciounlockdisk= 46
.ENDIF

.IF SPARTA_X
ciosetattr   = 49
.ENDIF

cioread      = 4
ciowrite     = 8
ciodir       = 6

; >>>>> Zero Page <<<<<

DOSVEC = $0A

ICHIDZ = $20
ICDNOZ = $21
ICCOMZ = $22
ICSTAZ = $23
ICBALZ = $24
ICBAHZ = $25
ICPTLZ = $26
ICPTHZ = $27
ICBLLZ = $28
ICBLHZ = $29
ICAX1Z = $2A
ICAX2Z = $2B
ICAX3Z = $2C
ICAX4Z = $2D
ICAX5Z = $2E
ICAX6Z = $2F

ROWCRS = $54
COLCRS = $55
LMARGN = $52

N       = $F0       ; $F0-$FE Free Bytes for RAF Commander Modules
XSAVE   = $FF       ; Save Place for X Register = Datastack Pointer
TIB     = $100      ; Terminal Input Buffer (80 Bytes)

; >>>>> PAGE 2-5 <<<<<<

INVFLG = $2B6
CRSINH = $2F0
CH     = $2FC

; Input/Output Control Block (IOCB)

ICHID  = $340
ICDNO  = $341
ICCOM  = $342
ICSTA  = $343
ICBAL  = $344
ICBAH  = $345
ICPTL  = $346
ICPTH  = $347
ICBLL  = $348
ICBLH  = $349
ICAX1  = $34A
ICAX2  = $34B
ICAX3  = $34C
ICAX4  = $34D
ICAX5  = $34E
ICAX6  = $34F

; Atari OS Vectors

CIOV   = $E456

.IF ATARI_800
  EOUTCH = $F6A4            ; put Value in Accu on Screen  (Atari 800)
  KGETCH = $F6E2            ; get Key from Keyboard and place in Accu (Atari 800) 
.ENDIF

.IF ATARI_XL
  EOUTCH = $F2B0            ; put Value in Accu on Screen  (Atari XL)
  KGETCH = $F2F8            ; get Key from  Keyboard  and place in Accu (Atari XL)
.ENDIF


