; $Id: fileio.asm , cstrotm $
;
;  RAF Commander - A free File Manager for Atari 8bit
;  Copyright (C) 1999-2000 Regionalgruppe Atari Frankfurt / RAF
;
;  This program is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License
;  as published by the Free Software Foundation; either version 2
;  of the License, or (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;  or visit http://www.gnu.org

; DOS File IO Routines


; >>>>>>> READDIR <<<<<<<
; n --
.IF FORTH
NFA_READDIR .CBYTE $87, "READDIR"
LFA_READDIR .WORD NFA_PREV  ; UPLINK
CFA_READDIR .WORD PFA_READDIR
NFA_PREV .= NFA_READDIR
PFA_READDIR
    JSR _READDIR
    JMP POP
.ENDIF

_READDIR   
    STX XSAVELOCAL
    LDA 0,X
    PHA         ; save stack parameter
    BNE L1300   ; 0 = left, 1 = right dir-panel

    LDA DNU0    ; Set Diskdrive Number
    STA DFI0+1
    BNE L1301
L1300
    LDA DNU1    ; Set Diskdrive Number
    STA DFI1+1

L1301
    CLC
    ASL 0,X
    LDY 0,X

    LDA P_0DFIL,Y     ; load 2 Byte parameter
    STA ICBAL+$60
    LDA P_0DFIL+1,Y
    STA ICBAH+$60
    LDA DIRMEM0,Y
    STA ACTDM
    LDA DIRMEM0+1,Y
    STA ACTDM+1

    LDA #0
    STA N

    LDX #$60
    LDA #CIOOPEN
    STA ICCOM,X
    LDA #6              ; Aux1=6 = Read Dir
    STA ICAX1,X
    JSR CIOV
    BMI ERROR
L1302
    LDA #CIOGETREC
    STA ICCOM,X
    
    LDA ACTDM
    STA ICBAL,X
    LDA ACTDM+1
    STA ICBAH,X
    LDA #<$12
    STA ICBLL,X
    LDA #>$12
    STA ICBLH,X
    JSR CIOV

    LDA ICSTA+$60
    BMI ERROR

    LDY #1
    LDA (ICBALZ),Y      ; FILENAME OR FREE SECTORS ?
    CMP #$20
    BEQ L1304

    LDY #3              ; IT'S THE FREE SECTORS LINE
    LDA (ICBALZ),Y      
    ORA #$80
    STA (ICBALZ),Y
    JMP CLOSEDIR

L1304                   ; ENTRY IS FILENAME
    INC N               ; NUMBER OF ENTRIES
    
    LDY #$10
    LDA (ICBALZ),Y
    ORA #$80
    STA (ICBALZ),Y
    DEY
L1305
    LDA (ICBALZ),Y
    AND #$7F
    STA (ICBALZ),Y
    DEY
    BNE L1305
    
L1310        
    CLC
    LDA ACTDM
    ADC RLEN
    STA ACTDM
    BCC L1302
    INC ACTDM+1
    JMP L1302

ERROR    
CLOSEDIR
    LDX #$60
    JSR CLOSECHANNEL    ; close channel 6

    DEC N
    PLA                 ; get stack parameter (left or right)
    TAY

    LDA N
    STA NUMD0,Y
    
    TYA
    CLC
    ASL
    TAY
    LDA ACTDM
    STA DIRMEE0,Y
    LDA ACTDM+1
    STA DIRMEE0+1,Y

    JSR CALCCABS
    LDX XSAVELOCAL
    RTS
;   ---------
L_READLEFT
    LDY #0
    BEQ L_READ
L_READRIGHT
    LDY #1
    BNE L_READ

L_READACT
    LDY ACTFR
L_READ
    STY 0,X
    JMP _READDIR

GETDIR
    DEX
    DEX
    JSR L_READLEFT
    JSR L_READRIGHT
    INX
    INX
    RTS

LOCKFILE
    LDA ACTLOCK
    CMP #'*
    BEQ UNLOCKFILE

    LDA #ciolock
    PHA
    JMP DOCIO

UNLOCKFILE
    LDA #ciounlock
    PHA
    JMP DOCIO

DELETEFILE
    LDA #ciodelete
    PHA
    JMP DOCIO

RUNFILE
    LDA #cioload
    PHA

DOCIO
    LDA 0,X
    PHA
    LDA 1,X
    PHA
    LDX #$60
    PLA
    STA ICBAH,X
    PLA
    STA ICBAL,X
    PLA
    STA ICCOM,X
    JSR CIOV
    JSR CHECKERROR
    RTS

COPYFILE
    JSR GETDESTFILENAME
    JSR OPENSOURCEFILE
    JSR OPENDESTFILE
    JSR DOCOPY
    LDX #$50
    JSR CLOSECHANNEL
    LDX #$60
    JSR CLOSECHANNEL
    RTS

MOVEFILE
    JSR COPYFILE
    LDA P_DSTR
    STA 0,X
    LDA P_DSTR+1
    STA 1,X
    JSR DELETEFILE
    RTS

DOCOPY
    LDX #$60
    LDA #ciogetchar
    STA ICCOM,X
    LDA DIRMEE1
    PHA
    STA ICBAL,X
    LDA DIRMEE1+1
    PHA
    STA ICBAH,X
    LDA COPBUF
    STA ICBLL,X
    LDA COPBUF+1
    STA ICBLH,X
    JSR CIOV        ; Read in Buffer
    JSR CHECKERROR

    LDA ICBLL,X
    PHA
    LDA ICBLH,X
    PHA             ; Get number of bytes in buffer

    LDX #$50
    LDA #cioputchar
    STA ICCOM,X
    PLA
    STA ICBLH,X
    PLA
    STA ICBLL,X
    PLA
    STA ICBAH,X
    PLA
    STA ICBAL,X
    JSR CIOV
    JSR CHECKERROR

    LDX #$60
    LDA ICSTA,X
    BPL DOCOPY

DOCOPYEND
    RTS

OPENSOURCEFILE
    LDX #$60        ; channel 6
    LDA #cioopen
    STA ICCOM,X
    LDA P_DSTR
    STA ICBAL,X
    LDA P_DSTR+1
    STA ICBAH,X
    LDA #cioread
    STA ICAX1,X
    LDA #0
    STA ICAX2,X
    JSR CIOV
    RTS

OPENDESTFILE
    LDX #$50        ; channel 5
    LDA #cioopen
    STA ICCOM,X
    LDA P_CSTR
    STA ICBAL,X
    LDA P_CSTR+1
    STA ICBAH,X
    LDA #ciowrite
    STA ICAX1,X
    LDA #0
    STA ICAX2,X
    JSR CIOV
    RTS

CLOSECHANNEL
    LDA #cioclose
    STA ICCOM,X
    JSR CIOV
    RTS

GETDESTFILENAME
    LDA P_DSTR
    STA N
    LDA P_DSTR+1
    STA N+1
    LDA P_CSTR
    STA N+2
    LDA P_CSTR+1
    STA N+3
    LDY #15
GDF1
    LDA (N),Y
    STA (N+2),Y
    DEY
    BNE GDF1

    LDA ACTFR
    EOR #1      ; get number of inactive frame
    TAY
    LDA DNU,Y
    LDY #1
    STA (N+2),Y ; set opposite Drive number
    RTS

CHECKERROR
    RTS



