; $Id: rafcmain.asm , cstrotm $
;
;  RAF Commander - A free File Manager for Atari 8bit
;  Copyright (C) 1999-2000 Regionalgruppe Atari Frankfurt / RAF
;
;  This program is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License
;  as published by the Free Software Foundation; either version 2
;  of the License, or (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;  or visit http://www.gnu.org

FORTH = 0
.IF .NOT FORTH 
DEBUG = 0
.ENDIF

BETA      = 1

ATARI_800 = 0
ATARI_XL  = 1

ATARI_DOS = 1
MY_DOS    = 0
SPARTA23  = 0
SPARTA_X  = 0

.INCLUDE MACROS.ASM
.INCLUDE EQU.ASM

.IF .NOT FORTH
  * = $4000
  JMP RAFCINIT
.ENDIF

; Padding for FORTH, aligning indirekt Jumps

.IF FORTH
NFA_PREV .= NFA_MON
NOP

; >>>>>>> RAFCINIT <<<<<<<
; --
NFA_RAFCINIT .CBYTE $88, "RAFCINIT"
LFA_RAFCINIT .WORD NFA_PREV  ; LINK TO "SCRCLR"
CFA_RAFCINIT .WORD PFA_RAFCINIT
NFA_PREV .= NFA_RAFCINIT
PFA_RAFCINIT
    LDY #0
    STY LMARGN
    INY
    STY CRSINH
    M_CHOUT clrscr
    JMP NEXT

.ELSE

RAFCINIT
    LDX #$E8            ; Init Stack Pointer
    STX CRSINH
    M_CHOUT clrscr
    LDA #0
    STA LMARGN

.IF BETA
    JSR BETAMESSAGE
.ENDIF

;    JMP RAFC            ; and go!

.ENDIF

; >>>>>>> RAFC <<<<<<
; --
.IF FORTH
NFA_PREV .= NFA_PROCESS

NFA_RAFC .CBYTE $84, "RAFC"
LFA_RAFC .WORD NFA_PREV
CFA_RAFC .WORD DOCOL
PFA_RAFC 
    .WORD CFA_RAFCINIT
    .WORD CFA_0 ; 0
    .WORD CFA_READDIR
    .WORD CFA_1 ; 1
    .WORD CFA_READDIR
    .WORD CFA_REFSCR
    .WORD CFA_0            ; Start Action = 0
L1100
    .WORD CFA_RAFCDEBUG    ; DEBUG : show stack pointer
    .WORD CFA_DROP

    .WORD CFA_GETKEY
    .WORD CFA_GETAC
    .WORD CFA_DUP     ; DUP
    .WORD CFA_0BRANCH      ; 0BRANCH
    .WORD L1100-*
    .WORD CFA_ACTION
    .WORD CFA_BRANCH      ; BRANCH
    .WORD L1100-*
    .WORD CFA_EXIT     ; S;

NFA_LASTWORD = NFA_RAFC

.ELSE

RAFC
    JSR GETDIR   
    JSR REFSCR
    DEX
    DEX
RAFC1    
.IF DEBUG
    JSR RAFCDEBUG
.ENDIF
    JSR GETKEY
    STA 0,X
    JSR GETAC
    LDA 0,X
    BEQ RAFC1 
    JSR ACTION
    JMP RAFC1
.ENDIF

; >>>>>> ACTIONTABLE <<<<<<<<

ACTAB
.INCBIN "ac.tab"

; Action Code and Process handling

.INCLUDE ACTION.ASM

; Screen IO and Keyboard Input Routines

.INCLUDE SCREENIO.ASM

; File IO Routines

.INCLUDE FILEIO.ASM

; Sort and Framehandling Routines

.INCLUDE SORT.ASM

; DEBUG Routines

.INCLUDE DEBUG.ASM

; >>>>>> Variable <<<<<

.INCLUDE VARTAB.ASM

; >>>>>> STRINGS <<<<<<

.INCLUDE STRTAB.ASM



