; $Id: screenio.asm , cstrotm $
;
;  RAF Commander - A free File Manager for Atari 8bit
;  Copyright (C) 1999-2000 Regionalgruppe Atari Frankfurt / RAF
;
;  This program is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License
;  as published by the Free Software Foundation; either version 2
;  of the License, or (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;  or visit http://www.gnu.org

; Screen and Keyboard IO Routines

; some definitions for Screen IO

ro = 5          ;  FRAME "TOP RIGHT"
lo = 17         ;  FRAME "TOP LEFT"
hr = 18         ;  FRAME "HORIZONTAL"
vr = 124        ;  FRAME "VERTICAL"
lu = 26         ;  FRAME "BOTTOM LEFT"
ru = 3          ;  FRAME "BOTTOM RIGHT"
cross = 19      ;  FRAME "CROSS"
cr = 155        ;  CARRIAGE RETURN
bl = 32         ;  BLANK
clrscr = 125    ;  CLEAR SCREEN

GETCH
    STX XSAVE-1
    TYA         ; Y Register retten
    PHA
    JSR KGETCH  ; Zeichen holen (in accu)
    TAX
    PLA         ; Y Register wiederherstellen
    TAY
    TXA
    LDX XSAVE-1
    RTS

OUTCH
    STX XSAVE-1
    TAX
    TYA         ; Y Register retten
    PHA
    TXA
    JSR EOUTCH  ; Zeichen ausgeben
    PLA         ; Y Register wiederherstellen
    TAY
    LDX XSAVE-1
    RTS

XSTROUT
    LDA (0,X)
    TAY
    INC 0,X
    LDA (0,X)
    STY 0,X
    STA 1,X
XSTROUT1
    LDA (0,X)
    
    AND #$7F
    ORA INVFLG
    JSR OUTCH
    LDA (0,X)
    PHA
    JSR ADDONE
XSTROUT2
    PLA
    AND #$80
    BEQ XSTROUT1
RTSVEC
    RTS

XFRAME      ; prints frame
            ; N = XLEN, N+1 = YLEN
            ; N+2 = XPOS
    LDA COLCRS
    STA N+2
    M_CHOUT lo
    LDA #hr
    LDY N
    JSR XTIMES
    M_CHOUT ro
    M_CHOUT cr

    DEC N+1
L0010
    LDA N+2
    STA COLCRS
    M_CHOUT vr
    LDA #bl
    LDY N
    JSR XTIMES
    M_CHOUT vr
    M_CHOUT cr
    DEC N+1
    BNE L0010

    LDA N+2
    STA COLCRS
    M_CHOUT lu
    LDA #hr
    LDY N
    JSR XTIMES
    M_CHOUT ru
    RTS

; >>>>>>> XTIMES <<<<<<<

.IF FORTH

NFA_XTIMES .CBYTE $86, "XTIMES"
LFA_XTIMES .WORD NFA_PREV  ; UPLINK
CFA_XTIMES .WORD PFA_XTIMES
NFA_PREV .= NFA_XTIMES
PFA_XTIMES
    LDY 0,X ; GET TIMES
    LDA 2,X ; GET CHARACTER
    JSR XTIMES
    JMP POPTWO

.ENDIF

XTIMES
    PHA
    JSR OUTCH
    PLA
    DEY
    BNE XTIMES
    RTS

; >>>>>>> POS <<<<<<<
.IF FORTH
NFA_POS .CBYTE $83, "POS"
LFA_POS .WORD NFA_PREV  ; UPLINK
CFA_POS .WORD PFA_POS
NFA_PREV .= NFA_POS
PFA_POS
    LDA 0,X ; GET XPOS
    STA COLCRS
    LDA 2,X ; GET YPOS
    STA ROWCRS
    JMP POPTWO
.ENDIF

; >>>>>>> REFRESH_SCREEN <<<<<<<
.IF FORTH
NFA_REFSCR .CBYTE $86, "REFSCR"
LFA_REFSCR .WORD NFA_PREV  ; UPLINK
CFA_REFSCR .WORD DOCOL
NFA_PREV .= NFA_REFSCR
PFA_REFSCR
    .WORD CFA_REFFRM        ; Frame
    .WORD CFA_0 ; 0
    .WORD CFA_REFDIR        ; show left dir
    .WORD CFA_1 ; 1
    .WORD CFA_REFDIR        ; show right dir
    .WORD CFA_EXIT          ; S;    ; end of word
.ELSE
REFSCR
    JSR REFFRM              ; Frame
    DEX
    DEX
    LDA #0
    STA 0,X
    JSR _REFDIR             ; left dir
    LDA #1
    STA 0,X
    JSR _REFDIR             ; right dir
    INX
    INX
    RTS
.ENDIF
    
.IF FORTH
; >>>>>>> REFRESH_FRAME <<<<<<<
NFA_REFFRM .CBYTE $86, "REFFRM"
LFA_REFFRM .WORD NFA_PREV  ; UPLINK
CFA_REFFRM .WORD PFA_REFFRM
NFA_PREV .= NFA_REFFRM
PFA_REFFRM
    JSR REFFRM
    JMP NEXT
.ENDIF

REFFRM
    M_POS 8,0
    M_PRINT P_0RAFM
    M_CHOUT cr
    M_CHOUT lo

    JSR HRLOOP      ; Horizontal line

    M_CHOUT ro
 
    M_POS 8,1
    M_PRINT P_0DSKM
    M_POS 10,1
    LDA DNU0
    JSR OUTCH
    
    M_POS 19,1
    M_CHOUT 23

    M_POS 27,1
    M_PRINT P_0DSKM
    M_POS 29,1
    LDA DNU1
    JSR OUTCH

    LDY #20
L1003
    STY ROWCRS
    LDA #0
    STA COLCRS
    M_CHOUT vr
    LDA #19
    STA COLCRS
    M_CHOUT vr
    LDA #38
    STA COLCRS
    M_CHOUT vr
    DEY
    CPY #1
    BNE L1003

    M_POS 0,21
    M_CHOUT 1
    
    JSR HRLOOP

    M_CHOUT 4
    M_POS 19,21
    M_CHOUT cross
    M_POS 0,22

    JSR DSKDSP
    JSR DSKDSP

    M_CHOUT vr
    M_POS 0,23
    M_CHOUT lu

    JSR HRLOOP

    M_CHOUT ru
    M_POS 19,23
    M_CHOUT 24
    
    M_POS 0,0

    RTS
    
;   -----------
HRLOOP
    LDY #37
L1001
    M_CHOUT hr
    DEY
    BNE L1001
    RTS

DSKDSP
    M_CHOUT vr

    M_PRINT P_1DSKM
    M_PRINT P_SFREM
    LDA #31
    LDY #4
    JSR XTIMES
    RTS

CLRFRMACT
    LDA ACTFR
    BNE CLRFRMRIGHT

CLRFRMLEFT
    LDA #1
    STA XPOS
    BNE CLRFRM

CLRFRMRIGHT
    LDA #20
    STA XPOS

CLRFRM
    LDA #20
CLRFRM1
    STA ROWCRS
    LDA XPOS
    STA COLCRS
    LDA #bl
    LDY #18
    JSR XTIMES
    DEC ROWCRS
    LDA ROWCRS
    CMP #1
    BNE CLRFRM1
    RTS

; >>>>>>> REFRESH_DIR <<<<<<<
; n --
.IF FORTH    
NFA_REFDIR .CBYTE $86, "REFDIR"
LFA_REFDIR .WORD NFA_PREV  ; UPLINK
CFA_REFDIR .WORD PFA_REFDIR
NFA_PREV .= NFA_REFDIR

PFA_REFDIR
    STX XSAVE
    JSR _REFDIR
    LDX XSAVE
    JMP POP
.ENDIF

DIRCNT = TIB      ; Counter for act. entry
YPOS   = TIB+1    ; Y-Position
XPOS   = TIB+2    ; X-Position
MAXN   = TIB+3    ; max Entries
    
_REFDIR
    LDA #2
    STA YPOS
    LDA #0
    STA ACTCF

    LDY 0,X         ;  left (0) or right (1) panel
    CPY ACTFR       ;  act. panel?
    BNE L1400
    LDA #$80        ; then show cursor
    STA ACTCF

L1400
    LDA XPS0,Y
    STA XPOS

    LDA COFS0,Y
    STA DIRCNT
    LDA NUMD0,Y
    BMI L1405           ; no entries !
    STA MAXN
    LDA CPOS0,Y
    STA CPOSA

    CLC
    ASL 0,X           ; two byte values
    LDY 0,X
    LDA DIRMEM0,Y
    STA ACTDM
    LDA DIRMEM0+1,Y
    STA ACTDM+1

    INC MAXN
L1401
    LDA YPOS
    STA ROWCRS
    LDA XPOS
    STA COLCRS
    LDA DIRCNT
    STA 0,X
    JSR PRINTDIRENTRY

    INC YPOS
    INC DIRCNT
    LDA DIRCNT
    CMP MAXN            ; all entries ?
    BEQ L1403
    LDA YPOS
    CMP #21             ; all 19 Screen lines ?
    BEQ L1403
    BNE L1401

L1403    
    LDA MAXN
    STA 0,X             ; last line = free Sectors
    LDA #22 
    STA ROWCRS
    CLC
    LDA XPOS
    ADC #14
    STA COLCRS
    JSR PRINTDIRENTRY
L1405
    RTS

;   ----------------------------

PRINTDIRENTRY
    LDA 0,X
    CMP CABSA
    BNE PRINTDIRENTRY1
    LDA ACTCF
    STA INVFLG

PRINTDIRENTRY1
    JSR CALCLINE0   ; calculate dir entry memory location
    JSR XSTROUT1    ; print dir entry
    LDA #0
    STA INVFLG
    RTS

; >>>>>>> SCRCLR <<<<<<<
; --
.IF FORTH
NFA_SCRCLR .CBYTE $86, "SCRCLR"
LFA_SCRCLR .WORD NFA_PREV  ; UPLINK 
CFA_SCRCLR .WORD PFA_SCRCLR
NFA_PREV .= NFA_SCRCLR
PFA_SCRCLR
    M_CHOUT clrscr
    JMP NEXT
.ENDIF

; >>>>>>> GETKEY <<<<<<<
; -- n
.IF FORTH
NFA_GETKEY .CBYTE $86, "GETKEY"
LFA_GETKEY .WORD NFA_PREV  ; UPLINK
CFA_GETKEY .WORD PFA_GETKEY
NFA_PREV .= NFA_GETKEY
PFA_GETKEY
    JSR GETKEY
    PHA
    LDA #0
    JMP PUSH
.ENDIF

GETKEY
    LDA #$FF
    STA CH
LAGK1
    LDA CH
    CMP #$FF
    BEQ LAGK1

    LDY #$FF
    STY CH
    RTS

; >>>>>>> CRSUP <<<<<<<
; --
.IF FORTH
NFA_CRSUP .CBYTE $85, "CRSUP"
LFA_CRSUP .WORD NFA_PREV  ; UPLINK 
CFA_CRSUP .WORD PFA_CRSUP
NFA_PREV .= NFA_CRSUP
PFA_CRSUP
    LDA #1
    JSR CRSUP
    JMP NEXT
.ENDIF

CRSUP
    STA N
    LDA #0
    STA N+1
    JSR CRSHIDE

CRSUP3
    JSR CALCCABS
    LDY ACTFR
    LDA CPOS0,Y
    BEQ CRSUP1      ; Cursor Position Top ?

    LDA CPOS0,Y     ; no, decrement cursor position
    STA CPOSA
    DEC CPOSA
    LDA CPOSA
    STA CPOS0,Y
    JMP CRSUP2

CRSUP1          ; CPOS = 0, Offset ?
    LDA COFS0,Y
    BEQ CRSUP2  ; Offset 0?

    STA COFSA   ; decrement Cursor Offset
    DEC COFSA
    LDA COFSA
    STA COFS0,Y
    INC N+1

CRSUP2
    DEC N
    BNE CRSUP3
    JSR CALCCABS
    LDA N+1
    BEQ CRSUP4
    JSR L_UPDACT

CRSUP4
    JMP CRSSHOW

CALCCABS        ; Calculates absolute Cursor positions
    LDY #2
CALCCABS1
    CLC
    LDA CPOS0,Y
    ADC COFS0,Y
    STA CABS0,Y
    DEY
    BPL CALCCABS1
    RTS

; >>>>>>> CRSDOWN <<<<<<<
; --
.IF FORTH
NFA_CRSDOWN .CBYTE $87, "CRSDOWN"
LFA_CRSDOWN .WORD NFA_PREV  ; UPLINK
CFA_CRSDOWN .WORD PFA_CRSDOWN
NFA_PREV .= NFA_CRSDOWN
PFA_CRSDOWN
    LDA #1
    JSR CRSDOWN
    JMP NEXT
.ENDIF

CRSDOWN
    STA N           ; Counter
    LDA #0
    STA N+1         ; Flag for Update
    JSR CRSHIDE

CRSDOWN3
    JSR CALCCABS
    LDY ACTFR

    LDA CABS0,Y
    CMP NUMD0,Y
    BEQ CRSDOWN2    ; max dir entries ?
    LDA CPOS0,Y
    CMP #18         ; 19 Screen entries ?
    BEQ CRSDOWN1

    LDA CPOS0,Y
    STA CPOSA
    INC CPOSA
    LDA CPOSA
    STA CPOS0,Y
    BNE CRSDOWN2
    
CRSDOWN1
    LDA COFS0,Y     ; increment cursor offset
    STA COFSA
    INC COFSA
    LDA COFSA
    STA COFS0,Y
    INC N+1
    
CRSDOWN2
    DEC N
    BNE CRSDOWN3
    JSR CALCCABS
    LDA N+1
    BEQ CRSDOWN4
    JSR L_UPDACT
   
CRSDOWN4
    JMP CRSSHOW

; >>>>>>> GETDRIVE <<<<<<<
; -- n
.IF FORTH
NFA_GETDRV .CBYTE $88, "GETDRIVE"
LFA_GETDRV .WORD NFA_PREV  ; UPLINK
CFA_GETDRV .WORD PFA_GETDRV
NFA_PREV .= NFA_GETDRV
PFA_GETDRV
    STX XSAVE
    JSR GETDRIVE
    LDX XSAVE
    PHA
    LDA #0
    JMP PUSH
.ENDIF

GETDRIVE
    LDA COLCRS
    PHA             ; save xpos
    LDA #6
    STA ROWCRS
    LDA #9
    STA N
    LDA #2
    STA N+1
    JSR XFRAME
    PLA
    STA COLCRS
    INC COLCRS
    LDA #7
    STA ROWCRS
    M_PRINT P_DRVS
    JSR GETCH
    PHA             ; save number
    SEC
    SBC #49
    BMI GETDRVERROR ; drive <= 0 ? -> error
    CMP #8
    BPL GETDRVERROR ; drive > 8 ? -> error
    TAY
    LDA DRVS,Y
    CMP #'x
    BNE GETDRV1
GETDRVERROR
    PLA
    LDA #0          ; error !
    PHA
GETDRV1
    PLA
    RTS

;   -----------

CRSHIDE

    LDA #0
    STA ACTCF
    BEQ L_UPDCRS3

L_UPDCRS            ; Update act. Cursor
CRSSHOW
    LDA #$80
    STA ACTCF
L_UPDCRS3
    LDA CPOSA
L_UPDCRS2
    PHA
    CLC
    ADC COFSA
    STA 0,X
    PLA
    CLC
    ADC #2
    STA ROWCRS


    LDY ACTFR
    LDA XPS0,Y
    STA COLCRS

    JSR PRINTDIRENTRY
    RTS   

L_UPDACT
    LDA ACTFR
    BNE L_UPDRIGHT

L_UPDLEFT
    LDA #0
    BEQ L_1

L_UPDRIGHT
    LDA #1
L_1
    STA 0,X
    JMP _REFDIR


