; $Id: sort.asm , cstrotm $
;
;  RAF Commander - A free File Manager for Atari 8bit
;  Copyright (C) 1999-2000 Regionalgruppe Atari Frankfurt / RAF
;
;  This program is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License
;  as published by the Free Software Foundation; either version 2
;  of the License, or (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;  or visit http://www.gnu.org

; Sort and Framehandling Routines

; >>>> BUBBLESORT <<<<
FLAST       = N     ; End outer loop
FLENKEY   .BYTE 0   ; Key length
RLEN      .BYTE $11 ; Record Length
OFFSETKEY .BYTE 0   ; Key offset
FIRST       = N+2   ; 1st element pointer
SECOND      = N+4   ; 2nd element pointer
LAST      .WORD 0   ; End, inner loop
FENDKEY   .BYTE 0   ; end, key loop
ORDER     .BYTE 0   ; Order, sort 0,1
FLENSEC   .BYTE 0   ; 2nd field length
OFFSETSEC .BYTE 0   ; 2nd field offset
FENDSEC   .BYTE 0   ; End 2nd field

BUBBLESORT
; set first (2 Byte), last (2 Byte)
; set FLENKEY (1 Byte), OFFSETKEY (1 Byte)
; set FLENSEC (1 Byte), OFFSETSEC (1 Byte)
; set RLEN (1 Byte), set ORDER (1 Byte)
    LDA ORDER
    EOR #01
    STA ORDER

    LDA OFFSETKEY
    CLC             ; Find end of
    ADC FLENKEY     ; first key
    STA FENDKEY
    LDA OFFSETSEC   
    CLC             ; Find end of
    ADC FLENSEC     ; second key
    STA FENDSEC
;
; All parms. now in zero page.
; Next, set pointer to the end
; of the outer loop
    LDA LAST+1
    STA FLAST+1
    SEC 
    LDA LAST
    SBC RLEN
    STA FLAST
    BCS SETSECOND
;
    DEC FLAST+1
; Start of outer loop.
; Adjust the second pointer to
; point to the first pointer
; plus the record length.
;
SETSECOND
    CLC 
    LDA FIRST+1
    STA SECOND+1
    LDA FIRST
    ADC RLEN
    STA SECOND
    BCC SORTKEY
    INC SECOND+1
; Start of the inner loop.
; 1. Compare the Key field of
;    the two sort elements.
; 2. If we find a mismatch,
;    do we need to swap them?
SORTKEY
    LDY OFFSETKEY
;
KEYLOOP
;
    LDA (FIRST),Y ;get a byte
    CMP (SECOND),Y ;of each.
    BEQ CHKMORE ;If = Continue.
;
    BCC NOSWAP  ;If F<S no swap.
;
    BCS SWAP    ;If F>S swap.
;
CHKMORE
;
    INY         ;Adjust pointer
    CPY FENDKEY ;All done?
    BNE KEYLOOP ;No.  Continue.
;
; At this point, all bytes in
; the key field of both sort
; elements are equal.  Drop to
; SORTSECOND and check the
; secondary fields.
;   If their lengths = 0, then
; we don't have 2ndry fields.
; We are only doing a one-field
; sort--goto the Noswap routine.
; If the key fields are equal,
; there is no need to swap them.
;
SORTSEC
    LDA FLENSEC ;A second field?
    BEQ NOSWAPBD ;No.
;
    LDY OFFSETSEC
SECLOOP
    LDA (FIRST),Y ;Compare byte
    CMP (SECOND),Y ;by byte...
    BEQ CHKMORE2 ;If = do more.
;
    BCC NOSWAP  ;If F<S Noswap.
;
    BCS SWAP    ;If F>s Swap.
;
CHKMORE2
    INY         ;Point to next.
    CPY FENDSEC ;End of 2nd?
    BNE SECLOOP ;No, do more.
;
; Now, both the key and the
; secondary fields of both sort
; elemtents are equal. Goto
; the noswap routine through the
; "back door." No need to check
; the order, no need to swap.
    BEQ NOSWAPBD
;
; This is where the swapping
; occurs. First, check the
; swapping order.
; (Assume swapping in ascending
; order.) If order<>0, then
; sort in descending order.
;
SWAP
;
    LDA ORDER   ;Get order
    BNE NOSWAPBD ;Not 0, No swap
;
; Swap routine's back door.
; If NOSWAP decides we need to
; swap by checking the order,
; we need to come here (instead
; of SWAP) or we would go into
; a continuous loop.
;
SWAPBD
    LDY #0
SWAPLOOP
    LDA (FIRST),Y ;Key byte
    PHA         ;  to stack.
    LDA (SECOND),Y ; 2ndry byte
    STA (FIRST),Y ;  to key.
    PLA         ;Key from stack
    STA (SECOND),Y ;to 2ndry.
    INY         ;Next byte.
    CPY RLEN    ; More?
    BNE SWAPLOOP ;Yes. Continue.
;
; All bytes have been swapped.
; Now adjust pointers to the
; next elements for the sort.
;  Goto the noswap back door.
;
    BEQ NOSWAPBD
;
NOSWAP
;
    LDA ORDER   ;Is ORDER=1?
    BNE SWAPBD  ;Yes. Swap them
;
NOSWAPBD
    CLC 
    LDA SECOND
    ADC RLEN
    STA SECOND
    LDA SECOND+1
    ADC #0
    STA SECOND+1
    CMP LAST+1
    BNE SORTKEY
;
    LDA SECOND
    CMP LAST
    BNE SORTKEY
;
; We've made one pass through
; the sort's inner loop.  Now,
; adjust the outer loop and
; check if we're done with it.
; If not, readjust the inner
; loop pointer to the outer loop
; pointer + the record length.
;
    CLC 
    LDA FIRST
    ADC RLEN
    STA FIRST
    LDA FIRST+1
    ADC #0
    STA FIRST+1
    CMP FLAST+1
    BEQ CHECK2
    JMP SETSECOND
;
CHECK2
    LDA FIRST
    CMP FLAST
    BEQ ENDSORT
    JMP SETSECOND
;
ENDSORT
    RTS         ; RETURN

SORTACT
    LDA ACTFR
    BNE SORTRIGHT
    
SORTLEFT
    LDA DIRMEM0         ; left panel
    STA FIRST
    LDA DIRMEM0+1 
    STA FIRST+1
    LDA DIRMEE0
    STA LAST
    LDA DIRMEE0+1
    STA LAST+1
    JSR BUBBLESORT      ; sort
    JSR L_UPDLEFT       ; update screen
    RTS

SORTRIGHT
    LDA DIRMEM1         ; left panel
    STA FIRST
    LDA DIRMEM1+1 
    STA FIRST+1
    LDA DIRMEE1
    STA LAST
    LDA DIRMEE1+1
    STA LAST+1
    JSR BUBBLESORT      ; sort
    JSR L_UPDRIGHT      ; update screen
    RTS

SETACTFR
    LDY ACTFR
    LDA NUMD0,Y
    STA NUMDA

    LDA COFS0,Y
    STA COFSA

    LDA CPOS0,Y
    STA CPOSA

    TYA             ; Accu * 2 for 2 Byte parameter
    CLC
    ASL
    TAY

    LDA DIRMEM0,Y
    STA ACTDM
    LDA DIRMEM0+1,Y
    STA ACTDM+1
    RTS

TOGGLEACT
    LDA ACTFR
    EOR #$01
    STA ACTFR
    RTS

; >>>>>>> ADD ONE <<<<<<
; n -- n+1

ADDONE
    CLC
    LDA 0,X
    ADC #1
    STA 0,X
    BCC ADDONE1
    INC 1,X
ADDONE1
    RTS

; >>>>>>> CALC LINE <<<<<<<
; n -- addr
;
.IF FORTH
NFA_CALCLINE .CBYTE $88, "CALCLINE"
LFA_CALCLINE .WORD NFA_PREV  ; UPLINK
CFA_CALCLINE .WORD PFA_CALCLINE
NFA_PREV .= NFA_CALCLINE
PFA_CALCLINE

    JSR CALCLINE0
    JMP NEXT
.ENDIF

CALCLINE0
    LDA 0,X

    LDY ACTDM
    STY 0,X
    LDY ACTDM+1
    STY 1,X

    TAY
    CPY #0
    BEQ CALCLINE3   ; 0 ?

CALCLINE1       ; * 16 
    CLC
    LDA 0,X
    ADC #$11
    STA 0,X
    LDA 1,X
    ADC #0
    STA 1,X
    DEY
    BNE CALCLINE1

CALCLINE3
    RTS

