#include <stdio.h>
#include <math.h>
unsigned char ymbuf[1000000];
unsigned char midbuf[500000];
long t[4096];
long len;

//----------------------------------------------------------------------

savefile(char* filename, char *dest, long size)
{
   FILE *out;
   if ( (out=fopen(filename, "wb")) == NULL )
   {
      printf("Save Error. Cannot open %s \n", filename);
      exit(1);
   }
   fseek(out,0,SEEK_SET);
   fwrite(dest,size,1,out);
   fclose(out);
}

//----------------------------------------------------------------------

loadfile(char* filename, char *srce, long size)
{
   FILE *in;
   if ( (in=fopen(filename, "rb")) == NULL )
   {
      printf("Load Error. Cannot open %s \n", filename);
      exit(1);
   }
   fseek(in,0,SEEK_SET);
   len=fread(srce,1,size,in);
   fclose(in);
}

//----------------------------------------------------------------------

main()
{
   long vbl,n,i,i1,i2,i3,od=0;
   long vol,not1,not2,note,onote,tic,size;
   long drum,dt,v1,v2,v3,od1=0,od2=0,od3=0,dconv=1;
   double db;
   unsigned char fname[50],fname2[50],temp[50];
   unsigned char *yreg[14],*midpos,*tpos;

   unsigned char header[8]={0x4d,0x54,0x68,0x64,0x00,0x00,0x00,0x06};
   unsigned char header2[6]={0x00,0x01,0x00,0x05,0x00,0x20};
   unsigned char trackhead[4]={0x4d,0x54,0x72,0x6b};
   unsigned char mastertrk[23]={0x00,0x00,0x00,0x13,0x00,0xff,0x58,0x04,0x03,0x02,0x18,0x08,0x00,0xff,0x51,0x03,0x09,0x27,0xc0,0x00,0xff,0x2f,0x00};
   unsigned char tracktail[5]={0x00,0xff,0x03,0x01,0x41};

   printf("YM3 to MIDI File Converter Version 1.1\n");
   printf("By Andrew Gower - 21st January 1998\n\n");
   printf("Please Enter Input Filename:\n"); scanf("%s",fname);
   printf("Please Enter Output Filename:\n"); scanf("%s",fname2);
   printf("Please Enter Instument Number 1: \n");
   scanf("%s",temp); i=0; i1=0; while (temp[i]!=0) {i1=(i1*10)+temp[i]-'0'; i++;}
   printf("Please Enter Instument Number 2: \n");
   scanf("%s",temp); i=0; i2=0; while (temp[i]!=0) {i2=(i2*10)+temp[i]-'0'; i++;}
   printf("Please Enter Instument Number 3: \n"); 
   scanf("%s",temp); i=0; i3=0; while (temp[i]!=0) {i3=(i3*10)+temp[i]-'0'; i++;}
   printf("Attempt Drum Emulation? \n"); dconv=getch(); printf("%c\n",dconv);

   loadfile(fname,ymbuf,1000000); vbl=(len-4)/14;
   for (n=0; n<14; n++) yreg[n]=ymbuf+4+n*vbl;
   midpos=midbuf;

   //Construct frequency table
   t[0]=0; for (n=1; n<4096; n++)
   {
      db=(12.0*log(3125.0/(11.0*n))/log(2.0))+69.0;
      i=(long)db; if (db-i>0.5) i++;
      if (i<31 || i>96) i=1;
      t[n]=i;
   }      

   //Save MIDI Header Info
   memcpy(midpos,header,8); midpos+=8;
   memcpy(midpos,header2,6); midpos+=6;  

   //Construct Master Track
   memcpy(midpos,trackhead,4); midpos+=4;
   memcpy(midpos,mastertrk,23); midpos+=23;

   //Convert Tracks 1-3
   for (i=0; i<3; i++)
   {
      memcpy(midpos,trackhead,4); tpos=midpos+4; midpos+=8;
      memcpy(midpos,tracktail,5); midpos+=5;
      onote=0; tic=0; size=12;
      *midpos++=0; *midpos++=192+i;
      if (i==0) *midpos++=i1; else if (i==1) *midpos++=i2; else *midpos++=i3;
      *midpos++=0; *midpos++=144+i; *midpos++=0; *midpos++=0;
      for (n=0; n<vbl; n++)
      {
         vol=(*yreg[8+i]++)*8; if (vol>=128) vol=127;
         not1=*yreg[1+i*2]++;
         not2=*yreg[0+i*2]++;
         note=t[not1*256+not2];
         if (note!=onote)
         {
            if (tic>16383) {*midpos++=128+(tic/16384)%128; size++;}
            if (tic>127) {*midpos++=128+(tic/128)%128; size++;}
            *midpos++=(tic%128); *midpos++=onote; *midpos++=0;
            *midpos++=0; *midpos++=note; *midpos++=vol;
            onote=note; tic=0; size+=6;
         }
         tic++;
      }
      *midpos++=0; *midpos++=0xff; *midpos++=0x2f; *midpos++=0x00;
      size+=4;
      *tpos++=(size/(65536*256))%256;
      *tpos++=(size/65536)%256;
      *tpos++=(size/256)%256;
      *tpos++=(size)%256;
   }

   //Convert Drums
   for (n=0; n<14; n++) yreg[n]=ymbuf+4+n*vbl;
   size=9; tic=0;
   memcpy(midpos,trackhead,4); tpos=midpos+4; midpos+=8;
   memcpy(midpos,tracktail,5); midpos+=5;
   *midpos++=0; *midpos++=144+9; *midpos++=0; *midpos++=0;
   if (!(dconv!='y' && dconv!='Y'))
   {
      for (n=0; n<vbl; n++)
      {
         drum=*yreg[7]++; dt=35+(*yreg[6]++);
         v1=*yreg[8]++; v1*=8; if (v1>=128) v1=127;
         v2=*yreg[9]++; v2*=8; if (v2>=128) v2=127;
         v3=*yreg[10]++; v3*=8; if (v3>=128) v3=127;
         if (!(v1!=0 && (drum&8)!=0)) od1=-1;
         if (!(v2!=0 && (drum&16)!=0)) od2=-1;
         if (!(v3!=0 && (drum&32)!=0)) od3=-1;
         if (v1!=0 && (drum&8)!=0 && od1==-1) 
         {
            od1=0; size+=6;
            if (tic>16383) {*midpos++=128+(tic/16384)%128; size++;}
            if (tic>127) {*midpos++=128+(tic/128)%128; size++;}
            *midpos++=tic%128; *midpos++=od; *midpos++=0; od=dt;
            *midpos++=0; *midpos++=dt; *midpos++=v1; tic=0;
         }
         if (v2!=0 && (drum&16)!=0 && od2==-1) 
         {
            od2=0; size+=6;
            if (tic>16383) {*midpos++=128+(tic/16384)%128; size++;}
            if (tic>127) {*midpos++=128+(tic/128)%128; size++;}
            *midpos++=tic%128; *midpos++=od; *midpos++=0; od=dt;
            *midpos++=0; *midpos++=dt; *midpos++=v2; tic=0;
         }
         if (v3!=0 && (drum&32)!=0 && od3==-1) 
         {
            od3=0; size+=6;
            if (tic>16383) {*midpos++=128+(tic/16384)%128; size++;}
            if (tic>127) {*midpos++=128+(tic/128)%128; size++;}
            *midpos++=tic%128; *midpos++=od; *midpos++=0; od=dt;
            *midpos++=0; *midpos++=dt; *midpos++=v3; tic=0;
         }
         tic++;
      }
   }
   *midpos++=0; *midpos++=0xff; *midpos++=0x2f; *midpos++=0x00; size+=4;
   *tpos++=(size/(65536*256))%256;
   *tpos++=(size/65536)%256;
   *tpos++=(size/256)%256;
   *tpos++=(size)%256;

   savefile(fname2,midbuf,(midpos-midbuf));

}
