/*
 *************************************************************************
 *
 *  ibm2a.c -- convert from ASCII to ATASCII, with ATASCII graphics
 *
 *  by Bob Hardy, Feb-Apr 1993, v1.1
 *
 **************************************************************************
 */

/*
     Mat*Rat brought many useful and interesting programs to Atari BASIC,
     and he also wrote some simple C programs for text processing, to convert
     from/to the Atari EOL character to/from the IBM-PC CR/LF combination, in
     the tradition of UNIX2DOS/DOS2UNIX.  While this code doesn't borrow much
     from Mat*Rat, we take this opportunity to thank him for the good stuff
     he brought us, particularly in the early '80's, and to admit that while
     this program is more elaborate than his comparable programs, he was here
     first.  Thanks Matt, and long may you Rat!
 */      

/*
     This program made necessary some unusual design decisions.  They
     revolved around how to deal with the fact that ATASCII has character
     "box" graphics, but has no double-line box characters, like the
     IBM-PC character set.  In the end, I took the only reasonable course
     that occurred to me -- since the PC has no inverse video box chars,
     let's swap inverse video chars for double-line box chars!
 */


#include <stdio.h>

int main (int argc, char **argv[])
{
  FILE *infile, *outfile;
  int c;

  puts("IBM2A - Convert ASCII to ATASCII, with Atari character graphics");
  puts("by Bob Hardy, with acknowledgements to Mat*Rat\n");

  if (argc < 3) {
    printf("Usage: %s infile outfile\n", argv[0]); 
    exit(1);
  }
    if ((infile=fopen(argv[1], "rb")) == NULL) {
    printf("%s: Could not open %s for read.\n", argv[0], argv[1]);
    exit(1);
  }
  if ((outfile=fopen(argv[2], "wb")) == NULL) {
    printf("%s: Could not open %s for write.\n", argv[0], argv[2]);
    exit(1);
  }
  printf("Converting %s...\n", argv[1]);
    while ((c=getc(infile)) != EOF) {
    switch(c) {
      case '\3'  : putc('\0',   outfile); /* heart */
                   break;
      case '\4'  : putc('\140', outfile); /* diamond */
                   break;
      case '\5'  : putc('\20',  outfile); /* club */
                   break;
      case '\6'  : putc('\173', outfile); /* spade */
                   break;
      case '\7'  : putc('\24',  outfile); /* big dot */
                   break;
      case '\10' : putc('\224', outfile); /* inverse big dot */
                   break;
      case '\11' : putc('\177', outfile); /* TAB */
                   break;
      case '\12' : putc('\233', outfile); /* CR = EOL */
                   break;
      case '\15' : break;                 /* Discard LF! */
      case '\263': putc('\174', outfile); /* single vertical line */
                   break;
      case '\264': putc('\4',   outfile); /* single right T-junction */
                   break;
      case '\265': putc('\204', outfile); /* mixed right T-junction */
                   break;
      case '\266': putc('\204', outfile); /* mixed right T-junction */
                   break;
      case '\267': putc('\205', outfile); /* mixed upper right box char */
                   break;
      case '\270': putc('\205', outfile); /* mixed upper right box char */
                   break;
      case '\271': putc('\204', outfile); /* double right T-junction */
                   break;
      case '\272': putc('\374', outfile); /* double vertical line */
                   break;
      case '\273': putc('\205', outfile); /* double upper right box char */
                   break;
      case '\274': putc('\203', outfile); /* double lower right box char */
                   break;
      case '\275': putc('\203', outfile); /* mixed lower right box char */
                   break;
      case '\276': putc('\203', outfile); /* mixed lower right box char */
                   break;
      case '\277': putc('\5',   outfile); /* single upper right box char */
                   break;
      case '\300': putc('\32',  outfile); /* single lower left box char */
                   break;
      case '\301': putc('\30',  outfile); /* single inverted T-junction */
                   break;
      case '\302': putc('\27',  outfile); /* single vertical T-junction */
                   break;
      case '\303': putc('\1',   outfile); /* single left T-junction */
                   break;
      case '\304': putc('\22',  outfile); /* single horizontal line */
                   break;
      case '\305': putc('\23',  outfile); /* single 4-way junction */
                   break;
      case '\306': putc('\201', outfile); /* mixed left T-junction */
                   break;
      case '\307': putc('\201', outfile); /* mixed left T-junction */
                   break;
      case '\310': putc('\232', outfile); /* double lower left box char */
                   break;
      case '\311': putc('\221', outfile); /* double upper left box char */
                   break;
      case '\312': putc('\230', outfile); /* double inverted T-junction */
                   break;
      case '\313': putc('\227', outfile); /* double vertical T-junction */
                   break;
      case '\314': putc('\201', outfile); /* double left T-junction */
                   break;
      case '\315': putc('\222', outfile); /* double horizontal line */
                   break;
      case '\316': putc('\223', outfile); /* double 4-way junction */
                   break;
      case '\317': putc('\230', outfile); /* mixed inverted T-junction */
                   break;
      case '\320': putc('\230', outfile); /* mixed inverted T-junction */
                   break;
      case '\321': putc('\227', outfile); /* mixed vertical T-junction */
                   break;
      case '\322': putc('\227', outfile); /* mixed vertical T-junction */
                   break;
      case '\323': putc('\232', outfile); /* mixed lower left box char */
                   break;
      case '\324': putc('\232', outfile); /* mixed lower left box char */
                   break;
      case '\325': putc('\221', outfile); /* mixed upper left box char */
                   break;
      case '\326': putc('\221', outfile); /* mixed upper left box char */
                   break;
      case '\327': putc('\223', outfile); /* mixed 4-way junction */
                   break;
      case '\330': putc('\223', outfile); /* mixed 4-way junction */
                   break;
      case '\331': putc('\3',   outfile); /* lower right corner */
                   break;
      case '\332': putc('\21',  outfile); /* single upper left box char */
                   break;
      case '\334': putc('\16',  outfile); /* low horizontal bar */
                   break;
      case '\335': putc('\26',  outfile); /* left vertical bar */
                   break;
      case '\336': putc('\2',   outfile); /* right vertical bar */
                   break;
      case '\337': putc('\15',  outfile); /* high horizontal bar */
                   break;
      default    : putc(c, outfile);      /* Accept given character. */
                   break;
    }
  }
  fclose(outfile);
  printf("%s: End-of-file encountered.\n", argv[1]);
  exit(0);
}
