/*
**      Applet frontend for JScott 1.00
**      Scott Adams Classic Adventure driver in Java.
**      Copyright (C) 1998 Vasyl Tsvirkunov.
*/

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.reflect.Array;
import java.io.*;
import java.net.URL;

////////////////////////////////////////////////////////////////////////////

final public class JScottApplet
	extends Applet
        implements UserInterface, Runnable, ActionListener
{
// ****** Runnable implementation
// Very simple, basic thread implementation for applet. Nothing particularly
// interesting here.

// Associated thread object
	private Thread theThread = null;

// Variable keepRunning is used to terminate thread execution.
	private boolean keepRunning = false;

	public void run()
	{
                keepRunning = true;
                while(keepRunning)
                {
                        try
                        {
                        	theThread.sleep(100);
                        }
                        catch(InterruptedException ex)
                        {
                        }
                }
	}

	public void stop()
	{
		keepRunning = false;
	}
//

// ****** Applet implementation

// Applet area is split to three text fields: static non-scrollable room
// description, vertically scrollable game transcript and user input field.
        private TextArea roomDescription;
        private TextArea gameTranscript;
        private TextField userInput;


	public void init()
	{
        // Initialize applet structure.
                roomDescription = new TextArea("", 0, 0, TextArea.SCROLLBARS_NONE);
                roomDescription.setEditable(false);
                gameTranscript = new TextArea("", 0, 0, TextArea.SCROLLBARS_VERTICAL_ONLY);
                gameTranscript.setEditable(false);
                userInput = new TextField();

        // OK, OK, I know that this part looks weird. I tried to make it
        // shorter and cleaner but alas. AWT is very strange design. Layout
        // managers represent very good idea and pitiful implementation.
		GridBagLayout layout = new GridBagLayout();
		setLayout(layout);

                GridBagConstraints rdConstraints = new GridBagConstraints();
                rdConstraints.gridy = 0;
                rdConstraints.gridheight = 7;
                rdConstraints.weighty = 7;
                rdConstraints.weightx = 1;
                rdConstraints.fill = GridBagConstraints.BOTH;
                rdConstraints.insets = new Insets(3, 3, 1, 3);
                layout.setConstraints(roomDescription, rdConstraints);
                add(roomDescription);

                GridBagConstraints gtConstraints = new GridBagConstraints();
                gtConstraints.gridy = 7;
                gtConstraints.gridheight = 7;
                gtConstraints.weighty = 7;
                gtConstraints.weightx = 1;
                gtConstraints.fill = GridBagConstraints.BOTH;
                gtConstraints.insets = new Insets(1, 3, 1, 3);
                layout.setConstraints(gameTranscript, gtConstraints);
                add(gameTranscript);

                GridBagConstraints uiConstraints = new GridBagConstraints();
                uiConstraints.gridy = 14;
                uiConstraints.gridheight = 1;
                uiConstraints.weighty = 1;
                uiConstraints.weightx = 1;
                uiConstraints.fill = GridBagConstraints.BOTH;
                uiConstraints.insets = new Insets(1, 3, 3, 3);
                layout.setConstraints(userInput, uiConstraints);
                add(userInput);

        // So applet will be notified when user presses Enter.
                userInput.addActionListener(this);

		try
		{
        // Open game related files as URL-based streams and create game
        // object.
                        String gameName = getParameter("game");
                        String languageName = getParameter("language");

                        InputStream gameData = new URL(getDocumentBase(), gameName).openStream();
                        InputStream languageData = null;
                        if(languageName != null && languageName.length() != 0)
                                languageData = new URL(getDocumentBase(), languageName).openStream();

			adventure = new Adventure(this, languageData, gameData);
	       	       	adventure.run(null);

        // Start thread. Applet is running.
	                theThread = new Thread(this);
			theThread.start();
		}
		catch(Exception ex)
		{
                        theThread.stop();
		}
        }

//

// ****** ActionListener implementation

// This will be called when user presses Enter.
        public void actionPerformed(ActionEvent e)
        {
        // Record user input in transcript
                gameTranscript.append(userInput.getText() + "\n");
        // Interpret it
                adventure.tick();
        // Clear input field
                userInput.setText("");
        }
//

// ****** UserInterface implementation

// Main driver object
        private Adventure adventure = null;

        public void notifyRoomChanged()
        {
        // Just some formatting stuff.
                String strDescription = adventure.describeRoom() + "\n";

	        String exits[] = adventure.describeExits();
                if(exits != null)
                {
                        int count = Array.getLength(exits);
                        for(int i=0; i<count; i++)
                        {
                                if(i > 1)
                                        strDescription += ", ";
                                strDescription += exits[i];
                        }
                        strDescription += ".\n";
                }

                String items[] = adventure.describeItems();
                if(items != null)
                {
                        int count = Array.getLength(items);
                        for(int i=0; i<count; i++)
                        {
                                if(i > 1)
                                        strDescription += " - ";
                                strDescription += items[i];
                        }
                        strDescription += "\n";
                }

                roomDescription.setText(strDescription);
        }

        public void printText(String message)
        {
        // Message is just appended to the transcript.
                gameTranscript.append(message);
        }

        public void clearScreen()
        {
        // We have nice scrollable transcript. Why should we destroy it?
                gameTranscript.append("\n\n\n\n\n\n\n");
        }

        public void doPrompt(String message)
        {
                printText(message);
        }

        public String getUserInput()
        {
                return userInput.getText();
        }

        public void delay(int milliseconds)
        {
        // Straightforward implementation. Don't forget to disable user
        // input... and enable it afterwards.
                userInput.setEnabled(false);

                try
                {
	               	theThread.sleep(milliseconds);
                }
                catch(InterruptedException ex)
                {
                }

                userInput.setEnabled(true);
        }

        public OutputStream getSaveStream() throws IOException
        {
                printText("Save file feature is not available in applet.\n");
                return null;
        }

        public InputStream getLoadStream() throws IOException, FileNotFoundException
        {
                printText("Load file feature is not available in applet.\n");
                return null;
        }
//
}

