/***************************************************************************

Another ScottFree Driver, revision 1.2 beta.
Derived from Alan Cox's "ScottFree" revision 1.14,
that work (C) 1993, 1994, 1995 Swansea University Computer Society.
This driver (C) 1998 Robert Schneck.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program (see the file 'license.txt'); if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Statement: Everything in this program has been deduced or obtained
solely from published material.  No game interpreter code has been
disassembled.

***************************************************************************/

#include <stdio.h>
#include <string.h>
#ifndef PYRAMID
#include <stdlib.h>
#endif
#include <ctype.h>
#include <stdarg.h>
#include <time.h>

/* I added this header to lose some warnings.  
   If it causes problems lose it */
#include <unistd.h>

#include<curses.h>
#include<signal.h>

#include"asfdcurs.h"

/* Tried to follow ScottFree in making this portable */
/*
 *	Configuration Twiddles
 */

#ifdef NOSTRNCASECMP
static int strncasecmp(char *a,char *b, int n) {
  char c,d;
  while(*a && *b && n>0) {
    c=*a;
    d=*b;
    if(islower(c)) {
      c=toupper(c);
    }
    if(islower(d)) {
      d=toupper(d);
    }
    if(c<d) {
      return(-1);
    }
    if(c>d) {
      return(1);
    }
    a++;
    b++;
    n--;
  }
  if(n==0) {
    return(0);
  }
  if(*a) {
    return(-1);
  }
  if(*b) {
    return(1);
  }
  return(0);
}
#endif

typedef char boolean;

/* current position of output */
int outputPos;

/*  from last look, for determining whether to redraw */
extern struct {
  short playerRoom;
  short *itemLoc;
  boolean dark;
  boolean clear; /* was there a clear screen (or other overriding redraw)? */
} lastLook;

/* have we initialized curses? (so we can run endwin()) */
boolean displayUp;


/* Print buf, breaking lines where convenient */
void Output(char *buf) {
  char word[MAX_OUTPUT_WORD_LENGTH+1];
  boolean ournewline;
  int pos;
  
  if(!displayUp) {
    printf("%s",buf);
    return;
  }

  ournewline = FALSE;
  
  while(*buf) {
    /* deal with whitespace */
    while(*buf && isspace(*buf)) {
      if(*buf=='\n') {
        printw("\n");
        ournewline = FALSE;
        outputPos=0;
      }
      /* don't put spaces at the beginning of the line
         if it was a newline only because we wrapped */
      else if (outputPos>0 || !ournewline) {
        outputPos++;
        if(outputPos<(WIDTH-1)) {
          printw(" ");
        }
      }
      
      buf++;
    }
    if (*buf == 0) {
      break;
    }
    
    /* get the next word */
    pos = 0;
    while(*buf && !isspace(*buf)) {
      word[pos++] = *buf++;
    }
    word[pos] = 0;
    
    /* print the word; insert newline if needed */
    /* let sole periods go farther (this is a bit of a klug, added
       because of how I print periods after items and rooms) */
    if(strlen(word)==1 && *word=='.') {
      if (outputPos>(WIDTH-2)) {
        printw("\n");
        ournewline = TRUE;
        outputPos=0;
      }
      printw(".");
      outputPos++;
    }
    else {
      /* if outputPos already 0, don't put in an extra newline */
      if((outputPos>0) && (outputPos+strlen(word) > (WIDTH-3))) {
        printw("\n");
        ournewline = TRUE;
        outputPos=0;
      }
      
      printw("%s",word);
      outputPos += strlen(word);
    }
  }
  refresh();
}


/* get character input */
void Input(char *buf) {
  int pos=0;
  char ch;
  
  while(TRUE) {
    ch = getch();
    switch(ch) {
    case 10:
    case 13:
      buf[pos]=0;
      printw("\n");
      refresh();
      outputPos = 0;
      return;
    case 8:
    case 127:
      if (pos>0) {
        printw("\010 \010");
        pos--;
      }
      break;
    default:
      /* accept printable characters */
      if(ch>=' ' && ch<=126 && pos < MAX_INPUT_LENGTH) {
        buf[pos++] = ch;
        printw("%c",ch);
      }
      break;
    }
    refresh();
  }
}


/* Functions to print in various styles */

void SetStyle(int pairnum,int attrs) {
  if (!displayUp) {
    return;
  }
  if (has_colors && COLOR_PAIRS>=5) {
    attrset(COLOR_PAIR(pairnum));
  }
  else {
    attrset(attrs);
  }  
}

void PrintTitle(char *buf) {
  SetStyle(1,TITLE_ATTR);
  Output(buf);
}

void PrintLook(char *buf) {
  SetStyle(2,LOOK_ATTR);
  Output(buf);
}

void PrintCommand(char *buf) {
  SetStyle(3,COMMAND_ATTR);
  Output(buf);
}

void PrintMessage(char *buf) {
  SetStyle(4,MESSAGE_ATTR);
  Output(buf);
}

void PrintDiag(char *buf) {
  SetStyle(5,MESSAGE_ATTR);
  Output(buf);
}

void PrintMessageString(char *buf,char *string) {
  char result[MAX_OUTPUT_LENGTH+1];
  sprintf(result,buf,string);
  PrintMessage(result);
}

void PrintMessageNum(char *buf,int num) {
  char result[MAX_OUTPUT_LENGTH+1];
  sprintf(result,buf,num);
  PrintMessage(result);
}

void PrintDiagNum(char *buf,int num) {
  char result[MAX_OUTPUT_LENGTH+1];
  sprintf(result,buf,num);
  PrintDiag(result);
}


void ClearScreen() {
  erase();
  refresh();
  outputPos = 0;
  lastLook.clear = TRUE;
}


void Exit(int status) {
  if(displayUp) {
    PrintDiag("\nHit any key...\n");
    getch();
    endwin();
  }
  exit(status);
}


/* ^C */
void Aborted (int i) {
  endwin();
  displayUp = 0;
  printf("User exit.\n");
  exit(0);
}


/* anything we need to do before we start playing */
void Initialize() {
  signal(SIGINT,Aborted);		/* For BSD curses */
  signal(SIGQUIT,SIG_IGN);
  signal(SIGTSTP,SIG_IGN);
  initscr();
  start_color();
  if(has_colors() && COLOR_PAIRS>=5) {
    init_pair(1,BACKGROUND_COLOR,TITLE_COLOR);
    init_pair(2,BACKGROUND_COLOR,LOOK_COLOR);
    init_pair(3,BACKGROUND_COLOR,COMMAND_COLOR);
    init_pair(4,BACKGROUND_COLOR,MESSAGE_COLOR);
    init_pair(5,BACKGROUND_COLOR,DIAG_COLOR);
  }
  noecho();
  cbreak();
  scrollok(stdscr,TRUE);
  leaveok(stdscr,FALSE);
  displayUp = TRUE;
  srand(time(NULL)^getpid()^getuid());
}

void Delay() {
  sleep(1);
}
