/***************************************************************************

Another ScottFree Driver, revision 1.2 beta.
Derived from Alan Cox's "ScottFree" revision 1.14,
that work (C) 1993, 1994, 1995 Swansea University Computer Society.
This driver (C) 1998 Robert Schneck.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program (see the file 'license.txt'); if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Statement: Everything in this program has been deduced or obtained
solely from published material.  No game interpreter code has been
disassembled.

***************************************************************************/

#ifdef AMIGA
#define NOGETPID
#define NOSTRNCASECMP
#endif

#ifdef PYRAMID
#define NOSTRNCASECMP
#endif

#ifdef NOSTRNCASECMP
static int strncasecmp(char *a,char *b,int n);
#endif

#ifdef NOGETPID
#ifndef AMIGA
#define getpid()   6031769
#else
#define getpid()   ((int)FindTask(NULL))
#endif
#endif



/* Print styles */
/* Curses colors:
  COLOR_BLACK COLOR_RED COLOR_GREEN COLOR_YELLOW 
  COLOR_BLUE COLOR_MAGENTA COLOR_CYAN COLOR_WHITE */
/* Curses attributes:
 A_STANDOUT A_UNDERLINE A_REVERSE A_BLINK A_DIM A_BOLD */

#define BACKGROUND_COLOR COLOR_BLACK
#define TITLE_COLOR COLOR_WHITE
#define LOOK_COLOR COLOR_GREEN
#define COMMAND_COLOR COLOR_RED
#define MESSAGE_COLOR COLOR_CYAN
#define DIAG_COLOR COLOR_WHITE
/* if no colors we'll use these instead */
#define TITLE_ATTR 0
#define LOOK_ATTR A_BOLD
#define COMMAND_ATTR A_UNDERLINE
#define MESSAGE_ATTR 0
#define DIAG_ATTR A_DIM


/* Values for i/o */

#define WIDTH 80
#define MAX_INPUT_LENGTH 255
#define MAX_INPUT_WORD_LENGTH 15
#define INPUT_SCANF_FORMAT "%15s %15s %15s"
/* i.e. three words of length MAX_INPUT_WORD_LENGTH */
#define MAX_OUTPUT_LENGTH 511
#define MAX_OUTPUT_WORD_LENGTH 79


#if !defined(TRUE) || (TRUE != 1)
#define TRUE 1
#endif
#if !defined(FALSE) || (FALSE != 0)
#define FALSE 0
#endif


void Output(char* buf);
void Input(char *buf);
void PrintTitle(char *buf);
void PrintLook(char *buf);
void PrintCommand(char *buf);
void PrintMessage(char *buf);
void PrintMessageString(char *buf,char *string);
void PrintMessageNum(char* buf,int num);
void PrintDiag(char *buf);
void PrintDiagNum(char* buf,int num);
void ClearScreen(void);
void Initialize(void);
void Exit(int status);
void Delay(void);
