#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 24 "parser.y"
#include <ctype.h>
#include "scottcom.h"

static int owner_level;		/* Level of owner */
Symbol* main_table;		/* Main symbol table. */
Symbol* noun_table;		/* Symbol table for nouns. */
Symbol* verb_table;		/* Symbol table for verbs. */
Symbol* label_table;		/* Symbol table for labels. */
Parameters info;		/* The parameters the player must specify. */

/*
 * The current symbol table to use for lookup of identifiers.
 * Normally set to main_table, but can temporarily be set to
 * one of the other tables.
 */
static Symbol** current = &main_table;

/*
 * Private functions for this file.
 */
static int special(int c);
static int skipWhiteSpace(void);
static void yyerror(char *s);
static void printMessage(char* message);
#line 49 "parser.y"
typedef union {
    int	n;			/* Any integer. */
    char *sp;			/* Pointer to a string. */
    Symbol *sym;		/* Pointer to a symbol. */
} YYSTYPE;
#line 37 "y.tab.c"
#define NUMBER 257
#define STRING 258
#define TESTOBJ 259
#define TESTROOM 260
#define TESTFLAG 261
#define TESTNUM 262
#define PARAMLESS 263
#define IF 264
#define ACTOBJ 265
#define ACTROOM 266
#define ACTFLAG 267
#define ACTNUM 268
#define ACTROOMOBJ 269
#define ACTOBJOBJ 270
#define TIMER 271
#define DIRECT 272
#define VLABEL 273
#define NLABEL 274
#define KW_NOUN 275
#define KW_VERB 276
#define KW_FLAG 277
#define KW_TIMREG 278
#define KW_ROOMREG 279
#define KW_OBJECT 280
#define KW_ROOM 281
#define KW_ACTION 282
#define KW_MESSAGE 283
#define OLABEL 284
#define FLABEL 285
#define UNDEF 286
#define ROOM 287
#define VERB 288
#define NOUN 289
#define OBJECT 290
#define MESSAGE 291
#define FLAG 292
#define TREG 293
#define RREG 294
#define PARSTART 295
#define PARTREASURE 296
#define PARLIGHT 297
#define PARCARRY 298
#define PARABBREV 299
#define PARTITLE 300
#define PLAYER 301
#define VOID 302
#define SWAP 303
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,   10,   10,   13,   11,   15,   16,   11,   17,   18,
   19,   11,   11,   22,   11,   11,   11,   11,   11,   11,
   11,   11,   11,   11,   11,   25,   25,   26,   28,   14,
   29,   14,   27,   27,   30,   31,   12,   12,   32,   32,
   21,   21,   21,   33,   33,   24,   24,   34,    3,   35,
   36,    3,    2,    2,    2,    1,   37,    1,    4,    4,
    4,    4,   38,   39,   23,   23,    7,    7,    8,    8,
    5,    5,    5,    6,    6,   20,   20,   20,   40,   40,
   40,   40,   40,   41,   42,   40,   40,   40,   40,   40,
   40,   40,   40,   40,   40,   40,   40,   40,    9,    9,
    9,    9,    9,    9,
};
short yylen[] = {                                         2,
    1,    1,    2,    0,    4,    0,    0,    5,    0,    0,
    0,    9,    5,    0,    6,    3,    3,    3,    3,    4,
    4,    4,    4,    4,    4,    1,    3,    0,    0,    6,
    0,    2,    1,    3,    0,    0,    6,    1,    1,    3,
    0,    1,    3,    2,    2,    1,    3,    5,    0,    0,
    0,    5,    0,    1,    1,    0,    0,    4,    0,    1,
    1,    1,    0,    0,    6,    1,    1,    3,    1,    3,
    1,    1,    1,    1,    1,    1,    2,    3,    5,    5,
    5,    5,    2,    0,    0,    6,    3,    3,    3,    3,
    5,    5,    3,    2,    2,    3,    3,    5,    1,    3,
    3,    3,    3,    3,
};
short yydefred[] = {                                      0,
    4,    6,    0,    0,    0,    0,    0,    9,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    2,    0,    0,
   66,   63,    0,   67,    0,   69,    0,   57,    0,    0,
   46,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    3,   39,   35,    0,    0,   28,    7,    0,    0,   16,
   17,    0,   18,    0,    0,    0,   19,    0,   14,   75,
   74,   10,    0,    0,    0,   99,    0,    0,    0,    0,
   26,    0,    0,    5,    0,    0,    0,   33,    0,    0,
   68,   70,    0,   50,    0,   47,    0,    0,    0,   20,
   21,    0,    0,    0,    0,    0,   22,   23,   24,   25,
    0,    0,   40,    0,    8,    0,   64,   58,    0,    0,
    0,    0,   42,   73,   72,   11,    0,   13,  104,    0,
    0,  102,  103,   27,   36,   29,   34,    0,   55,   54,
   51,   61,   60,   62,   48,   45,   44,   15,    0,    0,
    0,    0,   65,    0,   43,    0,   37,    0,   52,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   76,   95,    0,    0,
    0,    0,   83,   84,    0,    0,    0,    0,    0,    0,
    0,   94,    0,    0,    0,    0,   12,   77,    0,    0,
    0,    0,    0,   87,   88,   89,   90,    0,    0,   93,
    0,   97,   96,   78,    0,    0,    0,    0,    0,    0,
    0,    0,   79,   80,   81,   82,    0,   91,   92,   98,
   86,
};
short yydgoto[] = {                                      16,
   29,  131,   85,  135,  116,   62,   25,   27,   68,   17,
   18,   44,   19,   47,   20,   77,   33,   88,  140,  166,
  112,   87,   23,   30,   72,   76,   79,  142,   48,   73,
  141,   45,  113,   31,  109,  144,   55,   49,  128,  167,
  193,  217,
};
short yysindex[] = {                                   -226,
    0,    0,  -39, -269, -264,    7, -223,    0, -209,   20,
   46,   48,   52,   57,   95,    0, -226,    0,  -38,  121,
    0,    0,    2,    0,  -31,    0,   21,    0, -120,   23,
    0,  -93, -265,  106, -112, -110,  -37,  -37,  -37,  -84,
    0,    0,    0,  119,  135,    0,    0, -106, -104,    0,
    0, -103,    0, -102,  -99,  146,    0,    7,    0,    0,
    0,    0,  -71,  129,  130,    0,  -37,  -27,   17,   63,
    0,   24,  -83,    0,  -96,  -81,  134,    0,  150,  154,
    0,    0,  155,    0,  -61,    0,  -74,  -40,  140,    0,
    0,   78,  -37,  -37,  -37,  -37,    0,    0,    0,    0,
  -58,  160,    0,  161,    0,  -82,    0,    0, -113, -275,
 -153,   31,    0,    0,    0,    0,   84,    0,    0,  -28,
  -28,    0,    0,    0,    0,    0,    0,  -80,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  -74,   80,
  -79, -106,    0,  164,    0, -167,    0,  150,    0,  149,
  169,  170,  171,  172,  156,   90,  -76,  -69,  -73,  -37,
  -66,  -68,  -37,  157, -122, -121,    0,    0,  -67,  -63,
  -65,  -37,    0,    0,  166,  167,  173,   69,  184,  185,
  110,    0,  186,  174,  175,  176,    0,    0,  190,  195,
  196,  117, -167,    0,    0,    0,    0,  -52,  -51,    0,
  -50,    0,    0,    0,  182,  183,  191,  192, -225,  193,
  194,  197,    0,    0,    0,    0,  118,    0,    0,    0,
    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0, -120,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  244,    0,    0,  -41,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  198,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   -4,    0, -120,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  199,    0,
    0,    0,    0,    0,    0,    0,   71,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  214,   73,
    0,    0,    0,    0,    0,    0,  136,    0,    0,  -35,
  -34,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  201,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  137,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,
};
short yygindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,   -9,    0,
  246,    0,    0,    0,    0,    0,    0,    0,    0,   68,
    0,    0,    0,    0,    0,    0,  122,    0,    0,    0,
    0,    0,  126,  208,    0,    0,    0,    0,    0, -161,
    0,    0,
};
#define YYTABLESIZE 266
short yytable[] = {                                      67,
   22,   43,   67,  187,  188,  100,  101,  100,  101,  100,
  101,  132,   52,   95,   95,   93,   24,   94,   96,   96,
   60,   26,   61,  100,  101,  133,  134,   51,   69,   70,
  186,   97,  150,  151,  152,  153,  154,  155,  156,  157,
  158,  159,  160,  161,  162,  163,   28,  188,    1,    2,
    3,    4,    5,    6,    7,    8,    9,   92,   95,   93,
   50,   94,   32,   96,   54,  164,   58,  101,   10,   11,
   12,   13,   14,   15,  139,   98,   34,  165,  117,   53,
   35,   57,  100,  120,  121,  122,  123,  100,  101,  138,
  150,  151,  152,  153,  154,  155,  156,  157,  158,  159,
  160,  161,  162,  163,   95,   93,   36,   94,   37,   96,
   95,   93,   38,   94,   41,   96,   59,   39,  119,   95,
   93,   99,   94,  164,   96,   95,   93,  197,   94,   41,
   96,   59,  136,  137,  186,  165,  150,  151,  152,  153,
  154,  155,  156,  157,  158,  159,  160,  161,  162,  163,
  178,   95,   93,  181,   94,   40,   96,  208,   95,   93,
   46,   94,  192,   96,   59,   56,   63,  183,  200,  164,
  184,  185,  129,   71,   64,  130,   65,   74,   75,   78,
   80,  165,   81,   82,   83,   84,   89,   90,   91,  103,
  102,  104,  105,  106,  107,  108,  110,  111,  118,  124,
  125,  126,  146,  127,  149,  143,  147,  168,  169,  170,
  171,  172,  174,  175,  173,  182,   66,  176,  177,   66,
  179,  180,  189,  190,  194,  195,  191,  198,  199,  201,
  205,  196,  202,  203,  204,  206,  207,  210,  211,  212,
  213,  214,  221,    1,   31,  114,   21,   42,  115,  215,
  216,  218,  219,   49,   53,  220,   38,   32,   71,   30,
  209,   85,   41,  148,  145,   86,
};
short yycheck[] = {                                      40,
   40,   40,   40,  125,  166,   41,   41,   43,   43,   45,
   45,  287,   44,   42,   42,   43,  286,   45,   47,   47,
  286,  286,  288,   59,   59,  301,  302,   59,   38,   39,
  256,   59,  258,  259,  260,  261,  262,  263,  264,  265,
  266,  267,  268,  269,  270,  271,   40,  209,  275,  276,
  277,  278,  279,  280,  281,  282,  283,   67,   42,   43,
   59,   45,  286,   47,   44,  291,   44,   44,  295,  296,
  297,  298,  299,  300,   44,   59,  286,  303,   88,   59,
   61,   59,   59,   93,   94,   95,   96,  123,  123,   59,
  258,  259,  260,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,   42,   43,   61,   45,   61,   47,
   42,   43,   61,   45,   44,   47,   44,   61,   41,   42,
   43,   59,   45,  291,   47,   42,   43,   59,   45,   59,
   47,   59,  286,  287,  256,  303,  258,  259,  260,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  160,   42,   43,  163,   45,   61,   47,   41,   42,   43,
   40,   45,  172,   47,  258,  286,   61,  290,   59,  291,
  293,  294,  286,  258,  287,  289,  287,   59,   44,  286,
  285,  303,  286,  286,  284,   40,  258,   59,   59,  286,
  274,  273,   59,   44,   41,   41,  258,  272,   59,  258,
   41,   41,  123,  286,   41,  286,  286,   59,   40,   40,
   40,   40,  123,  290,   59,   59,  257,  287,  292,  257,
  287,  290,  290,  287,   59,   59,  292,   44,   44,   44,
   41,   59,   59,   59,   59,   41,   41,  290,  290,  290,
   59,   59,  125,    0,  286,  286,  286,  286,  289,   59,
   59,   59,   59,  258,   41,   59,   59,   59,  123,   59,
  193,  125,   17,  142,  139,   58,
};
#define YYFINAL 16
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 303
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,0,
"';'","'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,"NUMBER","STRING","TESTOBJ","TESTROOM","TESTFLAG","TESTNUM",
"PARAMLESS","IF","ACTOBJ","ACTROOM","ACTFLAG","ACTNUM","ACTROOMOBJ","ACTOBJOBJ",
"TIMER","DIRECT","VLABEL","NLABEL","KW_NOUN","KW_VERB","KW_FLAG","KW_TIMREG",
"KW_ROOMREG","KW_OBJECT","KW_ROOM","KW_ACTION","KW_MESSAGE","OLABEL","FLABEL",
"UNDEF","ROOM","VERB","NOUN","OBJECT","MESSAGE","FLAG","TREG","RREG","PARSTART",
"PARTREASURE","PARLIGHT","PARCARRY","PARABBREV","PARTITLE","PLAYER","VOID",
"SWAP",
};
char *yyrule[] = {
"$accept : prog",
"prog : stmtlist",
"stmtlist : stmt",
"stmtlist : stmtlist stmt",
"$$1 :",
"stmt : KW_NOUN $$1 nounitem ';'",
"$$2 :",
"$$3 :",
"stmt : KW_VERB $$2 verbitem $$3 ';'",
"$$4 :",
"$$5 :",
"$$6 :",
"stmt : KW_ACTION $$4 new_or_old_verb $$5 noun_expr $$6 '{' actlist '}'",
"stmt : KW_MESSAGE UNDEF '=' STRING ';'",
"$$7 :",
"stmt : KW_ROOM UNDEF STRING $$7 dirlist ';'",
"stmt : KW_FLAG flagitem ';'",
"stmt : KW_TIMREG treglist ';'",
"stmt : KW_ROOMREG rreglist ';'",
"stmt : KW_OBJECT objlist ';'",
"stmt : PARSTART '=' ROOM ';'",
"stmt : PARTREASURE '=' ROOM ';'",
"stmt : PARLIGHT '=' expr ';'",
"stmt : PARCARRY '=' expr ';'",
"stmt : PARABBREV '=' expr ';'",
"stmt : PARTITLE '=' string_list ';'",
"string_list : STRING",
"string_list : string_list ',' STRING",
"$$8 :",
"$$9 :",
"verbitem : '(' $$8 VLABEL ')' $$9 vlist",
"$$10 :",
"verbitem : $$10 vlist",
"vlist : UNDEF",
"vlist : vlist ',' UNDEF",
"$$11 :",
"$$12 :",
"nounitem : '(' $$11 NLABEL ')' $$12 UNDEF",
"nounitem : nlist",
"nlist : UNDEF",
"nlist : nlist ',' UNDEF",
"dirlist :",
"dirlist : diritem",
"dirlist : dirlist ',' diritem",
"diritem : DIRECT ROOM",
"diritem : DIRECT UNDEF",
"objlist : objitem",
"objlist : objlist ',' objitem",
"objitem : labelref UNDEF opt_nounref STRING ownerref",
"opt_nounref :",
"$$13 :",
"$$14 :",
"opt_nounref : '(' $$13 nounref $$14 ')'",
"nounref :",
"nounref : NOUN",
"nounref : UNDEF",
"labelref :",
"$$15 :",
"labelref : '(' $$15 OLABEL ')'",
"ownerref :",
"ownerref : PLAYER",
"ownerref : ROOM",
"ownerref : VOID",
"$$16 :",
"$$17 :",
"flagitem : '(' $$16 FLABEL ')' $$17 UNDEF",
"flagitem : UNDEF",
"treglist : UNDEF",
"treglist : treglist ',' UNDEF",
"rreglist : UNDEF",
"rreglist : rreglist ',' UNDEF",
"noun_expr : expr",
"noun_expr : NOUN",
"noun_expr : UNDEF",
"new_or_old_verb : VERB",
"new_or_old_verb : UNDEF",
"actlist : action",
"actlist : actlist action",
"actlist : actlist error ';'",
"action : TESTOBJ '(' OBJECT ')' ';'",
"action : TESTROOM '(' ROOM ')' ';'",
"action : TESTFLAG '(' FLAG ')' ';'",
"action : TESTNUM '(' expr ')' ';'",
"action : PARAMLESS ';'",
"$$18 :",
"$$19 :",
"action : IF '{' $$18 actlist $$19 '}'",
"action : ACTOBJ OBJECT ';'",
"action : ACTROOM ROOM ';'",
"action : ACTFLAG FLAG ';'",
"action : ACTNUM expr ';'",
"action : ACTROOMOBJ ROOM ',' OBJECT ';'",
"action : ACTOBJOBJ OBJECT ',' OBJECT ';'",
"action : TIMER expr ';'",
"action : MESSAGE ';'",
"action : STRING ';'",
"action : SWAP RREG ';'",
"action : SWAP TREG ';'",
"action : SWAP OBJECT ',' OBJECT ';'",
"expr : NUMBER",
"expr : expr '+' expr",
"expr : expr '-' expr",
"expr : expr '*' expr",
"expr : expr '/' expr",
"expr : '(' expr ')'",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 298 "parser.y"
	/* end of grammar */
void printtok(int t, YYSTYPE val);

int yylex(void)
{
    register int c;

    c = skipWhiteSpace();		/* Skip all white space. */

    if (c == EOF)
	return 0;

    /*
     * Test for a number.
     */
    if (isdigit(c)) {
	int i;

	ungetc(c, finp);
	fscanf(finp, "%d", &i);
	yylval.n = i;
	return NUMBER;
    }
    
    /*
     * Test for a string constant.
     */
    if (c == '"') {
	char sbuf[512];
	char *p;

	p = sbuf;

    catenate_strings:
	for (;;) {
	    c = getc(finp);
	    if (c == '"' && (c = getc(finp)) != '"') {
		ungetc(c, finp);
		break;
	    }
	    if (c == '\n' || c == EOF) {
		lineno++;
		error("missing quote");
	    }
	    if (p >= sbuf + sizeof(sbuf) - 1) {
		*p = '\0';
		error("string constant too long");
	    }
	    *p++ = c;
	}
	*p = 0;

	/*
	 * Test for new string following this string.
	 */
	c = skipWhiteSpace();
	if (c != '"')
	    ungetc(c, finp);
	else
	    goto catenate_strings;

	/*
	 * Definite end of string constant.
	 */
	yylval.sp = emalloc(strlen(sbuf)+1);
	strcpy(yylval.sp, sbuf);
	return STRING;
    }
    
    /*
     * Test for identifier.
     */
    if (isalpha(c) || special(c)) {
	Symbol *s;
	char sbuf[100], *p = sbuf;

	do {
	    *p++ = c;
	} while ((c=getc(finp)) != EOF && (isalnum(c) || special(c)));
	ungetc(c, finp);
	*p = '\0';
	s = lookup(*current, sbuf);
	if (s == 0) {
	    yylval.sym = install(current, sbuf, UNDEF);
	    return UNDEF;
	}
	switch (s->type) {
	case UNDEF:
	case ROOM:
	    yylval.sym = s;
	    return s->type;
	default:
	    yylval.n = s->value;
	    return s->type;
	}
    }
    return c;
}

/*
 * Skip white space and comments.
 */
static int skipWhiteSpace(void)
{
	register int c;

start:
	/*
	 * Skip white space.
	 */
	while ((c=getc(finp)), isspace(c))
		if (c == '\n')
			lineno++;

    	/*
    	 * Skip # comment.
    	 */
	if (c == '#') {
		while (getc(finp) != '\n')
			;
		lineno++;
		goto start;	/* Skip more white space */
	}
	return c;
}

static int special(int c)	/* test if special identifier character */
{
	if (strchr("_.!", c) != NULL)
		return YES;
	else
		return NO;
}

void error(char *s)		/* Report fatal error. */
{
     int old_yychar = yychar;
     yychar = -1;		/* Suppress printing of last token. */
     printMessage(s);
     yychar = old_yychar;
     fatalerr = YES;		/* Don't produce any output. */
}

void
warn(char *message)		/* Report a warning message. */
{
     int old_yychar = yychar;
     yychar = -1;		/* Suppress printing of last token. */
     printMessage(message);
     yychar = old_yychar;
}

static void yyerror(char *s)	/* recover from compilation error */
{
    fatalerr = YES;
    printMessage(s);
}


/*----------------------------------------------------------------------
 *
 * printMessage --
 *
 * 	This procedure prints the message on the standard output,
 *	together with the name of the input file and line number.
 *	If there is a last token available in yychar, that will
 *	be printed too to help locate the error.
 *
 * Results:
 *	None.
 *
 *----------------------------------------------------------------------
 */
static void
printMessage(char* message)	/* Message to print. */
{
    printf("%s(%d): %s", infile, lineno, message);
    if (yychar != -1) {
	printf(": ");
	if (yychar >= ' ' && yychar < 255)
	    printf("'%c'", yychar);
	else
	    printtok(yychar, yylval);
    }
    printf("\n");
}
#line 602 "y.tab.c"
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
#line 83 "parser.y"
{
	    yychar = -1;
	    if (info.word_length == 0) {
		info.word_length = 3; /* Silently default. */
	    }
	    if (info.max_load == 0) {
		info.max_load = 4; /* Silently default. */
	    }
	    if (info.current_room == 0) {
		error("parameter 'initial' not set");
	    }
	    FixLightSource();
	    if (!fatalerr) {
		dump();	
	    }
	}
break;
case 4:
#line 105 "parser.y"
{ current = &noun_table; }
break;
case 5:
#line 106 "parser.y"
{ current = &main_table; }
break;
case 6:
#line 107 "parser.y"
{ current = &verb_table; }
break;
case 7:
#line 108 "parser.y"
{ current = &main_table; }
break;
case 9:
#line 110 "parser.y"
{ current = &verb_table; }
break;
case 10:
#line 111 "parser.y"
{ current = &noun_table; }
break;
case 11:
#line 112 "parser.y"
{ current = &main_table; begaction(yyvsp[-2].n, yyvsp[0].n); }
break;
case 12:
#line 113 "parser.y"
{ endaction(); }
break;
case 13:
#line 114 "parser.y"
{ yyvsp[-3].sym->type = MESSAGE;
					  	  yyvsp[-3].sym->value = Message(yyvsp[-1].sp);
						}
break;
case 14:
#line 117 "parser.y"
{ yyvsp[-1].sym->value = owner_level = MakeRoom(yyvsp[0].sp);
				  yyvsp[-1].sym->type = ROOM;
				}
break;
case 20:
#line 125 "parser.y"
{ info.current_room = yyvsp[-1].sym->value; }
break;
case 21:
#line 126 "parser.y"
{ info.treasure_room = yyvsp[-1].sym->value; }
break;
case 22:
#line 128 "parser.y"
{ info.light_time = RangeCheck("light_time", yyvsp[-1].n, 1, 32767); }
break;
case 23:
#line 130 "parser.y"
{ info.max_load = RangeCheck("max_load", yyvsp[-1].n, 1, 256); }
break;
case 24:
#line 132 "parser.y"
{ info.word_length = RangeCheck("word_length", yyvsp[-1].n, 3, 10); }
break;
case 26:
#line 136 "parser.y"
{ titlestr(yyvsp[0].sp); }
break;
case 27:
#line 137 "parser.y"
{ titlestr(yyvsp[0].sp); }
break;
case 28:
#line 140 "parser.y"
{ current = &label_table; }
break;
case 29:
#line 141 "parser.y"
{ NumberVerb(yyvsp[-1].n); current = &verb_table; }
break;
case 31:
#line 143 "parser.y"
{ NumberVerb(VERB_NEXT); }
break;
case 33:
#line 146 "parser.y"
{ SetVerb(yyvsp[0].sym, PRIMARY);	}
break;
case 34:
#line 147 "parser.y"
{ SetVerb(yyvsp[0].sym, SYNONYM); }
break;
case 35:
#line 151 "parser.y"
{ current = &label_table; }
break;
case 36:
#line 152 "parser.y"
{ 	
						NounNo(yyvsp[-1].n);
					  	current = &noun_table;
					}
break;
case 37:
#line 156 "parser.y"
{ SetNoun(yyvsp[0].sym, PRIMARY); }
break;
case 39:
#line 160 "parser.y"
{ SetNoun(yyvsp[0].sym, PRIMARY); }
break;
case 40:
#line 161 "parser.y"
{ SetNoun(yyvsp[0].sym, SYNONYM); }
break;
case 44:
#line 169 "parser.y"
{ SetExit(yyvsp[-1].n, yyvsp[0].sym); }
break;
case 45:
#line 170 "parser.y"
{ SetExit(yyvsp[-1].n, yyvsp[0].sym); yyvsp[0].sym->value = -1; }
break;
case 48:
#line 179 "parser.y"
{ yyvsp[-3].sym->type = OBJECT;
				   yyvsp[-3].sym->value = yyvsp[-4].n;
				   SetItem(yyvsp[-4].n, yyvsp[-1].sp, yyvsp[0].n, yyvsp[-2].n);
				 }
break;
case 49:
#line 185 "parser.y"
{ yyval.n = 0; }
break;
case 50:
#line 186 "parser.y"
{ current = &noun_table; }
break;
case 51:
#line 187 "parser.y"
{ current = &main_table; }
break;
case 52:
#line 187 "parser.y"
{ yyval.n = yyvsp[-2].n; }
break;
case 53:
#line 190 "parser.y"
{ yyval.n = 0; }
break;
case 54:
#line 191 "parser.y"
{ yyval.n = yyvsp[0].n; }
break;
case 55:
#line 192 "parser.y"
{ yyval.n = SetNoun(yyvsp[0].sym, PRIMARY); }
break;
case 56:
#line 195 "parser.y"
{ yyval.n = GetNextItem(); }
break;
case 57:
#line 196 "parser.y"
{ current = &label_table; }
break;
case 58:
#line 197 "parser.y"
{ current = &main_table; yyval.n = yyvsp[-1].n; }
break;
case 59:
#line 200 "parser.y"
{ yyval.n = owner_level; }
break;
case 60:
#line 201 "parser.y"
{ yyval.n = 255; }
break;
case 61:
#line 202 "parser.y"
{ yyval.n = yyvsp[0].sym->value; }
break;
case 62:
#line 203 "parser.y"
{ yyval.n = 0; }
break;
case 63:
#line 213 "parser.y"
{ current = &label_table; }
break;
case 64:
#line 214 "parser.y"
{ current = &main_table; }
break;
case 65:
#line 216 "parser.y"
{ yyvsp[0].sym->type = FLAG;
				  yyvsp[0].sym->value = yyvsp[-3].n;
				}
break;
case 66:
#line 219 "parser.y"
{ if ((yyvsp[0].sym->value = GetNextFlag()) != -1)
				    yyvsp[0].sym->type = FLAG;
				}
break;
case 67:
#line 223 "parser.y"
{ yyval.n = yyvsp[0].sym->value = 0; yyvsp[0].sym->type = TREG; }
break;
case 68:
#line 224 "parser.y"
{ if (yyvsp[-2].n >= 4) {
						error("too many timer regs");
						yyval.n = yyvsp[-2].n;
					  } else {
						yyvsp[0].sym->type = TREG;
						yyval.n = yyvsp[0].sym->value = yyvsp[-2].n+1;
					  }	
					}
break;
case 69:
#line 234 "parser.y"
{ yyval.n = yyvsp[0].sym->value = 0; yyvsp[0].sym->type = RREG; }
break;
case 70:
#line 235 "parser.y"
{ if (yyvsp[-2].n >= 5) {
						error("too many room regs");
						yyval.n = yyvsp[-2].n;
					  } else {
						yyvsp[0].sym->type = RREG;
						yyval.n = yyvsp[0].sym->value = yyvsp[-2].n+1;
					  }
					}
break;
case 73:
#line 249 "parser.y"
{ yyval.n = SetNoun(yyvsp[0].sym, PRIMARY); }
break;
case 74:
#line 252 "parser.y"
{ yyval.n = yyvsp[0].n; }
break;
case 75:
#line 253 "parser.y"
{ NumberVerb(VERB_NEXT);
				  yyval.n = SetVerb(yyvsp[0].sym, PRIMARY); }
break;
case 78:
#line 260 "parser.y"
{ yyerrok; }
break;
case 79:
#line 263 "parser.y"
{ action1(yyvsp[-4].n, yyvsp[-2].n); }
break;
case 80:
#line 264 "parser.y"
{ action1(yyvsp[-4].n, yyvsp[-2].sym->value); }
break;
case 81:
#line 265 "parser.y"
{ action1(yyvsp[-4].n, yyvsp[-2].n); }
break;
case 82:
#line 266 "parser.y"
{ action1(yyvsp[-4].n, yyvsp[-2].n); }
break;
case 83:
#line 267 "parser.y"
{ action0(yyvsp[-1].n); }
break;
case 84:
#line 268 "parser.y"
{ begcatch(); }
break;
case 85:
#line 268 "parser.y"
{ endcatch(); }
break;
case 87:
#line 269 "parser.y"
{ action1(yyvsp[-2].n, yyvsp[-1].n); }
break;
case 88:
#line 270 "parser.y"
{ action1(yyvsp[-2].n, yyvsp[-1].sym->value); }
break;
case 89:
#line 271 "parser.y"
{ actflag(yyvsp[-2].n, yyvsp[-1].n); }
break;
case 90:
#line 272 "parser.y"
{ action1(yyvsp[-2].n, yyvsp[-1].n); }
break;
case 91:
#line 273 "parser.y"
{ action2(yyvsp[-4].n, yyvsp[-3].sym->value, yyvsp[-1].n); }
break;
case 92:
#line 274 "parser.y"
{ action2(yyvsp[-4].n, yyvsp[-3].n, yyvsp[-1].n); }
break;
case 93:
#line 275 "parser.y"
{ acttimer(yyvsp[-2].n, yyvsp[-1].n); }
break;
case 94:
#line 276 "parser.y"
{ action0(yyvsp[-1].n); }
break;
case 95:
#line 277 "parser.y"
{ action0(Message(yyvsp[-1].sp)); }
break;
case 96:
#line 279 "parser.y"
{
			if (yyvsp[-1].n == 0) {
				action0(OP_SELECT_RV);
    			} else {
				action1(OP_SWAP_LOC_RV, yyvsp[-1].n);
			}
		}
break;
case 97:
#line 286 "parser.y"
{ action1(OP_SWAP_COUNTER, yyvsp[-1].n); }
break;
case 98:
#line 287 "parser.y"
{ action2(OP_SWAP_ITEMS, yyvsp[-3].n, yyvsp[-1].n); }
break;
case 99:
#line 290 "parser.y"
{ yyval.n = yyvsp[0].n; }
break;
case 100:
#line 291 "parser.y"
{ yyval.n = yyvsp[-2].n + yyvsp[0].n; }
break;
case 101:
#line 292 "parser.y"
{ yyval.n = yyvsp[-2].n - yyvsp[0].n; }
break;
case 102:
#line 293 "parser.y"
{ yyval.n = yyvsp[-2].n * yyvsp[0].n; }
break;
case 103:
#line 294 "parser.y"
{ yyval.n = yyvsp[-2].n / yyvsp[0].n; }
break;
case 104:
#line 295 "parser.y"
{ yyval.n = yyvsp[-1].n; }
break;
#line 1120 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
