/*
 *    ScottCom -- Compiles adventures into the Scott Adams format.
 *    Copyright (C) 1985-1996  Bjorn Gustavsson
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: scottcom.c,v 1.2 1996/10/17 04:01:57 bjorn Exp $
 *
 */
#include "scottcom.h"
#include <ctype.h>

char acknowledge[] = "* Compiled by ScottCom, ver. 2.00 *";
char	*progname = "scottcomp"; /* for error messages */
int	lineno = 1;
int	fatalerr = NO;
int	verbose = NO;
char	*infile, *outfile;
FILE	*finp;

/*
 * Function pointers for the output format.
 */
unsigned (*translate)(unsigned code);
void (*titlestr)(char*);
void (*begaction)(int, int);
void (*endaction)(void);
void (*begcatch)(void);
void (*endcatch)(void);
void (*action0)(unsigned);
void (*action1)(unsigned, unsigned);
void (*action2)(unsigned, unsigned, unsigned);
void (*dump)(void);

int main(int argc, char *argv[])
{
    fprintf(stderr, "ScottCom, version 2.00\n");
    ti99_init();
    init();
    while (argc > 1 && argv[1][0] == '-') {
	switch (tolower(argv[1][1])) {
	case 'v':		/* -v: Verbose */
	    verbose = YES;
	    break;
	}
	argc--;
	argv++;
    }
    if (argc == 1)
	execerror("source file name must be specified");
    if (getexten(argv[1])[0] == '\0')
	infile = newexten(argv[1], ".apl");
    outfile = newexten(infile, "");
    if ((finp = fopen(infile, "r")) == NULL)
	execerror("cannot open source file");
    initprint(outfile);
    yyparse();
    fclose(finp);
    stopprint();
    if (fatalerr) {
	unlink(outfile);
	exit(1);
    }
    exit(0);
}

void execerror(char *s)
{
    fprintf(stderr, "%s: %s\n", progname, s);
    exit(1);
}

/*
 * Return pointer to extension or end of name.
 */
char *getexten(register char *name)
{
    register int i;

    for (i = strlen(name) - 1; i >= 0; i--) {
	if (name[i] == '.')
	    return name + i;
	if (name[i] == '/' || name[i] == '\\')
	    break;
    }
    return name + strlen(name);
}

char *newexten(char *name, char *ext) /* return pointer to name with new extension */
{
    char *new = emalloc(strlen(name)+strlen(ext)+1);

    strcpy(new, name);
    strcpy(getexten(new), ext);
    return new;
}

void _Assert(const char* file, unsigned line)
{
    fflush(stdout);
    fprintf(stderr, "\nAssertion failed: %s, line %u\n", file, line);
    fflush(stderr);
    abort();
}

