{Routinen fr den Dateizugriff von HEXEDIT}

PROCEDURE Load;

VAR
Again : BOOLEAN;

BEGIN
TempS := FExpand(FileName);
Again := FALSE;
BackUp := TRUE;
Temp := 'C:@BACKUP@';
FOR Drive := 3 TO 26 DO
IF DiskFree(Drive) > FileSize(WorkFile) THEN
BREAK;
Temp[1] := Chr(Drive + 64);
FOR I := Ord(FileName[0]) DOWNTO Ord(FileName[0])-8 DO
Dir[I] := UpCase(FileName[I]);
Dir[0] := #8;
IF (Drive = -1) OR (FileName = '@BACKUP@') THEN
BEGIN
SaveScreen;
StatusBar('WAITING...');
FoldOffWindow(' Note ',22, 9, 62, 16, LightCyan, Black+Blink, 1);
InfoBar(BackUpDLG);
TextBackground(LightCyan);
TextColor(LightRed);
GotoXY(24, 11);
Write('It''s impossible to create Swap-File...');
GotoXY(24, 13);
TextColor(Black);
Write('No Backup-File/Undo-Feature possible.');
GotoXY(36, 14);
Write('Go on [Y/N]: ');
BlockCursor;
REPEAT
C := ReadKey;
IF C = #27 THEN
EndUp('');
UNTIL C IN ['Y', 'y', 'N', 'n'];
HideCursor;
IF C IN ['N', 'n'] THEN
BEGIN
RestoreScreen;
DoOpen;
Again := TRUE;
END
ELSE
BEGIN
BackUp := FALSE;
RestoreScreen;
END;
END;
IF NOT Again THEN
BEGIN
IF FileType = New THEN
BackUp := FALSE;
IF NOT BackUp THEN
Temp := FileName;
Assign(BackUpFile, Temp);
IF BackUp THEN
ReWrite(BackUpFile, 1)
ELSE
ReSet(BackUpFile, 1);
MaxBlocks := 1;
IF FileSize(WorkFile) < 15360 THEN
EndPos := FileSize(WorkFile)-1
ELSE
BEGIN
EndPos := -1;
MaxBlocks := 1;
Inc(MaxBlocks, (FileSize(WorkFile)-15360) DIV 15104);
IF ((FileSize(WorkFile)-15360) MOD 15104) <> 0 THEN
Inc(MaxBlocks);
END;
IF FileSize(WorkFile) = 0 THEN
EndPos := 0;
StatusBar('LOADING FILE...');
IF BackUp THEN
BEGIN
Seek(WorkFile, 0);
Seek(BackUpFile, 0);
FOR I := 1 TO MaxBlocks DO
BEGIN
BlockRead(WorkFile, FileArea, SizeOf(FileArea), Counts);
BlockWrite(BackUpFile, FileArea, Counts);
Inc(Position, Counts);
UpDateSize(Position);
END;
Temp[0] := #2;
BackUpName := Temp + '\@BACKUP@';
Close(BackUpFile);
Seek(WorkFile, 0);
END;
IF FileType = Old THEN
BlockRead(WorkFile, FileArea, 15360, Counts)
ELSE
FillChar(FileArea, SizeOf(FileArea), 0);
CurPos := 0;
CursorPos := 0;
Blocks := 0;
Position := 0;
Index := 0;
FSize := FileSize(WorkFile);
StatusBar('');
IF FileType = New THEN
EndPos := 0;
UpDateSize(FSize);
UpDatePosition;
END;
END;

PROCEDURE LoadFile;

BEGIN
SaveScreen;
FileState := UnChanged;
FileType := Old;
FOR X := 1 TO Length(FileName) DO
FileName[X] := UpCase(FileName[X]);
Assign(WorkFile, FileName);
GetFAttr(WorkFile, FileAttr);
IF (FileAttr AND ReadOnly) <> 0 THEN
BEGIN
StatusBar('WAITING...');
InfoBar(MSG1);
FoldOffWindow(' Note ',24, 11, 52, 14, LightCyan, Red+Blink, 3);
GotoXY(27, 12);
TextBackground(LightCyan);
TextColor(Black);
Write('File is Write-protected!');
GotoXY(26, 13);
Write('Disable Protection [Y/N]:');
BlockCursor;
REPEAT
C := ReadKey;
UNTIL C IN ['Y', 'y', 'N', 'n'];
HideCursor;
RestoreScreen;
IF C IN ['N', 'n'] THEN
DoOpen
END;
I := Archive;
CDRom := FALSE;
SetFAttr(WorkFile, I);
GetFAttr(WorkFile, I);
IF I = ReadOnly THEN
CDRom := TRUE;
ReSet(WorkFile, 1);
IF IOResult <> 0 THEN
BEGIN
StatusBar('WAITING...');
InfoBar(MSG2);
FileAttr := Archive;
FoldOffWindow(' Note ', 24, 11, 52, 14, LightCyan, Red+Blink, 3);
TextColor(Black);
GotoXY(29, 12);
Write('File doesn''t exist...');
GotoXY(29, 13);
Write('Create it [Y/N]:');
BlockCursor;
REPEAT
C := ReadKey;
UNTIL C IN ['N', 'n', 'Y', 'y'];
HideCursor;
IF C IN ['N', 'n'] THEN
DoOpen
ELSE
BEGIN
FileType := New;
ReWrite(WorkFile, 1);
IF IOResult <> 0 THEN
EndUp('Disk Full.'+#10#13+'Can''t create '+FileName+',...');
END;
END;
GetFTime(WorkFile, FTimeDate);
RestoreScreen;
TextBackground(Blue);
TextColor(White);
GotoXY(12, 24);
WriteLn('            ');
GotoXY(12, 24);
FSplit(FileName, TempS, Temp, Dir);
Temp := Temp+Dir;
WriteLn(Temp);
Load;
END;


