{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Const
{ ************************************************************************** }
{ *** Verschiedene Konstanten der Programme                              *** }
{ ************************************************************************** }
                          PROT_IPX = 1;           { IPX-Protokoll-ID }
                      PROT_NETBIOS = 2;

             MaxDriversInstallable = 5;          { Max. Anzahl an installierbaren Treibern }


{ *** Treiber-Kommandos fr das Manager-Modul                            *** }
              DRVCMD_GETMAXDRIVERS = 1;          { Anzahl an maximal installierbaren und installierten Treibern erfragen }
             DRVCMD_REGISTERDRIVER = 3;          { Einen Treiber registrieren }
               DRVCMD_DELETEDRIVER = 4;          { Einen reigstrierten Treiber wieder lschen }
              DRVCMD_GETDRIVERINFO = 9;          { Informationen ber einen Treiber erlangen }
              DRVCMD_SETTOCALLPROC = 10;         { Die Event-Routine fr einen bestimmten Treiber setzen }

                       RET_SUCCESS = $FF;        { Kommando erfolgreich ausgefhrt ! }
                 RET_NOMOREDRIVERS = $01;        { Keine Treiber-Pltze frei ! }


Type
{ ************************************************************************** }
{ *** Elementerare Zeigertypen, die bentigt werden                      *** }
{ ************************************************************************** }
       pPointer = ^Pointer;                      { Zeiger auf einen Zeiger }
         tStr10 = String[10];                    { Der String-Typ, der immer den langen Netzwerknamen hat }
          tStr3 = String[3];                     { Der String-Typ, der immer den kurzen Netzwerknamen hat }

       pWordRec = ^WordRec;
        WordRec = Record                         { Wird verwendet, um auf die einzelnen Bytes eines Words zugreifen zu knnen.}
                   Lo,Hi : Byte;
                  End;
       pLongRec = ^LongRec;
        Longrec = Record                         { Wird verwendet, um auf die einzelnen Words eines Longs zugreifen zu knnen.}
                   Lo,Hi : Word;
                  End;

{ ************************************************************************** }
{ *** Typen-Deklarationen der jeweiligen Funktionsparameter              *** }
{ ************************************************************************** }

{ *** Der Funktionsrumpf der Haupt-Funktions-Dispatcher-Routine des      *** }
{ *** Treiber-Managers.                                                  *** }
       CallProc = Function( Command : Word; Request : Pointer) :Word;
{ *** Der Funktionsrumpf der Prozedur zum Abschicken eines Datenpaketes  *** }
      tSendProc = Function(IDNumber:Word;Address:pAddressChain;DataPointer:Pointer;DataLength:Word;WorkGroup:Word):Word;
{ *** Der Funktionsrumpf der Prozedur zumm Initialisieren des Treibers   *** }
tInitializeProc = Procedure;
{ *** Der Funktionsrumpf der DE-Initialisierungsroutine des Treibers     *** }
      tKillProc = Procedure;
{ *** Der Funktionsrumpf zum Vergleichen zweier Addressen des gleichen   *** }
{ *** Basistreibers                                                      *** }
   tCompareProc = Function( ID1, ID2 : Pointer ) : Boolean;


{ ************************************************************************** }
{ *** Typen-Deklarationen der Strukturen, die zur Kommunikation zwischen *** }
{ *** Treiber und Manager bzw. Manager und Anwender verwendet werden.    *** }
{ ************************************************************************** }
 pGetMaxDrivers = ^tGetMaxDrivers;               { Maximale Anzahl an insatllierten Treibern etc. erfragen }
 tGetMaxDrivers = Record
             MaxDrivers : Byte;                  { Maximale Treiberanzahl }
       InstalledDrivers : Byte;                  { Anzahl der installierten Treiber }
            DriverParts : Array[1..MaxDriversInstallable] of Byte; { Die Treiber-IDs der bereits installierten Treiber }
                       End;

     pRegisterDriver = ^tRegisterDriver;         { Einen Treiber registrieren }
     tRegisterDriver = Record
               DriverID : Byte;                  { Die ID-Nummer }
           SpecialFlags : Word;                  { Wird verwendet um besondere Bedrfnisse des Treibers kennzuzeichnen }
            LongVersion : LongRec;               { Die jeweilige Treiber-Version (HI/LO)}
                    Mtu : Word;                  { Die Treiber-Mtu (Maximale Datenzahl) }
               DataPart : Word;                  { Die Nutzdaten (Maximale NUTZdatenzahl) }
              NameShort : tStr3;                 { Ein Kurzer Name (z.B. IPX) }
               NameLong : tStr10;                { Ein lngerer Name (z.B. NetBIOS) }
           ToCallProcPt : Pointer;               { Zeiger auf die Addresse der Aufzurufenden Prozedur }
            CompareProc : tCompareProc;          { Zeiger auf die Vergleiche-Prozedur }
               SendProc : tSendProc;             { Zeiger auf die Sende-Prozedur des Treibers }
          InitalizeProc : tInitializeProc;       { Zeiger auf die Initialisierungsroutine des Treibers }
               KillProc : tKillProc;             { Zeiger auf die De-Initialisierungsroutine des Treibers }
              NetAddrPt : Pointer;               { Zeiger auf die Netzwerkaddresse des Treibers }

            DirNameAddr : pStr12;
                       End;

         pKillDriver = ^tKillDriver;             { Wird verwendet um einen Treiber zu de-Registrieren }
         tKillDriver = Record
               DriverID : Byte;                  { Die ID-Nummer }
                       End;

      pSetToCallProc = ^tSetToCallProc;          { Wird verwendet um die Addresse der Event-Routine zu ndern }
      tSetToCallProc = Record
                     DriverID : Byte;            { Die Treiber-Nummer }
                         Proc : Pointer;         { Die neue Addresse der Event-Routine }
                       ENd;


              tStr200 = String[200];

                pByte = ^Byte;                   { Zeiger auf ein Byte }
                pChar = ^Char;

           pWordArray = ^tWordArray;
           tWordArray = Array[1..1] of Word;


 pInterruptInfoStruct = ^tInterruptInfoStruct;
 tInterruptInfoStruct = Record
                       OldInt08 : Pointer;       { Beinhaltet den alten Interrupt-Vektor fr Int08, Timer }
                       OldInt09 : Pointer;       { Beinhaltet den alten Interrupt-Vektor fr Int09, Tastatur }
                       OldInt28 : Pointer;       { Beinhaltet den alten Interrupt-Vektor fr Int28, Dos-Idle }
                       OldInt71 : Pointer;       { Beinhaltet den alten Interrupt-Vektor fr Int71, Mein "COMM-Interrupt" }
                       OldInt10 : Pointer;
                         End;
Const
    OldInt08OffsetInStruct = 0;
    OldInt09OffsetInStruct = 4;
    OldInt28OffsetInStruct = 8;
    OldInt71OffsetInStruct = 12;
    OldInt10OffsetInStruct = 16;

Type


        tcrtByteArray = Array[0..$18] of Byte;

 pInterruptedMachiene = ^tInterruptedMachiene;
 tInterruptedMachiene = Record
               VideoMode : Word;                 { Der alte Videomodus }
{                 OldCurX : Byte;                 { Die alten Cursorpositionen }
{                 OldCurY : Byte; }
                 CurWord : Word;
            OldScanStart : Byte;                 { Die Scanzeilen des Cursors }
             OldScanStop : Byte;
              SavedBytes : LongInt;              { Die abgespeicherten Bytes }
              MiscOutReg : Byte;                 { Das MISC-Out-Register (nur bei Textmodus) }
         ClockingModeReg : Byte;                 { Das alte Clocking-Mode-Reg }
    HorizontalPelPanning : Byte;                 { Das alte Hor-Pel-Panning-Reg }
             ModeControl : Byte;                 { Das alte Mode-Control-Reg. (wegen Blinken/Hell) }
  OldWindow1, OldWindow2 : Word;                 { Die VESA-Fenster fr die Zugriffskontrolle }
                CrtBytes : tcrtByteArray;        { Die alten CRT-Register }
                 TagByte : Byte;                 { Um die "ungerade" Grsse der Struktur auszugleichen }
                        End;

{ ************************************************************************** }
{ *** Nun der Mll fr die Workgroups                                    *** }
{ ************************************************************************** }

 tClassRoomProps = Record
          IsClosed : Boolean;                    { Knnen noch Mitglieder aufgenommen werden ? }
        MaxMembers : Word;                       { Maxmiale Anzahl an Mitgliedern bevor geschlossen wird (0=Unbegrenzt) }
                   End;

 pteacherClassRoom = ^tteacherClassRoom;         { Ein Klassenraum aus der Sicht eines Lehrers }
 tteacherClassRoom = Record
      ClassRoomID : Word;                        { Die ID-Nummer des Klassenraums }
   ClassRoomProps : tClassRoomProps;
      CurrentLast : Word;
      ManagerName : tStr50;
    ClassRoomText : tStr50;                     { Die Kursbeschreibung mit #0 getaggt }
              End;

