{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
UNit DrivMan;
{ Die Unit fr den Treiber-Manager }
INTERFACE
Uses Dos,Crt,ProgVars,ReadKeys;

Procedure InitManager;

Function GetInstalledDriverNum : Byte;
Procedure WriteBaseDriverInformation;
Function DriverInSlot( Lauf1 : Byte ) : Byte;
Function MaxPossibleDrivers : Byte;

IMPLEMENTATION
Const
 DRV_NONE = 0;



Function GetInstalledDriverNum : Byte;
Var
 Struct : tGetMaxDrivers;
Begin
 DriverManagerProc(DRVCMD_GETMAXDRIVERS,@Struct);
 GetInstalledDriverNum := Struct.InstalledDrivers;
End;

Function MaxPossibleDrivers : Byte;
Var
 Struct : tGetMaxDrivers;
Begin
 DriverManagerProc(DRVCMD_GETMAXDRIVERS,@Struct);
 MaxPossibleDrivers := Struct.MaxDrivers;
End;

Function DriverInSlot( Lauf1 : Byte ) : Byte;
Var
 Struct : tGetMaxDrivers;
Begin
 DriverManagerProc(DRVCMD_GETMAXDRIVERS,@Struct);
 DriverInSlot := Struct.DriverParts[Lauf1];
End;

Procedure WriteBaseDriverInformation;
Var
 DrivInfo : pRegisterDriver;
 Lauf1 :Word;
Begin
 For Lauf1 := 1 to MaxPossibleDrivers do
  Begin
   If DriverInSlot(Lauf1) <> DRV_NONE then
    Begin
     pByte(@DrivInfo)^ := DriverInSlot(Lauf1);
     DriverManagerProc(DRVCMD_GETDRIVERINFO,@DrivInfo);
     With DrivInfo^ do
      Begin
  Writeln(NameLong,' (',NameShort,')      Version : ',LongVersion.Hi,'.',LongVersion.Lo,'    Datengre : ',DataPart,' Bytes');
      End;
    End;
  End;
End;


Procedure InitManager;
Var
 Regs : Registers;
 Y: Longrec;
Begin
 With Regs do
  Begin
   Ah := $C5;                                    { $C5 -> ID von den Treibern }
   Al := $AA;                                    { $AA -> Installations-Check }
   BX := $00;                                    { $00 -> Fr den Manager }
   Intr($2F,Regs);
  End;
 If Regs.Bx = $FF then                           { BX = $FF -> OK. }
  Begin
   With Regs do
    Begin
     Ah := $C5;
     Al := CMD_GetProcAddress;
     Bx := 0;
    ENd;
   Intr($2F,Regs);
   With Regs do
    Begin
     Y.Lo := Ax;
     Y.Hi := Bx;
    End;
   DriverManagerProc := CallProc(Y);
   ManagerLoaded := TRUE;
  End
 Else
  Begin
  End;
End;



End.