{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit Events;
INTERFACE
Uses NetTypes,MiscProc,ProgVars,StrType,Crt;
{ **************************************************************************
  In dieser Unit besteht die Mglichkeit, Events asnchron abzuarbeiten.
  Der Event in dem Record ist immer gleich der Botschaftnummer in einem
  zugehrigen IPX-Paket
  ************************************************************************** }
Type
            pEvent = ^tEvent;
            tEvent = Record
                    pNext : pEvent;
                    pPrev : pEvent;
              EventOrigin : tCompleteNetWorkIDStruct;
                      Case WhatEvent : Word of
    GETCONNECTEDPERSONSREPLY : (  EvConnectedPersonReply : pStr50 );
          GETCLASSROOMSREPLY : (  EvClassRoomID : Word;
                             EvClassRoomManager : pStr50;
                                EvClassRoomText : pStr50 );
             MAYDAYHELPMESOS : (     HelpMeText : pStr70 );
           HEREISTHEFULLTEXT : ( HelpMeTextLine : pStr70;
                                        LineNum : Word);
      ENTERWORKGROUPresponse : (     MayIEnter : Boolean;
                                   WorkGroupID : Word );
                     End;

Const
 FirstEvent : pEvent = NIL;
  LastEvent : pEvent = NIL;

Function AppendEvent : pEvent;

Procedure KillEvent( EventType : Word );
{ Lscht ein Typ an Events }

Function NextSameEvent( Event : pEvent ) : pEvent;
Function NextPrevEvent( Event : pEvent ) : pEvent;
{ Liefern das nchste bzw. vorhergehendes Ereignis zurck, das den gleichen Typ
  wie "Event" hat }

Function FindLastEvent( WhatEvent : Word ) : pEvent;
Function FindFirstEvent( WhatEvent : Word ) : pEvent;

IMPLEMENTATION

Function AppendEvent : pEvent;
Begin
 If (LastEvent = NIL) then                { Wenn noch kein Element eingetragen ist ... }
  Begin
   GetMem(FirstEvent,SizeOf(tEvent));      { Es ist das erste in der Kette ... }
   FillChar(FirstEvent^,SizeOf(tEvent),0);
   LastEvent := FirstEvent;                { Und das letzte Element aktualisieren }
   FirstEvent^.pPrev := NIL;
  End
 Else
  Begin
   GetMem(LastEvent^.pNext,SizeOf(tEvent)); { Speicher hinter dem letzten Item belegen }
   FillChar(LastEvent^.pNext^,Sizeof(tEvent),0);
   LastEvent^.pNext^.pPrev := LastEvent;
   LastEvent := LastEvent^.pNext;            { Und nun den Zeiger auf das letzte Element aktualisieren }
  End;
 AppendEvent := LastEvent;
End;

Procedure FreeEventMem( Event : pEvent );
Begin { Lscht den Speicher der durch die Event-Verwaltung innerhalb des Events benutzt wurde }
 Case Event^.WhatEvent of
  GETCLASSROOMSREPLY : Begin
                        FreeMem(Event^.EvClassRoomManager,SizeOf(tStr50));
                        FreeMem(Event^.EvClassRoomText,SizeOf(tStr50));
                       End;
GETCONNECTEDPERSONSREPLY :
                         begin
                          FreeMem(Event^.EvConnectedPersonReply,SizeOf(tStr50));
                         ENd;
       SPEECHLABACTIVE : FreeMem(Event^.EvConnectedPersonReply,SizeOf(tStr50));
       MAYDAYHELPMESOS : FreeMem(Event^.HelpMeText,SizeOf(tStr70));
     HereIsTheFullText : Freemem(Event^.HelpMeTextLine,SizeOf(tStr70));
 End;
End;

Function NextSameEvent( Event : pEvent ) : pEvent;
Var
 Tmppt : pEvent;
Begin
 Tmppt := Event^.pNext;
 While (Tmppt <> NIL) and (Tmppt^.WhatEvent <> Event^.WhatEvent) do Tmppt := Tmppt^.pNext;
 NextSameEvent := Tmppt;
End;

Function FindFirstEvent( WhatEvent : Word ) : pEvent;
Var
 Tmppt : pEvent;
Begin
 Tmppt := FirstEvent;
 While (Tmppt^.WhatEvent <> WhatEvent) and (Tmppt <> NIL) do Tmppt := Tmppt^.pNext;
 FindFirstEvent := Tmppt;
End;

Function FindLastEvent( WhatEvent : Word ) : pEvent;
Var
 Tmppt : pEvent;
Begin
 Tmppt := LastEvent;
 While (Tmppt^.WhatEvent <> WhatEvent) and (Tmppt <> NIL) do Tmppt := Tmppt^.pPrev;
 FindLastEvent := Tmppt;
End;

Procedure KillEvent( EventType : Word );
Var
     Tmppt : pEvent;
    Tmppt2 : pEvent;
Begin
 Tmppt := FindFirstEvent(EventType);

 While Tmppt <> NIL do
  Begin
   Tmppt2 := NextSameEvent(Tmppt);
   If Tmppt^.pPrev <> NIL then
    Begin
     If tmppt^.pNext = NIL then
      Begin
       LastEvent := Tmppt^.pPrev;
      End;
     FreeEventMem(Tmppt);
     Tmppt^.pNext^.pPrev := Tmppt^.pPrev;
     Tmppt^.pPrev^.pNext := Tmppt^.pNext;
     FreeMem(Tmppt, SizeOf(tEvent));
    End
   Else
    Begin
     FirstEvent := Tmppt^.pNext;
     If Tmppt^.pNext = NIL then
      Begin { Es ist das einzige Din in der Kette }
       LastEvent := NIL;                         { Nun ist die Kette leer. }
      End
     Else { ********** Korrektur ? **** }
      Begin
       Tmppt^.pNext^.pPrev := NIL;
      End;
     FreeEventMem(Tmppt);
     FreeMeM(Tmppt,SizeOf(tEvent));
    End;
   Tmppt := Tmppt2;
  End;
End;

Function NextPrevEvent( Event : pEvent ) : pEvent;
Var
 Tmppt : pEvent;
Begin
 Tmppt := Event^.pPrev;
 While (Tmppt <> NIL) and (Tmppt^.WhatEvent <> Event^.WhatEvent) do Tmppt := Tmppt^.pPrev;
 NextPrevEvent := Tmppt;
End;


End.