{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{ ************************************************************************** }
{ *** Der Interrupt-Handler fr den Interrupt 08h.      (Hardware-Timer) *** }
{ ************************************************************************** }
{ * Der Zweck dieses Interrupthandlers ist vielfltig. Er dient vor allem  * }
{ * zur einfacheren Verwaltung von "Verwaltungsaufgaben". Die Hauptaspekte * }
{ * sind dabei :                                                           * }
{ ************************************************************************** }
{ * 1. Verwaltung von Broadcast-Einstellungen                              * }
{ ************************************************************************** }
{ * Unter diesen Punkt fllt vor allem die stndige bertragung von Daten  * }
{ * von einem Rechner auf einen anderen. Das beste Beispiel von Sachen die * }
{ * hierunterfallen ist das bertragen des Bildschirminhaltes des "Lehrers"* }
{ * auf die Rechner der "Schler". Dazu mssen in bestimmten Abstnden     * }

Procedure MeinInt08; Interrupt;
Type
      pSendStruct = ^tSendStruct;
      tSendStruct = Record
                  ID : Word;
         DataPointer : Pointer;
          DataLength : Word;
                    End;

      tSavedState = Record
             SavePtr : Pointer;                  { Speichert die Informationen fr die Rcknahme der aktuellen Aktion. }
        SavedProcess : Word;                     { Der Zustand, der gesichtert wurde. }
                    End;


Var
           SendIt : pSendStruct;                 { Ist da zum "Versammeln" der Daten fr ein Send }
       SavedState : tSavedState;
    TempWorkPlace : Pointer;
     SpeedCounter : Word; {}
            Lauf1 : Word;
     BytesToWrite : Word;
     AllocMemSize : LongInt;
       SendResult : Byte;                        { Das Ergebnis des Absenden eines Paketes }
  CurrentProtoCol : Byte;

Begin
  { ************************************************************************ }
  { ***    Anmerkung :                                                   *** }
  { *** Diese "Beschrnkung" (Kann ja aufgehoben werden) ist dazu da,    *** }
  { *** das ein "Student" oder "Teacher" nicht sehen kann, was der,      *** }
  { *** dessen Bildschirm "gecaptured" wird, in seinem Control-Center    *** }
  { *** macht, um nicht an "sensibele" Einstellungen zu kommen.          *** }
  { ************************************************************************ }
 If (TsrAktiv = TSR_NONEACTIVE) and (In_Bios = 0) then        { Ist das Control-Center aktiv und die Festplatte inaktiv ? }
  Begin                                          { Nein ! }
   TsrAktiv := TSR_INTERRUPT08ACTIVE;

   If VideoIsToSave and (Dos_Ptr^ = 0) then      { Mu der Schirm noch gesichert werden, und kann dies getan werden ? }
    Begin
     SaveDataToDisk(SAVEDATAFOR_Interrupted,SavedVideoInMem);
     KillMemBlocks(SavedVideoInMem);
     VideoIstoSave := FALSE;
     MachieneAccessEnable := TRUE;
    End;

   If EndOfCapture and (Dos_Ptr^ = 0) then       { Das Capture soll beendet werden. Den Bildschirm etc. wiederherstellen }
    Begin
     MachieneAccessEnable := FALSE;
     EndOFCapture := FALSE;
     ReadDataFromDisk(SAVEDATAFOR_Interrupted,SavedVideoInMem);
    End;

   { *********************************************************************** }
   { *** berprfen, ob der "Gegner" antwortet                           *** }
   { *********************************************************************** }

   If (SendingData <> SEND_NONE) then
    Begin
     If (CaptureStarted = FALSE) and (SendingData = SEND_BROADCAST) then
      Begin
       CaptureStarted := TRUE;
       For Lauf1 := 1 to MaxProtoCol do
        SendStatus[Lauf1] := SENDPHASE_SYNCHRONIZE;      { Nun wird in die erste "Sende-Phase" eingetreten }
      End
     Else If ((SendingData = SEND_BROADCAST) and CaptureStarted) or (SendingData = SEND_TOTEACHER) then
      Begin
       GetMem(Sendit,SizeOf(tSendStruct));

       For CurrentProtoCol := 1 to DriversLoaded do If UseProcs[CurrentProtoCol] then
        Begin
         For SpeedCounter := 1 to SpeedUpFactor do
          Begin
           Case SendStatus[CurrentProtoCol] of
          SENDPHASE_CHARSET,
      SENDPHASE_PALETTEDATA,
        SENDPHASE_SCREENDATA : AllocMemSize := Drivers[CurrentProtoCol]^.DataPart;
       SENDPHASE_CURSORDATA  : AllocMemSize := SizeOf(tCurSorDataTransfer);
       SENDPHASE_STARTSCREEN : AllocMemSize := SizeOf(tScreenDataTransferStart);
       SENDPHASE_SYNCHRONIZE : AllocMemSize := SizeOf(tBroadCastDataStart);
           Else AllocMemSize := 0;
          End;
          If AllocMemSize <> 0 then
           Begin
            GetMem(TempWorkPlace,AllocMemSize);
            FillChar(pByte(TempWorkplace)^,AllocMemSize,0);
           End;

           { *************************************************************** }
           { *** Nun mu der Status gesichert werden, um bei einem       *** }
           { *** Sendefehler den Vorgang wiederholen zu knnen.          *** }
           { *************************************************************** }
           With SavedState do
            Begin
             SaveDProcess := SendStatus[CurrentProtoCol];
             Case SendStatus[CurrentProtoCol] of
        SENDPHASE_CHARSET,
      SENDPHASE_STOPMOUSE,
    SENDPHASE_PALETTEDATA,
    SENDPHASE_STARTSCREEN,
     SENDPHASE_SCREENDATA : Begin
                             GetMem(SavePtr,SizeOf(tVideoProcess));
                             pVideoProcess(SavePtr)^ := ProcessContinue[CurrentProtoCOl];
                            End;
             End;
            SendResult := 0;
          End;

         FillChar(SendIt^,SizeOf(tSendStruct),0);

       Case SendStatus[CurrentProtoCol] of                       { In welcher Phase befindet sich die Transaktion ? }
 SENDPHASE_SYNCHRONIZE : Begin
                         { ************************************************* }
                         { * 1. Synchornisierungsphase.                    * }
                         { * Mit dieser Nachricht wird an alle verbundenen * }
                         { * Rechner der Beginn eines neuen Zyklus         * }
                         { * signalisiert. Danach wird zur nchsten Phase, * }
                         { * dem Bildschirm-Start-Signal bergegangen.     * }
                         { * Auch wird hier die allgemeine Information bertragen * }
                         { ************************************************* }
                          { Temporrar }

                          With pBroadCastDataStart(TempWorkplace)^ do
                           Begin
                         VersionIDMaj := MyVersionMaj;
                         VersionIDMin := MyVersionMin;
                             OSOrigin := OS_DOS;    { Dies ist ein "DOS"-Programm }
                       OSVersionIDMaj := cOsVersionMaj;
                       OsVersionIDMin := cOsVersionMin;
                           PackedType := PACK_NONE;
                          TimeOutTime := 0;                        { 0 -> Nie einen Time-Out generieren }
                          SendingType := SendingData;
                           End;
                          With SendIt^ do
                           Begin
                            ID := TEACHERBROADCASTDATASTART;
                            DataPointer := TempWorkPlace;
                            DataLength := SizeOf(tBroadCastDataStart);
                           End;
                          SendStatus[CurrentProtoCol] := SENDPHASE_STARTSCREEN;
                         End;
 SENDPHASE_STARTSCREEN : Begin
                         { ************************************************* }
                         { * 2. Bildschirm-Start-Phase                     * }
                         { *                                               * }
                         { *                                               * }
                          With pScreenDataTransferStart(TempWorkplace)^ do
                           Begin
                            VideoMode := GetVideoMode;
                           PackedType := PACK_NONE;
                           { Nun die VGA-Register bertragen }
                            ModifyedMode := IsModifyedMode13;

                            If IsTextMode then
                             Begin
                            GetVGARegistersForTextMode(ModeControl, MiscOutReg,ClockingModeReg,HorizontalPelPanning,CrtBytes);
                              SetMaxTransMitSizeForMode(GetVideoMode);
                              TransFerBytes := GetMaxTransmitSize(GetVideoMode);
                             End;
                           End;

                          With SendIT^ do
                           Begin
                            ID := SCREENDATATRANSFERSTART;
                            DataPointer := TempWorkPlace;
                            DataLength := SizeOf(tScreenDataTransferStart);
                           End;

                          With ProcessContinue[CurrentProtoCol] do
                           Begin
                            ReturnBytes := Drivers[CurrentProtoCol]^.DataPart - SizeOf(tScreenDataTransfer) + 1;
                            VioMode := GetVideoMode;
                            TransMitted := 0;
                           End;
                          SendStatus[CurrentProtoCol] := SENDPHASE_SCREENDATA;
                         End;
SENDPHASE_SCREENDATA  : Begin
                         If GetVideoMode <> ProcessContinue[CurrentProtoCol].VioMode then
                          Begin
                           SendStatus[CurrentProtoCol] := SendPhase_StartScreen;
                          End
                         Else
                          Begin
                           pScreenDataTransfer(TempWorkplace)^.ProcessId := ProcessContinue[CurrentProtoCol];

    Lauf1 := GetVideoData(@ProcessContinue[CurrentProtoCol],@pScreenDataTransfer(TempWorkplace)^.PacketData,BytesToWrite);
{}
                           With pScreenDataTransfer(TempWorkplace)^ do
                            Begin
                             ProcessID.ReturnBytes := Bytestowrite;

                             With SendIT^ do
                              Begin
                               ID := ScreenDataTransfer;
                               DataPointer := TempWorkPlace;
                               DataLength := Drivers[CurrentProtoCol]^.DataPart;
                              End;
                            End;
                           If Lauf1 = 0 then
                            Begin
                             ProcessContinue[CurrentProtoCol].Transmitted := 0;

                             If ElapseCounter[Elapse_Palette] = HasElapsed[CurrentProtocol,Elapse_Palette] then
                              Begin
                               { Nur wenn der Zyklus fr die Palette dran ist senden ! }
                               With ProcessContinue[CurrentProtoCol] do
                                Begin
                                 ReturnBytes := Drivers[CurrentProtoCol]^.DataPart - SizeOf(tScreenDataTransfer) + 1;
                                 VioMode := GetVideoMode;
                                 TransMitted := 0;
                                End;
                               { Nur jetzt in die Plaettendatenphase eintreten }
                               SendStatus[CurrentProtoCol] := SENDPHASE_PALETTEDATA;
                              End
                             Else
                              Begin
                               Inc(HasElapsed[CurrentProtocol,Elapse_Palette]);
                               { Palettendaten berspringen ! }
                               SendStatus[CurrentProtoCol] := SENDPHASE_CURSORDATA;
                              End;
                            End;
                           End;
                         End;
 SENDPHASE_PALETTEDATA : Begin
                          With pPaletteDataTransfer(TempWorkplace)^ do
                           Begin
                            ProcessID := ProcessContinue[CurrentProtoCol];
                           End;
      Lauf1 := GetPaletteData(@ProcessContinue[CurrentProtoCol],@pPaletteDataTransfer(TempWorkplace)^.PacketData,BytesToWrite);
                          With pPaletteDataTransfer(TempWorkplace)^ do
                           Begin
                            ProcessID.ReturnBytes := BytesToWrite;
                           End;

                          With SendIT^ do
                           Begin
                            ID := PaletteDataTransfer;
                            DataPointer := TempWorkPlace;
                            DataLength := Drivers[CurrentProtoCol]^.DataPart;
                           End;
                          If Lauf1 = 0 then
                           Begin
                            ProcessContinue[CurrentProtoCol].Transmitted := 0;
                            HasElapsed[CurrentProtocol,Elapse_Palette] := 0; { Der Zyklus beginnt von vorne ! }
                            SendStatus[CurrentProtoCol] := SENDPHASE_CURSORDATA;
                           End;
                         End;
 SENDPHASE_CURSORDATA  : Begin
                          With pCurSorDataTransFer(TempWorkPlace)^ do
                           Begin
                        StartScanLine := GetStartScanLine;
                         StopScanLine := GetStopScanLine;
                              CurSorX := WhereX;
                              CurSorY := WhereY;
                           End;
                          With SendIT^ do
                           Begin
                            ID := CURSORDATATRANSFER;
                            DataPointer := TempWorkPlace;
                            DataLength := SizeOf(tCurSorDataTransFer);
                           End;
                          SendStatus[CurrentProtoCol] := SENDPHASE_STOPMOUSE;
                         End;
 SENDPHASE_STOPMOUSE   : Begin
                          If TransferCharset then
                           Begin
                            If ElapseCounter[Elapse_Charset] = HasElapsed[CurrentProtocol,Elapse_Charset] then
                             Begin
                              With ProcessContinue[CurrentProtoCol] do
                               Begin
                                ReturnBytes := Drivers[CurrentProtoCol]^.DataPart - SizeOf(tCharsetDataTransfer) + 1;
                                    VioMode := GetVideoMode;
                                TransMitted := 0;
                               End;
                              SendStatus[CurrentProtoCol] := SENDPHASE_CHARSET;
                             End else Inc(HasElapsed[CurrentProtocol,Elapse_CharSet])
                           End else SendStatus[CurrentProtoCol] := SENDPHASE_SYNCHRONIZE;
                         End;
     SENDPHASE_CHARSET : Begin
                          With pCharsetDataTransfer(TempWorkplace)^ do
                           Begin
                            ProcessID := ProcessContinue[CurrentProtoCol];
                           End;
Lauf1:=GetCharsetData(@ProcessContinue[CurrentProtoCol],Addr(pCharsetDataTransfer(TempWorkplace)^.PacketData),BytesToWrite);
                          With pCharsetDataTransfer(TempWorkplace)^ do
                           Begin
                           ProcessID.ReturnBytes := Bytestowrite;
                        CharMapSelect := GetReg(REG_SEQCONTROL,SUBREG_CHARMAP);
                            With SendIT^ do
                             Begin
                              ID := CHARSETDATATRANSFER;
                              DataPointer := TempWorkPlace;
                              SendIT^.DataLength := Drivers[CurrentProtoCol]^.DataPart;
                             End;
                           End;
                          If Lauf1 = 0 then
                           Begin
                            ProcessContinue[CurrentProtoCol].Transmitted := 0;
                            SendStatus[CurrentProtoCol] := SENDPHASE_SYNCHRONIZE;
                           End;
                         End;
                         { ************************************************* }
                         { *                                               * }
          End;

          With SendIT^ do
           Begin
            If ID <> 0 then { Wenn ein ID eingetragen wurde ( <> 0), dann das Paket abschicken }
             Begin
              If SendingData = SEND_BROADCAST then
               SendResult := Drivers[CurrentProtoCol]^.SendProc(ID,NIL,DataPointer,DataLength,MyWorkGroup) else
              If SendIngData = SEND_TOTEACHER then
                SendResult := Drivers[CurrentProtoCol]^.SendProc(ID,ListeningTeacherID,DataPointer,DataLength,MyWorkGroup); {}
             End;
           End;

          With SavedState do
           Begin
            Case SavedProcess of
    SENDPHASE_PALETTEDATA,
        SENDPHASE_CHARSET,
      SENDPHASE_STOPMOUSE,
    SENDPHASE_STARTSCREEN,
     SENDPHASE_SCREENDATA : Begin
                             If SendResult <> 0 then
                              Begin
                               ProcessContinue[CurrentProtoCOl] := pVideoProcess(SavePtr)^;
                                    SendStatus[CurrentProtoCol] := SavedProcess;
                              End;
                             FreeMem(SavePtr,SizeOf(tVideoProcess));
                            End;
              End;
            End;

           If AllocMemSize <> 0 then
            Begin
             FreeMem(TempWorkPlace,AllocMemSize);
            End;
          End;
        End;
       FreeMem(Sendit,SizeOf(tSendStruct));
      End;
    End
   Else
    Begin
     If CaptureStarted then                      { Ist der Aufruf gerade beendet worden ? }
      Begin
       SendAll(TEACHERCAPTUREEND,NIL,NIL,0);
       CaptureStarted := FALSE;
      End;
    End;

  End
 Else If TsrAktiv = TSR_MENUACTIVE then
  Begin                                          { OK. Control-Center aktiv, die anderen Rechner aber mit Paketen versorgen }
   If SendingData = Send_BroadCast then          { um sie auf "Stand-By" zu halten, so das sie nicht zurckschalten }
    Begin
     If ManagerWorkGroup = NIL then
      Begin
       SendAll(IAMSTILLLISTENING,NIL,NIL,0);        { Fr Modus 1 }
      End;
    End;
   If SendingData = Send_ToTeacher then
    SendAll(IAMSTILLLISTENING,ListeningTeacherID,NIL,0);
  End;

 { Dieser berprfungsabschnitt mu ausserhalb des resltichen Codes stehen, da
   er sowohl ausserhalb wie innerhalb des Mens gebraucht wird }
 If (ListeningForData = LIS_STUDENT) or (ListeningForData = LIS_TEACHER) or
    (SendingData      = SEND_TOTEACHER) then
  Begin
   If ListeningForData = LIS_STUDENT then
    Begin { Wenn ich einen Student beobachte, dann diesem mitteilen, das ich noch zuhre }
     SendAll(IAMSTILLLISTENING,StudentComputerID,NIL,0);
    End;
   If StationTimeOut <> 0 then
    Begin { Ich marschiere weiter auf das minimum zu ... }
     Dec(StationTimeOut);
    End
   Else
    Begin                                        { Time-Out erreicht, keine Antwort, Verbindung unterbrechen }
     If SendingData = SEND_TOTEACHER then        { Ein schne Scheisse ! Ich hre nichts mehr ! }
      Begin
      End
     Else
      Begin
       If ListeningforData = LIS_TEACHER then    { Und aufhren, dem bsen Teacher zuzuhren }
        Begin
         EndOfCapture := TRUE;
        End;
       ListeningForData := LIS_NONE;
      End;
    End;
  End;


 Asm
  les di, OldInterrupts                          { ES:DI -> OldInterrupts^ }
  pushf
  Call [DWord Ptr ES:[DI] + OldInt08OffsetInStruct]
 End;

 If TsrAktiv = TSR_INTERRUPT08ACTIVE then TsrAktiv := TSR_NONEACTIVE;
 Port[$20] := $20;                               { und dem Interrupt-Controller einen EOI (End Of Interrupt) signalisieren }
End;



