{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{ **************************************************************************
  In dieser Include-Datei sind die Typendeklarationen, Funktionen und Prozeduren
  aufgelistet, die mit Interrupts zu tuen haben.
  ************************************************************************** }

Procedure MeinInt28(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word); Interrupt;
Begin
 If VideoIsToSave then
  Begin
   VideoIsToSave := FALSE;
   If In_Bios = 0 then
    Begin
     SaveDataToDisk(SAVEDATAFOR_Interrupted,SavedVideoInMem);
     KillMemBlocks(SavedVideoInMem);
     VideoIsToSave := FALSE;
    End;
  End;
 If EndOfCapture {and (In_Bios = 0)}then
  Begin
   EndOFCapture := FALSE;
   MachieneAccessEnable := FALSE;
   ReadDataFromDisk(SAVEDATAFOR_Interrupted,SavedVideoInMem);
  End;

 Asm
  les di, OldInterrupts                          { ES:DI -> OldInterrupts^ }
  pushf
  Call [DWord Ptr ES:[DI] + OldInt28OffsetInStruct]
 End;
End;

Procedure MeinInt09(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word); Interrupt;
Var
 TastaturByte : Byte;

Begin
 { Nur wenn auf Daten gewartet wird und nicht einem Student zugehrt wird }
 If (ListeningForData = LIS_NONE) then
  Asm
   les di, OldInterrupts                          { ES:DI -> OldInterrupts^ }
   push  Flags
   Call [DWord Ptr ES:[DI] + OldInt09OffsetInStruct]
  End
 else If (ListeningForData = LIS_STUDENT) then
  Begin { Wenn ich einem Student zuhre, die Daten an diesen bertragen }
   { Wenn CRTL (STRG) - ESC gedrckt wird,ListeningForData auf LIS_NONE setzen }
   TastaturByte := Port[$60];
   Asm
    les di, OldInterrupts                         { ES:DI -> OldInterrupts^ }
    push Flags
    Call [DWord Ptr ES:[DI] + OldInt09OffsetInStruct]
   End;
   If TastaturByte < 128 then
    Begin { Ein Make-Code }
     If TastaturByte = EscapeKey then
      Begin
       If (Mem[$0040:$0017] and ChangerKey) = ChangerKey then
        Begin
         ListeningForData := LIS_NONE;
        End;
      End;
    End;
  End;
End;


Procedure MeinInt71(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word); Interrupt;
{ ************************************************************************** }
{ *** Dies ist der Interrupt-Handler fr den Interrupt $71.              *** }
{ *** Er wird von mir zur Kommunikation zwischen dem residenten und dem  *** }
{ *** transistenten Programm eingesetzt, wenn z.B. das Programm          *** }
{ *** deinstalliert werden soll, so wird Int $71 aufgerufen, der dann    *** }
{ *** die Addresse einer Struktur mit den wichtigen Daten zurckgibt     *** }
{ ************************************************************************** }
Begin
 If Ax = 1 then { FKT 1. 08 & 71 }
  Begin
   Ax := Seg(OldInterrupts^);
   Bx := Ofs(OldInterrupts^);
  End
End;

Var
 OldInt10 : Pointer;

Procedure MeinInt10; Far; Assembler;
Asm
 push ds                                        { Die Register drfen nicht verndert werden !!!! }
 push ax
 mov  ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
 Mov  ds,ax
 pop ax
@WirdNormalerModusgesetzt:
 Cmp  Ah, 00                                    { Soll ein BildschirmModus gesetzt werden ? }
 Jne @WirdVESAMOdusGesetzt
 Mov XLastVideoMode, Ax                          { Der Modus steht in AL, Ax ist aber sowieso 0 ... }

 Jmp @UndNunDenAltenInterrupt                   { Alter Interrupt ... }
@WirdVESAMOdusGesetzt:
 Cmp Ax, $4F02                                  { Wird die VESA-Funktion Video-Modus setzen aktiviert ? }
 Jne @UndNunDenAltenInterrupt                   { NEIN ! Alter Interrupt ... }
 { AHA ! Eine VESA-Funktion ! }
 Mov XLastVideoMode, BX                          { In BX steht der Modus ... }

@UndNunDenAltenInterrupt:
 pushf                                          { Die FLAGS pushen, um ein INT zu simulieren }
 call [OldInt10]                                { Und Aufrufen ! }

 pop ds                                         { Das alte DS wiederherstellen ! }
 iret                                           { Und weg ... }
End;



Procedure InitInterrupts;
{ ************************************************************************** }
{ *** Stellt die eigenen Interrupts ein. Die umgesetzten Interrupts      *** }
{ *** sind : Int $08, Hardwaretimer                                      *** }
{ ***        Int $28, Dos-Idle-Interrupt                                 *** }
{ ***        Int $71, Ein eigener Interrupt zur Programmkommunikation    *** }
{ ************************************************************************** }

Var
 IZaehler : Word;
Begin
 GetMem(OldInterrupts,SizeOf(tInterruptInfoStruct));
 asm
  cli
 End;
 With OldInterrupts^ do
  Begin
   GetIntVec($71,OldInt71);
   GetIntVec($08,OldInt08);
   GetIntVec($09,OldInt09);
   GetIntVec($28,OldInt28);
   GetIntVec($10,OldInt10);


   SetIntVec($71,@MeinInt71);
   SetIntVec($08,@MeinInt08);
   SetIntVec($09,@MeinInt09);
   SetIntVec($28,@MeinInt28);
  End;
 OldInt10 := OldInterrupts^.OldInt10;

 SetIntVec($10,@MeinInt10);

 Asm
  sti
 End;
End;

Procedure GetOldVectors;
{ ************************************************************************** }
{ *** Erlangt mittels meinem Int-$71-Handlers die alten Vektoren und     *** }
{ *** speichert sie in den dazugehrigen Variabelen.                     *** }
{ ************************************************************************** }
Begin
 Asm
   Mov ax, 1                                     { AX = 1 , meine Fkt. fr Int 71h }
   Int $71
   Mov word ptr OldInterrupts    , BX            { Die Struktur an die richtige Stelle verlegen }
   Mov word ptr OldInterrupts + 2, Ax
  End;
End;


Procedure KillInterrupts;
{ ************************************************************************** }
{ *** Stellt die vorher mit "GetOldVectors" erlangten Vektoren wieder    *** }
{ *** ein und aktiviert so die alten Handler wieder.                     *** }
{ ************************************************************************** }
Begin
  Asm
   cli                                           { Is kritisch. Interrupts verbieten. }
  End;
 With OldInterrupts^ do
  Begin
   SetIntVec($08,OldInt08);
   SetIntVec($09,OldInt09);
   SetIntVec($71,OldInt71);
   SetIntVec($28,OldInt28);
   SetIntVec($10,OldInt10);

  End;
  Asm                                            { Kritische Phase vorbei. Ints wieder erlauben. }
   sti
  End;
End;


