{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{ ************************************************************************** }
{ *** SEHR WICHTIG :                                                     *** }
{ *** Die beiden folgenden Konstanten sind die entscheidenen Konstanten  *** }
{ *** fr die Zusatzstacks des Programmes. Dabei gibt "SECONDSTACKSIZE"  *** }
{ *** die Grsse der einzelnen Stacks an. "STACKNUM" gibt an, wieviele   *** }
{ *** Stacks dabei mit der Grsse angelegt werden.                       *** }
{ ************************************************************************** }
{ *** Enthlt die Definitionen der Stack-Abhngigen Variabelen. Ebenso   *** }
{ *** werden die Prozeduren zum Verwalten der Mehreren "Zweit"-Stacks    *** }
{ *** hier definiert. Als letztes werden die Request-Interrupts der      *** }
{ *** diversen Netzwerkprotokolle hier deklariert. Dies geschieht        *** }
{ *** aufgrund ihrer Low-Level-Codierung per Assembler und ihrer starken *** }
{ *** Stack-Abhngigkeit.                                                *** }
{ ************************************************************************** }
Const
{        SECONDSTACKSIZE = 2000; }
        SECONDSTACKSIZE = 2000;
               STACKNUM = 4;
             UsedStacks : Array[1..StackNum] of Byte = (0,0,0,0);


Type
 tStackRecord = Array[1..SECONDSTACKSIZE] of Byte;{ Mein "Zweit"-Stack }


Var
    ResidentStacks : Array[1..StackNum] of tStackRecord;


Function FindStackAddr : Pointer; Assembler;
{ ************************************************************************** }
{ *** Durchsucht die Stacks fr den "Zwischengebrauch" und gibt die      *** }
{ *** Addresse eines freien Stacks zurck. Dieser wird dabei als belegt  *** }
{ *** gekennzeichnet.                                                    *** }
{ ************************************************************************** }
Asm
  Mov Di, 0                                      { Di -> Counter }
  Mov Dl, 0                                      { Dl bleibt (bis zum Ende) so }
  Mov Dh, 1                                      { Dh bleibt (bis zum Ende) so }
  @StackSuchenSchleifeStart:
    Cmp Di, StackNum + 1                         { Ist das Ende des Feldes mit den Stacks erreicht ? }
    Je  @StackSuchenSchleifeEnde                 { JA. Przedur beenden. }
    Cmp Byte Ptr UsedStacks[Di], Dl              { Ist der Stack bereits in Benutzung ? (Dl = 0)}

    Jne @DieserStackIstbereitsBelegt              { Ja. Wegspringen. }
    @DieserStackIstNochNichtBelegt:              { Nein. }
      { In diesem Teil werden AX und BX verndert. }
      { In diesem ASM-Teil geht der gefundene Zeiger nach Tmppt ! }
      Mov Bx, Di                                 { In DI ist meine Base. }
      Mov Byte Ptr UsedStacks[BX], Dh            { Den jeweiligen Stack als "Belegt" deklarieren (Dh = 1)}
      Inc Bx
      Mov Ax, BX                                 { Danach den Offset des Elements berechnen }
      Mov Bx, SECONDSTACKSIZE
      Mul Bx                                     { Berechnen, das wievielte Byte in einem "Langen" Array gefragt ist }
      { AX -> Lauf1 * SecondStackSize }
      Mov Bx, Ax                                 { Mit AX Arrrays indizieren geht nicht ! }
      Lea Ax, ResidentStacks[BX]                 { Die Offset-Addresse des gefragten Elementes erlangen }
      Dec Ax                                     { Das Array ist nicht 0, sondern 1-Basiert sind d.h. ein Byte abziehen }
      Mov Dx, Seg ResidentStacks                 { Das Segment in DX (Fkt. Erg. bei Pointer fr Segment) bringen }
      Jmp @RausAusdemGanzenDreck                 { Das Offset ist bereits in AX. Und jezt hinaus. }
    @DieserStackIstbereitsBelegt:

    Inc Di                                       { Ein Element weiterzhlen. }
    Jmp @StackSuchenSchleifeStart                { Und weitersuchen. }
  @StackSuchenSchleifeEnde:                      { Hier kommt man nur hin, wenn nichts gefunden wurde }
  Mov Dx, 0
  Mov Ax, 0

  @RausAusDemGanzenDreck:
End;



Procedure RestoreStackAddr( StackPtr : Pointer );
Var
 Lauf1 : Word;
Begin
 For Lauf1 := 1 to StackNum do
  Begin
   If StackPtr = Addr(ResidentStacks[Lauf1][SECONDSTACKSIZE]) then
    Begin
     UsedStacks[Lauf1] := 0;
    End;
  End;
End;

Procedure GeneralRequest; Far; Assembler;
{ Beim Eintritt mu sein :
 AX = Offset Header
 BX = Segment Header
 CX = Offset Daten
 DX = Header Daten }
Asm
 pusha
 push ds
 push es
 push bp
 mov bp, sp

 cli

 push ax
 mov  ax,seg @Data                              { Das Datensegment wieder herstellen, da es inkorrekt (fr micht) ist !  }
 Mov  ds,ax
 pop ax


 { AX:BX, CX:DX }

 push ax  { Fkt. erg. Wird in DX:AX bergeben -> Sichern }
 push bx
 push cx
 push dx

 call [findstackaddr]
 pop si  { DX nach Si poppen, da mein Funktionsergebnis in DX liegt ! }
 pop cx
 pop bx
 pop di { AX nach DI poppen, da mein Funktionergbnis auch in AX liegt ! }

 { DI:BX , CX:SI,  DX:AX -> Gefundener Stack }

 cmp dx, 0            { Wurde ein Stack gefunden ? }
 jne  @WasDa          { Wenn dx <> 0 , d.h segment da -> Stack gefunden ! }
 cmp ax, 0
 je @Raus
 @WasDa:

 { Zunchst den alten Stack sichern }
 Push Dx
 Mov Dx, SS
 Mov Es, Dx
 Pop DX
 { ES -> Altes SS, DX -> Neues SS }
 Xchg Sp, Ax          { In AX ist mein neuer SP. Sp mit AX austauschen. }
 Mov SS, Dx
 Mov Dx, ES
{ Xchg SS, DX          { In DX ist mein neues SS. Dies mit SS austausche. }

 push sp
 push ss
 { So - SS:SP -> Neuer Stack, DX:AX -> Alter Stack, DI:BX -> Header, CX:SI -> Datenteil }
 push dx              { Der Alte Stack ist nun auf dem neuen Stack gesichert }
 push ax
 { Jezt die beiden Zeiger pushen. In Reihenfolge Header, Daten. Normale Pointer-bergabe. (SEGM:OFFS) gepusht }

 push bx
 push di
 push si
 push cx

 call [digestPacket]  { Digest rufen. Dies poppt nun die Argumente ! }


 { STACK : OldSp, OldSS, NewSS, NewSP }
 pop  ax
 pop  bx
 { STACK : NewSS, NewSP
    REGS : AX : OldSp, BX : OldSS }
 pop  cx
 pop  dx
 { STACK : ---
    REGS : AX : OldSp, BX : OldSS, CX : NewSS, DX : NewSp }
 push bx
 push ax
 { STACK : OldSp, OldSS
    REGS : CX : NewSS, DX : OldSS }
 push cx
 push dx
 { STACK : NewSP, NewSS, OldSp, OldSS
    REGS : --- }

 call [restorestackaddr]
 { STACK : OldSp, OldSS
    REGS : --- }

 pop ax
 pop bx
 Mov Sp, ax
 Mov SS, Bx



 { AX,BX,CX,DX,DI,SI = ?  STACK = OldSp, OldSS }
    { STACK :

     BX -> ES:BX -> Aktiver NCB
     ES
     AX -> DX:AX -> Gefundener Stack
     DX
     SI -> CX:SI -> Alter Stack
     CX
     BX -> Nochmal der aktive NCB.
     ES
     -> -> Der Stack ist jetzt so gesetzt, das ich die vier
           Entscheidenen Operationen ausfhren kann :
           1. NCB bearbeiten (erst per Call-Gates, dann per Digest)
           2. Zweit-Stack wieder freigeben
           3. Alten (NetBIOS)-Stack wieder herstellen, um das NetBIOS nicht zu rgern
           4. Den NCB wieder zum Lauschen bereitmachen.
      Dies geht nun einfach da :
       -> 1. poppt ES:BX als seinen Parameter
       -> 2. poppt DX:AX als seinen parameter
       -> 3. poppt CX:SI als Werte in die Register
       -> 4. poppt BX:ES (wie fantasievoll) als seine PaRaMeTeR
     }
{ call [netbiosstage1callgate]
    { STACK :
     AX -> DX:AX -> Gefundener Stack
     DX                         }

 @Raus:
 leave
 pop es
 pop ds
 popa
End;
