{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit ipxunit;
{$A-,R-,S-}
Interface
{ nderungen :

 17.01.1997 : Habe die Unit soweit ergnzt, das sie zum einen nicht abstrtzt,
              wenn kein IPX-Treiber geladen wird. Auch funktioniert nun das
              mehrmalige Initzialisieren ohne Absturz.
 }
uses Dos, Crt,NetTypes, FastCop;
Const
 IDChar1 = 'L';                                  { Identifikationszeichen 1 }
 IDChar2 = 'S';                                  { Identifikationszeichen 2 }


  Ipx_MaximalPacketSize = 576;                   { Die maximale Paketgrssee berhaupt }
     Ipx_MaximalMemSize = Ipx_MaximalPacketSize + 1;
       Ipx_TransFerUNit = Ipx_MaximalPacketSize - SizeOf(tIpxPacket) + 1; { Die maximale Nutzdatenlast berhaupt }

   IPXSENDERR_NOECBFREE = 101;

            MyIpxSocket : Word = Swap($DA00);    { Der Socket, auf dem ich immer sende }
{            MyIpxSocket : Word = Swap($DDDD);    { Der Socket, auf dem ich immer sende }
       IpxRecieveECBNum : Word = 15;
          IpxSendECBNUm : Word = 15;             { Eigentlich wird nur ein Sende-ECB gebraucht }
      IpxCurrentSendECB : Word = 1;              { Der ECB, der als nchstes gesendet werden mu }

               MyIPxPacketType = 4;             { Mein Pakettyp (16 = Experimental) (4=PACKET TRANSPORT)}
                         IPXint=$7F;            { Hier freie Int-Nummer fr IPX einsetzen }


{ Netzwerkunabhnige Variabelen }


       samenet:tNetWork=0;
      stayopen=$FF;

Type
     pIPXPacketArray = ^tIPXPacketArray;
     tIPXPacketArray = Array[1..1] of pIpxPacket;



var
               ipxproc : procedure;
            ProcToCall : Pointer;
          MyIPXAddress : TIpxIDStruct;           { Wer bin ich ? }
{            RecieveECB : pIPxECBBlock;
         RecieveBlocks : pIPxPacketArray;           { Mehrere Empfangs-ECBs bereithalten }
           RecieveECBs : pIpxECBArray;
              SendECBs : pIpxECBArray;           { Die Sende-ECBs }
            EveryNodes : tIpxIDStruct;           { Ein kleiner Node - Kunstgriff }
               NoNodes : tIpxIDStruct;           { Ein kleiner Node - Kunstgriff }
           SwapDirName : tStr12;                 { Der Pfad fr das IPX-Auslagerungsverzeichnis }
         InitedAlReady : Boolean;                { Wurde schoneinmal das IPX initialisiert ? }


Procedure CancelEvent(var ecb);
Procedure CloseSocket (Socket:Word);
Procedure IpxGetLocalTarget( Target : tIpxIdStruct; Var LocalTargetNode:tNode);
Procedure GetInterNetWork (var Net:tNetWork;var Node:tNode);
Function  GetIntervalMarker:word;
procedure listen ( ecb:pIPXECBBlock);
Procedure opensocket ( modus:byte; Socket:Word);
Procedure RelinquishControl;
Procedure send ( ecb:pIPXECBBlock);
Procedure ipxIntHandler;
Function  GetIPXAdr:pointer; {pm}
Procedure InitIPXint{(var result:integer)};
Procedure setecb ( ecb:pIPXECBBlock; esradr:pointer;  Socket:Word; wem:tIpxIDStruct;  packettIPXFragment:tIPXFragment);
Procedure IPXfunction  (nr:byte;var reg:registers);

Procedure InitializeIPX;
Procedure DeInitializeIPX;
Function CompareIpxIDs( ID1, ID2 : pointer ) : Boolean;

Function SendOneIpxPacket(IDNumber:Word;Address:pAddressChain;DataPointer:Pointer;DataLength:Word;WorkGroupBool:Word):Word;
Function SendIpxPacket(IDNumber:Word;Address:pAddressChain;DataPointer:Pointer;DataLength:Word;WorkGroupBool:Word):Word;
Implementation


Procedure ipxIntHandler; Assembler;
{ Der Interrupt-Handler, der vom IPX angesprungen wird ! }
asm
 call ipxproc
 iret
end;




Function GetIPXAdr :pointer; Assembler;
{ Gibt die IPX-Adresse als Funktionsergebnis zurck }
Asm
 Mov Ax, $7A00
 Int $2F
 cmp al, $FF
 jne @FEHLER
 mov dx, es                                { Pascal-Funktionsergebnisse werden immer in DX:AX zurckgegeben. }
 mov ax, di
 JMP @BEENDEN
 @FEHLER:
 mov dx, 0
 mov ax, 0
 @BEENDEN:

{ jne @BEENDEN
 mov dx, es                                { Pascal-Funktionsergebnisse werden immer in DX:AX zurckgegeben. }
{ mov ax, di
 @BEENDEN: }
End;

Procedure InitIPXint;
{ Return mit Result=
   0: alles ok
   1: IPX nicht gefunden
   2: IntIPX schon belegt
}
var altint:pointer;
begin
 @ipxproc:=getipxadr;
 if @ipxproc = NIL then
  Begin
   Writeln(' Kein IPX-Treiber gefunden !!! ');
   Halt(500);
  End
 else
  begin
   setIntvec (IPXint,@IPXInthandler);
  end;
end;


Procedure CopyIpxIDs( Var ID1, ID2 : tIpxIdStruct );
Var
  Lauf1 : Word;
Begin
 ID2.Socket := ID1.Socket;
 ID2.Network := ID1.Network;
 For Lauf1 := 0 to 5 do ID2.Node[Lauf1] := ID1.Node[Lauf1];
End;


{ ****** alle IPX-Funktionen ****** }

var
 reply  :tIpxIdStruct;

Procedure IPXfunction  (nr:byte;var reg:registers);
begin
 reg.bx:=nr;
 reg.ds:=dseg;
 intr(IPXInt,reg);
end;

Procedure setecb ( ecb:pIPXECBBlock; esradr:pointer;  Socket:Word; wem:tIpxIDStruct; packettIPXFragment:tIPXFragment);
 { beschrnkt auf ein Fragment }
begin
 ecb^.linkAddress:=nil;
 ecb^.esraddress:=esradr;
 ecb^.SocketNum:=Socket;
 ecb^.ImmediateAddress:=wem.Node;
 If Wem.Network <> 0 then IpxGetLocalTarget(wem,ecb^.ImmediateAddress);
 ecb^.inuseFlag:=0;
 ecb^.fragmentcount:=1;
 ecb^.fragments[0]:=packettIPXFragment;
 ecb^.Fragments[0].Data^.Header.SourceNet := MyIPXAddress;
 ecb^.Fragments[0].Data^.Header.SourceNet.Socket := Socket;
end;


Procedure opensocket ( modus:byte; Socket:Word); Assembler;
Asm
 Mov Bx, 0h                                      { BX = 0 -> Open Socket }
 Mov Al, Modus
 Mov Dx, Socket
 Call [IpxProc]
End;

Procedure closesocket (Socket:Word); Assembler;
Asm
 Mov Bx, 01h                                     { BX = 1 -> Socket schliessen }
 Mov Dx, Socket
 Call [IpxProc]
End;

Procedure IPxGetLocalTarget (  Target : tIpxIdStruct; Var LocalTargetNode:tNode);
{ nicht von EventRoutine aufrufen !}

var
 Locadr:tNode absolute reply;
var
 reg:registers;

begin
 reg.ES:=seg(target); reg.SI:=ofs(target);
 reg.DI:=ofs(reply);
 IPXfunction (2,reg);
 LocalTargetNode:=Locadr;
end;

procedure listen ( ecb:pIPXECBBlock);
var reg:registers;
begin
 reg.es:=seg(ecb^);
 reg.si:=ofs(ecb^);
 ipxfunction (4,reg);
end;

Procedure send( ecb : pIPXECBBlock);
var reg:registers;
begin
 reg.es:=seg(ecb^);
 reg.si:=ofs(ecb^);
 ipxfunction (3,reg);
end;

Procedure CancelEvent (var ecb);
var reg:registers;
begin
 reg.es:=seg(ecb); reg.si:=ofs(ecb);
 ipxfunction (6,reg);
end;

Function GetIntervalMarker:word; Assembler;
Asm
 Mov Bx, 08h
 Call [IpxProc]         { Rckgabewert ist in AX, Pascal Fkt. Werte werden aber auch in AX zurckgegeben ! }
End;


Procedure GetInterNetWork (var Net:tNetWork;var Node:tNode);
{ nicht von EventRoutine aufrufen !}
var
 reg:registers;
begin
 reg.es:=seg(reply); reg.si:=ofs(reply);
 ipxfunction ($09,reg);
 Net:=reply.network;
 Node:=reply.node;
end;

Procedure RelinquishControl; Assembler;
Asm
 Mov Bx, $0A
 Call [IpxProc]
End;

Procedure GetBiggestBlock;
Begin
End;

Function SendOneIpxPacket(IDNumber:Word;Address:PAddressChain;DataPointer : Pointer; DataLength : Word; WorkGroupBool : Word
                                                                                                                     ) : Word;
{ Diese Funktion schickt ein IPX-Paket mit dem Kommando-ID "IDNumber"
  an die IPX-Addresse "IpxAddress" (Zeiger auf selbige).
  Wenn Address "NIL" ist, Broadcast !
  Die Vorbereiteten Daten stehen in "DataLength" auf "DataPointer" folgenden Bytes.
  19.02.1996 : Fehler gefunden !
               Dieser Fehler usserte sich in einem "korrupten" Dateninhalt bei allen
               gesendeten Botschaften. Dieser Fehler lag darin begrndet, das bei dem
               Aufruf der "Kopierroutine" "Charcopy" die Parameter vertauscht wurden. }
Var
    Lauf1 : Word;                               { Eine Laufvariabele }
  SendECB : pIPXECBblock;                          { Zeiger auf einen leeren ECB }
Begin
 SendECB := NIL;
 For Lauf1 := 1 to IpxSendECBNum do
   If SendECBs^[Lauf1]^.InUseFlag = 0 then
    Begin
     SendECB := SendECBs^[Lauf1];
     SendECB^.InUseFlag := 1;
     Lauf1 := IpxSendECBNum;                  { Schleife beenden und Interrupts ausschalten, damit mir keiner in der }
    End;

 If SendECB = NIL then { Hmm. Alle durch und immer noch nichts gefunden ... }
  Begin
   SendOneIpxPacket := IPXSENDERR_NOECBFREE;
   Exit;
  End;

{ Asm
{ With SendECB^ do                               { Nun die Daten in den gefundenen ECB eintragen }
{  Begin                                               }
{  les di, SendECB
  Mov Ax, 0
  Mov Word Ptr ES:[DI] + IpxEcbStructOfs_Linkaddress, Ax
  Mov Word Ptr ES:[DI] + IpxEcbStructOfs_Linkaddress + 2, Ax
  Mov Word Ptr ES:[DI] + IpxEcbStructOfs_Esraddress, Ax
  Mov Word Ptr ES:[DI] + IpxEcbStructOfs_Esraddress + 2, Ax
{    LinkAddress := NIL;                         { Keinen Link vornehmen }
{     EsrAddress := NIL;                         { Keinen Event-Handler beim Senden }
{  Mov Word Ptr ES:[DI] + IpxECBStructOfs_FragmentCount, 1
{  FragmentCount := 1;                           { Ich hab nur ein Fragment ... }
{  Mov Bx, MyIpxSocket
  Mov Word Ptr ES:[DI] + IpxECBStructOfs_SocketNum, Ax
{      SocketNum := MyIpxSocket;                 { Immer nur auf meinem Socket senden ! }
{  Cmp Word Ptr Address, 0
  Jne @ZielAddresseIstNichtNIL
  Cmp Word Ptr Address + 2, 0
  Jne @ZielAddresseIstNichtNIL
  @ZielAddresseIstNIL:
     Mov Word Ptr ES:[DI] +


  @ZielAddresseIstNichtNIL:
       }
{ End; }

 With SendECB^ do                               { Nun die Daten in den gefundenen ECB eintragen }
  Begin
   Asm
    Les Di, SendECB                             { ES:SI -> SendECB^ }
    Mov Bx, 0                                   { BX = NIL }
    Mov Word Ptr ES:[DI] + IpxEcbStructOfs_Linkaddress, Bx
    Mov Word Ptr ES:[DI] + IpxEcbStructOfs_Linkaddress + 2, Bx   { LinkAddress := NIL }
    Mov Word Ptr ES:[DI] + IpxEcbStructOfs_Esraddress, Bx
    Mov Word Ptr ES:[DI] + IpxEcbStructOfs_Esraddress + 2 , Bx   { ESRAddress := NIL }
    Mov Word Ptr ES:[DI] + IpxECBStructOfs_FragmentCount, 1 { FragmentCount := 1 }
    Mov Ax, MyIPxSocket
    Mov Word Ptr ES:[DI] + IpxECBStructOfs_SocketNum, Ax { SocketNum := MyIPxSocket }

{    Cmp Word Ptr Address, 0
    Jne @AddresseIstNichtNIL
    Cmp Word Ptr Address + 2, 0
    Jne @AddresseIstNichtNIL
    Jmp @AddresseIstNIL                          { If Address <> NIL then }
{    @AddresseIstNichtNil:                        { Begin }


{
    Jmp @AddressenVerGleichEnde                  { End }
{    @AddresseIstNIL:                             { Else Begin }
{      Mov Word ptr ES:[DI] + IpxECBStructOfs_ImmediateAddress   , $FFFF { $FFFF -> Alle Nodes (BoradCast) }
{      Mov Word Ptr ES:[DI] + IpxECBStructOfs_ImmediateAddress+ 2, $FFFF
      Mov Word Ptr ES:[DI] + IpxECBStructOfs_ImmediateAddress+ 4, $FFFF { ImmidateAddress := EveryNodes.Node }

{      Les Di, DWord ptr ES:[DI] + Fragment0_DataPointer { ES:[DI] -> Fragments[0].Data }
{      Add Di, IpxHeaderOffsetDestiNationNet
      Lea Si, EveryNodes                         { Si -> Offset(EveryNodes) }
      { Da EveryNodes eine normale Variable ist, steht ihr Segment bereits in DS. }
      { DS mu also nicht verndert werden, um eine String-OPeration durchzufhren. }
 {     Mov Cx, IpxIDStructSizeInWords
      { ES:[DI] -> Ziel , DS:[SI] -> Quelle, Cx -> Bytes zu verschieben  }
{      Rep MovsW                                  { Die Daten verschieben }

{      Mov Di,
      Mov Es, Seg ImmediateAddress }
{      Les Di, }

{      Les Di, SendECB
    @AddressenVerGleichEnde:                     { End; }

   End;
{    LinkAddress := NIL;                         { Keinen Link vornehmen }
{     EsrAddress := NIL;                         { Keinen Event-Handler beim Senden }
{  FragmentCount := 1;                           { Ich hab nur ein Fragment ... }
{      SocketNum := MyIpxSocket;                 { Immer nur auf meinem Socket senden ! }

   If Address = NIL then                        { NIL = Broadcast, so mglich }
    Begin
     ImmediateAddress := EveryNodes.nOde;
     CopyIpxIDs(EveryNodes,Fragments[0].Data^.Header.DestinationNet);
    End
   Else
    Begin
     CopyIpxIDs(pIpxIdStruct(Address)^,Fragments[0].Data^.Header.DestinationNet);
     If (pIpxIdStruct(Address)^.Network <> 0) and
        (pIpxIdStruct(Address)^.Network <> MyIpxAddress.NetWork) then
      Begin { Wenn der Node nicht im gleichen Netz ist, Routeraddresse erlangen }
       IpxGetLocalTarget(pIpxIdStruct(Address)^,ImmediateAddress);
      End
     else
      Begin
       ImmediateAddress := pIpxIdStruct(Address)^.Node;
      End;
    End;


   With Fragments[0].Data^ do                    { Nun die Daten in das IPX-Paket eintragen }
    Begin
     With ProgramHeader do
      Begin
       MyID := IDNumber;
       FromWorkGroup := WorkGroupBool;
       IsIDChar1 := IdChar1;
       IsIDChar2 := IdChar2;
       With WhoIsSender do                       { Den Sender noch eintragen ... }
        Begin
         NetType := Prot_IPX;                         { Ich bin ein IPX-Paket ! }
         WhoiSSender.IpxAddress := MyIPXAddress;
         With Header do                          { Nun die Daten in den Header eintragen }
          Begin
           PacketType := MyIPxPacketType;
          End;
        End;
      End;
    End;
   FastCopy(DataPointer^,Fragments[0].Data^.Data,DataLength); { Nun die bereitgestellten Daten in den ECB kopieren }
  End;

 SendECB^.InUseFlag := 0;


 Asm
  pusha
  Mov Bx, 3                                      { Abschicken }
  Mov Dx, Seg @Data
  Mov Ds, Dx
  Les Si, SendECB

  Call IpxProc
  popa
 End;

 If SendECB^.InUseFlag = 0 then
  Begin
   SendOneIpxPacket := SendECB^.ErrorCode;           { Und einen evtl. Fehlercode zurckgeben }
  End
 Else
  Begin
   SendOneIpxPacket := 0;
  End;
End;

Function SendIpxPacket(IDNumber:Word;Address:pAddressChain;DataPointer:Pointer;DataLength:Word;WorkGroupBool:Word):Word;
Var
 Lauf1 : Word;
  OldDS : Word;
Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

 If Address = NIL then                           { Soll an alle etwas gesendet werden ? }
  Begin
   SendIpxPacket := SendOneIpxPacket(IdNumber,NIL,DataPointer,DataLength,WorkGroupBool);
  End
 Else
  Begin
   SendIPXPacket := 0;
   While Address <> NIL do                       { Alle Addressen abarbeiten }
    Begin
     Lauf1 := SendOneIpxPacket(IdNumber,Addr(Address^.Address.IpxAddress),DataPointer,DataLength,WorkGroupBool);
     If Lauf1 <> 0 then
      Begin
       SendIpxPacket := Lauf1;
       Exit;
      End;
     Address := Address^.pNext;
    End;
  End;

 Asm
  Mov Ds ,OldDS
 End;
End;


Procedure IpxStage1CallGate( CallingECB : pIpxEcbBlock ); Far;
Var
 Pointer1, Pointer2 : Pointer;
 DataPointer : pIpxPacket;
 Lauf1 : Word;
 FoundSuccess : Boolean;
Begin


 If CallingECB^.ErrorCode <> 0 then              { Gab es beim ankommen einen Fehler ??? }
  Begin                                          { offensichtlich ... }
   { *********************************************************************** }
   { *** Da diese Fehlerbehandelung offensichtlich scheisse ist, mu sie *** }
   { *** STARK verbessert werden !!!                                     *** }
   { *********************************************************************** }
   Sound(550);
   Halt(65535);
  End;

 If CallingEcb^.Fragments[0].Data^.Header.PacketType = MYIPXPACKETTYPE then
  Begin
   DataPointer := CallingECB^.Fragments[0].Data;

   { Nun einen Freien Datenblock suchen. Diese sind durch die vertaUSCHTEN ID-Buchstaben gekknzeichnet. }
   FoundSuccess := TRUE;
   For Lauf1 := 1 to IpxRecieveECBNum do
    Begin
     If (RecieveBlocks^[Lauf1]^.ProgramHeader.IsIDChar1 = IdChar2) and
        (RecieveBlocks^[Lauf1]^.ProgramHeader.IsIDChar2 = IdChar1) then
      Begin
       CallingECB^.Fragments[0].Data := RecieveBlocks^[Lauf1];
       FoundSuccess := TRUE;
       Listen(CallingECB);
       Lauf1 := IpxRecieveECBNum;
      End;
    End;

   If (DataPointer^.ProgramHeader.IsIDChar1 = IDChar1) and
      (DataPointer^.ProgramHeader.IsIDChar2 = IDChar2) then
    Begin                        { Es ist eins von (MEINEN ?) PROT_IPX-Paketen !!! }
     If Not(CompareIPXIDs(@(DataPointer^.Programheader.WhoIsSender.IpxAddress),@(MyIPxAddress))) then
      Begin
       Pointer1 := Addr(Datapointer^.ProgramHeader);
       Pointer2 := Addr(Datapointer^.Data);
       Asm

        { *** Nun den "Haupt"-Event-Handler des Programmes aufrufen *** }
        Push Ds
        Push Es
        Pusha
        Mov Ax, Word Ptr Pointer1
        Mov Bx, Word Ptr Pointer1 + 2
        Mov Cx, Word Ptr Pointer2
        Mov Dx, Word Ptr Pointer2 + 2
        Call ProcToCall
        Popa
        Pop es
        Pop ds
       End;
     End;
    End;
  End;
 DataPointer^.ProgramHeader.IsIDChar2 := IdChar1;
 DataPointer^.ProgramHeader.IsIDChar1 := IdChar2;
 If Not(FoundSuccess) then Listen(CallingECB);
End;



Procedure MyCallProc; Far; Assembler;
Asm
 push ds
 push ax
 mov ax, seg @data
 mov ds, ax

 pop ax

 cmp word ptr proctoCall, 0
 jne @Wasda
 cmp word ptr proctoCall + 2, 0
 je @Nichtsda
@WasDa:
{ Ist es vom gleichen Rechner ? (dann raus !) }

  push es
  push si

  call IpxStage1Callgate

@Nichtsda:
@UndRaus:

 pop ds
 retf
End;

Procedure SetSwapDirName;
Const
 hex:array[0..15] of char='0123456789ABCDEF';
Var
 Lauf1 : Word;

Begin
 SwapDirName := '';
 For Lauf1 := 1 to 5 do
  Begin
   SwapDirName := SwapDirName +(hex[(MyIpxAddress.Node[Lauf1] shr 4) and $F]);
   SwapDirName := SwapDirName +(hex[MyIpxAddress.Node[Lauf1] and $F]);
   If Lauf1 = 4 then SwapDirName := SwapDirName + '.';
  End;
 SwapDirName := SwapDirName + (hex[(MyIpxAddress.Node[5] shr 4) and $F]);
End;



Procedure InitializeIPX;
Var
 Lauf1 : Word;
 OldDS : Word;

Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

{ If (InitResult <> 0) and (Initresult <> 2) then Error(ERR_NOIPXDRIVERFOUND); }

 Opensocket (stayopen,MyIpxSocket);
 MyIPXAddress.Socket  := MyIpxSocket;

 If Not(InitedAlReady) then
  Begin
{   GetMeM(RecieveECB,SizeOf(tIPXECBBlock)); }

   GetMem(RecieveECBs,SizeOf(pIpxECBArray) * IpxRecieveECBNum ); { Den Speicher fr die ECB-Arrays reservieren }

   For Lauf1 := 1 to IpxRecieveECBNum do
    Begin
     GetMem(RecieveECBs[Lauf1]^,SizeOf(tIPXECBBlock));
     RecieveECBs[Lauf1]^.FragmentCount := 1;
     RecieveECB[Lauf1]^.Fragments[0].Size := Ipx_MaximalMemSize;
     GetMeM(RecieveECBs^[Lauf1],^.Fragments[0].Data,Ipx_MaximalMemSize);
     With RecieveECBs^[Lauf1],^.Fragments[0].Data^ do
      Begin
       ProgramHeader.IsIDChar1 := IdChar2;  { Die ID-Buchstaben falschrum einschreiben }
       ProgramHeader.IsIDChar2 := IdChar1;
      End;
    End;

{   RecieveECB^.Fragments[0].Data := RecieveBlocks^[1]; }
   GetBiggestBlock;                                { Hier noch ne Proc reim zum Erlangen der grtmglichen Bandbreite }

   GetMem(SendEcbs,SizeOf(pIpxECBArray) * IpxSendECBNum );

   For Lauf1 := 1 to IpxSendECBNum do
    Begin
     GetMem(SendECBs^[Lauf1],SizeOf(tIPXECBBlock));
     With SendECbs^[Lauf1]^ do                     { Grundinitialisierungen vornehmen }
      Begin
       FragmentCount := 1;
           SocketNum := MyIpxSocket;
           InUseFlag := 0;
       GetMeM(Fragments[0].Data,Ipx_MaximalMemSize);
       With Fragments[0] do
        Begin
         Size := IPX_MaximalMemSize;
         With Data^.Header do
          Begin
           SourceNet := MyIPXAddress;
          End;
        End;
      End;
    end;

   Fillchar(EveryNodes.Node,SizeOf(tNode),$FF);
    EveryNodes.Socket := MyIpxsocket;
   EveryNodes.Network := 0;

   Fillchar(NoNodes.Node,SizeOf(tNode),$00);
       NoNodes.Socket := MyIpxSocket;

   For Lauf1 := 1 to IpxRecieveECBNum do
    Begin
     RecieveBlocks^[Lauf1]^.Header.SourceNet := MyIPXAddress;
     RecieveBlocks^[Lauf1]^.Header.SourceNet.Socket := MyIpxSocket;
    End;
   InitedAlready := TRUE;
  End;


 Setecb(RecieveECB,@MyCallProc,MyIpxSocket,NoNodes,RecieveECB^.Fragments[0]);    {}

 Listen(RecieveECB);
 Asm
  Mov Ds ,OldDS
 End;
End;


Procedure DeInitializeIPX;
Var
 Lauf1 : Word;
 OldDS : Word;
Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

 CloseSocket(MyIpxSocket);
{ For Lauf1 := 1 to IpxRecieveECBNum do              { Alle anstehenden ECBs stornieren }
{  CancelEvent(RecieveECBS^[Lauf1]^);  }
 CancelEvent(RecieveECB^);

 Asm
  Mov Ds ,OldDS
 End;
End;


Function CompareIpxIDs( ID1, ID2 : pointer ) : Boolean;
Var
 Lauf1 : Word;
 OldDS : Word;

Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

 CompareIpxIDs := TRUE;
 If (pIpxIDStruct(ID1)^.NetWork <> pIpxIDStruct(ID2)^.NetWork) then
  Begin
   CompareIpxIDS := FALSE;
  End;
 For Lauf1 := 0 to 5 do If pIpxIDStruct(ID1)^.Node[Lauf1] <> pIpxIDStruct(ID2)^.Node[Lauf1] then
  Begin
   CompareIpxIDs := FALSE;
  ENd;
 Asm
  Mov Ds ,OldDS
 End;
End;

Begin
 InitedAlready := FALSE;
 ProcToCall := NIL;
 INITipxint;
 GetInterNetWork(MyIPXAddress.Network,MyIpxAddress.Node);
 MyIpxAddress.Socket := MyIPxSocket;

 EveryNodes.Network := 0;
 SetSwapDirName;
end.

