{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit NetBUnit;
Interface
uses Crt,Dos, NetTypes,Fastcop;
Type
    pStr16      = ^tStr16;
    pStr50      = ^tStr50;
    pStr70      = ^tStr70;

    tStr10      = String[10];
    tStr3       = String[3];
    tStr16      = String[16];
    tStr19      = String[19];
    tStr20      = String[20];
    tStr45      = String[45];
    tStr50      = String[50];
    tStr70      = String[70];
 
{ ************************************************************************** }
{ ***           NETBUNIT - NetBIOS Routinen fr LanTsr                   *** }
{ ***                        V 0.003b                                    *** }
{ ************************************************************************** }
{ *** History :                                                          *** }
{ ***                                                                    *** }
{ *** V 0.003b / 26.08.1996 :                                            *** }
{ ***    Diese Datei angelegt. Es wurden die Funktionen                  *** }
{ ***      - GetComputerInformation                                      *** }
{ ***      - ResetAdapter                                                *** }
{ ***      - AddNetBIOSName                                              *** }
{ ***    in dieser Version implementiert.                                *** }
{ *** V 0.004b / 26.08.1996 :                                            *** }
{ ***    Hinzugefgt wurden :                                            *** }
{ ***      - DeleteNetBIOSName                                           *** }
{ ***      - NetBIOSSend                                                 *** }
{ *** V 0.005b / 30.08.1996 :                                            *** }
{ ***    Nun ja. Es scheint nicht zu funktionieren, das Senden und       *** }
{ ***    Empfangen per "Send" und "Recieve". Nur das Senden + Empfangen  *** }
{ ***    per Broadcasts luft ...                                        *** }
{ ************************************************************************** }
Const
                   MaxNames = 10;

{$I NB_TYPES}

Const
                    IDChar1 = 'L';               { Identifikationszeichen 1 }
                    IDChar2 = 'S';               { Identifikationszeichen 2 }


  NetBIOS_MaximalPacketSize = 512;
    NetBIOS_MaximalDataSize = NetBIOS_MaximalPacketSize - SizeOf(tNetBIOSPacket) + 1;

      NETBIOS_PACKET_ISUSED = $FF;               { Dieser Wert zeigt in einem Paket an, das dieses verwendet wird }

                  GROUPNAME = TRUE;
                   USERNAME = FALSE;

           NetBIOS_NodeName = 1;

                 UseNetBIOS : Boolean = TRUE;   { NetBIOS benutzen ? }

             CurrentAdapter = 0;
                     LSNMAX = 32;                { Die Maximale Zahl an LSNs }
            OutStandNCBsMax = 32;                { Die Maximale Zahl an NCBs }

          NetBIOSSendNCBNUm : Word = 5;         { Eigentlich wird nur ein Sende-ECB gebraucht }
       NetBIOSRecieveNCBNum : Word = 5; {}
                   SendNCBs : pNetBIOSNcbArray = NIL;  { Die Pakete, die zum Senden da sind. }
                RecieveNCBs : pNetBIOSNcbArray = NIL;  { Die Pakete, die auf eine Antwort lauschen. }

               NB_EVERYNAME = $FF;               { Jeder Nachricht zuhren }

                   LanTsrID = 'DVD ';
            LantsrGroupName = 'LanTsr (C) DvD  ';


Var
                MyNetWorkID : tNetBIOSIdStruct;
                 ProcToCall : Pointer;
                 ListenProc : Pointer;
                SwapDirName : tStr12;            { Auslagerungspfad fr NetBIOS }



Procedure CancelNetBIOSEvent( OldNCB : pNCB );
{ ************************************************************************** }
{ *** Storiniert das alte Kommando, das mit "OldNCB" befehligt wurde.    *** }
{ ************************************************************************** }

Procedure GetComputerInformation;
{ ************************************************************************** }
{ *** Liefert Informationen ber den Rechner & das NetBIOS zurck.       *** }
{ ************************************************************************** }

Procedure ResetAdapter( adapternum, sessionzahl, pendingcomm : Byte );
{ ************************************************************************** }
{ *** Setzt den Adapter 0 innerhalb des Rechners zurck.                 *** }
{ ************************************************************************** }

Function AddNetBIOSName( Name : tStr16; Var AddedNameNumber : Byte; IsGroupName : Boolean ) : Byte;
{ ************************************************************************** }
{ *** Dieses Kommando fgt einen Gruppennamen in die Namenstabelle des   *** }
{ *** NetBIOS ein. Der Name wird ber "Name" bergeben. Die Nummer des   *** }
{ *** Namens, so er hinzugefgt wird, wird in "AddedNameNumber"          *** }
{ *** eingetragen. Wird "IsGroupName" gesetzt, so wird ein Gruppenname   *** }
{ *** hinzugefgt, ansonsten wird ein lokaler Namen eingetragen.         *** }
{ *** Es ist umbedingt ntig, das Funktionsergebnis zu berprfen, um    *** }
{ *** kontrollieren zu knnen, ob der Name nicht bereits vorhanden ist.  *** }
{ *** (Fktergenis = $19/$0D, <> 0)                                       *** }
{ ************************************************************************** }

Function DeleteNetBIOSName( Name : tStr16 ) : Byte;
{ ************************************************************************** }
{ *** Lscht den lokalen Namen "Name".                                   *** }
{ ************************************************************************** }

Function NetBIOSSend( MyNCB : Pointer; DataBuffer : Pointer; DataLength : Word; Name : tStr16; MyNameNum : Byte ) : Byte;
{ ************************************************************************** }
{ *** Schickt den Datenblock "DataBuffer" mit der Lnge "DataLength"     *** }
{ *** ab. Dazu wird der ber "MyNCB" bergebene NCB-Block verwendet.     *** }
{ *** Der Empfnger wird ber "Name" spezifiziert. "MyNameNum" gibt      *** }
{ *** einen "Namen" aus meiner Namensliste an, der als "Absender"        *** }
{ *** benutzt wird.                                                      *** }
{ ************************************************************************** }
Procedure NetBIOSSendBroad( MyNCB : Pointer; DataBuffer : Pointer; DataLength : Word; Name : tStr16; MyNameNum : Byte );


Procedure NetBIOSRecieve
( MyNcb : Pointer; DataBuffer : Pointer; DataLength : Word; EventHandler : Pointer; NameToListenTo : Byte );

Procedure RepeatRecieve( MyNCB : pNCB );

Procedure NetBIOSRecieveBroad
( MyNcb : Pointer; DataBuffer : Pointer; DataLength : Word; EventHandler : Pointer; NameToListenTo : Byte );


Procedure CallNetBios( MyNCB : pNCB );

Procedure CopyNameToStr( Var Name : tStr16; MyName : pNetBIOSName );
Procedure CopyStrToName( Name : tStr16; MyName : pNetBIOSName );

{Function GetFreeNetBIOSDataBlock : Pointer;{}

Procedure InitializeNetBIOS;
Procedure DeInitializeNetBIOS;
Function CompareNetBIOSIDs( ID1, ID2 : Pointer ) : Boolean;

Function SendOneNetBIOSPacket( IdNum: Word; Address: Pointer; DataPointer:Pointer; DataLength:Word; InWorkGroup:Word):Word;
Function SendNetBIOSPacket( IdNum:Word;Address:pAddressChain;DataPointer:Pointer; DataLength:Word; InWorkGroup:Word ):Word;

Implementation

Const
 NetBiosInt = $5C;

 NB_COMMAND_ADAPTERSTATUS = $33;                 { Adapter-Informationen erlangen }
     NB_COMMAND_BROADCAST = $A2;                 { Boradcast mit Event-Routine }
         NB_COMMAND_RESET = $32;                 { Adapter-Reset }
       NB_COMMAND_ADDNAME = $30;                 { Lokalen Namen hinzufgen }
  NB_COMMAND_ADDGROUPNAME = $36;                 { Gruppennamen hinzufgen }
     NB_COMMAND_ADDNAMENW = $B0;                 { Lokalen Namen hinzufgen }
NB_COMMAND_ADDGROUPNAMENW = $B6;                 { Gruppennamen hinzufgen }

    NB_COMMAND_DELETENAME = $31;                 { Namen lschen }

        NB_COMMAND_SENDNW = $A0;                 { Senden ohne warten }
      NB_COMMAND_LISTENNW = $A1;                 { Lauschen ohne warten }

   NB_COMMAND_SENDBROADNW = $A2;                 { Broadcast abschicken ... }
 NB_COMMAND_LISTENBROADNW = $A3;                 { Auf Broadcast lauschen }

        NB_COMMAND_CANCEL = $35;

      NB_ERROR_NAMEEXISTS = $16;



    NB_ERR_TOMUCHCOMMANDS = $22;                 { Zu viele Kommandos anstehend }


Procedure CopyStrToName( Name : tStr16; MyName : pNetBIOSName );
Var
 Lauf1 : Word;
Begin
 For Lauf1 := 1 to 16 do
  Begin
   If Lauf1 > Length(name) then
    Begin
     MyName^[Lauf1] := #0;
    End
   Else
    Begin
     MyName^[Lauf1] := Name[Lauf1];
    End;
  End;
End;

Procedure CopyNameToStr( Var Name : tStr16; MyName : pNetBIOSName );
Var
 Lauf1 : Word;
Begin
 Name := '';
 For Lauf1 := 1 to 16 do
  Begin
   If MyName^[Lauf1] <> #0 then Name := Name + MyName^[Lauf1];
  End;
End;

Procedure CallNetBios( MyNCB : pNCB );
{ Ruft das NetBIOS auf und bergibt ihm den angebenen NCB. }
Begin
  Asm
   mov es, word ptr myncb + 2
   mov bx, word ptr myncb
   int NETBIOSINT
  End;
End;



Procedure GetComputerInformation;
const
 hex:array[0..15] of char='0123456789ABCDEF';

Var
 StandardNCB : pNCB;
     TempStr : tStr16;
       Lauf1 : Word;

 Procedure SetSwapDirName;
 Var
   Lauf1 : Word;

  Begin
   SwapDirName := '';
   With pAdapterStatus(StandardNCB^.Buffer)^ do
    Begin
     For Lauf1 := 1 to 5 do
      Begin
       SwapDirName := SwapDirName +(hex[(MyNode[Lauf1] shr 4) and $F]);
       SwapDirName := SwapDirName +(hex[MyNode[Lauf1] and $F]);
       If Lauf1 = 4 then SwapDirName := SwapDirName + '.';
      End;
     SwapDirName := SwapDirName + (hex[(MyNode[5] shr 4) and $F]);
    End;
  End;



Begin
 GetMem(StandardNCB,SizeOf(tNCB));
 FillChar(StandardNCB^,SizeOf(tNCB),0);
 GetMem(StandardNCB^.Buffer,SizeOf(tAdapterStatus));
 FillChar(pAdapterStatus(StandardNCB^.Buffer)^,SizeOf(tAdapterStatus),0);

 With StandardNCB^ do
  Begin
      Command := NB_COMMAND_ADAPTERSTATUS;
   AdapterNum := 0;
  CallName[1] := '*';
       BufLen := SizeOf(tAdapterStatus);
  End;

 CallNetBios(StandardNCB);
 Repeat Until StandardNCB^.CmdDone <> $FF;

 { So. Die Informationen wurde nun geliefert. Diese mssen jetzt umgesetzt werden. }

 With pAdapterStatus(StandardNCB^.Buffer)^ do
  Begin
   TempStr := LanTsrID;                          { Den temporren Namens-String mit dem Standardwert vorbelegen }
   For Lauf1 := 0 to 5 do { Alle 5 Node-Nummern durchlaufen. }
    Begin
     TempStr := TempStr + (hex[(MyNode[Lauf1] shr 4) and $F]);
     TempStr := TempStr + (hex[MyNode[Lauf1] and $F]);
    End;
   CopyStrTOName(TempStr,Addr(MyNetWorkID));

   SetSwapDirName;
  End;

 FreeMem(StandardNCB^.Buffer,SizeOf(tAdapterStatus));
 FreeMem(StandardNCB,SizeOf(tNCB));
End;

Procedure CancelNetBIOSEvent( OldNCB : pNCB );
Var
 StandardNCB : pNCB;
Begin
 If OldNCB^.CmdDone = $FF then
  Begin
   GetMem(StandardNCB,SizeOf(tNCB));
   FillChar(StandardNCB^,SizeOf(tNCB),0);
   With StandardNCB^ do
    Begin
     Command := NB_COMMAND_CANCEL;
     AdapterNum := CurrentAdapter;
     Buffer := pNetBIOSPacket(OldNCB);
    End;
   FreeMem(StandardNCB,SizeOf(tNCB));
   Repeat UNtil StandardNCB^.CmdDone <> $FF;
  End;
End;

Procedure ResetAdapter( adapternum, sessionzahl, pendingcomm : Byte );
Var
 StandardNCB : pNCB;
Begin
 GetMem(StandardNCB,SizeOf(tNCB));
 FillChar(StandardNCB^,SizeOf(tNCB),0);
 With StandardNCB^ do
  Begin
      Command := NB_COMMAND_RESET;
   AdapterNum := AdapterNum;
          Lsn := SessionZahl;
      NameNum := PendingComm;
  End;
 CallNetBios(StandardNCB);
 Repeat Until StandardNCB^.CmdDone <> $FF;
 FreeMem(StandardNCB,SizeOf(tNCB));
End;

Function AddNetBIOSName( Name : tStr16; Var AddedNameNumber : Byte; IsGroupName : Boolean ) : Byte;
{ Achtung !
  Diese Prozedur braucht recht lange, um zu Funktionieren !!!
    }
Var
 StandardNCB : pNCB;

Begin
 GetMem(StandardNCB,SizeOf(tNCB));
 FillChar(StandardNCB^,SizeOf(tNCB),0);

 With StandardNCB^ do
  Begin
   If IsGroupName then
{IFDEF RETAILVERSION}                           { Wenn zum Weiterverkaufen gedacht, warten lassen (zur Sicherheit) }
      Command := NB_COMMAND_ADDGROUPNAME else
      Command := NB_COMMAND_ADDNAME;
{ELSE}
{      Command := NB_COMMAND_ADDGROUPNAMENW else
      Command := NB_COMMAND_ADDNAMENW; {}
{ENDIF}

   AdapterNum := CurrentAdapter;
   CopyStrToName(Name,@MyName);
   PostRoutine := NIL;
  End;
 CallNetBios(StandardNCB);
 Repeat Until StandardNCB^.CmdDone <> $FF;
  AddNetBIOSName := StandardNCB^.RetCode;
 AddedNameNumber := StandardNCB^.NameNum;
 FreeMem(StandardNCB,SizeOf(tNCB));
End;

Function DeleteNetBIOSName( Name : tStr16 ) : Byte;
Var
 StandardNCB : pNCB;
Begin
 GetMem(StandardNCB,SizeOf(tNCB));
 FillChar(StandardNCB^,SizeOf(tNCB),0);
 With StandardNCB^ do
  Begin
   Command := NB_COMMAND_DELETENAME;
   AdapterNum := 0;
   CopyStrToName(Name,@MyName);
  End;
 CallNetBios(StandardNCB);
 Repeat Until StandardNCB^.CmdDone <> $FF;
 If StandardNCB^.RetCode = $17 then DeleteNetBIOSName := 0 else DeleteNetBIOSName := StandardNCB^.RetCode;
 FreeMem(StandardNCB,SizeOf(tNCB));
End;


Procedure NetBIOSSendBroad( MyNCB : Pointer; DataBuffer : Pointer; DataLength : Word; Name : tStr16; MyNameNum : Byte );
Begin
 With pNCB(MyNCB)^ do
  Begin
       Command := NB_COMMAND_SENDBROADNW; {}
    AdapterNum := CurrentAdapter;
        Buffer := DataBuffer;
        BufLen := DataLength;
   PostRoutine := NIL;
       NameNum := MyNameNum;
  End;
 CallNetBios(MyNCB);
End;

{Function GetFreeNetBIOSDataBlock : Pointer;
Var
 Lauf1 : Word;
Begin
 GetFreeNetBIOSDataBlock := NIL;
 For Lauf1 := 1 to NetBIOSRecieveBlockNum do
  Begin
   If (DataBlocks^[Lauf1]^.IsIDChar1 <> IDChar1) or
      (DataBlocks^[Lauf1]^.IsIDChar2 <> IDChar2) then
    Begin { Wenn die Identifikation nicht der entspricht, die verwendet wird, wenn das Paket "Gebraucht" wird, benutzen }
{     GetFreeNetBIOSDataBlock := DataBlocks^[Lauf1];
     Exit;
    End;
  End;
End; {}


Procedure NetBIOSRecieveBroad
( MyNcb : Pointer; DataBuffer : Pointer; DataLength : Word; EventHandler : Pointer; NameToListenTo : Byte );
Begin
 With pNCB(MyNCB)^ do
  Begin
      Command := NB_COMMAND_LISTENBROADNW;
   AdapterNum := CurrentAdapter;
       Buffer := DataBuffer;
       BufLen := DataLength;
      NameNum := NameToListenTo;
  PostRoutine := EventHandler;
  End;
 CallNetBios(MyNCB);
End;

{$I NB_SNRC}
{$F+}
Var
 Pointer1, Pointer2 : Pointer;

Procedure NetBIOSStage1CallGate( CallingNCB : pNCB );  Far;
Begin
 If Not(CompareNetBIOSIds(@(CallingNCB^.Buffer^.ProgramHeader.WhoIsSender.NetBIOSAddress),@(MyNetworkid))) then
  Begin { Das Paket kommt nicht von Mir ! }
   Pointer1 := Addr(CallingNCB^.Buffer^.ProgramHeader);
   Pointer2 := Addr(CallingNCB^.Buffer^.Data);
   Asm
    Push Ds
    Push Es
    Pusha

    Mov Ax, Word Ptr Pointer1
    Mov Bx, Word Ptr Pointer1 + 2
    Mov Cx, Word Ptr Pointer2
    Mov Dx, Word Ptr Pointer2 + 2

    Call [ProcToCall]

    Popa
    Pop es
    Pop ds
   End;
  End;
 { Das "Listen" ist bei NetBIOS berflssig, da es von der Request-Routine
   aufgerufen wird. }
End;


Procedure MyCallProc; Assembler;
Asm
        push     ds
        push ax
        mov ax, seg @data
        mov     ds, ax
        pop ax

        cmp     word ptr proctoCall, 0  { Erstmal kontrollieren, ob }
        jne     @Wasda
        cmp     word ptr proctoCall + 2, 0
        je      @Nichtsda

@WASDA:


        pusha                           { Alle Register sichern, da NetBIOS allergisch auf Registervernderungen ist ! }
        push    ds                      { DS, ES werden von PUSHA/POPA nicht behandelt ! }
        push    es

        push    es
        push    bx

        call    [NetBIOSStage1CallGate]
        pop     es
        pop     ds
        popa                            { Und die gesicherten Wiederherstellen ! }

@NICHTSDA:
        pusha
        push    ds                      { DS, ES werden von PUSHA/POPA nicht behandelt ! }
        push    es

        push    es                      { ES:BX -> Zeiger auf den NCB, der Ankam. Dieser mu erneut freigegeben werden. }
        push    bx                      { Darum mu ich sie als Parameter auf den Stack tun (Fr ListenProc) }

        call    ListenProc              { Und wieder freigeben  }
        pop     es
        pop     ds
        popa                            { Und die gesicherten Wiederherstellen ! }

        pop ds
        iret
End;

Procedure DeInitializeNetBIOS;
Var
 lauf1 : Word;
 OldDS : Word;

Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;
 For Lauf1 := 1 to NetBIOSRecieveNCBNum do
  CancelNetBIOSEvent(RecieveNCBs^[Lauf1]);
 DeleteNetBIOSName(LantsrGroupName);
 DeleteNetBIOSName(MyNetWorkID.NetBiosName);
 Asm
  Mov Ds ,OldDS
 End;
End;

Function CompareNetBIOSIDs( ID1, ID2 : Pointer ) : Boolean;
Var
 OldDS : Word;
 Lauf1 : Byte;

Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;
 CompareNetBIOSIds := TRUE;
 ID1 := @(pNetBIOSIdStruct(ID1)^.NetBIOSName);
 ID2 := @(pNetBIOSIdStruct(ID2)^.NetBIOSName);
 For Lauf1 := 1 to SizeOf(tNetBIOSName) do
  Begin
   If Char(ID1^) <> Char(ID2^) then CompareNetBIOSIDs := FALSE;
   Inc(LongInt(Id1));
   Inc(LongInt(Id2));
  End;

 Asm
  Mov Ds ,OldDS
 End;
End;

Function SendOneNetBIOSPacket( IdNum: Word; Address: Pointer; DataPointer:Pointer; DataLength:Word; InWorkGroup:Word):Word;

Var
 SendNCB : pNcb;
   Lauf1 : Word;
   Xname : tstr16;
 OldDS : Word;

Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

 SendNCB := NIL;
 While SendNCB = NIL do                         { Bei IPX als erstes einen noch nicht zum Senden benutzten ECB suchen }
  Begin
   For Lauf1 := 1 to NetBIOSSendNCBNum do
    If SendNCBs^[Lauf1]^.CmdDone <> NETBIOS_PACKET_ISUSED then
      Begin
       SendNCB := SendNCBs^[Lauf1];
       Lauf1 := NetBiosSendNCBNum;              { Schleife beenden und Interrupts ausschalten, damit mir keiner in der }
       asm
        cli
       End;
      End;
   If (Lauf1 = NetBIOSSendNCBNum) and (SendNCB = NIL) then
    Begin { Mll ! Kein Teil gefunden ! }
     SendOneNetBIOSPacket := 1;
     Exit;                                      { Und Raus ... }
    End;
  End;


 With SendNCB^ do                               { Nun die Daten in den gefundenen ECB eintragen }
  Begin
   CmdDone := NETBIOS_PACKET_ISUSED;            { Das Paket fr andere Prozesse sperren. }
   asm
    sti
   End;

   With Buffer^.ProgramHeader do
    Begin
     MyID := IdNum;                              { Das Paket-ID eintragen }
     FromWorkGroup := InWorkGroup;
     IsIDChar1 := IdChar1;
     IsIDChar2 := IdChar2;
     With WhoIsSender do                        { Den Sender noch eintragen ... }
      Begin
       NetType := Prot_NetBIOS;                   { Ich bin ein IPX-Paket ! }
       WhoisSender.NetBIOSAddress.NetBIOSName := MyNetworkID.NetBIOSName; { Den Absender eintragen }
      End;
    End;
   FastCopy(DataPointer^,Buffer^.Data[0],DataLength);  { Die Daten in das Paket verschieben }

   If Address = NIL then
    Begin { Ein Broadcast an alle Lantsr-Benutzer ! }
     CmdDone := 0;
     SendOneNetBIOSPacket := NetBIOSSend(SendNCB,SendNCB^.Buffer,NetBIOS_MaximalPacketSize,LanTsrGroupName,NetBIOS_NodeName);
    End
   Else
    Begin { Nur an einen bestimmten Rechner gerichtet ! }
     CmdDone := 0;
{     With pNetBIOSIdStruct(Address)^ do }
      Begin
       CopyNameToStr(XName,Addr(pNetBIOSIdStruct(Address)^.NetBIOSName));
SendOneNetBIOSPacket := NetBIOSSend(SendNCB,SendNCB^.Buffer,NetBIOS_MaximalPacketSize,XName,NetBIOS_NodeName);
      End;
    End;
  End;
 Asm
  Mov Ds ,OldDS
 End;

End;

Function SendNetBIOSPacket( IdNum:Word;Address:pAddressChain;DataPointer:Pointer; DataLength:Word; InWorkGroup:Word ):Word;
Var
 Lauf1 : Word;
 OldDS : Word;

Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;
 If Address = NIL then
  Begin
   Lauf1 := SendOneNetBIOSPacket(IdNum,NIL,DataPointer,DataLength,InWorkGroup);
   SendNetBIOSPacket := LAuf1;
  End
 Else
  Begin
   SendNetBIOSPacket := 0;
   While Address <> NIL do                       { Alle Addressen abarbeiten }
    Begin
      Lauf1 := SendOneNetBIOSPacket(IdNum,Addr(Address^.Address.NetBIOSAddress),DataPointer,DataLength,InWorkGroup);
     If Lauf1 <> 0 then
      Begin
       SendNetBIOSPacket := Lauf1;
       Exit;
      End;
     Address := Address^.pNext;
    End;
  End;
 Asm
  Mov Ds ,OldDS
 End;
End;




Procedure InitializeNetBIOS;
Var
   Lauf1 : Word;
 TempStr : tStr16;
 OldDS : Word;

Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

 ResetAdapter(0,13,13);
{ BigBlocks[Prot_NetBIOS] := Const_NetBIOSBiggestBlock; }
 { Ausgeben, damit der Benutzer wei was los ist ! }
 Write('Hinzufgen der LanTsr-Gruppe ... (Bitte warten) : ');
 Lauf1 := AddNetBIOSName(LantsrGroupName,MyNetWorkID.MainGroupNameNumber,True); {}

{$IFDEF RETAILVERSION}
 If Lauf1 = NB_ERROR_NAMEEXISTS then
  Begin
   Writeln('Gruppe schon vorhanden.');
   MyNetWorkID.NetBIOSAddress.IsTrueGroupName := FALSE;
                                                { In dem entprecheenden Feld der Adresse steht nicht die korrekte Nummer. }
  End
 Else If Lauf1 <> 0 then                       { Scheisse gebaut ! }
  Begin
   Writeln;
   Writeln('Fehler beim Initialisieren. NetBIOS wird deaktiviert.');
   Writeln(Lauf1);
   UseNetBIOS := FALSE;
   Exit;                                       { Und raus ... }
 End
  Else {$ENDIF}
   Begin
    Writeln('OK.');
    MyNetWorkID.IsTrueGroupName := TRUE;
   End; {}

  Write('Hinzufgen des Rechner-Ids ...   (Bitte warten) : ');
  CopyNameToStr(TempStr,Addr(MyNetWorkID.NetBiosName));
   Lauf1 := AddNetBIOSName(TempStr,MyNetWorkID.MyNameNumber,False); {}
{$IFDEF RETAILVERSION}
  If Lauf1 <> 0 then
   Begin
    Writeln;
    Writeln('Fehler beim Initialisieren. NetBIOS wird deaktiviert.');
    Writeln(Lauf1);
    UseNetBIOS := FALSE;
    Exit;                                       { Und raus ... }
   End
  Else
{$ENDIF}
   Writeln('OK.');

 GetMem(SendNCBs,SizeOf(tNetBIOSNcbArray) * NetBIOSSendNCBnum );
 For Lauf1 := 1 to NetBIOSSendNCBNum do
  Begin
   GetMem(SendNCBs^[Lauf1],SizeOf(tNCB));
   FillChar(SendNCBs^[Lauf1]^,SizeOf(tNCB),0);
   GetMem(SendNCBs^[Lauf1]^.Buffer,NetBIOS_MaximalPacketSize );
   FillChar(SendNCBs^[Lauf1]^.Buffer^,NetBIOS_MaximalPacketSize,0 );
   SendNCBs^[Lauf1]^.BufLen := NetBIOS_MaximalPacketSize;
  End;

 GetMem(RecieveNCBs,SizeOf(tNetBIOSNcbArray) * NetBIOSRecieveNCBnum );
 For Lauf1 := 1 to NetBIOSRecieveNCBNum do
  Begin
   GetMem(RecieveNCBs^[Lauf1],SizeOf(tNCB));
   FillChar(RecieveNCBs^[Lauf1]^,SizeOf(tNCB),0);
   GetMem(RecieveNCBs^[Lauf1]^.Buffer,NetBIOS_MaximalPacketSize );
   FillChar(RecieveNCBs^[Lauf1]^.Buffer^,NetBIOS_MaximalPacketSize,0);
   RecieveNCBs^[Lauf1]^.BufLen := NetBIOS_MaximalPacketSize;
  End; {}


 For Lauf1 := 1 to NetBIOSRecieveNCBNum do
  With RecieveNCBs^[Lauf1]^ do
   Begin                                             {RecieveProcs[PROT_NETBIOS] }
    NetBIOSRecieve(RecieveNCBs^[Lauf1],Buffer,BufLen,@MyCallProc,NB_EVERYNAME); {}
   End;

 Asm
  Mov Ds ,OldDS
 End;
End;



Begin
 GetComputerInformation;                       { Erlangt Basisiinformationen ber den Rechner und fllt "MYID" }
 ProcToCall := NIL;
 ListenProc := @RepeatRecieve;
End.