{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit SpLab;
INTERFACE
{ Implementiert die Sprachlabor-Routinen }
Uses Dos,Crt, Screens, StrType, String_P, Video, SbDsp, SoundRec, ProgVars, ReadKeys,
     SendProc;

Procedure StartClientSpeechLab;
Procedure RecordSpeechLabFile;

IMPLEMENTATION

Const
 ScriptOK : Boolean = FALSE;

{$F+}

PROCEDURE TimerInterruptForSpeechLab; Interrupt;
Var
 TempWord : Word;

Begin
 If (Snd_CurrentJob = SND_Playing) or (Snd_CurrentJob = SND_PlayRecord) then
  Begin
   If UsedBlock[CurrBlock] then
    Begin
{     TempPointer := Pointer(LongInt(PLyBytePtr) - 1);
     If TempPointer^ - PlyBytePtr^ > 5 then WriteDirect(PLyBytePtr^ + 5) else
If TempPointer^ - PlyBytePtr^ < -5 then WriteDirect(PLyBytePtr^ - 5) else }
{     IF PlyInBlockPosition < 050 THEN   { Datenblock abgespielt? (-1, da letztes Byte immer = 0) }
{     WriteDirect(128) else }
     WriteDirect(PlyByteptr^);

     If Snd_CurrentJob = Snd_PlayRecord then
      Begin
       TempWord := MyReadDirect;
       Inc(TempWord,PlyBytePtr^);
       PlyBytePtr^ := TempWord shr 1;
      End;

     IF PlyInBlockPosition = DataBlockSize - 1 THEN   { Datenblock abgespielt? (-1, da letztes Byte immer = 0) }
      Begin
{       If SpeechLabListener <> NIL then          { Soll an jemand anderes ebenfalls verschickt werden ? }
{        Begin
         SendAll(SPEECHDATA,SpeechLabListener,@PlayDataBlocks[CurrBlock]^[1],DataBlockSize);
        End; }

       UsedBlock[CurrBlock] := FALSE;
       If CurrBlock = MaxBlock then CurrBlock := 1 else Inc(CurrBlock);
       PLyBytePtr := @PlayDataBlocks[CurrBlock]^[1];
       PlyInBlockPosition := 0;
      End
     ELSE                                           { nein }
      BEGIN
       Inc(PlyInBlockPosition);                                 { Zhler erhhen }
       Inc(LongInt(PlyBytePtr));                       { nchstes Byte holen (auch korrekt mit Segmentbertrag !) }
      END;
    End
   else
    Begin
     If CurrBlock = MaxBlock then CurrBlock := 1 else Inc(CurrBlock);
     PlyBytePtr := @PlayDataBlocks[CurrBlock]^[1];
     WriteDirect(128)
    End;
  End;

 Port[$20] := $20;                              { Interruptroutine beenden }
 If TimerCount > 0 then
  Begin
   Dec(TimerCount);
  End
 Else
  Begin
   TimerCount := TimerCountFrom;
   asm
    pushf
    call [TimerOld]
   End;
  End;
END;


Procedure StopLabData;
Var
 Lauf1 : Word;
Begin
{ If Snd_CurrentJob <> SND_None then }
   { *** Den Verwaltungsapperat zurcksetzen ******************************* }
   Snd_CurrentJob := SND_IDle;
   SetOrigFreq;                                 { Original-Frequenz fr den Timer einstellen }
{   SetTimerWord(OldTimerValue);                  { Dem alten Timer-Wert wiederherstellen }
   SetIntVec($08, TimerOld);                     { alte Timer-Routine setzen }
   Speaker_Off;                                  { Lautsprecher aus }
{
   Case Snd_CurrDest Of
    DST_NETBROADCAST : Begin
                       End;
             DST_HDD : Begin
                       End;
   End;
          }
   Snd_CurrDest := DST_NONE;
{ *** Und den reservierten Speicher wieder freigeben *********************** }
{ For Lauf1 := 1 to 4 do FreeMem(RecordDataBlocks[Lauf1],SizeOf(tByteArray)); }
 For Lauf1 := 1 to 4 do FreeMem(PlayDataBlocks[Lauf1],SizeOf(tByteArray));
End;

PROCEDURE StartLabData(Destination : Byte);
Var
 Lauf1 : Word;
BEGIN
 If Snd_CurrentJob = SND_IDLE then
  Begin
   { *** Und den Speicher nicht vergessen ... ****************************** }
   For Lauf1 := 1 to 4 do
    Begin
{     GetMem(RecordDataBlocks[Lauf1],SizeOf(tByteArray)); }
     GetMem(PlayDataBlocks[Lauf1],SizeOf(tByteArray));
     FillChar(PLayDataBlocks[Lauf1]^,SizeOf(tByteArray),SoundNullByte);
    End;

   { *** Je nach Ziel der bertragung unterschiedliche Initialisierung ***** }
{   Case Destination Of
    DST_NETBROADCAST : Begin
                       End;
             DST_HDD : Begin
                       End;
   End; }
   { *** Wichtige Variablen initialisieren ********************************* }
   Snd_CurrDest := Destination;
   PlyBytePtr := @PlayDataBlocks[1]^[1];
   PlyInBlockPosition := 0;
   CurrBlock := 1;

   { *** Den DSP und die Verwaltung initialisieren ************************* }
   InitDSP;                                       { DSP initialisieren }
{   Snd_CurrentJob := }

   Speaker_On;                                        { Lautsprecher ein }
{   OldTimerValue := EstimateTimerValue; }
   GetIntVec($08, TimerOld);             { alten Timer-Interrupt sichern }
   SetIntVec($08, @TimerInterruptForSpeechLab );              { Timer-Interrupt umlenken }

   SetTimerFreq(STD_SAMPLEFREQ);                 { Timer-Frequenz einstellen }
   { Nun den Faktor berechnen, mit dem der alte Interrupt aufgerufen werden soll. }
   TimerCountFrom := STD_SAMPLEFREQ div 18;  { 18 -> Alte Frequenz ... }
   TimerCount := TimerCountFrom;
  End
 Else
  Begin
   MessageBox(10,3,60,3,'Das Sound-System ist bereits aktiv !');
   Readkey;
  End;
END;


Procedure StartClientSpeechLab;
Const
  DisplayedCharCounter : Byte = 0;               { Aktuelles buntes Zeichen }
          MenuPosition : Byte = 1;               { Die aktuelle Menposition }

              WINDOW_Y = 2;

             WINDOW_X2 = 75;
          MAXMENUITEMS = 5;

      WIND_GRANULARITY = 4;                      { Die Anzahl an "DataBlockSize"-Blcken, die bei einer Bettigung der tasten}
      WIND_DELAY       = 10000;
      WIND_BACK = 1;
      WIND_FORWARD = 2;

              OUTWIN_X = 10;
              OutWin_Y = 7;
             OutWin_X2 = 60;
             OutWin_Y2 = 13;

            FatalError : Boolean = FALSE;


Var
     CurrentPlyLabFile : File;
         FilePositions : Array[1..MaxBlock] of LongInt;

   CurrentFilePosition : LongInt;
   MaximalFilePosition : LongInt;

              TempLong : LongiNt;
                 Lauf1 : Word;
                 Lauf2 : Word;
               SaveJob : Word;
               OldSptr : Pointer;
{ ************************************************************************** }
           MaximalFree : LongInt;
        CurrentWritten : LongInt;
{ ************************************************************************** }
              Eingabe : Char;


     CurrentWINDDELAY : Word;
          CurrentWind : Byte;

{$I SR_SCRIP}

  Procedure WriteNiceActiveationDisplay;
  Begin
   Inc(DisplayedCharCounter); If DisplayedCharCounter = 9 then DisplayedCharCounter := 1;
   GotoXY(71,3);
   Case DisplayedCharCounter of
      2 : Write('');
      4 : Write('/');
      6 : Write('');
      8 : Write('\');
   End;
  End;

Const
   Men_STOP = 1;
     Men_FB = 2;
   Men_PLay = 3;
    Men_FWD = 4;
    Men_Rec = 5;



  XPosition_CurrentPos = 18;
  YPosition_CurrentPos = 4;
  XPosition_MaximalPos = 29;
  YPosition_MaximalPos = 4;


  {$I SR_SUPPM}                                  { *** Die Support-Routinen fr das Men }


Begin
 If Snd_CurrentJob = SND_IDLE then
  Begin
   CurSorOff;
   For lauf1 := 1 to Maxblock do FilePositions[Lauf1] := $FFFFFFFF;
   GotoXY(1,1);
   OldSptr := Sptr;
   CurrentWindDelay := 0;
   SaveScreen;
   CurrentFilePosition := 0;
   PaintBoxShadow(5,2,WINDOW_X2,23);                      { Einen Kasten malen }
   GotoXY(15,3); Write('SPRACHLABOR (C) 1996 by Daniel von Dincklage');
   GotoXy(70,3); Write('(*)');
    GotoXY(7,4); Write('Position : ');

   {*** Das Fenster mit den Ausgaben ***}
   PaintBox(OUTWIN_X,OutWin_Y,OutWin_X2+OutWin_X,OutWin_Y2+OutWin_Y);

   MaximalFree := DiskFree(0);                  { Variablen initialisieren }
   CurrentWritten := 0;
   Eingabe := #255;



   InitScript;

   If Not(FatalError) then
    Begin
     NextCommand;
     MaximalFilePosition := FileSize(CurrentPlyLabFile);
     GOtoXY(XPosition_CurrentPos,YPosition_CurrentPos);
     Write(CurrentFilePosition:10,'/',MaximalFilePosition);
     PaintMenu;

     ClearKBDBuffer;                               { Den Tastatur-Puffer lschen, da sonst Probleme }
     CurrentWIND := 0;

     StartLabData(DST_HDD);
     Snd_CurrDest := DST_HDD;

     Repeat
      If (Snd_CurrentJob = SND_Playing) or (Snd_CurrentJob = SND_PlayRecord) then
       Begin

        CurrentFilePosition := FilePos(CurrentPLyLabFile);
        For Lauf1 := 1 to MaxBlock do
         Begin
          If UsedBlock[Lauf1] = FALSE then
           Begin
            If (CurrentFilePosition < MaximalFilePosition) then
             Begin
              If (FilePositions[Lauf1] <> $FFFFFFFF) and (Snd_CurrentJob = Snd_PlayRecord) then
               Begin
                CurrentFilePosition := FilePos(CurrentPlyLabFile);
                WriteNiceActiveationDisplay;                 { Diesen netten "tanzenden" Balken produzieren. }
                Seek(CurrentPlyLabFile,FilePositions[Lauf1]);
                BlockWrite(CurrentPlyLabFile,PlayDataBlocks[Lauf1]^[1],DataBlockSize);
                Seek(CurrentPlyLabFile,CurrentFilePosition); { Diese wurde ja schon vorhin gesichert }
                Inc(CurrentWritten,DataBlockSize);
               End;

              FilePositions[Lauf1] := FilePos(CurrentPlyLabFile);
              BlockRead(CurrentPlyLabFile,PlayDataBlocks[Lauf1]^[1],DataBlockSize);
              UsedBlock[Lauf1] := TRUE;
             End
            Else StopRecordAndPLay; { Wenn das Ende erreicht ist, anhalten }

            OldX := WhereX;
            OldY := WhereY;
            GotoXY(XPosition_CurrentPos,YPosition_CurrentPos);
            Write(CurrentFilePosition:10);
            GotoXY(OldX,OldY);
           End;
         End;
        NextCommand;
       End;
      If CurrentWINDDelay <> 0 then       { Dies hier wird verwendet, um eine Soundausgabe nach einiger Zeit zu starten}
       Begin
        Dec(CurrentWindDelay);
        IF CurrentWindDelay = 0 then
         Begin
          Snd_CurrentJob := SaveJob;
          If CurrentWIND = WIND_BACK then
            SyncronizeFileToPosition(CurrentFilePosition,SYNC_Back) else
            SyncronizeFileToPosition(CurrentFilePosition,SYNC_AHED);
         End;
       End;
      If KeyPressed then
       Begin
        Eingabe := ReadKey;
        If CurrentCommand.Command = CMD_WriteAwnser then
         Begin
          ReadInputForAwnser(Eingabe)
         End
       else
        Case Eingabe of
         #0 : Begin                                  { Es ist ein "Escape-Code" }
               EIngabe := ReadKey;
               Case Eingabe of
                    #75 : Begin                      { Links }
                         If MenuPosition = 1 then MenuPosition := MaxMenuItems else Dec(MenuPosition);
                          PaintMenu;
                        End;
                  #77 : Begin                     { Rechts }
                         If MenuPosition = MaxMenuItems then MenuPosition := 1 else Inc(MenuPOsition);
                         PaintMenu;
                        End;

             End;
           End;
     #13 : Begin                                 { ENTER }
            Case MenuPosition of
          Men_STOP : StopRecordAndPlay;          { Menposition "STOP" aktiviert. }
            Men_FB : Begin                       { *** Menposition "Schneller Rcklauf" angewhlt }
                      CurrentFilePosition := FilePos(CurrentPlyLabFile);
                      If (CurrentFilePosition - WIND_GRANULARITY * DataBlockSize) >= 0 then
                       Begin
                        If CurrentWindDelay = 0 then
                         Begin
                          SaveJob := SND_CurrentJob;
                          Snd_CurrentJob := Snd_None;
                         End;

                        CurrentWIND := WIND_BACK;

                        Seek(CurrentPLyLabFile,CurrentFilePosition - WIND_GRANULARITY * DataBlockSize );
                        CurrentFilePosition := FilePos(CurrentPlyLabFile);
                        { Jetzt ist gespult. Die Datenblcke neu einlesen lassen. }
                        For Lauf2 := 1 to 4 do UsedBlock[Lauf2] := FALSE;
                        GotoXY(XPosition_CurrentPos,YPosition_CurrentPos);
                        Write(CurrentFilePosition:10);
                        CurrentWindDelay := WIND_DELAY;
{                        Snd_currentJob := Lauf1; }
                       End;
                     End;
          Men_PLay : StartPlay;                  { *** Menposition "Abspielen" angewhlt }
           Men_FWD : Begin                       { *** Menposition "Schneller Vorlauf" angewhlt }
                      CurrentFilePosition := FilePos(CurrentPlyLabFile);
                      If (CurrentFilePosition + WIND_GRANULARITY * DataBlockSize) <= MaximalFilePOsition then
                       Begin
                        If CurrentWindDelay = 0 then
                         Begin
                          SaveJob := SND_CurrentJob;
                          Snd_CurrentJob := Snd_None;
                         End;
                        CurrentWIND := Wind_Forward;
                        Seek(CurrentPLyLabFile,CurrentFilePosition + WIND_GRANULARITY * DataBlockSize );
                        CurrentFilePosition := FilePos(CurrentPlyLabFile);
                        { Jetzt ist gespult. Die Datenblcke neu einlesen lassen. }
                        For Lauf2 := 1 to 4 do UsedBlock[Lauf2] := FALSE;
                        GotoXY(XPosition_CurrentPos,YPosition_CurrentPos);
                        Write(CurrentFilePosition:10);
                        CurrentWindDelay := WIND_DELAY;
                       End;
                     End;
           Men_Rec : StartRecord;                { *** Menposition "Aufnahme" angewhlt }
            End;
           End;
     #27 : Begin                                 { RAUS HIER ! }
           End;
        End;
       End;
     Until Eingabe = #27;

     StopLabData;
{    Close(CurrentRecLabFile); }

     Close(CurrentPlyLabFile); {}
     Close(ScriptFile);         {}
    End;

   RestoreScreen;
   Sptr := OldSptr;
   ClearKBDBuffer;
  End
 Else
  Begin
   MessageBox(10,3,60,3,'Das Sound-System ist bereits aktiv !');
   Readkey;
  End;
End;




{$I SR_RECOR}


End.