


#include <stdio.h>
#include <maestro.h>

extern	   char nbuf[]; 	/* Buffer in which the file will be manipulated
				 * before storing in on disk.		     */
extern	   int nlen;
extern	   char name_buf[];	/* Directory of file name buffer.
				 * (Things like *flist and *instname point
				 * to the elements of name_buf.)	     */
extern	   char dump;		/* Flag for dump option.		     */

/*************************************************************************
 * POKER provides for the altering of an instrument file.
 * The user selects a file from the sound library (.SND files on the
 * default disk).  That file is read into NBUF[5...].  The user can
 * view and alter the contents of the file (in PC RAM), byte by byte.
 * The altered file may be stored on disk, but it will over-write
 * the original file.
 *************************************************************************/

poker()
{
	long gethex();		/* Subprogram to get console input in hex   */
	char *flist[MAXENT];	/* flist is an array of pointers into an
				 * array of file names (name_buf).   gfname
				 * will return flist arranged so that the
				 * file names can be accessed alphabetically.*/
	char file[14];		/* File selected + .SND 		     */
	char *p;
	static char ext[] = ".SND";
	static char bin_hedr[] = {0xFF,0xFF,'B','I','N','A','R','Y','\0'};
	int fd; 		/* File descriptor used for writing new file.*/
	int f_end;		/* Number of instrument tables	on disk.
				 * i.e. Length of flist.		     */
	int inst;		/* Instrument number.			     */
	int index = 0;		/* Index into NBUF.			     */
	int page = 1;		/* Page of list to be displayed.	     */
	long i;
	int j;
	int c;			/* Input				     */
	char selcting = 1;	/* Just a flag. 			     */

/*	Display sound library.	*/

	while((f_end=gfname("????????SND",flist,MAXENT,name_buf,MAXNBUF))==0) {
		CLEAR;
		cursor(20,1);
		printf("\n There are no instrument files in your ");
		printf("default directory.\n");
		printf(" Insert a new disk and type any character ");
		printf("to try again.  (ESC to return.)\n");
		if (getch() == ESC) return(0);
	}
	putbar(TOP);		/* Clears screen.			     */
	printf("\t\t     Sound Library in Current Directory ");
	putright();
	putbar(MID);
	prntlist(flist, f_end, page);
	putbar(MID);
	printf("  Specify the instrument number ( 1 - %3d)       ",f_end);
	putright();
	printf("  for that instrument which you wish to alter. ");
	putright();
	printf("                        (Type ESC to return.)");
	putright();
	printf("                        (Type '*' to toggle dump option.)");
	putright();
	putbar(BOT);

/*	User selects a file.	*/

	printf("     Instrument: ");
	fflush(stdout);
	SAV_CURS;
	while (selcting) {
		if ((inst = getnum()) == 0-ESC) return(0);
		else if (inst == 0-'*') {
			if (dump) printf("\n\t\t\t (Dump option on.) ");
			else	printf("\n\t\t\t (Dump option off.)");
		}
		else if (inst <= 0 || inst > f_end) {
			RTN_CURS;
			printf("      No good. Try again.   ");
		}
		else selcting = 0;
		fflush(stdout);
		RTN_CURS;
	}

/*	Read file into NBUF[5 . . . ].	*/

	printf("\n");
	p = flist[inst-1];
	for (i=0; (file[i] = *p++) != '\0'; i++);
	for (j=0; j < 5; file[i+j] = ext[j++]); /* Append extenstion.	     */

	if (read_bin(file) == ERR) {
		printf("I couldn't read the file, %s.\n",flist[inst-1]);
		printf("Type any character to return. \n");
		getch();
		return(0);
	}

	putbar(TOP);	/* Clears screen.			*/
	printf(" File to be altered:     %s",flist[inst-1]);
	putright();
	putbar(MID);
	printf(" REMEMBER THE FOLLOWING KEY COMMANDS:");
	putright();
	putbar(MID);
	putright();
	printf(" Type:   ");
	putright();
	printf("           'a'  to alter a particular byte,      ");
	putright();
	putright();
	printf("           'd'  to display a particular byte,    ");
	putright();
	putright();
	printf("      <return>  to display the next byte,             ");
	putright();
	putright();
	printf("           's'  to store the file,                        ");
	putright();
	printf("                (Note: old file will be replaced on disk),");
	putright();
	putright();
	printf("           ESC  to quit.  (Altered file will not be stored.)");
	putright();
	putright();
	putbar(BOT);
	printf("\nThe file is %x (hex) bytes long.  (0...%x)\n",nlen-5,nlen-6);
	for (;;) {
		c = getch();
		if (c == 'a' || c == 'A') {
			printf("Alter which byte?  (specify in hex): ");
			SAV_CURS;
			while ((i = gethex()) == ERR) {
				RTN_CURS;
				printf("      No good.  Try again.       ");
				fflush(stdout);
				RTN_CURS;
			}
			printf("\n");
			if (i == 0-ESC) {
				printf("\nAre you sure? ");
				printf(" Altered file won`t be stored. ");
				printf(" ( 'y' / anything ): ");
				fflush(stdout);
				if ((j = getch()) == 'y' || j == 'Y')
					return(0);
				printf("\n");
			}
			else if (i == -13);/* <CR> typed. Don't alter index. */

			else if (i > nlen-6) {
			       printf("\nFile is only %x (hex) bytes ",nlen-5);
			       printf("long.  (0...%x)\n",nlen-6);
			}
			else index = i;

		      if (i <= nlen-6 && i != 0-ESC) {

			printf("Current value of byte %2x is %2x.\n",
				index,nbuf[index+5]);
			printf("New value (specify in hex): ");
			SAV_CURS;
			while ((i = gethex()) == ERR || i > 0xFF) {
				RTN_CURS;
				if (i > 0xFF) {
				   printf("      That's more than a byte.  ");
				   printf("Try again.       ");
				}
				else {
				   printf("      No good.  ");
				   printf("Try again.                ");
				}
				fflush(stdout);
				RTN_CURS;
			}
			printf("\n");
			if (i == 0-ESC) {
				printf("\nAre you sure? ");
				printf(" Altered file won`t be stored. ");
				printf(" ( 'y' / anything ): ");
				fflush(stdout);
				if (((j = getch()) == 'y') || (j == 'Y'))
					return(0);
				printf("\n");
			}
			else if (i == -13); /* <CR> typed. Don't alter byte. */

			else nbuf[index+5] = i;

			printf("byte %2x = %2x\n",index,nbuf[index+5]);
			if (index < nlen-6) index += 1;
			else printf("(End of file.)\n");
		      }
		}

		if (c == 'd' || c == 'D') {
			printf("Display which byte?  (specify in hex): ");
			SAV_CURS;
			while ((i = gethex()) == ERR) {
				RTN_CURS;
				printf("      No good.  Try again.       ");
				fflush(stdout);
				RTN_CURS;
			}
			printf("\n");
			if (i == 0-ESC) {
				printf("\nAre you sure? ");
				printf(" Altered file won`t be stored. ");
				printf(" ( 'y' / anything ): ");
				fflush(stdout);
				if (((j = getch()) == 'y') || (j == 'Y'))
					return(0);
				printf("\n");
			}
			else if (i == -13);/* <CR> typed. Don't alter index. */

			else if (i > nlen-6) {
				printf("File length exceeded.  \n");
				index = nlen-6;
			}
			else index = i;

			printf("byte %2x = %2x\n",index,nbuf[index+5]);
			if (index < nlen-6) index += 1;
			else printf("(End of file.)\n");
		}

		if (c == 13) {
			printf("byte %2x = %2x\n",index,nbuf[index+5]);
			if (index < nlen-6) index += 1;
			else printf("(End of file.)\n");
		}

		if (c == 's' || c == 'S') { /* Write new file over old! */
			printf("Storing altered file . . . \n");

		       /* Note: Must open file to write in UNTRANSLATED mode.
			* (In translated mode, the default, for each
			* LF character a CR character is inserted!)	   */

			if ((fd = open(file, 0x8001)) == ERR) {
				printf("poker: can't open %s ", file);
				printf("for writing.  Sorry.");
				printf("\nPress any key to return.\n");
				getch();
				return(ERR);
			}
			i = write(fd,bin_hedr,9);
			if ((write(fd, &nbuf[5],nlen-5) != nlen-5) || (i!=9)) {
				close(fd);
				printf("Error encountered on writing file.\n");
				printf("File contents may have been lost.\n");
				printf("Press any key to return.\n");
				getch();
				return(ERR);
			}
			close(fd);
			printf("The altered file has been ");
			printf("stored (over the old file).\n");
			printf("Press any key to return.\n");
			getch();
			return(0);
		}

		if (c == ESC) {
			printf("\nAre you sure? ");
			printf(" Altered file won`t be stored. ");
			printf(" ( 'y' / anything ): ");
			fflush(stdout);
			if (((j = getch()) == 'y') || (j == 'Y')) return(0);
			printf("\nbyte %2x = %2x\n",index,nbuf[index+5]);
			if (index < nlen-6) index += 1;
			else printf("(End of file.)\n");
		}
	}
}

/*************************************************************************
 *   'keyboard' invokes Gary's Chroma keyboard interface.
 *************************************************************************/

extern	chroma();

keyboard()
{
	int numvoice;

	CLEAR;
	printf("\nHow many voices? (1-8): ");
	fflush(stdout);
	SAV_CURS;
	while ((numvoice = getnum()) <= 0 || numvoice > 8) {
		RTN_CURS;
		if (numvoice == 0-'*') {          /* dump has been toggled.      */
			if (dump) printf("\n\t\t\t (Dump option on.) ");
			else	printf("\n\t\t\t (Dump option off.)");
		}
		else if (numvoice == 0-ESC) return(0);
		else	printf("      No good. Try again.   ");
		fflush(stdout);
		RTN_CURS;
	}
	CLEAR;
	cursor(10,30);
	printf("Take it away!");
	cursor(24,1);
	printf("(Depress Chroma pedal to return.)\n");
	chroma(numvoice);
	return(0);
}

/*************************************************************************
 * Get a positive 4-digit hexidecimal number from console.
 * Special responses to the following inputs:
 *		      <CR> --> terminate number with less than 2 digits.
 *		       ESC --> - ESC is returned.
 * empty value (only <CR>) --> - 13 is returned.
 *	 invalid character --> ERR is returned.
 *************************************************************************/
long gethex()
{
	unsigned value = 0;  /* 	 value of input.		 */
	int digit;
	char c[5];
	int i,j;

	for (i = 0; ((c[i] = getch()) != 13) && (i < 5); ++i) {
		if (c[i] == ESC) return(0 - ESC);
		else if (c[i] == '\b') {
			if (i == 0) {
				--i;
			}
			else {
			/*	printf("\b \b"); <--Doesn't work! (Why not?)  */
				putch('\b');
				putch(' ');
				putch('\b');
				i -= 2;
			}
		}
		else putch(c[i]);
	}
	if (i == 5) return(ERR);
	if (i == 0) return(-13);

	for (j = 0; j < i; ++j) {
		if (c[j] >= '0' && c[j] <= '9') digit = c[j] - '0';
		else if (c[j] >= 'a' && c[j] <= 'f') digit = c[j] - 'a' + 10;
		else if (c[j] >= 'A' && c[j] <= 'F') digit = c[j] - 'a' + 10;
		else return(ERR);
		value = value * 16 + digit;
	}
	return(value);
}
