      name    icode
;
; jcode.asm -- "improved" amy interrupt driver
; -- now has more complicated note data structure
;
	title	72 hz Interrupt Routine for Amy Driving v2.0
	subttl	16 Sept 83 (IBM PC)

dgroup	group	buffer
;------------------------------------------------------------------------------
buffer	segment word public 'data'
	assume	ds:dgroup
	public	nbuf,NBUFSIZ

;variables imported/exported from/to the C environment

SIZ	equ	64768		; 63.25K is the amount of RAM available for
				; instrument tables.
nbuf	db	(SIZ + 5) dup(?); Buffer of bytes to be sent to 8051.
				; (5 more bytes added for 5-byte LRAM
				; driver command which must proceed
				; data to be loaded.)
NBUFSIZ dd	SIZ + 5 	; Size of nbuf.

buffer	ends
;------------------------------------------------------------------------------

pgroup	group	prog
prog	segment byte public 'prog'
	public	put_nbuf,get_nbuf
	assume	cs:pgroup, ss:dgroup, ds:dgroup, es:nothing


;put a byte into nbuf (return 0 if okay, return -1 if error)

put_nbuf  proc near

;	assume	es:buffer
;	push	bp
;	push	es
;	mov	bp, sp
;	mov	ax,seg nbuf
;	mov	es,ax
;	mov	si,[bp+4]	;get first arguement  (Index into nbuf)
;	cmp	si,es:NBUFSIZ
;	jg	ovf

;	mov	al,[bp+6]	;get second arguement (Byte to put into nbuf)
;	mov	es:nbuf[si],al	   ;put byte into nbuf.
;	mov	ax,0		;return 0 (all-akay).
;	jmp	ok
;
;ovf:	 mov	 ax,-1		 ;return -1 (error).

;ok:	 pop	 es
;	pop	bp
	ret

put_nbuf  endp

;get a byte from nbuf

get_nbuf  proc near

;	assume	es:buffer
;	assume	es:nothing
;	assume	ds:dgroup
	push	bp
;	push	es
	mov	bp, sp
;	mov	ax,seg nbuf
;	mov	es,ax
	mov	si,[bp+4]	;get first arguement  (Index into nbuf)
	mov	ah,0
;	mov	al,es:nbuf[si]	;return byte from nbuf.
	mov	al,nbuf[si]  ;return byte from nbuf.
;	pop	es
	pop	bp
	ret

get_nbuf  endp

prog	ends
	end
