      name    icode
;
; jcode.asm -- "improved" amy interrupt driver
; -- now has more complicated note data structure
;
	title	72 hz Interrupt Routine for Amy Driving v2.0
	subttl	16 Sept 83 (IBM PC)

dgroup	group	data
data	segment word public 'data'
	assume	ds:dgroup

	public	nbuf,NBUFSIZ

;SIZ =	 K didn't work.  MAESTRO linked with no errors, but then upon
;execution, MAESTRO did nothing, simply returning to DOS.

;SIZ =	 K worked for running maestro, except that massage couldn't open
;*.TAB files for pre-processing.  (i.e. Nothing could be pro-processed.)
;When changed to SIZ =		  , massage could open and therefore
;pre-process GRRHODES.TAB.  So, we'll leave it at that and see if things work.

SIZ	equ	18*1024 	; This restriction on the amount of data
				; to ship to the 8051 is a temporary response
				; to the Lattice linker's problems with
				; "large" arrays.  After much effort to allow
				; for a 64K buffer (nbuf) with only crazy
				; results, i'm hoping that by keeping the
				; whole data segment below 32K we'll win
				; more space than the 12K version of MAESTRO
				; which is restricted by declaring nbuf in
				; the C code.
nbuf	db	(SIZ + 5) dup(?); Buffer of bytes to be sent to 8051.
				; (5 more bytes added for 5-byte LRAM
				; driver command which must proceed
				; data to be loaded.)
NBUFSIZ dw	SIZ + 5 	; Size of nbuf.

old_o	dw	?;		old offset  (of interrupt routine)
old_s	dw	?;		old segment

divby4	db	0;	0..3

treg	db	0;	0..tempo

voice	dw	?;voice counter
state	db	4 dup(?)	;state of note-playing fsa -- 0..3

dataport	dw	?;equ	  3bch
ackport 	dw	?;equ	  3bdh
irqport 	dw	?;equ	  3beh

ackmask 	equ	40h
irqmask 	equ	1


;dispatch table

state_table   dw      is0, is1, is2, is3

;variables imported/exported from/to the C environment

	extrn	music_p:word, music_s:byte, score:byte, tempo: byte
	extrn	herror:byte, nlen:word

;end of variables i/e f/t the C environment

pic0		equ	20h
pic1		equ	21h
porta		equ	71ch
portb		equ	71dh
portc		equ	71eh
pcmd		equ	71fh
gdataport	equ	3bch
statport	equ	3bdh
cntlport	equ	3beh
inbufsiz	equ	256

age_table	db	8 dup (?)
pn_table	db	8 dup (?)
pv_table	db	8 dup (?)
pg_table	db	8 dup (?)
tailptr 	dw	?
index		dw	?
first_flag	db	?
data_byte	db	?
gstate		db	?
end_flag	db	?
note		db	?
player		db	?
numvoice	db	?
front		dw	?
back		dw	?
inbuff		db	inbufsiz dup (?)

data	ends


abs0	segment at 0

	org	08h*4
timer_int label   dword;	   offset here, then a segment

	org	34h

irq5	dw	?
irq52	dw	?

abs0	ends

rom_data segment at 40h

	org	8
printer_base label dword

rom_data ends

pgroup	group	prog
prog	segment byte public 'prog'
	public	init_clo,quit_clo, send_amy, initport, send_byt, chroma
	assume	cs:pgroup, ds:dgroup, ss:dgroup, es: abs0

;send a byte to amy

send_amy  proc near

	push	bp
	mov	bp, sp
	mov	al,[bp+4] ;get arguement
	mov	nlen,1
	mov	nbuf,al
	call	send_byt
	pop	bp
	ret

send_amy endp

init_clo  proc near

;initialize the clock interrupt to 72hz and our own routine

	cli;interrupts off

	mov	music_s,0ffffh	;don't play music now
	mov	divby4,0	;initialize counter
	mov	treg,1		;initialize tempo register

	push	es;	set es to point to the interrupt vector

	mov	ax,abs0
	mov	es,ax

	mov	ax,es:timer_int;    save the old interrupt vector
	mov	old_o,ax

	mov	ax,es:timer_int+2
	mov	old_s,ax


	mov	ax,offset tick_clock; set up the new interrupt vector
	mov	es:timer_int,ax

	mov	ax,prog
	mov	es:timer_int+2,ax

;So, let's change the interrupt rate to 72.8hz (which is 4 times the traditional
;18.2hz time of day interrupt)
; By the way, the clock is 1.19318 Mhz
; so 60hz needs 19886.3333 (riiiiiight)

timer	equ	40h;	like code on page A-11

	mov	al,36h; sel timer 0, lsb, msb, mode 3
	out	timer+3,al

	mov	ax,4000h
	out	timer,al
	mov	al,ah
	out	timer,al

;set up i/o port locations of printer

	assume	es: rom_data

	mov	ax, rom_data
	mov	es, ax
	mov	ax, es:printer_base
	mov	dataport, ax
	inc	ax
	mov	ackport, ax
	inc	ax
	mov	irqport, ax

;zero the state variable

	mov	si, 3
zst:	mov	state[si],0
	dec	si
	jge	zst

	mov	ax, dataport	;return printer base

	pop	es;	restore es, enable interrupts, and return
	sti
	ret

init_clo  endp

	assume	es: abs0
tick_clock proc far

;handle an interrupt

	sti

	push	ds;	set ds to the C data area
	push	si
	push	ax
	mov	ax,data
	mov	ds,ax

;---- Start of the actual useful code, for which all the rest of this file is
;     merely window dressing, support functions, and so forth ----

;interpretation loop

	cmp	music_s,0	;should we be playing?
	je	check
	jmp	iloopx	;nope!

check:	dec	treg		;decrement tempo count
	je	check0
	jmp	iloopx

check0: mov	al, tempo     ;set up loop again
	mov	treg, al

	mov	si,0

checkl: cmp	state[si],3	;dead voice state
	jne	checkx
	inc	si
	cmp	si,3
	jle	checkl

;all dead -- end of music
	mov	music_s,0ffffh
	jmp	iloopx

checkx:

;for each voice: (0..3)

	mov	voice, 0

iloop:	mov	si, voice	;dispatch on state of this voice
	mov	al, state[si]
	mov	ah,0
	cmp	al,3
	jle	iloop1
	mov	al,3	;limit 0..3
iloop1: shl	ax,1
	mov	si,ax
	mov	ax,state_table[si]
	mov	si,voice
	jmp	ax

;state is zero, so attack note and set state to one

is0:	shl	si,1
	mov	ax,music_p[si]	;counter for this voice
	mov	si,ax
	cmp	score[si][1],255   ;end of piece? (if volume == 255)
	jne	i1

;end of piece

	mov	si, voice
	mov	state[si],3	;end of this voice (state 3)
	shl	si,1
	mov	music_p[si],0ffffh
	jmp	iloopq

i1:	cmp	score[si],128	;rest?
	je	i2		;if so, don't attack it.

;attack a note

	mov	ax, 0d0h	;base for a note depression
	add	ax, voice
	mov	nbuf, al

	mov	al,score[si]	;note
	mov	nbuf+1,al

	mov	al, score[si][1]	;volume
	mov	nbuf+2,al

	mov	nbuf+3,0	;preasure

	mov	nlen,4
	call	send_byt

i2:	mov	si,voice	;state := 1
	mov	state[si],1
	jmp	is1		;and fall thru to state 1

;state is 1 (counting down while playing something)

is1:	shl	si,1
	mov	ax,music_p[si]
	mov	si,ax
	dec	score[si][2]	;decrement count
	jne	iloopq

;we've counted down to zero, so release note and go to state 2

	cmp	score[si],128	;rest?
	je	i3		;if so, don't release it.

;release a note

	mov	ax, 0d8h	;base for a note depression
	add	ax, voice
	mov	nbuf, al

	mov	al,score[si]	;note
	mov	nbuf+1,al

	mov	al, score[si][1]	;volume
	mov	nbuf+2,al

	mov	nlen,3
	call	send_byt

i3:

	mov	al,score[si][3] ;inter-record gap
	cmp	al,0
	jne	i4	;not a tied note. . . .

;a tied note, so report it as an error (we shouldn't see it here!)
	mov	herror,3
;	mov	si,voice	;bump music pointer
;	shl	si,1
;	add	music_p[si],4
;
;	mov	si,voice
;	jmp	is0		;and handle as if state zero
;

i4:
	mov	si,voice
	mov	state[si],2
	jmp	iloopq

;state 2

is2:	shl	si,1
	mov	ax,music_p[si]
	mov	si,ax
	dec	score[si][3]	;decrement inter-note-gap
	jne	iloopq

;have reached end of inter-note-gap

	mov	si,voice	;back to state 0
	mov	state[si],0

	shl	si,1		;and bump music pointer
	add	music_p[si],4
	jmp	iloopq

;state 3 -- don't do anything

is3:

;loop 'till voice == 4

iloopq: inc	voice
	cmp	voice,4
	jge	iloopx
	jmp	iloop

iloopx:

;and that's the ball game

;---- End of the actual useful code, for which all the rest of this file is
;     merely window dressing, support functions, and so forth ----

	inc	divby4
	cmp	divby4,4
	jne	my_tick

	mov	al,0
	mov	divby4,al

	push	es

	cli
	mov	ax,abs0
	mov	es,ax
	mov	ax,old_o
	mov	es:timer_int,ax
	mov	ax,old_s
	mov	es:timer_int+2,ax
	sti

	int	8;	      do the "real" 18hz interrupt

	cli
	mov	ax,offset tick_clock
	mov	es:timer_int,ax
	mov	ax,prog
	mov	es:timer_int+2,ax
	sti

	pop	es

	jmp	end_tick

my_tick:
	mov	al,20h; 	EOI to 8259 ala A-78
	out	020h,al

end_tick:
	pop	ax;		restore ds and return
	pop	si
	pop	ds
	iret



tick_clock endp

;normalize note by copying bit 6 into bit 7

norm_note	proc	near
	and	al,07fh
	cmp	al,040h
	jl	nnq
	or	al,080h
nnq:	ret
norm_note	endp

; send a string of bytes to AMY via lpt1:
;

send_byt    proc near
	push	si
	push	dx
	push	bx
	push	ax
	cli
	mov	si,0
	cmp	dataport,0	;check if any printer
	je	saq		;if none, punt

sl:
;wait for ack to be high

	mov	bx,1000;	timeout counter
	mov	dx,ackport

w1:	dec	bx
	jne	w12
	mov	herror,1
	jmp	saq;		timed out

w12:	in	al,dx
	and	al,ackmask
	je	w1

;ack is high
	mov	dx,dataport
	mov	al,nbuf[si];this is the byte to send
	out	dx,al

	mov	al,irqmask
	mov	dx,irqport
	out	dx,al

	mov	bx,1000;	timeout counter
	mov	dx,ackport

w2:	dec	bx
	jne	w21
	mov	al,0;	timed out
	mov	dx,irqport
	out	dx,al
	mov	herror,2
	jmp	saq

w21:	in	al,dx
	and	al,ackmask
	jne	w2

;ack went low
	mov	al,0
	mov	dx,irqport
	out	dx,al

s2:	inc	si
	cmp	si,nlen
	jne	sl

saq:	sti
	pop	ax
	pop	bx
	pop	dx
	pop	si
	ret
send_byt   endp

quit_clo  proc near

;restore the clock interrupt to 18.2hz and the default routine


	cli;interrupts off

	push	es;	set es to point to the interrupt vector

	mov	ax,abs0
	mov	es,ax

	mov	ax,old_o;    restore the old interrupt vector
	mov	es:timer_int,ax

	mov	ax,old_s
	mov	es:timer_int+2,ax

	pop	es;	restore es, enable interrupts, and return

	mov	al,36h; sel timer 0, lsb, msb, mode 3
	out	timer+3,al
	mov	ax,0
	out	timer,al
	mov	al,ah
	out	timer,al

	sti
	mov	ax,old_s
	ret

quit_clo  endp

;-----------------------------------------------------------------------------
; Added for Claudia's stuff.  (This is also part of init_clo, above.)

initport  proc near

;set up i/o port locations of printer

	assume	es: rom_data

	push	es

	mov	ax, rom_data
	mov	es, ax
	mov	ax, es:printer_base
	mov	dataport, ax
	inc	ax
	mov	ackport, ax
	inc	ax
	mov	irqport, ax

	mov	ax, dataport	;return printer base

	pop	es;	restore es, enable interrupts, and return
	ret

initport  endp

;-----------------------------------------------------------------------------
;  Gary's chroma handler.

	assume	cs:pgroup, ds:dgroup, es:abs0

chroma	proc	near

; Get arguement from stack:
	push	bp
	mov	bp,sp
	mov	al,[bp+4]
	mov	numvoice,al
	pop	bp

	push	ax
	push	bx
	push	cx
	push	dx
	push	ds
	push	es

	mov	ax, dgroup		; set up ds
	mov	ds, ax
	mov	ax, abs0		; set up es
	mov	es, ax
	mov	ax, offset cntl_int	; set up interrupt vector
	mov	es:irq5, ax
	mov	ax, pgroup
	mov	es:irq5+2, ax
	mov	tailptr, offset age_table

	mov	bx, 0
gi1:	mov	age_table[bx], 0ffh
	inc	bx
	cmp	bx, 8
	jne	gi1

	mov	bx, 0
gi2:	mov	pn_table[bx], 0ffh
	inc	bx
	cmp	bx, 8
	jne	gi2

	mov	bx, 0
gi3:	mov	pv_table[bx], 0ffh
	inc	bx
	cmp	bx, 8
	jne	gi3

	mov	bx, 0
gi4:	mov	pg_table[bx], 0
	inc	bx
	cmp	bx, 8
	jne	gi4

	mov	first_flag, 0
	mov	end_flag, 0
	mov	gstate, 0
	mov	index, 0

	mov	front, offset inbuff
	mov	back, offset inbuff

	mov	bx, 0
gi5:	mov	inbuff[bx], 0ffh
	inc	bx
	cmp	bx, inbufsiz
	jne	gi5

	in	al, pic1
	and	al, 0dfh		; unmask 5
	or	al, 1			; mask 0
	out	pic1, al

	mov	dx, pcmd		; set up cntl port
	mov	al, 099h
	out	dx, al
	mov	dx, portb
	mov	al, 0feh		; toggle ack/
	out	dx, al
	in	al, dx
	mov	al, 0ffh
	out	dx, al
	mov	al, 0ffh		; set ack/
	out	dx, al

	mov	dx, cntlport		; set stb/
	mov	al, 0
	out	dx, al
	sti				; enable interrupts

loop:
	mov	al, end_flag
	cmp	al, 0
	je	loop1

	in	al, pic1
	or	al, 20h 		; mask 5
	and	al, 0feh		; unmask 0
	out	pic1, al
	mov	al, end_flag

	jmp	endloop

loop1:	cmp	index, 0		; any dat in buffer?
	je	loop

	cmp	index, inbufsiz
	jne	loop15
	mov	end_flag, 2
	jmp	end_int

loop15: mov	bx, back		; get next data byte
	mov	al, [bx]
	inc	back
	cmp	back, offset inbuff+inbufsiz
	jne	loop2
	mov	back, offset inbuff

loop2:	dec	index

	cmp	gstate, 0		; state 0 ?
	jne	chks1
chkatk: cmp	al, 0d0h		; attack command?
	jne	chkrel
	mov	gstate, 1
	mov	first_flag, 1
	jmp	end_int
chkrel: cmp	al, 0d8h		; release command?
	jne	chkoth
	mov	gstate, 4
	jmp	end_int
chkoth: cmp	first_flag, 0
	je	loop
	mov	end_flag, 1		; program exit
	jmp	end_int

chks1:	cmp	gstate, 1		; state 1?
	jne	chks2
	mov	note, al		; save note value
alloc:	call	find_player		; is note in pn_table?
	cmp	al, 0ffh		; al = p or ff if not in table
	jne	assign
	call	find_avail		; any players available?
	cmp	al, 0ffh		; al = p or ff if none avialable
	jne	assign
	mov	al, age_table		; use oldest player
	call	rem_table		; remove that player fm age_table
assign: mov	player, al		; save assigned player number
	mov	bx, tailptr
	mov	[bx], al		; add player to end of table
	inc	tailptr
	mov	bx, 0
	mov	bl, al			; set up index
	mov	al, note		; retreive note value
	mov	pn_table[bx], al	; save note value
	mov	pg_table[bx], 1 	; set gate
	mov	gstate, 2
	jmp	end_int

chks2:	cmp	gstate, 2		; state 2?
	jne	chks3
	mov	bx, 0
	mov	bl, player		; set up index
	mov	pv_table[bx], al	; save velocity value
	mov	gstate, 3
	jmp	end_int

chks3:	cmp	gstate, 3		 ; state 3?
	jne	chks4
	mov	bx,0
	mov	bl, player		; set up index
	mov	al, player		; set up chroma command byte
	add	al, 0d0h
	call	out_byte		; send it to driver
	mov	al, pn_table[bx]	; get note value
	call	out_byte
	mov	ax, 0
	mov	al, pv_table[bx]	; get velocity value
	shl	ax, 1			; x 8
	shl	ax, 1
	shl	ax, 1
	cmp	ax, 255
	jle	itsok
	mov	ax, 255
itsok:	call	out_byte
	mov	al, 0			; dummy
	call	out_byte
	mov	gstate, 0
	jmp	end_int

chks4:	cmp	gstate, 4		; state 4?
	jne	s6
	call	find_player		; find player associated
	cmp	al, 0ffh		; al = p or ff if not found
	je	s5			; player allready reassigned
	mov	bx, 0
	mov	bl, al
	mov	pg_table[bx], 0 	; clear gate
	call	rem_table		; remove player from age_table
	add	al, 0d8h
	call	out_byte
	mov	al, pn_table[bx]
	call	out_byte
	mov	al, 0
	call	out_byte
s5:	mov	gstate, 5
	jmp	end_int

s6:	mov	gstate, 0		 ; state 5?
end_int:jmp	loop

endloop:
	pop	es
	pop	ds
	pop	dx
	pop	cx
	pop	bx
	pop	ax

	ret

chroma	endp


cntl_int    proc    far

	cli
	push	ax
	push	bx
	push	dx
	mov	dx, porta		; get control byte
	in	al, dx

	mov	bx, front
	mov	[bx], al
	inc	front
	cmp	front, offset inbuff+inbufsiz
	jne	c1
	mov	front, offset inbuff
c1:	inc	index

	mov	dx, portb
	mov	al, 0feh		; toggle ack/
	out	dx, al
	in	al, dx
	mov	al, 0ffh
	out	dx, al
	mov	al, 20h
	out	pic0, al
	pop	dx
	pop	bx
	pop	ax
	iret

cntl_int    endp

out_byte    proc    near

	cli
	push	ax
	push	cx
	push	dx
	mov	data_byte, al

	mov	cx, 1000
	mov	dx, statport		; wait for ack/ to be hi
l1:	dec	cx
	jz	l4			; timed out - bye
	in	al, dx			; chk ack/
	and	al, 40h 		; ack/ = bit 6
	jz	l1			; wait

	mov	dx, gdataport		; put byte at output port
	mov	al, data_byte
	out	dx, al

	mov	dx, cntlport		; set stb/ = 0
	mov	al, 1
	out	dx, al

	mov	cx, 1000
	mov	dx, statport		; wait for ack/ to be lo
l2:	dec	cx
	jz	l3
	in	al, dx			; chk ack/
	and	al, 40h
	jnz	l2			; wait
	jmp	l5

l3:	mov	end_flag, 4
l5:	mov	dx, cntlport		; set stb/ = 1
	mov	al, 0
	out	dx, al
	jmp	end_byte

l4:	mov	end_flag, 3

end_byte:
	pop	dx
	pop	cx
	pop	ax
	sti
	ret

out_byte    endp

rem_table   proc    near

	push	ax
	push	bx
	mov	bx, offset age_table - 1	; find player #
r1:	inc	bx
	cmp	al, [bx]
	jne	r1

r2:	inc	bx
	cmp	bx, tailptr			; done?
	je	r3
	mov	al, [bx]
	dec	bx
	mov	[bx], al
	inc	bx
	jmp	r2

r3:	dec	tailptr
	pop	bx
	pop	ax
	ret

rem_table   endp

find_player proc    near

	push	bx
	mov	bx, 0

fp1:	cmp	al, pn_table[bx]
	je	fp2
	inc	bx
	cmp	bl, numvoice
	jne	fp1
	mov	bx, 0ffh

fp2:	mov	al, bl
	pop	bx
	ret

find_player endp

find_avail  proc    near

	push	bx
	mov	bx, 0

fa1:	cmp	pg_table[bx], 0
	je	fa2
	inc	bx
	cmp	bl, numvoice
	jne	fa1
	mov	bx, 0ffh

fa2:	mov	al, bl
	pop	bx
	ret

find_avail  endp

prog	ends
	end
