	name	icode
;
	title	72 hz Interrupt Routine for Amy Driving
	subttl	28 Jul 83 (IBM PC)

dgroup	group	data
data	segment word public 'data'
	assume	ds:dgroup

old_o	dw	?;		old offset  (of interrupt routine)
old_s	dw	?;		old segment

divby4	db	0;	0..3

dataport	equ	3bch
ackport 	equ	3bdh
irqport 	equ	3beh

ackmask 	equ	40h
irqmask 	equ	1


nlen	dw	?;	# of bytes to send to 8051. . . .
nbuf	db	10 dup(?);	buffer for note bytes

;variables imported/exported from/to the C environment

	extrn	music_p:word,note:byte,score:byte,herror:byte

;end of variables i/e f/t the C environment

data	ends

abs0	segment at 0

	org	08h*4
timer_int label   dword;	   offset here, then a segment

abs0	ends

pgroup	group	prog
prog	segment byte public 'prog'
	public	init_clo,quit_clo
	assume	cs:pgroup, ds:dgroup, ss:dgroup, es: abs0

init_clo  proc near

;initialize the clock interrupt to 72hz and our own routine

	cli;interrupts off

	mov	ax,0
	mov	divby4,al	;initialize counter

	push	es;	set es to point to the interrupt vector

	mov	ax,abs0
	mov	es,ax

	mov	ax,es:timer_int;    save the old interrupt vector
	mov	old_o,ax

	mov	ax,es:timer_int+2
	mov	old_s,ax


	mov	ax,offset tick_clock; set up the new interrupt vector
	mov	es:timer_int,ax

	mov	ax,prog
	mov	es:timer_int+2,ax

;So, let's change the interrupt rate to 72.8hz (which is 4 times the traditional
;18.2hz time of day interrupt)
; By the way, the clock is 1.19318 Mhz
; so 60hz needs 19886.3333 (riiiiiight)

timer	equ	40h;	like code on page A-11

	mov	al,36h; sel timer 0, lsb, msb, mode 3
	out	timer+3,al

	mov	ax,4000h
	out	timer,al
	mov	al,ah
	out	timer,al

	pop	es;	restore es, enable interrupts, and return

	sti
	mov	ax,old_o
	ret

init_clo  endp

tick_clock proc far

;handle an interrupt

	sti

	push	ds;	set ds to the C data area
	push	si
	push	ax
	mov	ax,data
	mov	ds,ax

;---- Start of the actual useful code, for which all the rest of this file is
;     merely window dressing, support functions, and so forth ----

	cmp	music_p,0ffffh
	je	tick_e

;interpretation loop

iloop:
	mov	si,music_p
	cmp	score[si],255
	jne	i1

;have reached end of music

	mov	ax,0ffffh
	mov	music_p,ax
	jmp	tick_e

;have not reached end of music, is the waiting over?

i1:	cmp	score[si],0
	je	i2

;have not reached end of delay, so dec & loop

	dec	score[si]
	jmp	tick_e

;the waiting is over, send the note

i2:	add	music_p,2
	inc	si
	mov	al,score[si]
	mov	note,al

;if bit 7 set, this is a note release

	or	al,al
	jns	i3

;bit seven is set.
	and	al,07fh 	;clear high bit (*sigh*)
	call	norm_note
	mov	nbuf+1,al
	mov	al,0d8h
	mov	nbuf,al
	mov	al,031
	mov	nbuf+2,al
	mov	ax,3
	mov	nlen,ax
	call	send_amy
	jmp	tick_e

;bit 7 clear means a note depression

i3:	call	norm_note
	mov	nbuf+1,al
	mov	al,0d0h
	mov	nbuf,al
	mov	al,031
	mov	nbuf+2,al
	mov	al,0
	mov	nbuf+3,al
	mov	ax,4
	mov	nlen,ax
	call	send_amy
	jmp	tick_e

;and that's the ball game

tick_e:

;---- End of the actual useful code, for which all the rest of this file is
;     merely window dressing, support functions, and so forth ----

	inc	divby4
	cmp	divby4,4
	jne	my_tick

	mov	al,0
	mov	divby4,al

	push	es

	cli
	mov	ax,abs0
	mov	es,ax
	mov	ax,old_o
	mov	es:timer_int,ax
	mov	ax,old_s
	mov	es:timer_int+2,ax
	sti

	int	8;	      do the "real" 18hz interrupt

	cli
	mov	ax,offset tick_clock
	mov	es:timer_int,ax
	mov	ax,prog
	mov	es:timer_int+2,ax
	sti

	pop	es

	jmp	end_tick

my_tick:
	mov	al,20h; 	EOI to 8259 ala A-78
	out	020h,al

end_tick:
	pop	ax;		restore ds and return
	pop	si
	pop	ds
	iret



tick_clock endp

;normalize note by copying bit 6 into bit 7

norm_note	proc	near
	and	al,07fh
	cmp	al,040h
	jl	nnq
	or	al,080h
nnq:	ret
norm_note	endp

send_amy	proc near
	push	si
	push	dx
	push	bx
	push	ax
	cli
	mov	si,0
sl:
;wait for ack to go high

	mov	bx,1000;	timeout counter
	mov	dx,ackport

w1:	dec	bx
	jne	w12
	mov	al,1
	mov	herror,al
	jmp	saq;		timed out

w12:	in	al,dx
	and	al,ackmask
	je	w1

;ack is high
	mov	dx,dataport
	mov	al,nbuf[si];this is the byte to send
	out	dx,al

	mov	al,irqmask
	mov	dx,irqport
	out	dx,al

	mov	bx,1000;	timeout counter
	mov	dx,ackport

w2:	dec	bx
	jne	w21
	mov	al,0;	timed out
	mov	dx,irqport
	out	dx,al
	mov	al,2
	mov	herror,al
	jmp	saq

w21:	in	al,dx
	and	al,ackmask
	jne	w2

;ack went low
	mov	al,0
	mov	dx,irqport
	out	dx,al

s2:	inc	si
	cmp	si,nlen
	jne	sl

saq:	sti
	pop	ax
	pop	bx
	pop	dx
	pop	si
	ret
send_amy	endp




quit_clo  proc near

;restore the clock interrupt to 18.2hz and the default routine


	cli;interrupts off

	push	es;	set es to point to the interrupt vector

	mov	ax,abs0
	mov	es,ax

	mov	ax,old_o;    restore the old interrupt vector
	mov	es:timer_int,ax

	mov	ax,old_s
	mov	es:timer_int+2,ax

	pop	es;	restore es, enable interrupts, and return

	mov	al,36h; sel timer 0, lsb, msb, mode 3
	out	timer+3,al
	mov	ax,0
	out	timer,al
	mov	al,ah
	out	timer,al

	sti
	mov	ax,old_s
	ret

quit_clo  endp

prog	ends
	end
