//******************************************************************************
// NODE NAME : ADisplay.cpp
// part of the Atari Rom File Designer source files
// for Atari Fonts and Graphics Retreiving Dialog Box
//------------------------------------------------------------------------------
// Written by Philippe VUILLERME (c) PVBest 2001-2002
//
/*---------------------**| ARFD SOURCE REVISION HISTORY |**---------------------
 Date:     | What:
-----------|--------------------------------------------------------------------
 JUNE 2002 | Clean updated source code for ARFD revision 1.9.0 (public realease)
------------------------------------------------------------------------------*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include "MesTypes.h"
#include "ADisplay.h"
#include "Resource.h"
#include "rtffuncs.h"
#include "AmDialog.h"


   static UWORD s_sect;
   static UWORD s_offs;
   static UINT s_pos;
   int s_color;
   int s_width;
   int s_height;
   int dislx;
   BOOL bSearchAtariFont;
   BOOL broffs;

   char tmpFont[1024];

   char sSGD[3][8] = {"1 bit","2 bits","4 bits"};
   char sSGW[4][8] = {"40","80","160","320"};
   char sSGH[4][8] = {"24","48","96","192"};
   COLORREF AtariColor[16]= {RGB(0,0,0),RGB(15,15,15),RGB(31,31,31),
                             RGB(47,47,47),RGB(63,63,63),RGB(59,59,59),
                             RGB(95,95,95),RGB(111,111,111),RGB(127,127,127),
                             RGB(143,143,143),RGB(159,159,159),RGB(175,175,175),
                             RGB(191,191,191),RGB(208,208,208),RGB(224,224,224),
                             RGB(255,255,255)};

   extern UBYTE *   lpFileBuffer;
   extern char      sTmpSTR[256];
   extern char      szFileFilter[128];
   extern UWORD     SectSize;
   extern HINSTANCE hInstance;
   extern HANDLE    hFile;

   extern int iGet_Hex(char * lpszTmpStr);
   extern int iGet_Dec(char * lpszTmpStr);
   extern char * lpInt_To_Char(int a, char* lpszTmpStr);
   extern UINT Get_FilePosition(UWORD sector, UWORD offset);
   extern void INC_Sect(UWORD * TheSect);
   extern void DEC_Sect(UWORD * TheSect);
   extern void CHECK_Sect(UWORD * TheSect);
   extern void CHECK_Offs(UWORD * TheOffset, UWORD TheSector, UWORD TheMax);
   extern UWORD returnFBO(UINT * iPos, BOOL bOffs);

   FARPROC lpfnNewDisplayGraphProc;
   HWND hDisplayGraph;
   WNDPROC OldDisplayGraphProc;

//------------------------------------------------------------------------------
// DIALOG BOXES PROCEDURES
//------------------------------------------------------------------------------
   /* WM_COMMAND
		wNotifyCode = HIWORD(wParam); // notification code
		wID = LOWORD(wParam);         // item, control, or accelerator identifier
		hwndCtl = (HWND) lParam;      // handle of control */

void DisplayGraphDlg_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
	HDC PaintDC;
	HWND hDlg = hwnd;
   static UWORD SectSizeM = (UWORD) (SectSize - 3);

            switch(id)
            {
                case IDC_RADIOBUTTON90:
                    bSearchAtariFont = TRUE;
                    Init_Graphic_Dlg(hDlg);
                    Read_Param_Graphic_Dlg(hDlg);
                    //InvalidateRect(hDlg,FALSE,TRUE);
                    break;
                case IDC_RADIOBUTTON91:
                    bSearchAtariFont = FALSE;
                    Init_Graphic_Dlg(hDlg);
                    Read_Param_Graphic_Dlg(hDlg);
                    //InvalidateRect(hDlg,FALSE,TRUE);
                    break;
                case IDC_RADIOBUTTON92:
                    broffs = TRUE;
                    CHECK_Offs(&s_offs, s_sect , SectSizeM);
                    break;
                case IDC_RADIOBUTTON93:
                    broffs = FALSE;
                    break;
                case IDC_LISTBOX90:
                case IDC_LISTBOX91:
                case IDC_COMBOBOX90:
                    if (codeNotify == LBN_DBLCLK)
                    {
                    		Read_Param_Graphic_Dlg(hDlg);
                    		break;
                    }
                    else return;
                case IDC_BUTTON90:
                    Read_Param_Graphic_Dlg(hDlg);
                    break;
                case IDC_BUTTON995:
                	  s_sect += (UWORD) 8;
                    CHECK_Sect(&s_sect);
                    break;
                case IDC_BUTTON95:
                    INC_Sect(&s_sect);
                    break;
                case IDC_BUTTON996:
                	  s_sect -= (UWORD) 8;
                    CHECK_Sect(&s_sect);
                    break;
                case IDC_BUTTON96:
                    DEC_Sect(&s_sect);
                    break;
                case IDC_BUTTON997:
                    s_offs += (UWORD) 7;
                case IDC_BUTTON97:
                    s_offs ++;
                    if (broffs) CHECK_Offs(&s_offs, s_sect , SectSizeM);
                    else CHECK_Offs(&s_offs, s_sect , 0);
                    break;
                case IDC_BUTTON998:
                    s_offs -= (UWORD) 7;
                case IDC_BUTTON98:
                    s_offs --;
                    if (broffs) CHECK_Offs(&s_offs, s_sect , SectSizeM);
                    else CHECK_Offs(&s_offs, s_sect , 0);
                    break;
                case IDC_BUTTON93:
                    Save_Font(hDlg);
                    return;
                case IDOK:
                    EndDialog(hDlg, IDOK);
                    return; //TRUE; //exit & close dialog box
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return; //TRUE; //exit & close dialog box
            	 default:
                    return; // FALSE; //message not processed
            }
            Update_Sect_Graphic_Dlg(hDlg);          //reafficher secteur, offset et hauteur
            PaintDC = GetDC(hDisplayGraph);
            if (bSearchAtariFont)
            	Display_Atari_Font(hDlg,PaintDC);    //redessiner le rectangle display
            else
            	Display_Atari_Graphic(hDlg,PaintDC); //redessiner le rectangle display
            ReleaseDC(hDisplayGraph,PaintDC);
            return; //TRUE; //message processed
        }   // End WM_COMMAND

BOOL CALLBACK _export DisplayGraphDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
 {
    switch(Message)
    {
        case WM_INITDIALOG:
            hDisplayGraph = GetDlgItem(hDlg,IDC_STATIC90);
        		MakeCallBackProcs();
        		bSearchAtariFont = TRUE;
            broffs = FALSE;
            s_sect = 1;
            s_offs = 0;
            s_color = 2;
   			s_width = 160;
   			s_height = 192;
            s_pos = 0;
            Init_Graphic_Dlg(hDlg);
            Update_Sect_Graphic_Dlg(hDlg);
            return TRUE;  //set the focus on hDlg first item
        case WM_COMMAND:
            HANDLE_WM_COMMAND(hDlg, wParam, lParam, DisplayGraphDlg_OnCommand);
            return TRUE; // Message WM_COMMAND processed
    } // End switch(Message)
    return FALSE; //message not processed
 }

//------------------------------------------------------------------------------
// Autres Procedures
//------------------------------------------------------------------------------
void Init_Graphic_Dlg(HWND hDlg)
{
            int i;
            Button_SetCheck(GetDlgItem(hDlg,IDC_RADIOBUTTON90),bSearchAtariFont);
            Button_SetCheck(GetDlgItem(hDlg,IDC_RADIOBUTTON91),!bSearchAtariFont);

            Button_SetCheck(GetDlgItem(hDlg,IDC_RADIOBUTTON92),broffs);
            Button_SetCheck(GetDlgItem(hDlg,IDC_RADIOBUTTON93),!broffs);

    			ListBox_ResetContent(GetDlgItem(hDlg,IDC_LISTBOX90));
            ListBox_ResetContent(GetDlgItem(hDlg,IDC_LISTBOX91));
            ComboBox_ResetContent(GetDlgItem(hDlg,IDC_COMBOBOX90));
            for (i = 0; i <= 2; i++)
            	ListBox_AddString(GetDlgItem(hDlg,IDC_LISTBOX90),sSGD[i]);
            for (i = 0; i <= 3; i++)
    				ListBox_AddString(GetDlgItem(hDlg,IDC_LISTBOX91),sSGW[i]);
            for (i = 0; i <= 3; i++)
    				ComboBox_AddString(GetDlgItem(hDlg,IDC_COMBOBOX90),sSGH[i]);

            ListBox_Enable(GetDlgItem(hDlg,IDC_LISTBOX90),!bSearchAtariFont);
            ListBox_Enable(GetDlgItem(hDlg,IDC_LISTBOX91),!bSearchAtariFont);
            ComboBox_Enable(GetDlgItem(hDlg,IDC_COMBOBOX90),!bSearchAtariFont);
            EnableWindow(GetDlgItem(hDlg,IDC_BUTTON93),bSearchAtariFont);    //save font
            //EnableWindow(GetDlgItem(hDlg,IDC_BUTTON94),!bSearchAtariFont); //save bitmap
            EnableWindow(GetDlgItem(hDlg,IDC_BUTTON94),FALSE);
            if (!bSearchAtariFont)
            {
    				ListBox_SetCurSel(GetDlgItem(hDlg,IDC_LISTBOX90),1);
            	ListBox_SetCurSel(GetDlgItem(hDlg,IDC_LISTBOX91),2);
            	ComboBox_SetCurSel(GetDlgItem(hDlg,IDC_COMBOBOX90),3);
            }
            Button_SetCheck(GetDlgItem(hDlg,IDC_RADIOBUTTON92),broffs);
            Button_SetCheck(GetDlgItem(hDlg,IDC_RADIOBUTTON93),!broffs);
            wsprintf(sTmpSTR,"Sector size (Max $%03X bytes) :",(SectSize+1));
            SetDlgItemText(hDlg,IDC_GROUPBOX95,sTmpSTR);

}
void Update_Sect_Graphic_Dlg(HWND hDlg)
{
            SetDlgItemText(hDlg,IDC_EDIT90,lpInt_To_Char(s_sect,sTmpSTR));
    			SetDlgItemText(hDlg,IDC_EDIT91,lpInt_To_Char(s_offs,sTmpSTR));
            wsprintf(sTmpSTR,"%d",s_height);
            SetDlgItemText(hDlg,IDC_COMBOBOX90,sTmpSTR);
}
void Read_Param_Graphic_Dlg(HWND hDlg)
{
		    int i;
          if (GetDlgItemText(hDlg,IDC_EDIT90,sTmpSTR,4))
          		s_sect = (UWORD) iGet_Hex(sTmpSTR);
          CHECK_Sect(&s_sect);
          if (GetDlgItemText(hDlg,IDC_EDIT91,sTmpSTR,5))
          		s_offs = (UWORD) iGet_Hex(sTmpSTR);
          s_offs &= SectSize;
          if (GetDlgItemText(hDlg,IDC_COMBOBOX90,sTmpSTR,5))
          		s_height = iGet_Dec(sTmpSTR);
          if (s_height == 0 || s_height > 200) s_height = 192;
          i = ListBox_GetCurSel(GetDlgItem(hDlg,IDC_LISTBOX90));
          s_color = 0x01 << i;
          i = ListBox_GetCurSel(GetDlgItem(hDlg,IDC_LISTBOX91));
          s_width = (0x01 << (i+1)) * 20;
}
void Display_Atari_Font(HWND hDlg, HDC hdc)
{
   	int a,h,m,k,d,j,e,x,y;
      COLORREF C1,C2,C3;
      UWORD tb;

      Init_Display_Rectangle(hdc);
      s_pos = Get_FilePosition(s_sect,s_offs);
      C1 = AtariColor[0];
      C2 = AtariColor[15];

      a = 5;  //decalage fenetre affichage
      h = 5;

		for (m = 0; m < 128 ; m++)
      {
      		x = a;
      		y = h;
      		for (k=0;k<8;k++)  // les 8 niveaux d'un char (8 octets)
      		{
            	tb = returnFBO(&s_pos, broffs);
               d = tb & 0x000000FF;

        			for (j=0;j<8;j++)   // les 8 bits
            	{
         			e = (d >> (7-j)) & 0x01 ;
            		if (e)
            			C3 = C1;
            		else C3 = C2;
            		//SetPixelV(PaintDC,(a+j),(h+k),C3);
						SetPixelV(hdc,(x),(y),C3);
            		SetPixelV(hdc,(x+1),(y+1),C3);
            		SetPixelV(hdc,(x),(y+1),C3);
            		SetPixelV(hdc,(x+1),(y),C3);
                  x += 2;
            	}
               y += 2;
               x = a;
               if (tb & 0x8000) return;
            }
            a += 16;
            if ((m & 0x0F) == 0x0F)
            {
            	 a = 5;
                h += 16;
            }
      }
}
void Display_Atari_Graphic(HWND hDlg, HDC hdc)
{
   	int a,h,m,k,d,j,e,g,l,lpixel,hpixel,p,fin;
      UWORD tb;
      COLORREF C3;
      g = 0;
      Init_Display_Rectangle(hdc); //carr blanc = vider l'cran
      s_pos = Get_FilePosition(s_sect,s_offs);
      if (dislx<0) dislx = 5;  //decalage fenetre affichage
      a = dislx;
      h = 5;  //decalage fenetre affichage
      p = 8/s_color; //nombre de point (= pixel atari) dans un octet
      if (!(p && s_color && s_height && s_width))
      {
      	 // aucunes de ces valeur ne devaient tre nulles !!!
      	 MessageBox(hDlg,"ARFD Error:\nDivision by NULL","Display Atari Graphic :",MB_OK | MB_ICONERROR);
          return;
      }
      lpixel = 320/s_width; // = largeur d'un point en pixel PC pour un total de 320 pixels large
      hpixel = 192/s_height; // = largeur d'un point en pixel PC pour un total de 192 pixels haut
      fin = s_width/p; // = Nombre total d'octet qu'il faut dans une ligne
		for (m = 0; m < s_height ; m++) //hauteur (nbre de lignes) : m
      {
      	for (k = 0 ; k < fin ; k++)  // nombre d'octet par ligne : k
      	{
				tb = returnFBO(&s_pos, broffs);
         	d = tb & 0x000000FF;
        		for (j=0;j<p;j++)  // pour tous les points (pixel atari) dans un octet
            {
               	switch (s_color)
               	{
               		case 1:
                    		g = 15;
                    		e = (d >> (7 - j*s_color)) & 0x01;
                    		break;
                  	case 2:
                    		g = 5;
                   	 	e = (d >> (6 - j*s_color)) & 0x03;
                   		break;
                  	case 4:
                    		e = (d >> (4 - j*s_color)) & 0x0F;
                    		g = 1;
                    		break;
               	}
               	C3 = AtariColor[e*g];
               	for (l=0;l<lpixel;l++)
						{
               		SetPixelV(hdc,(a+l),(h),C3);
               	}
               	a += lpixel ; //point (pixel atari) suivant
            }
            if (tb & 0x8000) return;
         }
         h++; //Ligne suivante
         a = dislx; //retour au dbut de la ligne : decalage fenetre affichage

      }
}
void Init_Display_Rectangle(HDC hdc)
{
				RECT Rect;
 				HBRUSH OldBrush, NewBrush;
            GetClientRect(hDisplayGraph, &Rect);
      		NewBrush = CreateSolidBrush(RGB(255,255,255));
      		OldBrush = SelectBrush(hdc,NewBrush);
      		Rectangle (hdc, 0, 0, Rect.right, Rect.bottom);
            dislx = (Rect.right - 320) / 2;
      		SelectBrush(hdc, OldBrush);
      		DeleteBrush(NewBrush);
}
//////////////////////////////////////
// SubClassing for Display Graphic Window
//////////////////////////////////////
void MakeCallBackProcs()
{
  OldDisplayGraphProc = (WNDPROC)SetWindowLong(hDisplayGraph,
                           GWL_WNDPROC, LONG(NewDisplayGraphProc));
}

LRESULT CALLBACK _export NewDisplayGraphProc(HWND hwnd, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
  HDC PaintDC;
  PAINTSTRUCT ps;
  switch(Message)
  {
    case WM_GETDLGCODE:
      return DLGC_WANTALLKEYS;
    case WM_PAINT:      //redessiner le rectangle display
    	PaintDC = BeginPaint(hDisplayGraph, &ps);
      if (bSearchAtariFont)
      	Display_Atari_Font(hwnd,PaintDC);
      else
         Display_Atari_Graphic(hwnd,PaintDC);
      EndPaint(hDisplayGraph, &ps);
      break;
  }
  return
    CallWindowProc(OldDisplayGraphProc, hwnd, Message, wParam, lParam);
}
void Save_Font(HWND hwnd)
{
	//HANDLE hFile;
   int br, i;
   UWORD d;
   BOOL bResult;
   char szDialogTitle[] = "Save the Atari Font Data";
   char AFileName[128];
   char LFileName[STRSIZE];

   strcpy(AFileName,"");
   strcpy(LFileName,"");

   s_pos = Get_FilePosition(s_sect,s_offs);
   for (i=0; i<1024; i++)
   {
      d = returnFBO(&s_pos, broffs);
      tmpFont[i] =(UBYTE)( d & 0x000000FF);
      if (d & 0x8000)
      {
         MessageBox(hwnd,
         	"ARFD file saving Error:\nMemory End of File encountered: saving font aborted!",
            szDialogTitle,MB_OK|MB_ICONERROR);
      	return;
      }
   }

   memset(szFileFilter,0x00,128);
   LoadString(hInstance,STRG_FILEFILTER_FON,szFileFilter,128);

   bResult = Get_FileName(hwnd, (LPSTR) LFileName,
   		szFileFilter, (LPSTR) AFileName,
   		szDialogTitle,
         FALSE, //Open for Save
         TRUE,  //confirm the file overwritting if it already exits
         1);    //Filter index is 1 (default *.*)

   if (bResult)
   {
   	hFile = CreateFile(LFileName,
   	GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
   	FILE_ATTRIBUTE_NORMAL, NULL);

   	if (hFile == INVALID_HANDLE_VALUE)
   	{
   		wsprintf(sTmpSTR, "while opening file handle:\n '%s'",LFileName);
         Handle_System_Error(hwnd, szDialogTitle, sTmpSTR, GetLastError ());
   		return;
   	}

      if (!WriteFile(hFile, tmpFont, 1024, (LPDWORD) &br, NULL))
      	Handle_System_Error(hwnd, szDialogTitle, "while saving data into file", GetLastError());
      Close_File(&hFile);

      wsprintf(sTmpSTR, "ARFD Info:\nAtari font data saved into '%s'",AFileName);
      MessageBox(hwnd,sTmpSTR,szDialogTitle,MB_OK|MB_ICONINFORMATION);
   }
}
