//******************************************************************************
// NODE NAME : AmDialog.cpp
// part of the Atari Rom File Designer source files
// Cr pour allger ARFD.cpp
// Contient les prcdures et fonctions relatives aux boites de dialogue
// Created to make ARFD.CPP ligther
// contains all dialog box functions and procedures of the ARFD main window
//------------------------------------------------------------------------------
// Written by Philippe VUILLERME (c) PVBest 2001-2002
//
/*---------------------**| ARFD SOURCE REVISION HISTORY |**---------------------
 Date:     | What:
-----------|--------------------------------------------------------------------
 JUNE 2002 | Clean updated source code for ARFD revision 1.9.0 (public realease)
------------------------------------------------------------------------------*/


#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#pragma hdrstop
#include "Resource.h"
#include "MesTypes.h"
#include "ARFDFunctions.h"
#include "rtffuncs.h"
#include "Monitor.h"
#include "AmDialog.h"
#include "EditSector.h"

//------------------------------------------------------------------------------
// Declaration des variables externes globales et des fonctions de ARFDMain.cpp
//------------------------------------------------------------------------------
// reproduit la mme liste que ARFDMAIN.CPP
// Declarations inutiles prcdes de //

   extern char szAppRevision[];
   extern char szDlgBoxMain[];
   extern char szDlgBoxDis[];

   //Instance application et librairie RichEdit
   extern HINSTANCE hInstance;

   //Pointeur sur les 3 fenetres principales
   extern HWND hMainWindow;
   extern HWND hChildEditWindow;

   //Pointeurs boites de dialogue et de fenetres filles
   extern HWND hMainRText;  //Fenetre edition principale
   //extern       HWND DisWin;  //Fenetre edition desassemblage
   //extern       HWND hStatus;  //Barre de status fenetre principale
   //extern       HWND hToolbar	;  //Barre d'outils icones fenetre principale
   extern HWND hDisParamDlg;  //Boite de dialogue parametres desass.
   extern HWND hConvertDlg;  //Boite de dialogue conversion Hex<>Dec
   extern HWND hAtariDirDlg;
   extern HWND hWaitDlg;              //Boite de dialogue d'attente
   extern HWND hWaitProgress;         //Barre de progression dialogue attente
   //extern       HANDLE hResource;           //Handle vers ressources
   extern HMENU ModMenu;              //Handle menu fenetre principale

   //initialisation des structures de donnes
   extern TDIS_PARAM D_Def;
   extern TDIS_PARAM D_Cur;
   extern TMON_PARAM AmParam;

   // variables pour les recherches ASCII/HEXA
   extern BOOL   bSearchInProgress;     // Flag de recherche en cours
   //extern int    nSearchDataBytes;      // selected data length
   extern int    iSearchMode;           // type de recherche et remplacement

   // variables boolennes :
   extern BOOL bFileModified;
   extern BOOL bNewFileParam;
   //extern BOOL bChildDisWin;  	 //Flag Fenetre de Desassemblage presente
   //extern BOOL bChildEditWin;
   extern BOOL bEndDisThread; //Flag Fin du processus de desassemblage
   extern BOOL bFileMem;     //Flag Fichier prsent en mmoire
   extern BOOL bATRFlag;     //Flag Fichier en mmoire est au format ATR
   //extern BOOL bDisAddMode;           //Flag ajout dans la fenetre desassemblage
   //extern BOOL bOpenCmdParamFile;
   //extern BOOL   bFileResult;                 // reussite d'ouverture ou sauvegarde fichier
   extern BOOL bImportData;

   //Variables concernant le fichier PC en mmoire :
   extern char 	 szAtariFileName[STRSIZE];  //chemin complet du fichier en cours...
   //extern char   szAppPathDir[STRSIZE];
   extern int 	 iFileLength;

   // variables pour les OPEN/SAVE file
   //extern int    iFileExtension;
   //extern int    iFilterIndex;
   //extern char   szTextFileTitle[128];
   extern char   szFileFilter[128];

   //buffer mmoire
   extern char 	 * lpsTmpCB;
   //extern UBYTE  * lpRom;
   extern UBYTE	 * lpFileBuffer;
   //extern UBYTE  * lpAtariFileTmp;

   //Chaines temporaires
   extern char   sTmpSTR[256];
   //extern char   sTmpCmdLine[256];

   //variables de positionnement mmoire ( Atari ROM file memory )
   extern UWORD SectSize;
   extern UWORD iCurSect;             //Secteur  afficher courant
   extern UWORD iNewSect;             //New last sector for conversion
   //extern UINT  iCurFilePos;        //Position courante dans le fichier
   extern UWORD iCurOff;              //Offset courant

   //variables globales pour le dsassemblage
   //extern UWORD Dis_CMemAddr;
   //extern UINT Dis_CPosFile;
   //extern UWORD Dis_CSector;
   //extern UWORD Dis_COffset;

   //variables diverses
   extern char szEnterSectTitle [32];

   //fonctions externes de ARFDMain
   extern void Set_Windows_Title(LPSTR lpszTitleString);
   extern void Reset_Edit_Sector(BOOL rstsectorone);
   extern void Close_DirDialog();


   extern HFONT hfARFD;  //The ARFD fixed font for all edit control display
   //extern LOGFONT LogFont;

   extern ATARIDOSDIRECTORY addir;


//------------------------------------------------------------------------------
// Variables locales :
//------------------------------------------------------------------------------

   static char szInputDataString[48] = ""; // ligne de donnes d'entre pour rechercher/remplacer

   static TIEDATA IEData = {
   	1, //UWORD IE_FS; //FirstSect;
   	0, //UWORD IE_FO; //FirstOffset;
   	0, //UWORD IE_GO; //GeneralFirstOffset;
   	0x7F, //UWORD IE_LB; //GeneralLastByte;
   	1, //UWORD IE_LS; //LastSect;
   	0x7F, //UWORD IE_LO; //LastOffset;
   	0x100, //int   IE_LengthSize;
      1024, //int   MaxDiff;
   	TRUE, //BOOL  bFileSize;
      };
   static TSRDATA SRData;

   int  iBinFileLn;
   BOOL bConvertFile;    // Activation de la conversion dans le dialogbox PARAM
   BOOL bWantToCompare;
   BOOL bFoundDifferent;

   char szTheBinFile[STRSIZE];
   char szTheBinaryFilename[128];

   HANDLE hBinFile;     //Handle for import/export binary file
   BOOL bBinFileInMem;

   char sCOMBO_0[] = "1-> SINGLE DENSITY : 720 ($2D0) Sectors, 128 Bytes/Sector";
   char sCOMBO_1[] = "2-> 1050 ENHANCED FORMAT : 1040 ($410) Sectors, 128 Bytes/Sector";
   char sCOMBO_2[] = "3-> DOUBLE DENSITY FORMAT : 720 ($2D0) Sectors, 256 Bytes/Sector";

   char szSRTitle[7][36] = {
               "Search Hex Data in sectors :      ",
               "Search ASCII Data in sectors :    ",
               "Replace Hex Data in sectors :     ",
               "Replace ASCII Data in sectors :   ",
               "Fill sectors with Hex pattern :   ",
               "Fill sectors with ASCII pattern : ",
               "Apply a XOR data mask to sectors :"};

   char szAsciiTxt[] = "Ascii enter format : '09azAZ !@...'  - Max : 16 chars";

//------------------------------------------------------------------------------
//==============================================================================
//
// 							DIALOG BOXES PROCEDURES
//
//==============================================================================
//------------------------------------------------------------------------------
// ABOUT DIALOGBOX
BOOL CALLBACK _export AboutDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    HBITMAP hb;
    static HFONT hft;
    switch(Message)
    {
        case WM_INITDIALOG:
        {
            hft = CreateFont(0,0,0,0,700,0,0,0,0,0,0,0,0,"Arial");
            if (hft != NULL)
                 SetWindowFont(GetDlgItem(hDlg, IDC_APPNAME), hft, TRUE);
        		SetDlgItemText(hDlg,IDC_FILEVERSION,szAppRevision);
           	hb = LoadBitmap(hInstance, "ImageAbout");

             if (!hb)
    					MessageBox(hDlg, "ARFD Sys Error:\nCould not load the About Dialog bitmap!",
                  	"About Dialog :", MB_OK|MB_ICONERROR);
              else
    					SendMessage(GetDlgItem(hDlg, IDC_ABOUTICON), STM_SETIMAGE,
                		IMAGE_BITMAP, LPARAM(hb));
            return TRUE;
        }
        case WM_COMMAND:
            if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
            {
            	 if (hb) DeleteBitmap(hb);
                if (hft) DeleteFont(hft);
                EndDialog(hDlg, IDOK);
                return TRUE;
            }
            if (LOWORD(wParam) == CM_MAILTO)
               ShellExecute(NULL,"open","mailto:PVBest@free.fr",NULL,NULL,SW_SHOWNORMAL);
            break;
    }
    return FALSE;
}
//------------------------------------------------------------------------------
// ROM FILE PARAMETER AND INFORMATION DIALOGBOX
BOOL CALLBACK _export ParamDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
            bConvertFile = FALSE; // dsactiver la conversion  l'initialisation
            if (!bNewFileParam)   // Fentre Info et pas New File
            {
            	EnableWindow(GetDlgItem(hDlg,IDOK),FALSE);
               SetDlgItemText(hDlg,IDCANCEL,"Close");
            }
            Set_Param_Dialog(hDlg);
            return TRUE;
        case WM_COMMAND:
        {
            switch(LOWORD(wParam))
            {
                // Predefined Atari Disk Format selection
                case IDC_RADIOBUTTON60:
                	   if (!bConvertFile && !bNewFileParam)
                        Set_Param_Dialog(hDlg);
                     else
                     {
                     	EnableWindow(GetDlgItem(hDlg,IDC_COMBOBOX60),TRUE);
    							EnableWindow(GetDlgItem(hDlg,IDC_EDIT61),FALSE);
                        EnableWindow(GetDlgItem(hDlg,IDC_RADIOBUTTON62),FALSE);
    							EnableWindow(GetDlgItem(hDlg,IDC_RADIOBUTTON63),FALSE);
                     }
                     break;
                // Manual Atari Disk Format selection
                case IDC_RADIOBUTTON61:
                	   if (!bConvertFile && !bNewFileParam)
                        Set_Param_Dialog(hDlg);
                     else
                     {
                     	EnableWindow(GetDlgItem(hDlg,IDC_COMBOBOX60),FALSE);
    							EnableWindow(GetDlgItem(hDlg,IDC_EDIT61),TRUE);
                        EnableWindow(GetDlgItem(hDlg,IDC_RADIOBUTTON62),TRUE);
    							EnableWindow(GetDlgItem(hDlg,IDC_RADIOBUTTON63),TRUE);
                     }
                     break;
                // $80 bytes per sector
                case IDC_RADIOBUTTON62:
                	   if (!bConvertFile && !bNewFileParam)
                        Set_Param_Dialog(hDlg);
                     break;
                // $100 bytes per sector
                case IDC_RADIOBUTTON63:
                	   if (!bConvertFile && !bNewFileParam)
                        Set_Param_Dialog(hDlg);
                     break;
                // File Conversion Enabling Button
                case IDC_BUTTON60:
                		if (bFileMem && !bNewFileParam)
                     {
                           Close_DirDialog();
                				bConvertFile = TRUE;
                     		Enable_Conversion(hDlg);
                     }
                     break;
                // Apply File Conversion Button
                case IDC_BUTTON61:
                		Get_Param_Dialog(hDlg);
                     Set_Param_Dialog(hDlg);
                    	break;
                case IDOK:
                		if (bNewFileParam)
                     {
                     	Get_Param_Dialog(hDlg);
                        EndDialog(hDlg, IDOK);
                    		return TRUE;
                     }
                case IDCANCEL:
                {
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
                }
            }
        }
    }
    return FALSE;
}
//------------------------------------------------------------------------------
// DISASSEMBLY PARAMETER INPUT DIALOGBOX
BOOL CALLBACK _export DesassembleDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
        {
            Set_Disassemble_Dialog(hDlg,&D_Cur);
            hDisParamDlg = hDlg;
            return TRUE;
        }
        case WM_COMMAND:
        {
            switch (LOWORD(wParam))
            {
                case IDC_SETDEFAULT :
                {
                    if (MessageBox(hDlg,"Load default disassembly parameters?",
                            szDlgBoxDis,MB_OKCANCEL|MB_ICONQUESTION) == IDOK)
                        Set_Disassemble_Dialog(hDlg,&D_Def);
                    break;
                }
                case IDC_RADIOBUTTON1:
                {
                    Text_Enable(hDlg, IDC_EDIT4);
                    Text_Disable(hDlg, IDC_EDIT5);
                    break;
                }
                case IDC_RADIOBUTTON2:
                {
                    Text_Enable(hDlg, IDC_EDIT5);
                    Text_Disable(hDlg, IDC_EDIT4);
                    break;
                }
                case IDC_RADIOBUTTON3:
                case IDC_RADIOBUTTON4:
                    Text_Disable(hDlg, IDC_EDIT6);
                    break;
                case IDC_RADIOBUTTON5:
                    Text_Enable(hDlg, IDC_EDIT6);
                    break;
                case IDOK:
                {
                    if (!Get_Disassemble_Dialog(hDlg,&D_Cur)) break;
                    LoadString(hInstance,STRG_DISPARAM,sTmpSTR,250);
                    wsprintf(lpsTmpCB,sTmpSTR,AmParam.FName,D_Cur.FSect,D_Cur.SOff,D_Cur.FMemAdd,D_Cur.BytPerSect);
                    if (D_Cur.Mnemo)
                        strcat(lpsTmpCB,"\r\n- Use of Atari Address Mnemonic");
                    else
                        strcat(lpsTmpCB,"\r\n- No Atari Address Mnemonic");
                    if (D_Cur.ShowFilePos)
                        strcat(lpsTmpCB,"\r\n- Display File position index");
                    else
                        strcat(lpsTmpCB,"\r\n- No File position index");
                    if (D_Cur.EnhancedCode)
                        strcat(lpsTmpCB,"\r\n- Use of enhanced 65C02 opcodes set");
                    else
                        strcat(lpsTmpCB,"\r\n- Use of standard 6502 opcodes set");
                    if (D_Cur.DisMem)
                    {
                        strcat(lpsTmpCB,"\r\n- Disassembly stop at address:");
                        wsprintf(sTmpSTR," $%04X",D_Cur.LMemAdd);
                        strcat(lpsTmpCB,sTmpSTR);
                    }
                    else
                    {
                        strcat(lpsTmpCB,"\r\n- Disassembly stop at sector:");
                        wsprintf(sTmpSTR," $%03X (included)",D_Cur.LSect);
                        strcat(lpsTmpCB,sTmpSTR);
                    }
                    if (DialogBox(hInstance,"DisConfirmDialog", hDlg,
                    			(DLGPROC)DisConfirmDlgProc) == IDOK)
                    {
                        PostMessage(hMainWindow,WM_COMMAND,(WPARAM)CM_DISVIEW,0);
                        EndDialog(hDlg, IDOK);
                        hDisParamDlg = NULL;
                        return TRUE;
                    }
                    break;
                }
                case IDCANCEL:
                {
                    EndDialog(hDlg, IDCANCEL);
                    hDisParamDlg = NULL;
                    return TRUE;
                }
            }
            break;
        }
    }
    return FALSE;
}
//------------------------------------------------------------------------------
// ENTER SECTOR DIALOGBOX
BOOL CALLBACK _export EnterSectDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    UWORD w;
    char szTitleBox[] = "Number Input Error :";
    switch(Message)
    {
        case WM_INITDIALOG:
        {
        		wsprintf(sTmpSTR,"[Hex value from 1 to $%X]",AmParam.MAXSect);
            SetDlgItemText(hDlg,IDC_STATIC30,sTmpSTR);
            SetDlgItemText(hDlg,IDC_STATIC31,szEnterSectTitle);
            SetDlgItemText(hDlg,IDC_EDIT30,lpInt_To_Char(iCurSect,sTmpSTR));
            ShowCaret(hDlg);
            return TRUE;
        }
        case WM_COMMAND:
        {
            switch (LOWORD(wParam))
            {
                case IDOK:
                    if (GetDlgItemText(hDlg,IDC_EDIT30,sTmpSTR,9))
                    {
                        if (!Is_Hexa_String(sTmpSTR))
                            MessageBox(hDlg,"ARFD input Error:\nThis is not a valid hexadecimal number!",
                                szTitleBox,MB_OK|MB_ICONEXCLAMATION);
                        else
                        {
                            w = (UWORD) iGet_Hex(sTmpSTR);
                            if (!CHECK_Sect(&w))
                            {
                            	MessageBox(hDlg,"ARFD input Error:\nInvalid sector number!",
                            		szTitleBox,MB_OK|MB_ICONEXCLAMATION);
                              break;
                            }
                            iCurSect = w;
                            iCurOff  = 0;
                            EndDialog(hDlg, IDOK);
                            return TRUE;
                        }
                    }
                    break;
                case IDCANCEL:
                {
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
                }
            }
            break;
        }
    }
    return FALSE;
}
//------------------------------------------------------------------------------
// DISASSEMBLY WAIT DIALOGBOX
BOOL CALLBACK _export WaitDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
        {
          SetDlgItemText(hDlg,IDCANCEL,"STOP !");
          SetDlgItemText(hDlg,IDC_WAITSTATIC,"Please Wait...");
          hWaitProgress = GetDlgItem(hDlg,IDC_PROGRESS1);
          SendMessage(hWaitProgress, PBM_SETRANGE, 0, MAKELONG(0, (100)));
  			 SendMessage(hWaitProgress, PBM_SETSTEP, WPARAM(1), 0);
          hWaitDlg = hDlg;
          return TRUE;
        }
        case WM_COMMAND:
        {
            switch(LOWORD(wParam))
            {
                case CM_WAITOVER:
                {
                	SetDlgItemText(hDlg,IDCANCEL,"OK");
                	SetDlgItemText(hDlg,IDC_WAITSTATIC,"!! DONE !!");
                  break;
                }
                case IDCANCEL: //et sur fermeture de la fenetre ??
                {
                    hWaitDlg = NULL;
                    bEndDisThread = TRUE;
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                }
            }
        }
    }
    return FALSE;
}
//------------------------------------------------------------------------------
// CONFIRM DISASSEMBLY DIALOGBOX
BOOL CALLBACK _export DisConfirmDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
            SetDlgItemText(hDlg,IDC_DISCONFIRM,lpsTmpCB);
            return TRUE;
        case WM_COMMAND:
        {
            switch(LOWORD(wParam))
            {
                case IDOK:
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                {
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
                }
            }
        }
    }
    return FALSE;
}
//------------------------------------------------------------------------------
// SEARCH DIALOGBOX
BOOL CALLBACK _export SearchDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
            SetDlgItemText(hDlg,IDC_EDIT40,szInputDataString);
            SetDlgItemText(hDlg,IDC_EDIT41,szInputDataString);
            SetDlgItemText(hDlg,IDC_EDIT42,"1");
            SetDlgItemText(hDlg,IDC_EDIT43,lpInt_To_Char(AmParam.MAXSect,sTmpSTR));
            wsprintf(sTmpSTR,"($%03X)",iCurSect);
            SetDlgItemText(hDlg,IDC_STATIC41,sTmpSTR);
            EnableWindow(GetDlgItem(hDlg,IDC_EDIT42),FALSE);
            EnableWindow(GetDlgItem(hDlg,IDC_EDIT43),FALSE);
            CheckRadioButton(hDlg,IDC_RADIOBUTTON40,
                IDC_RADIOBUTTON42,IDC_RADIOBUTTON42);
            SRData.bPrompt = TRUE;
            CheckDlgButton(hDlg, IDC_CHECKBOX40, BST_CHECKED);
            SRData.bReplace = FALSE;
            SRData.bAscii = FALSE;
            SetWindowText(hDlg,szSRTitle[iSearchMode-1]);
            switch (iSearchMode)
            {
               case 2: // Ascii Search
                 	SetDlgItemText(hDlg,IDC_STATIC40, szAsciiTxt);
                  SRData.bAscii = TRUE;
               case 1: // Hexa Search
                  break;
               case 4 : // Replace Acsii Data
                  SetDlgItemText(hDlg,IDC_STATIC40, szAsciiTxt);
                  SRData.bAscii = TRUE;
               case 3 : // Replace Hex Data
                  EnableWindow(GetDlgItem(hDlg,IDC_EDIT41),TRUE);
                  EnableWindow(GetDlgItem(hDlg,IDC_CHECKBOX40),TRUE);
                  SRData.bReplace = TRUE;
                  break;
               case 6 : // fill with Ascii Pattern
                  SetDlgItemText(hDlg,IDC_STATIC40, szAsciiTxt);
                  SRData.bAscii = TRUE;
               case 5: //  fill with Hex Pattern
                  SetDlgItemText(hDlg,IDC_GROUPBOX40,"Enter the data string to fill sectors with :");
                  break;
               case 7 : // XOR pattern
                  SetDlgItemText(hDlg,IDC_GROUPBOX40,"Enter the XOR data byte string to apply :");
                  break;
            }
            return TRUE;

        case WM_COMMAND:
        {
            switch(LOWORD(wParam))
            {
            	 case IDC_CHECKBOX40:
                  SRData.bPrompt = !SRData.bPrompt;
                  break;
                case IDC_RADIOBUTTON40:
                	EnableWindow(GetDlgItem(hDlg,IDC_EDIT42),TRUE);
            		EnableWindow(GetDlgItem(hDlg,IDC_EDIT43),TRUE);
                  break;
                case IDC_RADIOBUTTON41:
                case IDC_RADIOBUTTON42:
                  EnableWindow(GetDlgItem(hDlg,IDC_EDIT42),FALSE);
            		EnableWindow(GetDlgItem(hDlg,IDC_EDIT43),FALSE);
                  break;
                case IDOK:
                    if (!Get_SearchReplace_Param_Dialog(hDlg)) break;
                    EndDialog(hDlg, IDOK);
                    return TRUE;
                case IDCANCEL:
                    EndDialog(hDlg, IDCANCEL);
                    return TRUE;
            }
        }
    }
    return FALSE;
}
//------------------------------------------------------------------------------
// IMPORT/EXPORT DIALOGBOX
BOOL CALLBACK _export ImportExportDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    switch(Message)
    {
        case WM_INITDIALOG:
            bWantToCompare = FALSE;
            bBinFileInMem = FALSE;
            hBinFile = INVALID_HANDLE_VALUE;
            iBinFileLn = 0;
            if (bImportData)
               SetWindowText(hDlg,"Import Data from a binary file :");
            else
            {
               SetWindowText(hDlg,"Export Data into a binary file :");
               EnableWindow(GetDlgItem(hDlg,IDCEX_CHECKBOX1),FALSE);
            }
            Set_ImportParam_Dialog(hDlg);
            return TRUE;
        case WM_COMMAND:
        {
            switch(LOWORD(wParam))
            {
                case IDCEX_RADIOBUTTON1:
                     IEData.bFileSize = TRUE;
                		EnableWindow(GetDlgItem(hDlg,IDCEX_EDIT7),TRUE);
                     EnableWindow(GetDlgItem(hDlg,IDCEX_EDIT5),FALSE);
                     EnableWindow(GetDlgItem(hDlg,IDCEX_EDIT6),FALSE);
                     break;
                case IDCEX_RADIOBUTTON2:
                     IEData.bFileSize = FALSE;
                		EnableWindow(GetDlgItem(hDlg,IDCEX_EDIT7),FALSE);
                		EnableWindow(GetDlgItem(hDlg,IDCEX_EDIT5),TRUE);
                		EnableWindow(GetDlgItem(hDlg,IDCEX_EDIT6),TRUE);
                		break;
                case IDCEX_CHECKBOX1:
                		bWantToCompare = ! bWantToCompare;
                     EnableWindow(GetDlgItem(hDlg,IDCEX_EDIT9),bWantToCompare);
                     break;
                case IDCEX_BUTTON1:
                     if (bBinFileInMem)
                     {
                     	wsprintf(sTmpSTR,
                        	"ARFD Warning:\nFile '%s' is already open!\nClick OK to close it and open a new one?",szTheBinFile);
       						if (MessageBox(hDlg,sTmpSTR,szDlgBoxMain,MB_OKCANCEL|MB_ICONWARNING) != IDOK)
                        	break;
                      	Close_File(&hBinFile);
                        bBinFileInMem = FALSE;
                     }
                     if (Open_Binary_File(hDlg, !bImportData))
                     {
       						bBinFileInMem = TRUE;
                        wsprintf(sTmpSTR,"ARFD Info:\nBinary file '%s' open!",szTheBinFile);
       						MessageBox(hDlg,sTmpSTR,szDlgBoxMain,MB_OK|MB_ICONINFORMATION);
                        if (bImportData)
                        {
                           //SetDlgItemText(hDlg,IDCEX_EDIT7,lpInt_To_Char(iBinFileLn,sTmpSTR)); Pas d'initialisation du champ ???
                        	wsprintf(sTmpSTR,"File '%s' open for import at $%05X (%d) bytes (reading file into memory)",
                           	szTheBinFile,iBinFileLn,iBinFileLn);
                        }
                        else
                           wsprintf(sTmpSTR,"File '%s' open for export (writing file from memory)",szTheBinFile);
                        SetDlgItemText(hDlg,IDCEX_EDIT8,sTmpSTR);
                     }
                     break;
                case IDOK:
            			if (Get_ImportParam_Dialog(hDlg))
                     {
                        // are you sure ??
                        if (!ImportExport_Data(hDlg)) break; // false = cancelled by the user !!
                        // ok !!
                     	EndDialog(hDlg, IDOK);
                        if (bBinFileInMem) Close_File(&hBinFile);
                     	return TRUE;
                     }
                     break;
                case IDCANCEL:
                    	EndDialog(hDlg, IDCANCEL);
                     if (bBinFileInMem) Close_File(&hBinFile);
                    	return TRUE;
            }
        }
    }
    return FALSE;
}
//------------------------------------------------------------------------------
// CONFIRM CONVERSION DIALOGBOX
BOOL CALLBACK _export ConvertConfirmDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    HICON hi;
    int iResult;
    switch(Message)
    {
        case WM_INITDIALOG:
            hi = LoadIcon(NULL,IDI_QUESTION);
            if (hi)
            	SendMessage(GetDlgItem(hDlg, IDICVRT_WARNING), STM_SETIMAGE,
                		IMAGE_ICON, LPARAM(hi));
            SetDlgItemText(hDlg,IDCCVRT_TEXT,(bATRFlag ? "XFD" : "ATR"));
            return TRUE;
        case WM_COMMAND:
        {
            iResult = LOWORD(wParam);
            switch (iResult)
            {
               case IDYES:
               case IDNO:
            	case IDCANCEL:
                  if (IsDlgButtonChecked(hDlg,IDCCVRT_CHECKBOX) & BST_CHECKED)
                  	iResult |= 0x00000010;
                  //if (hi) DeleteObject(hi); //No need for Windows ressources
                	EndDialog(hDlg, iResult);
                	return TRUE;
            }
        }
    }
    return FALSE;
}
//------------------------------------------------------------------------------
//==============================================================================
//
// 							  ASSOCIATED FUNCTIONS :
//
//==============================================================================
//------------------------------------------------------------------------------
//==============================================================================
//
// 							DISASSEMBLY DIALOGBOX FUNCTIONS
//
//==============================================================================
//------------------------------------------------------------------------------
// Set the initialization dialog box disassably parameters:
void Set_Disassemble_Dialog(HWND hDialog, TDIS_PARAM * D_P)
{
    char tmpstring[10] = "";
    SetDlgItemText(hDialog,IDC_EDIT1,lpInt_To_Char(D_P->FSect,tmpstring));
    SetDlgItemText(hDialog,IDC_EDIT2,lpInt_To_Char(D_P->SOff,tmpstring));
    SetDlgItemText(hDialog,IDC_EDIT3,lpInt_To_Char(D_P->FMemAdd,tmpstring));
    SetDlgItemText(hDialog,IDC_EDIT4,lpInt_To_Char(D_P->LSect,tmpstring));
    SetDlgItemText(hDialog,IDC_EDIT5,lpInt_To_Char(D_P->LMemAdd,tmpstring));
    SetDlgItemText(hDialog,IDC_EDIT6,lpInt_To_Char(D_P->BytPerSect,tmpstring));
    wsprintf(sTmpSTR,"Sector size (Max $%03X bytes) :",(SectSize+1));
    SetDlgItemText(hDialog,IDC_GROUPBOX3,sTmpSTR);

    if (D_P->Mnemo)
        CheckDlgButton(hDialog, IDC_CHECKBOX1, BST_CHECKED);
    else
        CheckDlgButton(hDialog, IDC_CHECKBOX1, BST_UNCHECKED);
    if (D_P->ShowFilePos)
        CheckDlgButton(hDialog, IDC_CHECKBOX2, BST_CHECKED);
    else
        CheckDlgButton(hDialog, IDC_CHECKBOX2, BST_UNCHECKED);
    if (D_P->EnhancedCode)
        CheckDlgButton(hDialog, IDC_CHECKBOX3, BST_CHECKED);
    else
        CheckDlgButton(hDialog, IDC_CHECKBOX1, BST_UNCHECKED);

    Text_Disable(hDialog, IDC_EDIT6);
    //if (D_P->BytPerSect == (SectSize + 1))
    CheckRadioButton(hDialog,IDC_RADIOBUTTON3,
                IDC_RADIOBUTTON5,IDC_RADIOBUTTON3);
    //if (D_P->BytPerSect == (SectSize - 2))
    //        CheckRadioButton(hDialog,IDC_RADIOBUTTON3,
    //            IDC_RADIOBUTTON5,IDC_RADIOBUTTON4);
    //     else
    //     {
    //        CheckRadioButton(hDialog,IDC_RADIOBUTTON3,
    //            IDC_RADIOBUTTON5,IDC_RADIOBUTTON5);
    //        Text_Enable(hDialog, IDC_EDIT6);
    //     }

    if (D_P->DisMem)
    {
        CheckRadioButton(hDialog,IDC_RADIOBUTTON1,
                IDC_RADIOBUTTON2,IDC_RADIOBUTTON2);
        Text_Enable(hDialog, IDC_EDIT5);
        Text_Disable(hDialog, IDC_EDIT4);
    }
    else
    {
        CheckRadioButton(hDialog,IDC_RADIOBUTTON1,
                IDC_RADIOBUTTON2,IDC_RADIOBUTTON1);
        Text_Enable(hDialog, IDC_EDIT4);
        Text_Disable(hDialog, IDC_EDIT5);
    }
 }
//------------------------------------------------------------------------------
// Get the dialog box disassably parameters:
BOOL Get_Disassemble_Dialog(HWND hDialog, TDIS_PARAM * lpD_P)
 {
    char tmpstring[10] = "";
    UWORD w1,w2,w3,w4;
    BOOL l;
    // secteur
    if (GetDlgItemText(hDialog,IDC_EDIT1,tmpstring,5))
        w1 = (UWORD) iGet_Hex(tmpstring);
    else w1 = 0;
    // offset
    if (GetDlgItemText(hDialog,IDC_EDIT2,tmpstring,5))
        w2 = (UWORD) iGet_Hex(tmpstring);
    else w2 = 0;
    //test w1/w2 secteur/offset
    if (!Is_Wrong_SectorOffset(hDialog,w1,w2,1,0)) return FALSE;
    lpD_P->FSect = w1;
    w4 = w1;
    // on garde w2 pour prochain test sur offset
    // start adresse
    if (GetDlgItemText(hDialog,IDC_EDIT3,tmpstring,5))
       w1 = (UWORD) iGet_Hex(tmpstring);
    else w1 = 0;
    lpD_P->FMemAdd = w1;

    // arret sur adresse mmoire ?
    l = (BOOL)(IsDlgButtonChecked(hDialog,IDC_RADIOBUTTON2) & BST_CHECKED);

    // stop adress
    if (GetDlgItemText(hDialog,IDC_EDIT5,tmpstring,5))
       w1  = (UWORD) iGet_Hex(tmpstring);
    else w1 = 0;
    // check stop adress
    if ( l && (w1 < lpD_P->FMemAdd))
    {
        wsprintf(sTmpSTR,"ARFD input Error:\nInvalid last address [$%04X]!\n",w1);
        MessageBox(hDialog,sTmpSTR,szDlgBoxMain,MB_OK|MB_ICONWARNING);
        return FALSE;
    }
    lpD_P->LMemAdd = w1;

    // stop sector
    if (GetDlgItemText(hDialog,IDC_EDIT4,tmpstring,5))
        w1 = (UWORD) iGet_Hex(tmpstring);
    else w1 = 0;
    // check stop sector
    if (!l && ((w1 < lpD_P->FSect) || (w1 > AmParam.MAXSect)))
    {
        wsprintf(sTmpSTR,"ARFD input Error:\nInvalid last sector [$%03X]!\n",w1);
        MessageBox(hDialog,sTmpSTR,szDlgBoxMain,MB_OK|MB_ICONWARNING);
        return FALSE;
    }
    lpD_P->LSect = w1;

    // bytes/sector
    if (IsDlgButtonChecked(hDialog,IDC_RADIOBUTTON5) & BST_CHECKED)
        {
        if (GetDlgItemText(hDialog,IDC_EDIT6,tmpstring,5))
         	w1 = (UWORD) iGet_Hex(tmpstring);
        else w1 = (UWORD) (SectSize + 1);
        // Check byte/sect
        if ((w1 > (SectSize + 1)) || (w1 < 1))
        		 w1 = (UWORD) (SectSize + 1);
        lpD_P->BytPerSect = w1;
        }
    else if (IsDlgButtonChecked(hDialog,IDC_RADIOBUTTON4) & BST_CHECKED)
        lpD_P->BytPerSect = (UWORD) (SectSize - 2);
    else lpD_P->BytPerSect = (UWORD) (SectSize + 1);

    // Check offset par rapport   byte/sector
    w3 = Size_Of_Sector(w4);
    if (w2 > w3)
    {
        wsprintf(sTmpSTR,"ARFD input Error:\nOffset of first sector [$%02X] greater than max sector byte [$%02X]!\n",w2,w3);
        MessageBox(hDialog,sTmpSTR,szDlgBoxMain,MB_OK|MB_ICONWARNING);
        return FALSE;
    }
    w3 = lpD_P->BytPerSect;
    if (w2 > (w3-1))
    {
        wsprintf(sTmpSTR,"ARFD input Error:\nOffset of first sector + 1 ($%02X) greater than byte per sector number ($%02X)!\n",w2+1,w3);
        MessageBox(hDialog,sTmpSTR,szDlgBoxMain,MB_OK|MB_ICONWARNING);
        return FALSE;
    }

    //OK ! mise en mmoire
    lpD_P->SOff = w2;
    lpD_P->DisMem = l;
    lpD_P->Mnemo =
        (BOOL)(IsDlgButtonChecked(hDialog,IDC_CHECKBOX1) & BST_CHECKED);
    lpD_P->ShowFilePos =
        (BOOL)(IsDlgButtonChecked(hDialog,IDC_CHECKBOX2) & BST_CHECKED);
    lpD_P->EnhancedCode =
        (BOOL)(IsDlgButtonChecked(hDialog,IDC_CHECKBOX3) & BST_CHECKED);

    return TRUE;
 }
//==============================================================================
//
// 							ROM FILE PARAMETER/INFO DIALOGBOX FUNCTIONS
//
//==============================================================================
//------------------------------------------------------------------------------
//Param dialog box initialization setting:
void Set_Param_Dialog(HWND hDialog)
 {
    UWORD nsect;
    UWORD nbyte;
    //CheckDlgButton(hDialog,IDC_CHECKBOX60,BST_CHECKED); // options conversions
    //SetDlgItemText(hDialog,IDC_COMBOBOX60,"Make your selection choice below...");
    ComboBox_AddString(GetDlgItem(hDialog,IDC_COMBOBOX60),sCOMBO_0);
    ComboBox_AddString(GetDlgItem(hDialog,IDC_COMBOBOX60),sCOMBO_1);
    ComboBox_AddString(GetDlgItem(hDialog,IDC_COMBOBOX60),sCOMBO_2);
    EnableWindow(GetDlgItem(hDialog,IDC_RADIOBUTTON62),FALSE);
    EnableWindow(GetDlgItem(hDialog,IDC_RADIOBUTTON63),FALSE);
    if (bATRFlag) SetDlgItemText(hDialog,IDC_CHECKBOX60,"File conversion into XFD");
    if (bNewFileParam)
    {
         SetDlgItemText(hDialog,IDC_EDIT60,"Please enter the format of the new Atari Rom file:");
        	SetDlgItemText(hDialog,IDC_EDIT61,"410");
        	ComboBox_SetCurSel(GetDlgItem(hDialog,IDC_COMBOBOX60),1);
        	// byte per sector
        	CheckRadioButton(hDialog,IDC_RADIOBUTTON62,
                IDC_RADIOBUTTON63,IDC_RADIOBUTTON62);
        	// Format predefined / manual
        	CheckRadioButton(hDialog,IDC_RADIOBUTTON60,
                IDC_RADIOBUTTON61,IDC_RADIOBUTTON60);
        	EnableWindow(GetDlgItem(hDialog,IDC_COMBOBOX60),TRUE);
    		EnableWindow(GetDlgItem(hDialog,IDC_EDIT61),FALSE);
    		EnableWindow(GetDlgItem(hDialog,IDC_RADIOBUTTON60),TRUE);
    		EnableWindow(GetDlgItem(hDialog,IDC_RADIOBUTTON61),TRUE);
    }
    else if (!bFileMem &&!bNewFileParam)  // pas de fichiers en mmoire
    {
        	SetDlgItemText(hDialog,IDC_EDIT60,"No File in Memory...");
        	SetDlgItemText(hDialog,IDC_EDIT61,"410");
        	ComboBox_SetCurSel(GetDlgItem(hDialog,IDC_COMBOBOX60),1);
        	// byte per sector
        	CheckRadioButton(hDialog,IDC_RADIOBUTTON62,
                IDC_RADIOBUTTON63,IDC_RADIOBUTTON62);
        	// Format predefined / manual
        	CheckRadioButton(hDialog,IDC_RADIOBUTTON60,
                IDC_RADIOBUTTON61,IDC_RADIOBUTTON61);
        	EnableWindow(GetDlgItem(hDialog,IDC_COMBOBOX60),FALSE);
    		EnableWindow(GetDlgItem(hDialog,IDC_EDIT61),FALSE);
    		EnableWindow(GetDlgItem(hDialog,IDC_RADIOBUTTON60),FALSE);
    		EnableWindow(GetDlgItem(hDialog,IDC_RADIOBUTTON61),FALSE);
    }
    else if (bFileMem && !bNewFileParam)          // fichier en mmoire
    {
        nsect = AmParam.MAXSect;
        nbyte = AmParam.NBytSect;
        if (bATRFlag) wsprintf(lpsTmpCB,"File loaded in memory has an ATR Rom header: ");
        else wsprintf(lpsTmpCB,"File loaded in memory is a standard XFD Rom: ");
        wsprintf(sTmpSTR,"\r\nFilename   \t\t: %s ",AmParam.FName);
        strcat(lpsTmpCB,sTmpSTR);
        wsprintf(sTmpSTR,"\r\nFile Length\t\t: $%X (%ld) Bytes",
            iFileLength,iFileLength);
        strcat(lpsTmpCB,sTmpSTR);
        wsprintf(sTmpSTR,"\r\nAtari Disk Length\t\t: $%X (%ld) Bytes / $%ld Kb",
            AmParam.MAXFL,AmParam.MAXFL,AmParam.MAXFL/1024);
        strcat(lpsTmpCB,sTmpSTR);
        wsprintf(sTmpSTR,"\r\nNumber of Sector\t\t: $%X (%ld) Sectors",
            AmParam.MAXSect,nsect);
        strcat(lpsTmpCB,sTmpSTR);
        wsprintf(sTmpSTR,"\r\nSector Size\t\t: $%X (%ld) Bytes per Sector",
            AmParam.NBytSect,nbyte);
        strcat(lpsTmpCB,sTmpSTR);
        SetDlgItemText(hDialog,IDC_EDIT60,lpsTmpCB);
        wsprintf(sTmpSTR,"%03X",nsect);
        SetDlgItemText(hDialog,IDC_EDIT61,sTmpSTR);
        //nbyte = SectSize + 1 = AmParam.NBytSect;
        if (nbyte == 256)
        // byte per sector
            CheckRadioButton(hDialog,IDC_RADIOBUTTON62,
                IDC_RADIOBUTTON63,IDC_RADIOBUTTON63);
        else
            CheckRadioButton(hDialog,IDC_RADIOBUTTON62,
                IDC_RADIOBUTTON63,IDC_RADIOBUTTON62);
        // Format predefined / manual
        if ((nsect == 720) && (nbyte == 128))
        {
    			CheckRadioButton(hDialog,IDC_RADIOBUTTON60,
                IDC_RADIOBUTTON61,IDC_RADIOBUTTON60);
        		ComboBox_SetCurSel(GetDlgItem(hDialog,IDC_COMBOBOX60),0);
            EnableWindow(GetDlgItem(hDialog,IDC_EDIT61),FALSE);
        }
        else if ((nsect == 720) && (nbyte == 256))
        {
    			CheckRadioButton(hDialog,IDC_RADIOBUTTON60,
                IDC_RADIOBUTTON61,IDC_RADIOBUTTON60);
        		ComboBox_SetCurSel(GetDlgItem(hDialog,IDC_COMBOBOX60),2);
            EnableWindow(GetDlgItem(hDialog,IDC_EDIT61),FALSE);
        }
        else if ((nsect == 1040) && (nbyte == 128))
        {
    			CheckRadioButton(hDialog,IDC_RADIOBUTTON60,
                IDC_RADIOBUTTON61,IDC_RADIOBUTTON60);
        		ComboBox_SetCurSel(GetDlgItem(hDialog,IDC_COMBOBOX60),1);
            EnableWindow(GetDlgItem(hDialog,IDC_EDIT61),FALSE);
        }
        else  // MANUAL : sector size = 128 or 256, nbr of sector = AmParam.MAXSect
        {
        		// Format predefined / manual
    			CheckRadioButton(hDialog,IDC_RADIOBUTTON60,
                IDC_RADIOBUTTON61,IDC_RADIOBUTTON61);
        		ComboBox_SetCurSel(GetDlgItem(hDialog,IDC_COMBOBOX60),1);
            // byte per sector
    			CheckRadioButton(hDialog,IDC_RADIOBUTTON62,
                IDC_RADIOBUTTON63,((nbyte == 256) ? IDC_RADIOBUTTON63 : IDC_RADIOBUTTON62));
            EnableWindow(GetDlgItem(hDialog,IDC_COMBOBOX60),FALSE);
            EnableWindow(GetDlgItem(hDialog,IDC_RADIOBUTTON62),TRUE);
    		   EnableWindow(GetDlgItem(hDialog,IDC_RADIOBUTTON63),TRUE);
        }
    }
    // desactiver File conversion :
    EnableWindow(GetDlgItem(hDialog,IDC_CHECKBOX60),FALSE);
    EnableWindow(GetDlgItem(hDialog,IDC_CHECKBOX61),FALSE);
    EnableWindow(GetDlgItem(hDialog,IDC_BUTTON61),FALSE);
}
//------------------------------------------------------------------------------
//Enable convertion item in the Param dialog box
void Enable_Conversion(HWND hDialog)
{
    EnableWindow(GetDlgItem(hDialog,IDC_CHECKBOX60),TRUE);
    EnableWindow(GetDlgItem(hDialog,IDC_CHECKBOX61),TRUE);
    EnableWindow(GetDlgItem(hDialog,IDC_BUTTON61),TRUE);
}
//------------------------------------------------------------------------------
//Change the filename extension in the ''lpszTheString'' into ''cinto''
void Change_FileExtension(char cinto, LPSTR lpszTheString)
{
	LPSTR ps;
   LPSTR istr;
   istr = NULL;
	ps   = lpszTheString;
	while (*ps) //tant que l'on est pas en fin de chaine
   {
		if (*ps == '.')    // chercher un '.'
      {
      	ps++;
         istr = ps;
      }
      else ps++;
   }
   if ((!istr) ||(* istr == '\0')) return; //no extension
   if (cinto == 'A')
   {
    if (!strcmp(istr,"xfd") || !strcmp(istr,"XFD"))
    	strcpy(istr,"atr");
   }
   else if (cinto == 'X')
   {
    if (!strcmp(istr,"atr") || !strcmp(istr,"ATR"))
    	strcpy(istr,"xfd");
   }
}
//------------------------------------------------------------------------------
void Convert_Rom_Type_and_Size(BOOL bRomFormat, UWORD ns, UWORD nb)
//Boite de dialogue Paramtres Conversion avec changement de taille :
// on change les paramtres en mmoire,
// les noms de fichiers en mmoire aussi.
{
   	if (bRomFormat) // changer de XFD vers ATR ou inversement (format de Rom)
    	{
    		if (bATRFlag)  //C'est un ATR  convertir en XFD
      	{
      		Shift_Memory(0,0,-16,0);
            Change_FileExtension('X',AmParam.FName);
            Change_FileExtension('X',(LPSTR) szAtariFileName);
      	}
     	 	else    //C'est un XFD  convertir en ATR
    		{
      		Shift_Memory(0,0,+16,0);
         	Make_ATR_Header(ns, nb);
            Change_FileExtension('A',AmParam.FName);
         	Change_FileExtension('A',(LPSTR) szAtariFileName);
      	}
      	bATRFlag = !bATRFlag;
   	}
    	else //Pas de changement de type
    	{
      	if (bATRFlag) Make_ATR_Header(ns, nb);  //Refaire le header ATR
    	}
    	// Ajustement de la taille
    	AmParam.MAXSect = ns;
    	AmParam.MAXFL = ns * nb;
    	SectSize = (UWORD) (nb - 1);
    	AmParam.NBytSect = nb;
    	if (bATRFlag) iFileLength = AmParam.MAXFL + 16;
    	else iFileLength = AmParam.MAXFL;

      //Enable the ATR HEADER MENU:
      if (bATRFlag)
        	EnableMenuItem(ModMenu,CM_ATRSHOW,MF_BYCOMMAND|MF_ENABLED);
    	else
         EnableMenuItem(ModMenu,CM_ATRSHOW,MF_BYCOMMAND|MF_GRAYED);
}
//------------------------------------------------------------------------------
void Convert_Rom_Type()
//simple conversion de nom, pas de changement de taille,
// initi par la procdure de sauvegarde de fichiers XFD ou ATR
// changement de nom dans la procdure Save_The_Atari_File
{
    	if (bATRFlag) //C'est un ATR  convertir en XFD
      {
      	Shift_Memory(0,0,-16,0);
         iFileLength = AmParam.MAXFL;
      }
      else //C'est un XFD  convertir en ATR
      {
      	Shift_Memory(0,0,+16,0);
      	Make_ATR_Header(AmParam.MAXSect, AmParam.NBytSect);
         iFileLength = AmParam.MAXFL + 16;
      }
      bATRFlag = !bATRFlag;

      //Enable the ATR HEADER MENU:
      if (bATRFlag)
        	EnableMenuItem(ModMenu,CM_ATRSHOW,MF_BYCOMMAND|MF_ENABLED);
    	else
         EnableMenuItem(ModMenu,CM_ATRSHOW,MF_BYCOMMAND|MF_GRAYED);
}
//------------------------------------------------------------------------------
//Get Parameter DialogBox Data
void Get_Param_Dialog(HWND hDialog)
{
    	BOOL btoatrxfd,btrunc;
    	UWORD nsize, nsect;
    	int i;
    	char tmps[8];
    	// combo box
    	if (IsDlgButtonChecked(hDialog,IDC_RADIOBUTTON60) & BST_CHECKED)
    	{
    		i = ComboBox_GetCurSel(GetDlgItem(hDialog,IDC_COMBOBOX60));
         switch (i)
         {
         	case 0:
            	nsect = 720;
               nsize = 128;
               break;
            case 2:
            	nsect = 720;
               nsize = 256;
               break;
            case 1:
            default:
            	nsect = 1040;
               nsize = 128;
               break;
         }
    	}
    	// manual
    	if (IsDlgButtonChecked(hDialog,IDC_RADIOBUTTON61) & BST_CHECKED)
    	{
    	  	if (GetDlgItemText(hDialog,IDC_EDIT61,tmps,5))
           nsect = (UWORD) iGet_Hex(tmps);
        	else nsect = 0;
        	if ((nsect > 0x410) || (nsect < 1))
        	{
        		MessageBox(hDialog, "ARFD input Error:\nInvalid number of sector",
     				"File conversion Dialog :",MB_OK | MB_ICONWARNING);
        		return;
        	}
        	if (IsDlgButtonChecked(hDialog,IDC_RADIOBUTTON62) & BST_CHECKED)
    		 nsize = 128;
        	else
    		 nsize = 256;
		}
    	// Est-on en pleine conversion ou dans un nouveau fichier?
      // -> on est dans nouveau fichier:
    	if (bNewFileParam)
    	{
    		SectSize = (UWORD) (nsize - 1);
      	iNewSect = nsect;
      	return; // fin de la procedure en cas de Nouveau Fichier...
    	}
      
		// -> on est dans une conversion:
		btrunc = (BOOL)(IsDlgButtonChecked(hDialog,IDC_CHECKBOX61) & BST_CHECKED);
    	if (btrunc)
    	{
       	View_DiskMap(NULL,&nsect);    //pas d'affichage dans hMainRText car NULL est transmis
    	}
    	btoatrxfd = (BOOL)(IsDlgButtonChecked(hDialog,IDC_CHECKBOX60) & BST_CHECKED);

    	strcpy(lpsTmpCB," File conversion with the following parameters:\n");
    	wsprintf(sTmpSTR," - Max Sector : $%03X, Sector size : $%03X,\n", nsect, nsize);
    	strcat(lpsTmpCB,sTmpSTR);
    	if (btrunc) strcat(lpsTmpCB," - Truncate the file at the last non-empty sector,\n");
    	else strcat(lpsTmpCB," - No automatic file truncating,\n");
    	if (btoatrxfd  & bATRFlag) strcat(lpsTmpCB," - File conversion from ATR to XFD Rom format,\n");
    	else if (btoatrxfd  & !bATRFlag) strcat(lpsTmpCB," - File conversion from XFD to ATR Rom format,\n");
    	else strcat(lpsTmpCB," - No ATR or XFD conversion,\n");
    	if (nsize != (SectSize+1))
    	{
    	 	strcpy(sTmpSTR," Warning: The changing of sector size may induce\n wrong and unrunable Atari DOS Format!\n");
       	strcat(lpsTmpCB,sTmpSTR);
    	}
      strcpy(sTmpSTR,lpsTmpCB);
    	strcat(lpsTmpCB,"\nClick OK to convert the current file?");
    	if (MessageBox(hDialog,lpsTmpCB,
        "File Conversion Dialog :",MB_OKCANCEL | MB_ICONQUESTION) != IDOK)
    	return;

      Add_EndRichText(hMainRText," \r\n FILE CONVERSION: \r\n ");
    	Add_EndRichText(hMainRText,sTmpSTR);

    	//conversion...
    	Convert_Rom_Type_and_Size(btoatrxfd, nsect, nsize);

    	bFileModified = TRUE;
    	bConvertFile = FALSE;

      //Afficher le texte Nom de Fichier en titre de la fenetre + StatusBar:
      Set_Windows_Title(AmParam.FName);

      iCurSect = 1;
      Reset_Edit_Sector(TRUE);
}

//==============================================================================
//
// 						IMPORT AND EXPORT DIALOG FUNCTIONS
//
//==============================================================================
//------------------------------------------------------------------------------
// Initialization of the Import/Export dialog box
void Set_ImportParam_Dialog(HWND hDialog)
{
    char tmpstring[10] = "";
    SetDlgItemText(hDialog,IDCEX_EDIT1,lpInt_To_Char(IEData.IE_FS,tmpstring));
    SetDlgItemText(hDialog,IDCEX_EDIT2,lpInt_To_Char(IEData.IE_FO,tmpstring));
    SetDlgItemText(hDialog,IDCEX_EDIT3,lpInt_To_Char(IEData.IE_GO,tmpstring));
    //SetDlgItemText(hDialog,IDCEX_EDIT4,lpInt_To_Char(SectSize,tmpstring)); // or IE_LB:
    SetDlgItemText(hDialog,IDCEX_EDIT4,lpInt_To_Char(IEData.IE_LB,tmpstring));
    SetDlgItemText(hDialog,IDCEX_EDIT5,lpInt_To_Char(IEData.IE_LS,tmpstring));
    //SetDlgItemText(hDialog,IDCEX_EDIT6,lpInt_To_Char(SectSize,tmpstring)); //or IE_LO:
    SetDlgItemText(hDialog,IDCEX_EDIT6,lpInt_To_Char(IEData.IE_LO,tmpstring));
    SetDlgItemText(hDialog,IDCEX_EDIT7,lpInt_To_Char(IEData.IE_LengthSize,tmpstring));
    SetDlgItemText(hDialog,IDCEX_EDIT8,"No binary file open : please press the Open Binary File button");
    wsprintf(tmpstring,"%d",IEData.MaxDiff);
    SetDlgItemText(hDialog,IDCEX_EDIT9,tmpstring);
    CheckRadioButton(hDialog,IDCEX_RADIOBUTTON1,
                IDCEX_RADIOBUTTON2,(IEData.bFileSize ? IDCEX_RADIOBUTTON1 : IDCEX_RADIOBUTTON2));
    EnableWindow(GetDlgItem(hDialog,IDCEX_EDIT5),!IEData.bFileSize);
    EnableWindow(GetDlgItem(hDialog,IDCEX_EDIT6),!IEData.bFileSize);
}
// Get the data in the Import/Export dialog box
BOOL Get_ImportParam_Dialog(HWND hDialog)
{
    int i;
    char tmpstring[16] = "";
    UWORD uw[6];
    if (!bBinFileInMem)
    {
       MessageBox(hDialog,"Please enter a binary file to open...",szDlgBoxMain,MB_OK);
       return FALSE;
    }
    //if (bImportData)
    //   SetDlgItemText(hDialog,IDCEX_EDIT7,lpInt_To_Char(iBinFileLn,tmpstring));
    // ne pas afficher sa longueur si bImportData ????
     
    // Les secteurs et offsets
    for (i = 0; i < 7; i++ )
    {
        if (GetDlgItemText(hDialog,(IDCEX_EDIT1 + i),tmpstring,5))
        		uw[i] = (UWORD) iGet_Hex(tmpstring);
        else uw[i] = 0;
    }
    // le data length size (for the file)
    if (GetDlgItemText(hDialog,IDCEX_EDIT7,tmpstring,8))
        IEData.IE_LengthSize = iGet_Hex(tmpstring);
    else IEData.IE_LengthSize = 0;
    //test w1/w2 secteur/offset
    if (!Is_Wrong_SectorOffset(hDialog,uw[0],uw[1],1,0))
    	return FALSE;
    if (!IEData.bFileSize)
    {
        if (!Is_Wrong_SectorOffset(hDialog,uw[4],uw[5],uw[0],0))
    			return FALSE;
        if ((uw[0] > uw[4]) || ((uw[0] == uw[4]) && (uw[1] > uw[5])))
        {
            MessageBox(hDialog,"ARFD input Error:\nInvalid end sector / offset!",
            	szDlgBoxMain,MB_OK|MB_ICONWARNING);
            return FALSE;
        }
    }
    else
    {
        if (bImportData && ((IEData.IE_LengthSize < 1) || (IEData.IE_LengthSize > AmParam.MAXFL)))
        {
            MessageBox(hDialog,"ARFD input Error:\nInvalid data bytes length!",
            	szDlgBoxMain,MB_OK|MB_ICONWARNING);
            return FALSE;
        }
    }
    if ( (uw[2] > SectSize) || (uw[3] > SectSize) || (uw[2] > uw[3]) || (uw[1] > uw[3]) )
    {
         MessageBox(hDialog,"ARFD input Error:\nInvalid first or general offset for the last byte number!",
         	szDlgBoxMain,MB_OK|MB_ICONWARNING);
         return FALSE;
    }
    if (bWantToCompare)
    {
       (GetDlgItemText(hDialog,IDCEX_EDIT9,tmpstring,5));
       i = iGet_Dec(tmpstring);
       if ((i < 1) || (i > 1024))
       {
       	MessageBox(hDialog,
         	"ARFD input Error:\nInvalid number of differences for compare!\n(Values are from 1 to 1024 decimal)",
         	szDlgBoxMain,MB_OK|MB_ICONWARNING);
         return FALSE;
       }
       else IEData.MaxDiff = i;

    }
    IEData.IE_FS = uw[0];
    IEData.IE_FO = uw[1];
    IEData.IE_GO = uw[2];
    IEData.IE_LB = uw[3];
    IEData.IE_LS = uw[4];
    IEData.IE_LO = uw[5];

    return TRUE;
}
// Open a binary file for the Import/Export operation
BOOL Open_Binary_File(HWND hDialog, BOOL bWrite)
{
      BOOL bResult;
      char szDialogTitle[64];
      if (bWrite)
      {
         strcpy(szDialogTitle,"Open filename for saving binary data file :");
         strcpy(szTheBinaryFilename,"Export.dat");
      }
      else
      {
         strcpy(szDialogTitle,"Open filename for binary data file to read :");
   		strcpy(szTheBinaryFilename,"");
      }
      memset(szFileFilter,0x00,128);
   	LoadString(hInstance,STRG_FILEFILTER_FON,szFileFilter,128);

   	bResult = Get_FileName(hDialog, (LPSTR) szTheBinFile,
   				szFileFilter, (LPSTR) szTheBinaryFilename,
   				szDialogTitle, !bWrite, FALSE, 1);
      if (!bResult)
		{
            MessageBox(hDialog, "ARFD file opening Warning:\nNo valid binary Data filename open!",
            szDlgBoxMain,MB_OK|MB_ICONINFORMATION);
         	return FALSE;
      }

      if (bWrite)
      {
      	bResult = Create_File(hDialog, szTheBinFile, szDialogTitle, 'W', &hBinFile);
      }
      else
      {
         bResult = Create_File(hDialog, szTheBinFile, szDialogTitle, 'R', &hBinFile);
      }
      if (!bResult) return FALSE;

      if (!bWrite)
      {
      	iBinFileLn = GetFileSize(hBinFile,NULL);
    		if (iBinFileLn > 266256)
    		{
        		Close_File(&hBinFile);
        		MessageBox(hDialog, "ARFD file opening error:\nThe binary file size is more than 260Kb (266256) bytes!",
            	szDialogTitle,MB_OK|MB_ICONERROR);
            return FALSE;
         }
      }
      return TRUE;
}
//------------------------------------------------------------------------------
// Import and Export Main function:
//
BOOL ImportExport_Data(HWND hDialog)
{
      UINT  ipos;
      int DBSize, count, diff;
      char szDlgTitle[64];
      static DWORD dwTmp,dwError;
      static UBYTE ub;
      static UWORD uws,uwb,nSecteur;
      static OVERLAPPED ovl;

      BOOL  bResult = TRUE;

      ZeroMemory(&ovl,sizeof(ovl));      // clearing the overlapped
      ovl.Offset     = 0;
		ovl.hEvent     = NULL;

      if (bWantToCompare)
      {
         strcpy(szDlgTitle,"Read and Compare Data :");
      	bFoundDifferent = FALSE;
         diff = 0;
         wsprintf(sTmpSTR,"You have chosen Comparing data :\n(Stop after %d differences)\nAre you sure to continue ?", IEData.MaxDiff);
         if (MessageBox(hDialog,sTmpSTR, szDlgTitle ,MB_YESNO | MB_ICONQUESTION) != IDYES)
            	return FALSE;
      	Add_EndRichText(hMainRText,"\r\n COMPARING DATA : ");
      }
      else
      {
         strcpy(szDlgTitle,(bImportData ? "Import Data :" : "Export Data :"));
         strcpy(sTmpSTR,"Click OK to launch the ");
         strcat(sTmpSTR, (bImportData ? "IMPORT" : "EXPORT"));
         strcat(sTmpSTR," operation?");
         if (MessageBox(hDialog, sTmpSTR, szDlgTitle, MB_OKCANCEL|MB_ICONQUESTION) != IDOK)
         	return FALSE;
         wsprintf(sTmpSTR,(bImportData ? "\r\n IMPORT (READ) DATA : " : "\r\n EXPORT (WRITE) DATA : "));
         Add_EndRichText(hMainRText,sTmpSTR);
      }

      count = 0;
      uws = IEData.IE_FS;
      uwb = IEData.IE_FO;
      ipos = Get_FilePosition(uws,uwb);

      if (IEData.bFileSize) //DBSize si taille de fichier spcifie :
      {
      	DBSize = IEData.IE_LengthSize;
      }
      else  // Calcul de DBSize si taille de fichier non spcifie :
      {
      	nSecteur = (UWORD) (IEData.IE_LS - IEData.IE_FS + 1);
         if (nSecteur >1)
         	DBSize = (IEData.IE_LB - IEData.IE_FO + 1)
            		+ (nSecteur-2) * (IEData.IE_LB - IEData.IE_GO + 1)
                  + (IEData.IE_LO - IEData.IE_GO + 1);
         else
         {
            DBSize = (IEData.IE_LO - IEData.IE_FO + 1);
            IEData.IE_LB = IEData.IE_LO;
         }
         IEData.IE_LengthSize =  DBSize;
      }

      // Pas de taille de fichier ouvert si exportation.
      if (!bImportData) iBinFileLn = DBSize;

      //Boucle principale
      while (count < DBSize)
      {

         //test de boucle...
         if (bImportData && (count >= iBinFileLn)) //EOF read PC file !!!
         {
                 MessageBox( hDialog,
         	 			"ARFD Info: Stopping!\nEnd Of File encounted in the binary file.",
             	 		szDlgTitle, MB_OK|MB_ICONINFORMATION);
                 break;
         }
         if ( (uwb > IEData.IE_LB) && ! ((!IEData.bFileSize) && (uws == IEData.IE_LS)) )
         // Si on a atteint IE_LB (last byte of the sector)
         // et si on est PAS au dernier secteur (et avec !IEData.bFileSize : fin par secteur:offset)
         // alors on change de secteur.
         // (dans le cas contraire, la fin de la boucle sera atteinte
         // par count qui atteint le DBSize calcul)
         {
         	 uws ++;
             uwb = IEData.IE_GO;

             ipos = Get_FilePosition(uws,uwb);
             if (ipos == 0) //EOF memory!
             {
                 MessageBox( hDialog,
         	 			"ARFD Info: Stopping!\nEnd Of File encounted from Atari Rom file memory.",
             	 		szDlgTitle, MB_OK|MB_ICONINFORMATION);
                 break;
             }
         }

         // lecture ou ecriture des donnes...
         ovl.Offset = (DWORD) count;
         // utiliser plutt SetFilePointer() car ovl.Offset ne marche pas ?????????
         /* DWORD SetFilePointer(
    				HANDLE hFile,	// handle of file
    				LONG lDistanceToMove,	// number of bytes to move file pointer
    				PLONG lpDistanceToMoveHigh,	// address of high-order word of distance to move
    				DWORD dwMoveMethod 	// how to move
   				); */

         if (bImportData) // import
         {
    			bResult = ReadFile(hBinFile,  // handle of file to read
            	(LPVOID) &ub,              // address of buffer that receives data
            	(DWORD) 1,                 // number of bytes to read
       			(LPDWORD) &dwTmp,          // address of number of bytes read
            	(LPOVERLAPPED) NULL);      // address of OVL structure for data
            if (!bResult)  //bResult == 0 : failed!
            {
            	dwError = GetLastError();
         		break; //error
         	}
            if (bWantToCompare)
            {

               if (lpFileBuffer[ipos] != ub)
               {
               	bFoundDifferent = TRUE;
                  diff++;
                  wsprintf(sTmpSTR,"\r\n Diff #%04d - Location $%03X:$%02X - Mem $%02X / File $%02X",
                  	diff, uws, uwb, lpFileBuffer[ipos], ub);
                  Add_RichText(hMainRText,sTmpSTR);
                  if (diff >= IEData.MaxDiff) break;
               }
            }
            else
            	lpFileBuffer[ipos] = ub;
         }
         else             // export
         {
            ub = lpFileBuffer[ipos];
            bResult = WriteFile(hBinFile, //HANDLE hFile, // handle of file to read
            	(LPVOID) &ub,              //LPVOID lpBuffer,	// address of buffer that receives data
            	(DWORD) 1,                 //DWORD nNumberOfBytesToRead,	// number of bytes to read
       			(LPDWORD) &dwTmp,          //LPDWORD lpNumberOfBytesRead,	// address of number of bytes read
            	(LPOVERLAPPED) NULL);
            if (!bResult)
            {
            	dwError = GetLastError();
         		break; //error
         	}
         }
         // incrmentation
         uwb ++;
         ipos ++;
         count ++;
      }

      //C'est la fin du fichier!
      SetEndOfFile(hBinFile);
      Close_File(&hBinFile);
      bBinFileInMem = FALSE;
      SetDlgItemText(hDialog,IDCEX_EDIT8,"File closed : No binary file open");

      if (!bResult)
      {
         Handle_System_Error(hDialog, szDlgTitle, "on binary file I/O operation", dwError);
      }

      if (bWantToCompare)
      {
      	if (bFoundDifferent)
         {
            Add_EndRichText(hMainRText," \r\n ");
            wsprintf(sTmpSTR,"Data were different: %d differences found for $%X (%d) bytes compared.", diff, count, count);
      	}
         else
            wsprintf(sTmpSTR,"Data were identical: No differences found.");
      }
      else
      {
      	wsprintf(sTmpSTR,"OK Done! with $%X (%d) bytes ",count,count);
      	strcat(sTmpSTR,(bImportData ? "imported." : "exported."));

      }
      MessageBox( hDialog, sTmpSTR,	szDlgTitle, MB_OK|MB_ICONINFORMATION);
      Add_EndRichText(hMainRText,sTmpSTR);
      Add_EndRichText(hMainRText," \r\n ");
      return TRUE;
}

//==============================================================================
//
// 							SEARCH AND REPLACE FUNCTIONS
//
//==============================================================================

BOOL Get_SearchReplace_Param_Dialog(HWND hDialog)
{
   int i,j;
   char * lptmp;
	i = GetWindowTextLength(GetDlgItem(hDialog,IDC_EDIT40));
   if (SRData.bReplace)
   	j = GetWindowTextLength(GetDlgItem(hDialog,IDC_EDIT41));
   else j = 1;
   if (!i || !j)
   {
      MessageBox(hDialog,"ARFD input Error:\nInvalid empty string!","Input String :",MB_OK|MB_ICONWARNING);
      return FALSE;
   }
   SRData.bPrompt = (BOOL)(IsDlgButtonChecked(hDialog,IDC_CHECKBOX40) & BST_CHECKED);
   if (IsDlgButtonChecked(hDialog,IDC_RADIOBUTTON41) & BST_CHECKED)
   {
   	SRData.SR_FS = iCurSect;
      SRData.SR_LS = iCurSect;
   }
   else if (IsDlgButtonChecked(hDialog,IDC_RADIOBUTTON42) & BST_CHECKED)
   {
   	SRData.SR_FS = 1;
      SRData.SR_LS = AmParam.MAXSect;
   }
   else // lire le premier et le dernier secteur
   {
        if (GetDlgItemText(hDialog,(IDC_EDIT42),sTmpSTR,5))
        		SRData.SR_FS = (UWORD) iGet_Hex(sTmpSTR);
        else SRData.SR_FS = 0;
        if (GetDlgItemText(hDialog,(IDC_EDIT43),sTmpSTR,5))
        		SRData.SR_LS = (UWORD) iGet_Hex(sTmpSTR);
        else SRData.SR_LS = 0;
        if ((SRData.SR_FS < 1) || (SRData.SR_FS > AmParam.MAXSect) ||
        	 (SRData.SR_LS < 1) || (SRData.SR_LS > AmParam.MAXSect) || (SRData.SR_LS < SRData.SR_FS))
   	  {
      		MessageBox(hDialog,"ARFD input Error:\nInvalid sector number!","Input Sector :",MB_OK|MB_ICONWARNING);
      		return FALSE;
   		}
   }

   if (SRData.bAscii)
   {
      if (i > 16) i = 16;
      GetDlgItemText(hDialog,IDC_EDIT40,szInputDataString,i+1);
      szInputDataString[16]= 0;   //truncate
      strcpy(SRData.cSearchDB,szInputDataString);  // !! Char et UBYTE ???
      SRData.nSearchDB = strlen(szInputDataString);
      if (SRData.bReplace)
      {
      	if (j > 16) j = 16;
         GetDlgItemText(hDialog,IDC_EDIT41,szInputDataString,j+1);
         szInputDataString[16]= 0;   //truncate
         strcpy(SRData.cReplaceDB,szInputDataString);  // !! Char et UBYTE ???
         SRData.nReplaceDB = strlen(szInputDataString);
      }
   }
   else // c'est de l'Hexa
   {
      if (i > 48) i = 48;
      lptmp = SRData.cSearchDB;
      GetDlgItemText(hDialog,IDC_EDIT40,szInputDataString,i+1);
      SRData.nSearchDB = Get_Data_Line(lptmp,szInputDataString);
      if (SRData.bReplace) // il faut lire la 2eme chaine de remplacement
      {
      	if (j > 48) j = 48;
         lptmp = SRData.cReplaceDB;
         GetDlgItemText(hDialog,IDC_EDIT41,szInputDataString,j+1);
			SRData.nReplaceDB = Get_Data_Line(lptmp,szInputDataString);
      }
      if (!SRData.nSearchDB || (!SRData.nReplaceDB && SRData.bReplace))
   	{
      	MessageBox(hDialog,"ARFD input Error:\nInvalid empty string!","Input String :",MB_OK|MB_ICONWARNING);
      	return FALSE;
   	}
   }
   wsprintf(sTmpSTR,"%s\nClick OK to start?",szSRTitle[iSearchMode-1]);
   if (MessageBox(hDialog,sTmpSTR,szSRTitle[iSearchMode-1],MB_OKCANCEL|MB_ICONQUESTION) != IDOK)
   	return FALSE;
   return TRUE;

}
//Continue Data searching (for Edit Sector)
void Cont_Data_Searching(HWND hwnd, UWORD uAS, UWORD uAI)
{
      SRData.iSearchPos = Get_FilePosition(uAS,uAI); //Continuer  la position courante
		if (Search_Data(hwnd, &SRData, FALSE, hMainRText)) //FALSE = Continuer la recherche
         // annuler la recherche en cours car fin de fichier atteind
         // avec Search_Data return TRUE  la fin du fichier
         bSearchInProgress = FALSE;
}
//Recherche et remplacement + mask XOR procdure + Fill with data
void Data_Searching(HWND hwnd)
{
      //DialogBox de commande et des paramtres d'entre
     	if (DialogBox(hInstance,"SearchDialog",
               	 hwnd, (DLGPROC)SearchDlgProc) != IDOK) return;

      // On demarre une nouvelle recherche ou remplissage:

      if (iSearchMode < 3)
         // C'est le cas de la recherche HEXA et ASCII sans remplacement
      	bSearchInProgress = TRUE; //permet la continuation
      else
      	bSearchInProgress = FALSE; //on ne permet pas la fentre continue search

   	if (Search_Data(hwnd, &SRData, TRUE, hMainRText)) // TRUE = Nouvelle operation en cours
      {
         //Search_Data retourne TRUE si fin de zone de recherche atteind
         //Annuler la recherche en cours car fin de fichier atteind
         // avec Search_Data return TRUE  la fin du fichier
      	bSearchInProgress = FALSE;
         Reset_Edit_Sector(FALSE);
      }
}
/****************** FOR SEARCH & REPLACE REMINDER ******************************
   SRData structure:
   	UWORD SR_FS; //FirstSect;
   	UWORD SR_LS; //LastSect;
   	int   nSearchDB; //number of data bytes to search
   	int   nReplaceDB; //number of data bytes for replacement
   	BOOL  bReplace; // TRUE for replace, if FALSE : search
   	BOOL  bPrompt; // Prompt on replace
   	BOOL  bAscii;  // TRUE for ASCII search, if FALSE : Hex Search
   	UINT  iSearchPos; // Last Search position index
      // tableau de donn  chercher pour fonction "rechercher" :
   	char  cSearchDB [16]; // search data bytes
      // tableau de donn  chercher pour fonction "remplacer":
   	char  cReplaceDB [16]; // replace data bytes
   	} TSRDATA;  // Search/Replace data structure
   //***************************************
   //variables globales pour les recherches ASCII/HEXA (ARFDMain.cpp)
   	BOOL   bSearchInProgress;     // Flag de recherche en cours
   	int    nSearchDataBytes;      // selected data length
   	int    iSearchMode;           // type de recherche et remplacement
   //****************************************
   //Variables locales  AmDialog.cpp:
   	static char szInputDataString[48] = "";


*******************************************************************************/

//==============================================================================
//
// 								ATARI DIRECTORY LIST VIEW FUNCTIONS
//
//==============================================================================
//Directory ListView
void DADD_ListView(HWND hlv)
{
     LV_ITEM lvi;
     char sztmp[8];
     int i;
     lvi.mask = LVIF_TEXT | LVIF_PARAM;
     for (i = 0; i < addir.nbroffile; i++)
     {
     	lvi.iItem = i;
      lvi.lParam = (LPARAM) &(addir.adf[i]);

      	lvi.iSubItem = 0;
         lvi.pszText = addir.adf[i].FName;
         lvi.cchTextMax = 100;
         ListView_InsertItem(hlv, &lvi);

         wsprintf(sztmp,"$%02X",addir.adf[i].FFlag);
         ListView_SetItemText(hlv, i, 1, sztmp);

         wsprintf(sztmp,"$%04X",addir.adf[i].FSect);
         ListView_SetItemText(hlv, i, 2, sztmp);

         wsprintf(sztmp,"$%04X",addir.adf[i].FBlock);
         ListView_SetItemText(hlv, i, 3, sztmp);
      }
}
// Get selected file data in the list view
ATARIDOSFILE * Get_Selected_Trace_File(HWND hlv)
{
 	LV_ITEM lvi;
 	int ItemData;
 	ItemData = ListView_GetNextItem(hlv, -1, LVNI_SELECTED);
 	if (ItemData < 0)
   	return NULL;
 	lvi.mask = LVIF_PARAM;
 	lvi.lParam = NULL;
 	lvi.iItem = ItemData;
   lvi.iSubItem = 0;
 	ListView_GetItem(hlv, &lvi);
   return (ATARIDOSFILE *) lvi.lParam;
}
int CALLBACK ListViewCompareFunc(
    LPARAM lParam1,
    LPARAM lParam2,
    LPARAM lParamSort) 
{
    int iCmp;
    ATARIDOSFILE * pItem1 =  (ATARIDOSFILE *) lParam1;
    ATARIDOSFILE * pItem2 =  (ATARIDOSFILE *) lParam2;

    switch (lParamSort)
    {
    	case 0:
       // Compare the specified column.
       iCmp = lstrcmpi((LPCTSTR)(pItem1->FName), (LPCTSTR)(pItem2->FName));
       return iCmp;
      case 1:
       iCmp = pItem1->FFlag - pItem2->FFlag;
       // Return the result if nonzero, or compare the
       // first column otherwise.
       return (iCmp != 0) ? iCmp : lstrcmpi((LPCTSTR)(pItem1->FName), (LPCTSTR)(pItem2->FName));
      case 2:
       iCmp = pItem1->FSect - pItem2->FSect;
       return (iCmp != 0) ? iCmp : lstrcmpi((LPCTSTR)(pItem1->FName), (LPCTSTR)(pItem2->FName));
      case 3:
       iCmp = pItem1->FBlock - pItem2->FBlock;
       return (iCmp != 0) ? iCmp : lstrcmpi((LPCTSTR)(pItem1->FName), (LPCTSTR)(pItem2->FName));
    }
}
//...DialogBox(hInstance,"DirDialog", hwnd, (DLGPROC)DirDlgProc)...
//  Atari Directory window main procedure:
BOOL CALLBACK _export DirDlgProc(HWND hDlg, UINT Message,
                             WPARAM wParam, LPARAM lParam)
{
    static HWND hLV;
    static ATARIDOSFILE * pFileSelected;
    LV_COLUMN lvc;
    char sztmp[128];
    char szDirTitle[] = "Trace Selected File :";

    switch(Message)
    {
    	case WM_INITDIALOG:
      	hLV = GetDlgItem(hDlg,IDCDIR_SYSLISTVIEW1);

         SendMessage(hLV,WM_SETFONT,(WPARAM) hfARFD,0);

         lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
         lvc.fmt = LVCFMT_LEFT;
         lvc.cx = 110;
         lvc.pszText = "File Name";
         lvc.iSubItem = 0;
         ListView_InsertColumn(hLV, 0, &lvc);
         lvc.cx = 50;
         lvc.pszText = "Flag";
         lvc.iSubItem = 1;
         ListView_InsertColumn(hLV, 1, &lvc);
         lvc.cx = 100;
         lvc.pszText = "1st sector";
         lvc.iSubItem = 2;
         ListView_InsertColumn(hLV, 2, &lvc);
         lvc.cx = 90;
         lvc.pszText = "Blocks";
         lvc.iSubItem = 3;
         ListView_InsertColumn(hLV, 3, &lvc);
            
         //Display Atari Dos Directory list view:
         DADD_ListView(hLV);

         wsprintf(sTmpSTR,
         	" Free blocks = $%03X (%d) sectors (according to DOS)\n Total number of Atari DOS files = $%02X (%d)\n Disk size is $%03X sectors",
         	addir.freeblocks, addir.freeblocks, addir.nbroffile, addir.nbroffile, AmParam.MAXSect);
         SetDlgItemText(hDlg,IDCDIR_EDIT,sTmpSTR);

         return TRUE;
        	case WM_NOTIFY:
        	#define pnm ((NM_LISTVIEW *) lParam)
        	#define pnmhdr ((NMHDR *) lParam)
         	// Branch depending on the specific notification message.
         	switch (pnmhdr->code)
         	{
               //Process the item selection changing.
               case LVN_ITEMCHANGED:
               	pFileSelected = Get_Selected_Trace_File(hLV);
                  if (pFileSelected)
                  	wsprintf(sztmp,"Name:\n '%s'\nFirst sector:\n $%03X\nBlocks:\n $%03X sectors",
                     	pFileSelected->FName,pFileSelected->FSect,pFileSelected->FBlock);
                  else strcpy(sztmp,"No selected file.");
                  SetDlgItemText(hDlg,IDCDIR_STATIC2,sztmp);
                  break;
               // Process NM_DBLCLK for tracing selection.
            	case NM_DBLCLK:
               	if (pnmhdr->hwndFrom == hLV && pnm->iSubItem == 0)
                  {
                  	pFileSelected = Get_Selected_Trace_File(hLV);
                     PostMessage(hDlg,WM_COMMAND,IDCDIR_TRACEBUTTON,0);
                  }
                  break;
        			// Process LVN_COLUMNCLICK to sort items by column.
        			case LVN_COLUMNCLICK:
            		ListView_SortItems(
                		pnm->hdr.hwndFrom,
                		ListViewCompareFunc,
                		(LPARAM) (pnm->iSubItem)
                  	);
            		break;
    			}
         	#undef pnm
            #undef pnmhdr
            break;
        case WM_COMMAND:
        {
            switch(wParam)
            {
                case IDCDIR_TRACEBUTTON:
                    if (!pFileSelected)
 								MessageBox(hDlg,"Please first select a file!",szDirTitle,MB_OK|MB_ICONINFORMATION);
                    else
                    {
                        if ((pFileSelected->FSect > AmParam.MAXSect) || (pFileSelected->FSect < 1))
                        {
                        	wsprintf(sTmpSTR,"ARFD Error:\nTracing '%s' file not possible!\nInvalid first sector $%03X",
                              pFileSelected->FName,pFileSelected->FSect);
                           MessageBox(hDlg,sTmpSTR,szDirTitle,MB_OK|MB_ICONEXCLAMATION);
                        }
                        else
                        {
                           wsprintf(sTmpSTR,"Tracing '%s' file starting at sector $%03X\nClick OK to continue?",
                              pFileSelected->FName,pFileSelected->FSect);
                    		   if (MessageBox(hDlg,sTmpSTR,szDirTitle,MB_OKCANCEL|MB_ICONQUESTION) == IDOK)
                           {
                              iCurSect = pFileSelected->FSect;
                           	SendMessage(hMainWindow,WM_COMMAND,CMDIR_TRACEFILE,0);
                           }
                        }
                    }
                    break;
                case IDCANCEL:
                case IDOK:
                    hAtariDirDlg = NULL;
                    EndDialog(hDlg, IDOK);
                    return TRUE;
            }
        }
    }
    return FALSE;
 }

//==============================================================================
//
// 				SPECIAL FILE FUNCTIONS TO OPEN AND CLOSE HANDLE
//
//==============================================================================
// System error message display.
void Handle_System_Error(HWND hwnd, LPSTR lpszDlgTitle, LPSTR lpszAMessage, DWORD dwTheError)
{
   LPVOID lpMsgBuf;
	FormatMessage(
    			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
    			NULL,
    			dwTheError,
    			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
    			(LPTSTR) &lpMsgBuf,
    			0,
    			NULL
				);
   // Display the string.
   wsprintf(lpsTmpCB, "ARFD System Error Warning encountered\n%s\nSystem error #%d : %s",
         	lpszAMessage,dwTheError,lpMsgBuf);
   MessageBox(hwnd,lpsTmpCB,lpszDlgTitle,MB_OK|MB_ICONERROR);
   // Free the buffer.
   LocalFree( lpMsgBuf );
}
// File handle opening and creation
BOOL Create_File(HWND hwnd, LPSTR lpszFullFileName, LPSTR lpszDlgTitle, char cReadWrite, LPHANDLE lphFile)
{
      DWORD dwLastError;
      HANDLE hAFile;
      
      if ((*lphFile) != INVALID_HANDLE_VALUE)
      	MessageBox(hMainWindow,"File Handle Already Open !!","Error",MB_OK|MB_ICONSTOP);
      *lphFile =  INVALID_HANDLE_VALUE;
      
      if (cReadWrite == 'W')
    			hAFile = CreateFile(lpszFullFileName,
                  GENERIC_WRITE, 0, NULL, OPEN_ALWAYS,
                  FILE_ATTRIBUTE_NORMAL, NULL);
      else //(cReadWrite == 'R')
          	hAFile = CreateFile(lpszFullFileName,
            		GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,
                  FILE_ATTRIBUTE_NORMAL,NULL);
      //regarder si il y a une erreur...
      if (hAFile == INVALID_HANDLE_VALUE)
    	{
         dwLastError = GetLastError();
         wsprintf(sTmpSTR, "while opening the file handle\n '%s'", lpszFullFileName);
         Handle_System_Error(hwnd, lpszDlgTitle, sTmpSTR, dwLastError);
        	return FALSE;
    	}
      //verifier si le fichier existe:
      else if (cReadWrite == 'W')
      {
      	if (GetLastError() == ERROR_ALREADY_EXISTS)
      	{
         	wsprintf(lpsTmpCB, "The file '%s' already exists:\nClick OK to overwrite it?",lpszFullFileName);
        		if (MessageBox(hwnd,lpsTmpCB,lpszDlgTitle,MB_OKCANCEL|MB_ICONWARNING) == IDCANCEL)
         	{
            	CloseHandle(hAFile);
               return FALSE;
         	}
      	}
      }
      * lphFile = hAFile;
      return TRUE;
}
// File handle closing
void  Close_File(LPHANDLE lphFile)
{
	CloseHandle(*lphFile);
   *lphFile = INVALID_HANDLE_VALUE;
}


