//******************************************************************************
// NODE NAME : ARFDFunctions.cpp
// part of the Atari Rom File Designer source files
// Cr pour allger Monitor.cpp
// Contient les prcdures et fonctions relatives aux traitements mmoires
// et textes
// Contains all functions and procedures for ARFD memory and text treatments
//
/*---------------------**| ARFD SOURCE REVISION HISTORY |**---------------------
 Date:     | What:
-----------|--------------------------------------------------------------------
 JUNE 2002 | Clean updated source code for ARFD revision 1.9.0 (public realease)
-----------|--------------------------------------------------------------------
------------------------------------------------------------------------------*/

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//    Entete :
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

#define STRICT
#include <windows.h>
#pragma hdrstop
#include <stdio.h>
#include "MesTypes.h"
#include "ARFDFunctions.h"

//------------------------------------------------------------------------------
//    Variables externes de ARFDesigner:
//------------------------------------------------------------------------------

extern   UBYTE * lpFileBuffer;  //The memory pointer
//extern   TDIS_PARAM D_Cur;
extern   TMON_PARAM AmParam;    //Parameters of the loaded file

extern 	UWORD iCurSect;        //Current sector
extern 	UINT  iCurFilePos;     //Current memory pointer
extern 	UWORD iCurOff;         //Current Offset (in sector)
extern 	BOOL  bATRFlag;        //Set to TRUE is the file in memory is ATR
extern   int   iFileLength;     //Total length of the file in memory

//extern   HWND  hMainWindow;
//extern   HWND  hChildEditWindow;
//extern   HWND  EditWin;
//extern   BOOL  bChildEditWin;
//extern   BOOL  bFileModified;

//extern 	void  Add_RichText(HWND hAEdit, char * lpszAddString);
//extern 	void  Add_EndRichText(HWND hAEdit, char * lpszAddString);
//extern   int   Get_Title_Line_Number(HWND hAEdit);
//extern   void  Make_Bold_Line(HWND hRichEdit, int iLine);
//extern 	BOOL  Is_Wrong_SectorOffset(HWND hwnd, UWORD sector, UWORD offset);

//extern 	char * lpsTmpCB;
extern   char sTmpSTR[256];    //Temporary string
extern 	UWORD SectSize;       //Current sector size

//extern   int   iTitleLine;
extern   char szDlgBoxMain[];  //title of the dialogbox

//Glaobal for Data searching and Replacement
//extern   BOOL  SearchInProgress;  //TRUE if there is a search in progress (F3)
//extern   int   iSearchMode;       //The search mode
//extern   int   nSearchDataBytes;  //Number of the data bytes search
//extern   char  szSRTitle[5][36];  //Action title string

//------------------------------------------------------------------------------
//    Variables pour la fonction dsassemblage externe de ARFDesigner :
//------------------------------------------------------------------------------
//extern   UWORD Dis_CMemAddr;
//extern   UINT Dis_CPosFile;
//extern   UWORD Dis_CSector;
//extern   UWORD Dis_COffset;

//Buffer pour les fichiers Atari lus...  65536 octets maximum
//extern   UBYTE * lpAtariFileTmp;

//------------------------------------------------------------------------------
// PROCEDURES TRAITEMENT DE TEXTE ET NOMBRES -----------------------------------
//------------------------------------------------------------------------------
BOOL Is_Displayable(UBYTE c)
{
		if ((c < 32) || (c == 127))
      	return FALSE;
      return TRUE;
}

BOOL Is_Hexa_String(char *szString)
{
    static char *s; // s est un pointeur
    s = szString;   // les 2 pointeurs ont la mme valeur
    if (*s)         // le premier caractre est non nul (fin de chaine)
        while (*s)  // caractre courant n'est pas pas null(fin de chaine)
        {
            if ((*s >= '0' && *s <= '9') ||
             (*s >= 'A' && *s <= 'F') || (*s >= 'a' && *s <= 'f'))
            {
                s++;
                continue;
            }
            else return (FALSE); //caractres non hexa
        }
    else return (FALSE);   // Chaine vide !!
    return TRUE;
}

BOOL Is_Dec_String(char *szString)
{
    static char *s; // s est un pointeur
    s = szString;   // les 2 pointeurs ont la mme valeur
    BOOL r = FALSE;
    if (*s)   // si chaine pleine...
    {         // le premier caractre est non nul (fin de chaine)
        if ((*s) == '-') s++; // nombre ngatif...
        while (*s)  // caractre courant n'est pas pas null(fin de chaine)
        {
            if (*s >= '0' && *s <= '9')
            {
                s++;
                r = TRUE;
                continue;
            }
            else
            {
                r = FALSE; //caractres non hexa
                break;
            }
        }
    }
    else return r;   // Chaine vide !!
    return r;
}

char * lpInt_To_Char(int a, char* lpszTmpStr)
{
    sprintf(lpszTmpStr, "%X", a);
    return lpszTmpStr;
}

int iGet_Hex(char * lpszTmpStr)
{
    int ihexval = 0;
    sscanf(lpszTmpStr, "%X", &ihexval);
    return ihexval;
}

int iGet_Dec(char * lpszTmpStr)
{
    int idecval = 0;
    sscanf(lpszTmpStr, "%d", &idecval);
    return idecval;
}

int Get_Data_Line(UBYTE * lpTheData, char * lpTheFindSting)
{
    static char TheString[48];
    static char * lpTheString;
    char *t;
    int nbval;
    int inval;
    if (*lpTheFindSting == NULL) return 0;
    strcpy(TheString,lpTheFindSting);
    lpTheString = &TheString[0];
    for (nbval=0; nbval<16; nbval++)
    {
        while (*lpTheString == ' ')
            lpTheString++;                // Skip Leading Spaces (if present)
        if (*lpTheString)
        {
            t = lpTheString;              //Start of String
            while (*lpTheString != ' ' && *lpTheString)
        		{                   // Locate End of String
            	lpTheString++;
        		}
        		if (*lpTheString == ' ')
        		{                           // Space Terminated ?
            	*lpTheString = 0;         // C String Terminator for char *t
            	lpTheString++;            // Point to Next Char
        		}
            inval = -1;
        		sscanf(t, "%X", &inval);
            if (inval != -1)
            	lpTheData[nbval] = (UBYTE) (inval);
            else break;
    		}
    		else
        		break;
     }
     return nbval;
}
//Return the file memory position,
// Return 0 if requested position does not exist in the loaded file
UINT Get_FilePosition(UWORD sector, UWORD offset)
{
   UINT r;
   UINT ssz = SectSize + 1;
	if (!bATRFlag)
    	r = ((sector-1)*ssz + offset);
   else
   	r = ((sector-1)*ssz + offset + 16);
   if (r >= iFileLength)
   	r = 0;
   return r;
}
//Update by Increment the file memory position pointer 'TheFilePos'
// If position is greater than Max, TheFilePos is set to zero
void INC_Pos(UINT * TheFilePos)
{
    (* TheFilePos) ++; //on augmente l'offset
    if ((* TheFilePos) >= iFileLength)
    {
        if (bATRFlag)
        		* TheFilePos = 16;
        else
            * TheFilePos = 0;
    }
}
//Update by Increment the sector pointer 'TheSect'
// If sector is greater than Max, TheSect is set to one
void INC_Sect(UWORD * TheSect)
{
    (* TheSect) ++; //on augmente le secteur
    if ((* TheSect) > AmParam.MAXSect)
        * TheSect = 1;
}
//Update by Decrement the sector pointer 'TheSect'
// If sector is lower than 1, TheSect is set to Max
void DEC_Sect(UWORD * TheSect)
{
    (* TheSect) --; //on decremente le secteur
    if ((* TheSect) < 1 )
        * TheSect = AmParam.MAXSect;
}
//Returns TRUE if sector is in existing range (1 to Max),
// FALSE otherwise
BOOL CHECK_Sect(UWORD * TheSect)
{
    //* TheSect &= 0x07FF;
    if ((* TheSect) < 1 )
        * TheSect = 1;
    else if ((* TheSect) > AmParam.MAXSect)
        * TheSect = AmParam.MAXSect;
    else return TRUE;
    return FALSE;
}
//Set the Offset TheOffset to the Max secteur Offset value (usually SectSize)
// except for the last sector.
// A Max value TheMax can be specified if set different than zero,
// to set TheOffset to a new Max value if greater.
void CHECK_Offs(UWORD* TheOffset, UWORD TheSector, UWORD TheMax)
{
    * TheOffset &= SectSize;
    // Dernier secteur : nombre d'octet n'est pas forcment SectSize
    if ( TheSector == AmParam.MAXSect)
        TheMax = Size_Of_Sector(TheSector);
    // secteur normal, TheMax = 0, on sort, pas de vrification
    else if (TheMax == 0) return;
    // verification de l'offset (si secteur = Lastsect ou si TheMax spcifi)
    if ((* TheOffset) > TheMax)
         (* TheOffset) = TheMax;
}
//Returns the length of the sector specified by TheSect
UWORD Size_Of_Sector(UWORD TheSect)
{
   if (TheSect == AmParam.MAXSect)
   	return (UWORD)((AmParam.MAXFL-1) - ((TheSect)-1) * (SectSize+1));
   else
      return SectSize;
}
//Returns TRUE if the given sector and offset are within the range.
// minimum sector MinS and maximum sector MaxS can be specified is set different
// than zero
// Returns FALSE after a message box otherwise.
BOOL Is_Wrong_SectorOffset(HWND hwnd, UWORD sector, UWORD offset, UWORD MinS, UWORD MaxS)
{    // test de sector & offset
	 // MinS = 1; MAxS = 0 -> AmPAram.MAXSect
    if (MaxS == 0)
        MaxS = AmParam.MAXSect;
    if ((sector >= MinS) && (sector <= MaxS) && (offset < AmParam.NBytSect))
        return TRUE;
    wsprintf(sTmpSTR,"ARFD Error:\nInvalid sector or offset [$%03X:%02X]!",sector,offset);
    MessageBox(hwnd,sTmpSTR,szDlgBoxMain,MB_OK|MB_ICONWARNING);
    return FALSE;
}

// Procedure pour fichiers Atari Binaire DOS
// Lecture d'un octet en mmoire,
// Variable globale 'iCurFilePos' utilise comme pointeur mmoire
// Utilisation et mise  jour de la variable lpNextSect pour Next Sector
// Retourne l'octet lu en poids faible et 0x80 en poids fort si EOF
int ubyteFB(UBYTE *lpByte, UWORD * lpNextSect)
{
    UWORD uTmp;
    UWORD d[3];
    int i, r;
    uTmp = returnFBN(&iCurFilePos);
    iCurOff--; // un octet de moins  lire dans le secteur
    (*lpByte) = (UBYTE) uTmp;
    if (uTmp & 0x8000) return -1;  //Si End of File  retourner -1
    r = 1; //on est pas en fin de fichier, faire les tests sur la lecture fichier
    //on regarde l'offset
    if (iCurOff == 0) //Le nombre d'octets  lire dans le secteur est atteind
    {
        if (*lpNextSect == 0) return 0;   // NextSector nul = fini !!!
        //prendre les paramtres du secteur suivant
        iCurOff = (UWORD) (SectSize-2);
        iCurFilePos = Get_FilePosition((*lpNextSect), iCurOff);
        if (iCurFilePos == 0) return -1;  //end of file
        for (i = 0; i < 3; i++)
        {
        		d[i] = returnFBN(&iCurFilePos);
        		if (d[i] & 0x8000) return -1;  //end of file
        }
        iCurSect = * lpNextSect; //le prochain secteur devient celui en cours
        * lpNextSect = (UWORD)((d[0] & 0x03)* 256 + d[1]); // prochain secteur
        if ((*lpNextSect != 0) && ((*lpNextSect > AmParam.MAXSect) || (*lpNextSect <= iCurSect)))
        		return -2;  // secteur error...
        iCurOff = (UWORD) (d[2] & 0x00FF);
        if ((iCurOff> (SectSize-2)) || (iCurOff == 0))
        		return -3; // Wrong number of bytes...
        iCurFilePos = Get_FilePosition(iCurSect, 0);
        r = 2;  //Un nouveau secteur a t charg car c'tait le dernier
    }
    //Pas fini ou fini, c'est le cas gnral o il faut retourner r
    return r; // c'est ok !

}
// lecture d'un octet de la mmoire avec end of file
// avec incrmentation de iPos pointeur mmoire
UWORD returnFBN(UINT * iPos)
{
 	UWORD u;
 	u = (UWORD)(lpFileBuffer[*iPos] & 0x00FF);
   if ((* iPos) < iFileLength)
   	(*iPos) ++; //on augmente l'offset
   else //* ipos == ou > a iFileLength
   {    // on le signal et on ne change pas *ipos qui reste au maxi
        u |= 0x8000; // nombre > 256   (iPos invalid)
   }
   // retourne l'octet en poids faible
   // poids fort = 0x80 on ne peut pas augmenter le pointeur mmoire
   // c'est donc le dernier octet qui a t lu
   return u;
}

UWORD returnFBO(UINT * iPos, BOOL bOffs)
{
 	UWORD u,b;
 	u = (UWORD)(lpFileBuffer[*iPos] & 0x00FF);
   if (bOffs)
   {
   	b = Get_Offset(*iPos);
   	if (b >= (SectSize-3))
      	(*iPos) += 3;
   }
   if ((* iPos) < iFileLength)
   	(*iPos) ++; //on augmente l'offset
   else //* ipos == ou > a MAXFL
   {    // on le signal et on ne change pas *ipos qui reste au maxi
        u |= 0x8000; // nombre > 256   (iPos invalid)
   }
   return u;
}
UWORD Get_Sector(UINT position)
{
    UINT ssz = SectSize + 1;
    if (!bATRFlag)
    	return (UWORD)(position/ssz + 1);
    else
    	return (UWORD)((position-16)/ssz + 1);
}

UWORD Get_Offset(UINT position)
{
    UINT ssz = SectSize + 1;
    if (!bATRFlag)
    	return (UWORD)(position % ssz);
    else
    	return (UWORD)((position-16) % ssz);
}

UBYTE Get_CheckSum(UWORD aSector)
{
	static UINT pos;
   int i;
   UWORD ck, cd;
   pos = Get_FilePosition(aSector,0);
   ck = 0;
   for (i = 0; i <= SectSize; i++)
   {
      cd = returnFBN(&pos);
   	ck += (UWORD) (cd & 0x00FF);  // on ne prend que l'octet
      if (ck > 255) ck = (UWORD) (ck - 256 + 1);
      if (cd & 0x8000) break; // end of file rencontr...
   }
   return (UBYTE) ck;
}

void Shift_Memory(UINT TheFirstByte, UINT TheLastByte, int TheShifting, UBYTE cRByte)
{
   //Insert or suppress TheShifting bytes at the TheFirstByte position
   //Last position (included) for the shifting is the TheLastByte
   //(TheLastByte + 1 is not shifted),
   //cRByte is the default insert or suppresed byte (usualy 0x00)
	int i,j;
   if (TheLastByte == 0) TheLastByte = iFileLength - 1;
   if ((TheShifting == 0) || (TheFirstByte > TheLastByte)) return;
   if ((TheShifting > 0) && ((TheFirstByte + TheShifting ) > TheLastByte))
   {
      while (TheFirstByte <= TheLastByte)
      {
         lpFileBuffer[TheFirstByte++] = cRByte;
      }
   	return;
   }
   if (TheShifting > 0)
   {
      j = (int) TheLastByte;
      i = (int) (TheLastByte - TheShifting);
   	while (i >= (int) (TheFirstByte))
   	{
   		lpFileBuffer[j--] = lpFileBuffer[i--];
      }
      for (i = 0; i < TheShifting; i++)
      	lpFileBuffer[TheFirstByte + i] = cRByte;
   }
   else
   {
      i = (int) TheFirstByte;
      TheShifting = 0 - TheShifting;
      j = (int)(TheFirstByte + TheShifting);
   	while (j <= (int)(TheLastByte))
   	{
   		lpFileBuffer[i++] = lpFileBuffer[j++];
      }
      for (i = 0; i < TheShifting; i++)
      	lpFileBuffer[TheLastByte+1 - TheShifting + i] = cRByte;
   }
}

UINT Copy_In_Memory(UBYTE * lpTheBuffer,
						UINT TheFirstPos,
                  UINT TheLastPos,
                  UINT nTheNbrOfBytes,
                  BOOL bInsBytes)
{
	  int i;
     if (TheLastPos == 0) TheLastPos = iFileLength - 1;
     if ((nTheNbrOfBytes == 0) || (TheFirstPos > TheLastPos)) return 0;
     if ((TheFirstPos + nTheNbrOfBytes) > (TheLastPos + 1))
        nTheNbrOfBytes = TheLastPos - TheFirstPos + 1;
     if (bInsBytes)
        Shift_Memory(TheFirstPos, TheLastPos, +nTheNbrOfBytes, 0x00);
     for (i = 0; i < nTheNbrOfBytes; i++)
        lpFileBuffer[TheFirstPos+i] = lpTheBuffer[i];
     return nTheNbrOfBytes;
}
