/*------------------------------------------------------------------------------
*  Programme ARFDesigner.exe (c) PVBEST 2001-2002 coded by Philippe
*  -Made in Savoie- (France)
*  Atari Rom File Designer for education and fun purpose only...
*  I make no profit. It's a freeware for the Atari fans and lovers !
*  Thanks to the following people who help me with their articles:
*  - E.Calvert (Windows 95 Programmation) for his coding lessons and based code
*    especialy in the RTFFUNCT.CPP module !
*  - All people from the Atari 800 Emulator Project : parts of desassembly
*    code of my monitor.cpp is based upon the 'monitor.c' of the
*    Atari 800 Emulator by David Firth and his Emulator team
*  - disassembly address mnemonic table is part of disassembler by Erich BACHER
*  - Serial communication module is based on C++ code from Thierry Schneider,
*    and code is also based upon the article ''Serial Communications in Win32''
*    by Allen Denver (Microsoft Windows Developer Support)
*  - Of course Microsoft and Windows are registered Trademark of Microsoft Corp.
*  - Thanks for all people making Atari lives through our PC computers !
*  Atari is still alive !! So Use and Enjoy.
*  Atari is a registered trademark.
*  Atari Rom File Designer (ARFDesigner) is currently under Revision 1.8.0
*  This revision 1.8.0 is the first public released
------------------------------------------------------------------------------*/
//
/*---------------------**| ARFD SOURCE REVISION HISTORY |**---------------------
 Date:     | What:
-----------|--------------------------------------------------------------------
 JUNE 2002 | Clean updated source code for ARFD revision 1.9.0 (public realease)
------------------------------------------------------------------------------*/


//------------------------------------------------------------------------------
//     Entetes :
//------------------------------------------------------------------------------
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <commdlg.h>
#pragma hdrstop
#include <richedit.h>
#include "MesTypes.h"
#include "ARFDFunctions.h"
#include "ARFDMain.h"
#include "Resource.h"
#include "Monitor.h"
#include "ADisplay.h"
#include "RTFFUNCS.H"
#include "EditSector.h"
#include "AmDialog.h"
#include "NewCom.h"

//------------------------------------------------------------------------------
// INTERFACE  : types et variables
//------------------------------------------------------------------------------

   char szAppRevision[] 		 	= "Revision : 1.9.0";
   char szAppName[] 				 	= "ARFDesigner";
   char szDisAppName[] 			 	= "ARFDDisassembly";
   char szDlgBoxMain[]  		 	= "Atari Rom File Designer :";
   char szDlgBoxDis[]  			 	= "Atari Rom File Designer Disassembly :";

   char szMainWindowTitle[] 		= "Atari Rom File Designer";
   char szChildDisWindowTitle[]  = "ARFD Dissassembly Display Window";
   char szChildEditWindowTitle[] = "ARFD Edit Sector Window";
   char szEditAppName[] 			= "ARFDEdition";

   //Instance application et librairie RichEdit
   HINSTANCE hInstance, hRichEditLib;
   //Pointeur sur les 3 fenetres principales
   HWND hMainWindow;
   HWND hChildDisWindow;
   HWND hChildEditWindow;
   //HWND hComDialog;
   //Pointeurs boites de dialogue et de fenetres filles
   HWND hMainRText 	 = NULL;  //Fenetre edition principale
   HWND hDisEditRText = NULL;  //Fenetre edition desassemblage
   HWND hStatus		 = NULL;  //Barre de status fenetre principale
   HWND hToolbar		 = NULL;  //Barre d'outils icones fenetre principale
   HWND hDisParamDlg  = NULL;  //Boite de dialogue parametres desass.
   HWND hConvertDlg;  //Fentre de conversion Hex<>Dec
   HWND hAtariDirDlg;
   HWND hWaitDlg;              //Boite de dialogue d'attente
   HWND hWaitProgress;         //Barre de progression dialogue attente
   HANDLE hResource;           //Handle vers ressources
   HANDLE hFile;               //Handle for PC HDD file
   HMENU ModMenu;              //Handle menu fenetre principale

   static HACCEL hAccel;       //Handle des touches raccourcis accelerateurs
   static TBBUTTON ToolAry[NUMBUTTONS];
   static HANDLE hDisThread;   //Handle processus de desassemblage
   static DWORD  DisThreadID;  //Numro de thread processus desassemblage

   //initialisation des structures de donnes
   TDIS_PARAM D_Def = {1,0,0x2D0,0x700,0xBFFF,0x80,TRUE,FALSE,FALSE,TRUE};
   TDIS_PARAM D_Cur = {1,0,0x003,0x700,0x0FFF,0x80,TRUE,FALSE,FALSE,TRUE};
   TMON_PARAM AmParam = {0x410,0x80,0,0,""};

   // variables pour les recherches ASCII/HEXA
   BOOL   bSearchInProgress;     // Flag de recherche en cours
   int    nSearchDataBytes;      // selected data length
   int    iSearchMode;           // type de recherche et remplacement

   // variables boolennes :
   BOOL   bFileModified;               //Flag Fichier en mmoire a t modifi
   BOOL   bNewFileParam 	= FALSE;    //Flag = TRUE si on est dans nouveau fichier
   //BOOL   bChildDisWin 		= FALSE;  	//Flag Fenetre de Desassemblage presente
   //BOOL   bChildEditWin 	= FALSE;    //Flag Fenetre de EditSector presente
   BOOL   bEndDisThread 	= FALSE; 	//Flag Fin du processus de desassemblage
   BOOL   bFileMem 			= FALSE;    //Flag Fichier prsent en mmoire
   BOOL   bATRFlag 			= FALSE;    //Flag Fichier en mmoire est au format ATR
   BOOL   bDisAddMode;           		//Flag ajout dans la fenetre desassemblage
   BOOL 	 bOpenCmdParamFile;           // True si un fichier a r pass  ARFD au lancement
   BOOL   bFileResult;                 // reussite d'ouverture ou sauvegarde fichier
   BOOL   bImportData;

   //Variables concernant le fichier PC en mmoire :
   char 	 szAtariFileName[STRSIZE] = "";  // chemin complet du fichier en cours...
   char   szAppPathDir[STRSIZE]= "";      // rpertoire de l'application ARFDesigner.exe au lancement
   char   szTmpCmdLine[STRSIZE];          // Ligne de commande passe  l'applcation
   int 	 iFileLength;                    // taille du fichier en mmoire
   // variables pour les OPEN/SAVE file
   char 	 szTextFileName[STRSIZE] = "";  //chemin complet du fichier de sauvegarde cran texte
   char   szFileExtension[128];
   int    iFilterIndex;
   char   szTextFileTitle[128];
   char   szFileFilter[128];
   //buffer mmoire
   char 	 * lpsTmpCB;  		  // clipboard texte
   UBYTE  * lpRom;     		  // Rom Font - 1024 octets (1Ko)
   UBYTE	 * lpFileBuffer;    // le fichiers Rom en mmoires 256 * 1040 + 16 = 266256 octets (~260Ko)
   UBYTE  * lpAtariFileTmp;  // Atari binary file - 65536 octets (64Ko)
   //Chaines temporaires
   char   sTmpSTR[256];
   //variables de positionnement mmoire ( Atari ROM file memory )
   UWORD  SectSize;             //taille secteur (0x7f ou 0xFF en gnral )
   UWORD  iCurSect;             //Secteur  afficher courant
   UWORD  iNewSect;             //New last sector for conversion
   UINT   iCurFilePos;          //Position courante dans le fichier
   UWORD  iCurOff;              //Offset courant
   // variables globales pour le dsassemblage
   UWORD  Dis_CMemAddr;
   UINT   Dis_CPosFile;
   UWORD  Dis_CSector;
   UWORD  Dis_COffset;
   // Varialbles globales pour Serial Com
   UBYTE AtrCOM;
   UBYTE AtrDDEVIC;
   int   AtrDTIMEOUT1;
   int   AtrDTIMEOUT2;
   // variables diverses
   char   szEnterSectTitle [32] = "";   // titre de la boite de dialogue "enter Sector"
   int    iTitleLine;

   HFONT hfARFD;  //The ARFD fixed font for all edit control display
   BOOL  bUSint;  //Type of integer for Convert Window

   void   Test3(HWND hwnd);

//------------------------------------------------------------------------------
//INITIALISATION WINMAIN
//------------------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInst,
     HINSTANCE hPrevInst, LPSTR lpszCmdParam, int nCmdShow)
     {
     MSG Msg;

     if (!hPrevInst)
        if (!Register(hInst))
            return FALSE;

     strcpy(szTmpCmdLine,lpszCmdParam);

     hMainWindow = Create_MainARFDWindow(hInst,nCmdShow);
     if (!hMainWindow)
        return FALSE;

    while (GetMessage(&Msg, NULL, 0, 0))
    {
      if (!hConvertDlg || !IsDialogMessage(hConvertDlg, &Msg))
      if (!hAccel || !TranslateAccelerator(hMainWindow, hAccel, &Msg))
      {
        TranslateMessage(&Msg);
        DispatchMessage(&Msg);
      }
    }
    return Msg.wParam;
  }
//------------------------------------------------------------------------------
// ENREGISTRER LA CLASSE DE LA FENETRE PRINCIPALE + FENETRE DESASSEMBLE
//------------------------------------------------------------------------------
BOOL Register(HINSTANCE hInst)
  {
      BOOL bResult;
      WNDCLASS    WndClass;

      WndClass.style         = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW;
      WndClass.lpfnWndProc   = (WNDPROC)WndProc;
      WndClass.cbClsExtra    = 0;
      WndClass.cbWndExtra    = 0;
      WndClass.hInstance     = hInst;
      WndClass.hIcon         = LoadIcon(hInst, "MonIcone");
      WndClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
      //WndClass.hCursor       = LoadCursor(hInst, "LeCurseur");
      WndClass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      //WndClass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
      WndClass.lpszMenuName  = "MainMenu";
      WndClass.lpszClassName = szAppName;

      bResult = RegisterClass(&WndClass);
      if (!bResult) return FALSE;

      WndClass.lpfnWndProc   = (WNDPROC) ChildDisProc;
      WndClass.cbClsExtra    = 0;
      WndClass.cbWndExtra    = 0;
      WndClass.hIcon         = LoadIcon(hInst, "MonIcone");
      //WndClass.hCursor       = LoadCursor(hInst, "LeCurseur");
      WndClass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
      //WndClass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
      WndClass.lpszMenuName  = "DisaMenu";
      WndClass.lpszClassName = szDisAppName;

      bResult = RegisterClass(&WndClass);
      if (!bResult) return FALSE;

      bResult = Register_EditSector(hInst);
      if (!bResult) return FALSE;

      WndClass.lpfnWndProc   = (WNDPROC) ChildConvertProc;
      WndClass.cbClsExtra    = 0;
      WndClass.cbWndExtra    = DLGWINDOWEXTRA;
      WndClass.hbrBackground = (HBRUSH)(COLOR_MENU+1);
      WndClass.lpszMenuName  = NULL;
      WndClass.lpszClassName = "ConvertWin"; //szConvertName;

      bResult = RegisterClass(&WndClass);
      if (!bResult)
      	return FALSE;

      return TRUE;
  }
//------------------------------------------------------------------------------
// CREATION DES FENETRES
//
//------------------------------------------------------------------------------
// FENETRE PRINCIPALE
//------------------------------------------------------------------------------
HWND Create_MainARFDWindow(HINSTANCE hInst, int nCmdShow)
  {
   hInstance = hInst;
   int Wtx, Wty;
   int Wwd; //= 500;
   int Wht; //= 350;
   Wtx = GetSystemMetrics(SM_CXSCREEN)/6;
   Wwd = 4* Wtx;
   Wty = GetSystemMetrics(SM_CYSCREEN)/5;
   Wht = 3* Wty;

   HWND hwnd = CreateWindowEx(
      WS_EX_LEFT,
      szAppName,
      szMainWindowTitle,
      WS_OVERLAPPEDWINDOW,
      Wtx,Wty,Wwd,Wht,
      NULL,
      NULL,
      hInst,
      NULL);

    if (hwnd == NULL)
        return hwnd;

    //SetMenu(hwnd,LoadMenu(hInst,"MonMenu"));

    hAccel = LoadAccelerators(hInst,"MainKeys");
    if (hAccel == NULL)
        MessageBox(hMainWindow,"ARFD Sys Warning:\nNo Accelerators keys loaded!",
        szDlgBoxMain,MB_OK|MB_ICONWARNING);

    ShowWindow(hwnd, SW_SHOWNORMAL);
    UpdateWindow(hwnd);
    return hwnd;
  }
//------------------------------------------------------------------------------
// FENETRE FILLE (DESASSEMBLE)
//------------------------------------------------------------------------------
HWND Create_DisassemblyChild(HINSTANCE hInst, int nCmdShow)
  {
   int Wtx, Wty;
   int Wwd; //= 500;  //old declaration...
   int Wht; // = 350;  //old declaration...
   Wtx = GetSystemMetrics(SM_CXSCREEN)/6;
   Wwd = 4 * Wtx;
   Wty = GetSystemMetrics(SM_CYSCREEN)/5;
   Wht = 3* Wty;
   HWND hwnd = CreateWindowEx(
      	WS_EX_LEFT,
      	szDisAppName,
      	szChildDisWindowTitle,
      	WS_OVERLAPPEDWINDOW,
      	Wtx,Wty,Wwd,Wht,
      	NULL,
      	NULL,
      	hInst,
      	NULL);

    if (hwnd == NULL)
        return hwnd;
    ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);
    return hwnd;
}

//------------------------------------------------------------------------------
// FENETRE TOOL CONVERSION
//------------------------------------------------------------------------------
HWND Create_ConvertChild(HINSTANCE hInst, int nCmdShow)
{
   HWND hdlg = CreateDialog(hInst, "ConvertDlg", hMainWindow, (DLGPROC) NULL);

   if (hdlg == NULL)
   {
      MessageBox(hMainWindow,"ARFD Sys Error:\nConvert window creation error!",
      	szDlgBoxMain,MB_OK|MB_ICONSTOP);
      return hdlg;
   }
    ShowWindow(hdlg, nCmdShow);
    //UpdateWindow(hdlg);
    return hdlg;
}
//------------------------------------------------------------------------------
//
// Procedures de fenetres 'WndProc' :
// procedures crackeurs & gestion des messages
//
//------------------------------------------------------------------------------
LRESULT CALLBACK
  WndProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
  {
    switch(Message)
    {
        HANDLE_MSG(hwnd, WM_CREATE, ARFD_OnCreate);
        HANDLE_MSG(hwnd, WM_DESTROY, ARFD_OnDestroy);
        HANDLE_MSG(hwnd, WM_COMMAND, ARFD_OnCommand);
        HANDLE_MSG(hwnd, WM_CLOSE, ARFD_OnClose);
        HANDLE_MSG(hwnd, WM_SETFOCUS, ARFD_OnSetFocus);
        HANDLE_MSG(hwnd, WM_SIZE, ARFD_OnSize);
        HANDLE_MSG(hwnd, WM_NOTIFY, ARFD_OnNotify);
        default:
        return ARFD_DefProc(hwnd, Message, wParam, lParam);
    }
 }

LRESULT CALLBACK
  ChildDisProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
  {
    switch(Message)
    {
        HANDLE_MSG(hwnd, WM_CREATE, DisaWin_OnCreate);
        //HANDLE_MSG(hwnd, WM_DESTROY, DisaWin_OnDestroy);
        HANDLE_MSG(hwnd, WM_COMMAND, DisaWin_OnCommand);
        HANDLE_MSG(hwnd, WM_CLOSE, DisaWin_OnClose);
        HANDLE_MSG(hwnd, WM_SIZE, DisaWin_OnSize);
        default:
        return DisaWin_DefProc(hwnd, Message, wParam, lParam);
    }
 }

LRESULT CALLBACK
  ChildConvertProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
  {
    switch(Message)
    {
        HANDLE_MSG(hwnd, WM_CREATE, Convert_OnCreate);
        HANDLE_MSG(hwnd, WM_COMMAND, Convert_OnCommand);
        HANDLE_MSG(hwnd, WM_SETFOCUS, Convert_OnSetFocus);
        HANDLE_MSG(hwnd, WM_CLOSE, Convert_OnClose);
        default:
        return Convert_DefProc(hwnd, Message, wParam, lParam);
    }
 }
//------------------------------------------------------------------------------
//
// hMainWindow : Procedures de gestion des diffrents messages
//
//------------------------------------------------------------------------------
BOOL ARFD_OnCreate(HWND hwnd, LPCREATESTRUCT lpCreatStruct)
{
 	 InitCommonControls();
    hRichEditLib = LoadLibraryEx("RICHED32.DLL",NULL,0);
    if (!hRichEditLib)
    {
        MessageBox(hwnd, "ARFD Sys Error:\nCould not open RICHED32.DLL!",
        szDlgBoxMain,MB_OK|MB_ICONSTOP);
        return FALSE;
    }
    
    lpFileBuffer =(UBYTE *) LocalAlloc(LMEM_FIXED,MAX_FILE_LENGTH);
    memset(lpFileBuffer,0x00,MAX_FILE_LENGTH);
    lpsTmpCB =(char *) LocalAlloc(LMEM_FIXED,65536);
    memset(lpsTmpCB,0x00,65536);
    lpRom = (UBYTE *) LocalAlloc(LMEM_FIXED,1024);
    memset(lpRom,0x00,1024);
    lpAtariFileTmp = (UBYTE *) LocalAlloc(LMEM_FIXED,65536);
    memset(lpAtariFileTmp,0x00,65536);

    hFile = INVALID_HANDLE_VALUE;

    SectSize = 0x7F; //default
    Set_Com_Default_Config();

    hfARFD = CreateFont(-15,0,0,0,FW_NORMAL,0,0,0,ANSI_CHARSET,0,0,0,(FF_MODERN|FIXED_PITCH),"Courier");;
    if (!hfARFD) hfARFD = GetStockFont(ANSI_FIXED_FONT);

    Do_Toolbar(hwnd);
    Do_Status(hwnd);
    hMainRText = CreateWindow("RICHEDIT",
                        "Dissassembly Display Window",
                        WS_CHILDWINDOW|WS_VISIBLE|WS_BORDER|
                        WS_VSCROLL|WS_HSCROLL|
                        ES_AUTOVSCROLL|ES_AUTOHSCROLL|
                        ES_LEFT|ES_MULTILINE|ES_NOHIDESEL,
                        0,0,0,0,hwnd, (HMENU)0,
                        lpCreatStruct->hInstance,NULL);

    //SendMessage(hMainRText,EM_SETEVENTMASK,0,ENM_SELCHANGE);
    SendMessage(hMainRText,WM_SETFONT,(WPARAM) hfARFD,0);

    SetWindowText(hMainRText,"");

    bFileModified = FALSE;

    hChildEditWindow = NULL;
    hChildDisWindow = NULL;
    hConvertDlg = NULL;
    hAtariDirDlg = NULL;

	 ModMenu = GetMenu(hwnd);
    EnableMenuItem(ModMenu,CM_ATRSHOW,MF_BYCOMMAND|MF_GRAYED);

    bOpenCmdParamFile = Get_CmdLine_FileName();
    //MessageBox(hwnd,szAppPathDir,"Application Directory Info",MB_OK);
    //MessageBox(hwnd,szTmpCmdLine,"Command line string Info",MB_OK);

    PostMessage(hwnd,WM_COMMAND,CM_INTRO,0);

    return TRUE;

}

void ARFD_OnDestroy(HWND hwnd)
{
    DeleteFont(hfARFD);
    LocalFree(lpFileBuffer);
    LocalFree(lpsTmpCB);
    LocalFree(lpRom);
    LocalFree(lpAtariFileTmp);
    FreeResource(hResource);
    /*if (hRichEditLib)
    {
    	FreeLibrary(hRichEditLib); //not necessary in WIN32
      hRichEditLib = NULL;
    }*/
    PostQuitMessage(0);
}

void ARFD_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    int iResult;
    switch(id)
    {
	 // Commandes internes et diverses:
        case CM_INTRO:
            Show_Intro_Data(hwnd);
            break;
        case CM_NAY:
            Not_Yet_Available(hwnd);
            break;
        case CM_DISVIEW:   //reu de DisParamDialog  la fin aprs OK
           if (!hChildDisWindow) hChildDisWindow = Create_DisassemblyChild(hInstance,SW_SHOWNORMAL);
           PostMessage(hChildDisWindow,WM_COMMAND,CM_DIS_SHOW,0);
           break;
        case CM_SECTMODIFIED:
            iTitleLine = Get_Title_Line_Number(hMainRText);
            Add_EndRichText(hMainRText,"\r\n \r\n THE FOLLOWING SECTOR HAS BEEN MODIFIED :\r\n");
            Make_Bold_Line(hMainRText,iTitleLine);
        		View_Sector(hMainRText);
            break;
        case CMR_NEWFILE:
            New_File(hwnd);
            break;
        //case CM_SAVENEWFILE: dans CM_SAVE
    // Commandes menu **Files**
        case CM_NEW:
        case ID_NEW:
            Close_DirDialog();
            if (bFileModified)
            	if (MessageBox(hwnd,"ARFD Warning:\nThe current file has been modified and not saved.\nClick OK to continue, creating a new one?",
                szDlgBoxMain,MB_OKCANCEL|MB_ICONWARNING) != IDOK)
                	break;
            bNewFileParam = TRUE;
            if (DialogBox(hInstance,"AFParam", hwnd, (DLGPROC)ParamDlgProc) == IDOK )
            {
               New_File(hwnd);
               Reset_Edit_Sector(TRUE);
            }
            break;
        case CMR_OPENFILE:
        case CM_OPEN:
        case ID_OPEN:
            Close_DirDialog();
        		if (bFileModified)
            	if (MessageBox(hwnd,"ARFD Warning:\nThe current file has been modified and not saved.\nClick OK to continue opening a new one?",
                szDlgBoxMain,MB_OKCANCEL|MB_ICONWARNING) != IDOK)
                	break;
            Open_An_Atari_File(hwnd,FALSE);
            break;
        case CMR_SAVEFILE:
        case CM_SAVE:
        case ID_SAVE:
        	   if (bFileMem == TRUE)
                Save_The_Atari_File(hwnd);
            else No_File(hwnd);
            break;
        case CM_EXIT:
           // ... Pouvait tre dans ARFD_OnClose() ...
           if (bFileModified)
           {
     				if (MessageBox(hwnd, "ARFD Warning:\nThe File has been modified.\nClick OK to Exit anyway?",
         			szDlgBoxMain, MB_ICONEXCLAMATION | MB_OKCANCEL | MB_DEFBUTTON2) != IDOK)
            			break; //return;
           }
           else if (MessageBox(hwnd, "Please confirm exit...",szDlgBoxMain,
            		MB_ICONQUESTION | MB_OKCANCEL) != IDOK)
            			break; //return;
           // ... Fin
           SendMessage(hwnd,WM_CLOSE,0,0L);
           break;
    // Commandes menu **View and Display**
    	  case CM_ENTERSECT:
        case ID_ENTERSECT:
        		strcpy(szEnterSectTitle,"to display :");
            if (bFileMem == TRUE)
                if (DialogBox(hInstance,"EnterSectNumber", hwnd,
                    (DLGPROC)EnterSectDlgProc) == IDOK)
                			View_Sector(hMainRText);
            else No_File(hwnd);
            break;
        case CM_PREVSECT:
        case ID_PREVSECT:
            if (bFileMem == TRUE)
            {
                DEC_Sect(&iCurSect);
                View_Sector(hMainRText);
            }
            else No_File(hwnd);
            break;
        case CM_NEXTSECT:
        case ID_NEXTSECT:
            if (bFileMem == TRUE)
            {
                INC_Sect(&iCurSect);
                View_Sector(hMainRText);
            }
            else No_File(hwnd);
            break;
        case CM_DIRECTORY:
        case ID_DIRECTORY:
            if (bFileMem == TRUE)
            {
               if (hChildEditWindow)
                  MessageBox(hwnd,
                   "ARFD Info:\nThe EditSector window is open, modifications may corrupt the directory!",
                    szDlgBoxMain, MB_OK | MB_ICONINFORMATION);
            	if (!hAtariDirDlg)
               {
                  if (Show_Dir(hMainRText))
                     // Non modal DialogBox using CreateDialog
            		   hAtariDirDlg = CreateDialog(hInstance,"DirDialog",
            			  hwnd, (DLGPROC)DirDlgProc);
                  else
                     MessageBox(hwnd, "ARFD Info:\nNo Atari DOS directory available!",
         			     szDlgBoxMain, MB_OK | MB_ICONINFORMATION);
               }
               else
               	SetFocus(hAtariDirDlg);
            }
            else No_File(hwnd);
            break;
        case CM_BOOTSECT:
        case ID_BOOTSECT:
            if (bFileMem == TRUE)
                Show_Boot(hMainRText);
            else No_File(hwnd);
            break;
        case CM_TRACEFILE:
        case ID_TRACEFILE:
        		strcpy(szEnterSectTitle,"of the file first block to trace :");
            if (bFileMem == TRUE)
            {
                if (DialogBox(hInstance,"EnterSectNumber", hwnd,
                    (DLGPROC)EnterSectDlgProc) == IDOK)
                    {
                        View_Sector(hMainRText);
                			iResult = Trace_File(hMainRText);
                        Finalize_Tracing(hwnd,iResult);
                    }
            }
            else No_File(hwnd);
            break;
        case CMDIR_TRACEFILE:
            iResult = Trace_File(hMainRText);
            Finalize_Tracing(hwnd,iResult);
            break;
    // Commandes menu **Desassembly**
        case CM_DISASSEMBLE:
        case ID_DISASSEMBLE:
            if (bFileMem == TRUE)
            {
                if (!hDisParamDlg)
                    DialogBox(hInstance,"Desassemble", hwnd,
                    (DLGPROC)DesassembleDlgProc);
                else SetFocus(hDisParamDlg);
            }
            else No_File(hwnd);
            break;
        case CM_ADDRMNEMO:
        		Show_Symbole_Table(hMainRText);
            break;
    	  case CM_6502MNEMO:
            Show_Instruction_Table(hMainRText);
            break;
    // Commandes menu **Edit and Search**
        case CM_MODSECTOR:
        case ID_MODSECTOR:
        		strcpy(szEnterSectTitle,"to modify :");
        		if (bFileMem == TRUE)
            {
            	if (DialogBox(hInstance,"EnterSectNumber", hwnd,
                    (DLGPROC)EnterSectDlgProc) != IDOK) break;
               ShowWindow(hwnd,SW_SHOWMAXIMIZED);
               wsprintf(sTmpSTR," \r\n ENTERING MODIFICATION & EDITION WINDOW FOR SECTOR $%03X (d%d). \r\n ",iCurSect,iCurSect);
               Add_EndRichText(hMainRText,sTmpSTR);
            	if (!hChildEditWindow)
               	hChildEditWindow = Create_EditSectorChild(hInstance, SW_SHOWNORMAL);
               else
               {
               	ShowWindow(hChildEditWindow,SW_SHOWNORMAL);
                  PostMessage(hChildEditWindow,WM_COMMAND,CM_EDITSECTORRESET,0);
               }
               Set_Windows_Title(AmParam.FName);
               SetFocus(hChildEditWindow);
            }
            else No_File(hwnd);
            break;
        case CM_FILLHEXSECTOR:
        case ID_FILLHEXSECTOR:
            if (bFileMem == TRUE)
            {
               Close_DirDialog();
               iSearchMode = 5;
               Data_Searching(hwnd);
            }
            else No_File(hwnd);
            break;
        case CM_FILLASCIISECTOR:
            if (bFileMem == TRUE)
            {
               Close_DirDialog();
               iSearchMode = 6;
               Data_Searching(hwnd);
            }
            else No_File(hwnd);
            break;
        case CM_XORMASK:
        case ID_XORMASK:
            if (bFileMem == TRUE)
            {
               Close_DirDialog();
               iSearchMode = 7;
               Data_Searching(hwnd);
            }
            else No_File(hwnd);
            break;
        case CM_DATAWRITE:
            if (bFileMem == TRUE)
            {
               bImportData = FALSE;
            	DialogBox(hInstance,"ImportExportDialog", hwnd, (DLGPROC)ImportExportDlgProc);
            }
            else No_File(hwnd);
            break;
        case CM_DATAREAD:
            if (bFileMem == TRUE)
            {
               Close_DirDialog();
               bImportData = TRUE;
            	DialogBox(hInstance,"ImportExportDialog", hwnd, (DLGPROC)ImportExportDlgProc);
               Reset_Edit_Sector(FALSE);
            }
            else No_File(hwnd);
            break;
        case CM_DISPLAYFONT:
        case ID_DISPLAYFONT:
            if (bFileMem == TRUE)
            {
            	DialogBox(hInstance,"DisplayGraphDialog", hwnd, (DLGPROC)DisplayGraphDlgProc);
            }
            else No_File(hwnd);
            break;
    // Commandes menu **Atari Rom File Info**
        case CM_PARAM:
        case ID_PARAM:
        		bNewFileParam = FALSE;
            DialogBox(hInstance,"AFParam", hwnd, (DLGPROC)ParamDlgProc);
            break;
        case CM_DISKMAP:
            if (bFileMem == TRUE)
            	View_DiskMap(hMainRText,NULL);
            else No_File(hwnd);
            break;
        case CM_ATRSHOW:
            Show_ATR_Header(hMainRText);
            break;
    // Commandes menu **Option** :
    		case CM_CHANGEFONT:
		      Change_Font(hwnd, hMainRText);
         	break;
        case CM_CLEAR:
        case ID_CLEAR:
        		if (MessageBox(hwnd,"Click OK to clear display window?",
                szDlgBoxMain,MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
            	Clear_RichText(hMainRText);
            break;
        case CM_COPYTOCB:
				iResult = Copy_RichText_To_CB(hMainRText);
            wsprintf(sTmpSTR,"ARFD Info:\n%d characters of the display window copied into the clipboard!",iResult);
        		MessageBox(hwnd, sTmpSTR, szDlgBoxMain, MB_OK | MB_ICONINFORMATION);
            break;
        case CM_SAVESCREEN:
  				Save_File_As_Text(hwnd, hMainRText);
         	break;
        case CM_FINDTEXT:
            Not_Yet_Available(hwnd);
            break;
    // Commandes menu **Help** :
        case CM_CONVERT:
        case ID_CONVERT:
            if (!hConvertDlg)
            	hConvertDlg = Create_ConvertChild(hInstance,SW_SHOWNORMAL);
            ShowWindow(hConvertDlg,SW_NORMAL);
            SetFocus(hConvertDlg);
            //InvalidateRect(hwnd,NULL,FALSE);
            break;
        case IDHELP:
            if (MessageBox(hwnd,"The ARFD inline Help is not available yet.\nFor online help please visit my Web site at:\nhttp://pvb.free.fr/Atari/Atari_Index.htm",
                "ARFDesigner Help Info :",MB_OKCANCEL|MB_ICONINFORMATION) == IDOK)
                		ShellExecute(NULL,"open","http://pvb.free.fr/Atari/Atari_Index.htm",NULL,NULL,SW_SHOWNORMAL);
            break;
        case CM_ABOUT:
        case ID_ABOUT:
            DialogBox(hInstance,"AboutDlg", hwnd, (DLGPROC)AboutDlgProc);
            break;
        case CM_SHELLABOUT:
        		ShellAbout(hwnd," Atari ROM File Designer","**  Atari ROM File Designer  **\n**  (c) PVBest 1999-2001  **",NULL);
            /*For reminder*
               int ShellAbout (
    				HWND hWnd,	// handle of parent window
    				LPCTSTR szApp,	// title bar and first line text
    				LPCTSTR szOtherStuff,	// other dialog text
    				HICON hIcon 	// icon to display
   				);*/
            break;
        case CM_TEST1:
        case CM_TEST2:
            Close_DirDialog();
            iResult = id - CM_TEST1 + 1;
            wsprintf(sTmpSTR,"Ready to launch Test %d?", iResult);
        		if (MessageBox(hwnd, sTmpSTR, szDlgBoxMain,
             	MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
            {
               memset(lpFileBuffer,0x00,MAX_FILE_LENGTH);
               AmParam.MAXSect = 0x410;
               AmParam.MAXFL = 0x410*128;
               iFileLength = AmParam.MAXFL;
               AmParam.NBytSect = 0x80;
             	if (iResult == 1) Test1();
               else Test2();
               wsprintf(sTmpSTR,"TEST %d", iResult);
               strcpy(AmParam.FName,sTmpSTR);
               iCurSect = 1;

               //Afficher le texte Nom de Fichier en titre de la fenetre + StatusBar:
               Set_Windows_Title(AmParam.FName);

               wsprintf(sTmpSTR,"ARFD Info:\nTest %d done in memory!", iResult);
        			MessageBox(hwnd, sTmpSTR, szDlgBoxMain, MB_OK);
               bFileMem = TRUE;

               View_Sector(hMainRText);

               Reset_Edit_Sector(TRUE);
            }
            break;
        case CM_TEST3:
        		Test3(hwnd);
            break;
        case CM_COMPARAMDLG:
            DialogBox(hInstance,"ComParamDialog", hwnd, (DLGPROC)ComParamDlgProc);
            break;
        case ID_COMDIALOG:
        case CM_COMDIALOG:
            Close_DirDialog();
            if (hChildEditWindow)
         			SendMessage(hChildEditWindow,WM_CLOSE,0,0L);
            //if (hChildDisWindow)
         	//		SendMessage(hChildDisWindow,WM_CLOSE,0,0L);
            ShowWindow(hwnd,SW_SHOWMINIMIZED);
            DialogBox(hInstance,"ComDialog", hwnd, (DLGPROC)ComDlgProc);

            //Afficher le texte Nom de Fichier en titre de la fenetre + StatusBar:
				Set_Windows_Title(AmParam.FName);

            ShowWindow(hwnd,SW_RESTORE);
            break;
    }
}

void ARFD_OnClose(HWND hwnd)
{
     //Fermer les fentres sans parent (cres avec hParent = NULL)
     if (hChildDisWindow) SendMessage(hChildDisWindow,WM_CLOSE,0,0L);
     if (hChildEditWindow) SendMessage(hChildEditWindow,WM_CLOSE,0,0L);
     DestroyWindow(hwnd);
}

void ARFD_OnSetFocus(HWND hwnd, HWND hwndOldFocus)
{
	SetFocus(hMainRText);
}

void ARFD_OnSize(HWND hwnd, UINT state, int cx, int cy)
{
    int toolbarheight, statusbarheight, windowWid, windowHgt;
    RECT Rct;
    if (state == SIZE_MINIMIZED)
    {
    	//if (hChildEditWindow)
      //	ShowWindow(hChildEditWindow,SW_SHOWMINIMIZED);
      // (NOTA : No need if hChildEditWindow 's parent is hMainWindow)
      //Minimize the DisWindow if MainWindow is minimized
      if  (hChildDisWindow)
         ShowWindow(hChildDisWindow,SW_SHOWMINIMIZED);
    }
    if (hToolbar)
    {
		SendMessage(hToolbar,TB_AUTOSIZE,0,0);
    	GetClientRect(hToolbar,&Rct);
      toolbarheight  = Rct.bottom;  // toolbar height
    }
    else toolbarheight = 0;
    if (hStatus)
    {
    	MoveWindow(hStatus,0,0,0,0,TRUE);
      SendMessage(hStatus, WM_SIZE, state, MAKELONG(cx,cy));
      GetClientRect(hStatus,&Rct);
    	statusbarheight  = Rct.bottom; // status bar height
    }
    else statusbarheight = 0;

    GetClientRect(hwnd,&Rct);
    windowWid = Rct.right;
    windowHgt = Rct.bottom;
    //windowWid = cx;
    //windowHgt = cy;
    windowHgt -= toolbarheight;
    windowHgt -= statusbarheight;
    toolbarheight += 3;  //Pour faire plus joli quand il y a la toolbar...
    windowHgt -= 3;
    if (hMainRText)
    	MoveWindow(hMainRText,0,toolbarheight,windowWid,windowHgt,TRUE);
      //SetWindowPos(hMainRText, NULL, 0,toolbarheight, windowWid, windowHgt, SWP_NOZORDER);
}

LRESULT ARFD_OnNotify(HWND hwnd, int idFrom, NMHDR * pnmhdr)
{
 	switch (pnmhdr->code)
   {
   	case TTN_NEEDTEXT:
      	LPTOOLTIPTEXT ToolTip = LPTOOLTIPTEXT(pnmhdr);
      	switch (idFrom)
         {
         	default:
              ToolTip->lpszText = MAKEINTRESOURCE(idFrom);
              ToolTip->hinst = hInstance;
            break;
         }
   }
   return 1;
}
//------------------------------------------------------------------------------
// hChildDisWindow Procedures
//------------------------------------------------------------------------------

BOOL DisaWin_OnCreate(HWND hwnd, LPCREATESTRUCT lpCreatStruct)
{
    hDisEditRText = CreateWindow("RICHEDIT",
                        "", //"Dissassembly Display Window",
                        WS_CHILDWINDOW|WS_VISIBLE|WS_BORDER|
                        WS_VSCROLL|WS_HSCROLL|
                        ES_AUTOVSCROLL|ES_AUTOHSCROLL|
                        ES_LEFT|ES_MULTILINE|ES_NOHIDESEL,
                        10,10,200,200,hwnd, (HMENU)0,
                        lpCreatStruct->hInstance,NULL);
    bDisAddMode = FALSE;

    if (hDisEditRText !=NULL)
    {
        SendMessage(hDisEditRText,WM_SETFONT,(WPARAM) hfARFD,0);
        return TRUE;
    }
    else return FALSE;
}

void DisaWin_OnSize(HWND hwnd, UINT state, int cx, int cy)
{
  if (hDisEditRText)
    SetWindowPos(hDisEditRText, NULL,0,0,cx, cy, SWP_NOZORDER);
}

void DisaWin_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
    int iResult;
    switch(id)
    {
    // Commandes Internes reue de hMainWindow
        case CM_DIS_SHOW:
            //Lancement dsassemblage:
        		// Pas de Set_Windows_Title(AmParam.FName); (Attention utilise lpsTmpCB)
            // car la fentre desassemblage peut contenir plusieurs fichiers...
            if (!bDisAddMode) Clear_RichText(hDisEditRText);
            else End_Of_RichText(hDisEditRText);
            bEndDisThread = FALSE;
            hWaitDlg = NULL;
            hDisThread = NULL;
            if (Open_Wait_Thread())
            	DialogBox(hInstance,"WaitDialog", hwnd, (DLGPROC)WaitDlgProc);
            break;
    // Commandes Utilisateurs
        case CM_DIS_NEW:
            if (!hDisParamDlg)
                DialogBox(hInstance,"Desassemble", hwnd,
                    (DLGPROC)DesassembleDlgProc);
                else SetFocus(hDisParamDlg);
            break;
        case CM_DIS_EXIT:
            if (MessageBox(hwnd,"Click OK to close the disassembly window?",
                szDlgBoxDis,MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
            	SendMessage(hwnd,WM_CLOSE,0,0L);
            break;
        case CM_DIS_CLEAR:
            if (MessageBox(hwnd,"Click OK to clear display window?",
                szDlgBoxDis,MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
            	Clear_RichText(hDisEditRText);
            break;
        case CM_DIS_COPYTOCB:
				iResult = Copy_RichText_To_CB(hDisEditRText);
            wsprintf(sTmpSTR,"ARFD Info:\n%d characters of the display window copied into the clipboard!",iResult);
        		MessageBox(hwnd, sTmpSTR, szDlgBoxDis, MB_OK | MB_ICONINFORMATION);
            break;
        case CM_DIS_FINDTEXT:
            Not_Yet_Available(hwnd);
            break;
        case CM_DIS_ADDMODE:
            bDisAddMode = !bDisAddMode;
            AddMode_Menu_Check(hwnd);
            break;
        case CM_DIS_SAVE:
        		Save_File_As_Text(hwnd, hDisEditRText);
            break;
        case CM_DIS_CHANGEFONT:
		      Change_Font(hwnd, hDisEditRText);
      		//UpdateMenu(hRichEdit, hwnd);
         	break;
        case CM_DIS_ABOUT:
            DialogBox(hInstance,"AboutDlg", hwnd, (DLGPROC)AboutDlgProc);
            break;
    }
}

void DisaWin_OnClose(HWND hwnd)
{
    hChildDisWindow = NULL;
    SetFocus(hMainWindow);
    DestroyWindow(hwnd);
}


//------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
//
// Autres Procedures Principales
//
//------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// Cocher ou dcocher le Dis Add Mode
void AddMode_Menu_Check(HWND hwnd)
{
    HMENU hMenu = GetMenu(hwnd);
    if (bDisAddMode)
        CheckMenuItem(hMenu,CM_DIS_ADDMODE,MF_BYCOMMAND|MF_CHECKED);
    else
        CheckMenuItem(hMenu,CM_DIS_ADDMODE,MF_BYCOMMAND|MF_UNCHECKED);
}
//------------------------------------------------------------------------------
// Boite de Message : en cours de cration
void Not_Yet_Available(HWND hwnd)
{
    MessageBox(hwnd,"Cration en cours...UnderConstruction... \r\nIndisponible pour le moment, Not available yet.",
    szDlgBoxMain,MB_OK|MB_ICONEXCLAMATION);
}
//------------------------------------------------------------------------------
//Boite de Message : Entrer un fichier
void No_File(HWND hwnd)
{
    MessageBox(hwnd,"ARFD Warning:\nPlease enter a file in memory first!",
        szDlgBoxMain,MB_OK|MB_ICONINFORMATION);
}
//------------------------------------------------------------------------------
//Creation d'un Nouveau fichier Rom Atari XFD:
//> iNewSect contient le nombre de secteur...
//> SectSize contient le nombre d'octets par secteur...
//  (paramtres donns par le Dialog Param)
void New_File(HWND hwnd)
{
      char szTmpFName[] = "New XFD File.xfd";
      bATRFlag = FALSE;  //c'est un XFD obligatoirement
		AmParam.MAXSect = iNewSect;
		AmParam.MAXFL = (SectSize + 1) * iNewSect;
		AmParam.NBytSect = (UWORD) (SectSize + 1);
		strcpy(AmParam.FName,szTmpFName);
      strcpy(szAtariFileName,szTmpFName);
		iFileLength = AmParam.MAXFL;

      memset(lpFileBuffer,0x00,MAX_FILE_LENGTH); //mise  zro de la mmoire

      bFileMem = TRUE;
      bFileModified = TRUE;
		iCurSect = 1;

      //Afficher le texte Nom de Fichier en titre de la fenetre + StatusBar:
      Set_Windows_Title(AmParam.FName);

		EnableMenuItem(ModMenu,CM_ATRSHOW,MF_BYCOMMAND|MF_GRAYED);
		wsprintf(lpsTmpCB, "ARFD Info:\nNew file '%s' created in memory!",AmParam.FName);
		MessageBox(hwnd,lpsTmpCB,szDlgBoxMain,
			MB_OK|MB_ICONINFORMATION);
      iTitleLine = Get_Title_Line_Number(hMainRText);
		wsprintf(lpsTmpCB,"\r\n \r\n New file created in memory : \r\n %s \r\n",AmParam.FName);
		Add_EndRichText(hMainRText,lpsTmpCB);
      Make_Bold_Line(hMainRText,iTitleLine);

		View_Sector(hMainRText);
}
//------------------------------------------------------------------------------
// Open and load a file procedure
// Lecture de fichier vers la mmoire:
BOOL Open_An_Atari_File(HWND hwnd, BOOL bCommandLine)
{
      BOOL bResult;
      //HANDLE hFile;
    	int br;
      char szTmpFName[STRSIZE];
    	char szDialogTitle[] = "Open and Load an Atari Rom File :";
      
      //if the filename comes from the command line,
      // no Get_FileName action is necessary
      if (!bCommandLine) // no command line openning
      {
         strcpy(szTmpFName,"");
      	memset(szFileFilter,0x00,128);
    		LoadString(hInstance,STRG_FILEFILTER_ATR,szFileFilter,128);
      	bFileResult = FALSE;

      	bResult = Get_FileName(hwnd,szTmpFName,
		 		szFileFilter, szTextFileTitle,
       		szDialogTitle, TRUE, FALSE, 1);

      	if (!bResult)
      	{
          	MessageBox(hwnd,"ARFD Info:\nNo Rom file loaded!",
             	szDialogTitle, MB_OK|MB_ICONINFORMATION);
          	return FALSE;
      	}
      	strcpy(szAtariFileName,szTmpFName);
      }
      else // command line openning
      {
         //The file name is given by the Winmain command line argument
         //Get the filename title:
         GetFileTitle(szTmpCmdLine,szTextFileTitle,128);
      }
    	//Ouverture du Handle fichier:
    	if (!Create_File(hwnd, szAtariFileName, szDialogTitle, 'R', &hFile)) return FALSE;

    	//Verification de la taille du fichier:
    	iFileLength = GetFileSize(hFile,NULL);
    	if (iFileLength > MAX_FILE_LENGTH)
    	{
        	Close_File(&hFile);
        	wsprintf(lpsTmpCB,
        	"ARFD file opening Error:\nThe file size is more than %ld bytes (%i Kb)!",
         	MAX_FILE_LENGTH,MAX_FILE_LENGTH/1024);
        	MessageBox(hwnd,lpsTmpCB,szDialogTitle,MB_OK|MB_ICONERROR);
        	return FALSE;
    	}
    	else if (iFileLength == 0)
    	{
        	Close_File(&hFile);
        	MessageBox(hwnd,"ARFD file opening Error:\nThe file size is 0 byte length!",szDialogTitle,MB_OK|MB_ICONERROR);
        	return FALSE;
      }
    	//Mise  zro de la mmoire:
    	memset(lpFileBuffer,0x00,MAX_FILE_LENGTH);
    	//Lecture du fichier:
    	if (!ReadFile(hFile, lpFileBuffer, iFileLength, (LPDWORD) &br, NULL))
          Handle_System_Error(hwnd, szDialogTitle, "while reading data", GetLastError());
    	//Fermeture du handle fichier:
    	Close_File(&hFile);

    	//Test : est-ce un fichier ATR ?
    	bATRFlag = Is_ATR_File();
    	//Si oui, activer le menu ATR Header:
    	if (bATRFlag)
    	{
        EnableMenuItem(ModMenu,CM_ATRSHOW,MF_BYCOMMAND|MF_ENABLED);
    	}

    	//Initialiser la structure AmParam et iFileLength:
    	AmParam.MAXFL = iFileLength;
    	if (bATRFlag) AmParam.MAXFL = iFileLength - 16;  //16 octets pour le ATR header
    	//taille des secteurs:
    	if (AmParam.MAXFL > (1040*128)) SectSize = 0xFF;
    	else SectSize = 0x7F;
    	AmParam.MAXSect = (UWORD)(AmParam.MAXFL / (SectSize+1));
    	if ((AmParam.MAXFL % (SectSize+1)) != 0) AmParam.MAXSect++;
    	AmParam.NBytSect = (UWORD) (SectSize + 1);

    	bFileMem = TRUE;
    	bFileModified = FALSE;
    	iCurSect = 1;

  		strcpy(AmParam.FName,szTextFileTitle);

      //Afficher le texte Nom de Fichier en titre de la fenetre + StatusBar:
      Set_Windows_Title(AmParam.FName);

		wsprintf(lpsTmpCB, "ARFD Info:\nFile '%s' loaded in memory!",AmParam.FName);
      MessageBox(hwnd,lpsTmpCB,szDialogTitle,
         		MB_OK|MB_ICONINFORMATION);
      iTitleLine = Get_Title_Line_Number(hMainRText);
      Add_EndRichText(hMainRText,"\r\n \r\n New Atari Rom File in memory :\r\n ");
      Add_EndRichText(hMainRText,szAtariFileName);
      Add_RichText(hMainRText,"\r\n");
      Make_Bold_Line(hMainRText,iTitleLine);
      View_Sector(hMainRText);

      bFileResult = TRUE;

		Reset_Edit_Sector(TRUE);

      return TRUE;
}
//------------------------------------------------------------------------------
// Save an Atari Rom file.
void Save_The_Atari_File(HWND hwnd)
{
  	//HANDLE hFile;
  	int br, i, iResult;
   char sResult[96];
   char szDialogTitle[] = "Save the Atari Rom File :";
  	BOOL bResult;
  	BOOL bAtr = FALSE;
  	BOOL bXfd = FALSE;
  	bFileResult = FALSE;

   if (bFileMem && bATRFlag) i = 2;
  	else i = 1;

  	if (!bFileModified)
  		if (MessageBox(hwnd,"The current file has not been modified\nClick OK to Save it anyway ?",
  			szDlgBoxMain, MB_OKCANCEL|MB_ICONQUESTION|MB_DEFBUTTON2) != IDOK) return;

  	memset(szFileFilter,0x00,128);
  	LoadString(hInstance,STRG_FILEFILTER_ATR,szFileFilter,128);

  	bResult = Get_FileName(hwnd, szAtariFileName,
		 szFileFilter, szTextFileTitle,
       szDialogTitle, FALSE, FALSE, i);

  	//conversions ncessaires ?? ne pas oublier de changer iFileLength et bAtrFile...
  	if (bResult)
  	{
      iResult = IDNO;
      strcpy(sResult,"");
      if (iFilterIndex == 1) //XFD
      {
      	bXfd = TRUE;
         if (bATRFlag)
         //
         //	iResult = MessageBox(hwnd,"Convert the current file in memory into XFD Rom file format?",
         //   	szDialogTitle,MB_YESNOCANCEL|MB_ICONQUESTION);
         iResult = DialogBox(hInstance,"ConvConfDialog", hwnd, (DLGPROC)ConvertConfirmDlgProc);
         switch (iResult & 0x0000000F)
         {
         	case IDCANCEL:
            	return;
            case IDYES:
               //convert into memory
            	Convert_Rom_Type();
               strcpy(sResult,"\r\n File converted into XFD (standard format, no ATR header)");
               //Change the filename extension into XFD
               if (iResult & 0x00000010)
               {
               	Change_FileExtension('X',(LPSTR) szAtariFileName);
               	Change_FileExtension('X',(LPSTR) szTextFileTitle);
                  break;
               }
            case IDNO:
               //No conversion:
               if (!(!strcmp(szFileExtension,"xfd") || !strcmp(szFileExtension,"XFD")))
               {
            		strcat(szAtariFileName,".xfd");
            		strcat(szTextFileTitle,".xfd");
               }
               break;
         }
      }
      else if (iFilterIndex == 2)  //ATR
      {
      	bAtr = TRUE;
         if (!bATRFlag)
         //
         //	iResult = MessageBox(hwnd,"Convert the current file in memory into ATR Rom file format?",
         //   	szDialogTitle,MB_YESNOCANCEL|MB_ICONQUESTION);
         iResult = DialogBox(hInstance,"ConvConfDialog", hwnd, (DLGPROC)ConvertConfirmDlgProc);
         switch (iResult & 0x0000000F)
         {
         	case IDCANCEL:
            	return;
            case IDYES:
               //convert into memory
            	Convert_Rom_Type();
               strcpy(sResult,"\r\n File converted into ATR (ATR format, including 16 firts bytes for ATR header)");
               //Change the filename extension into ATR
               if (iResult & 0x00000010)
               {
               	Change_FileExtension('A',(LPSTR) szAtariFileName);
               	Change_FileExtension('A',(LPSTR) szTextFileTitle);
               	break;
               }
            case IDNO:
               //No conversion:
               if (!(!strcmp(szFileExtension,"ATR") || !strcmp(szFileExtension,"atr")))
               {
         			strcat(szAtariFileName,".atr");
            		strcat(szTextFileTitle,".atr");
               }
               break;
         }
      }
      //else : ne rien faire/nothing to do

      if (!Create_File(hwnd, szAtariFileName, szDialogTitle,'W', &hFile)) return;

      if (!WriteFile(hFile, lpFileBuffer, iFileLength, (LPDWORD) &br, NULL))
      	Handle_System_Error(hwnd, szDialogTitle, "while writing data", GetLastError());
      SetEndOfFile(hFile);
    	Close_File(&hFile);
      
      //mise  Zro  de la fin de la mmoire fichier non utilise
      // (utile si il y a eu troncage du fichier...)
      memset((lpFileBuffer+iFileLength),0x00,(MAX_FILE_LENGTH - iFileLength));

      bFileModified = FALSE;

      strcpy(AmParam.FName,szTextFileTitle);

      //Afficher le texte Nom de Fichier en titre de la fenetre + StatusBar:
      Set_Windows_Title(AmParam.FName);

      wsprintf(lpsTmpCB, "ARFD Info:\nAtari Rom file saved into '%s' file!",AmParam.FName);
  		MessageBox(hwnd,lpsTmpCB,szDialogTitle,MB_OK|MB_ICONINFORMATION);
      iTitleLine = Get_Title_Line_Number(hMainRText);
      Add_EndRichText(hMainRText,"\r\n \r\n Atari Rom file saved into :\r\n  ");
      Add_RichText(hMainRText,szAtariFileName);
      Add_RichText(hMainRText,sResult);
      wsprintf(sResult," \r\n Size of the saved file is $%05X (d%d) bytes.", iFileLength, iFileLength);
      Add_RichText(hMainRText,sResult);
      Add_RichText(hMainRText," \r\n ");
      Make_Bold_Line(hMainRText,iTitleLine);

      bFileResult = TRUE;

      Reset_Edit_Sector(FALSE);
  	}
}
//------------------------------------------------------------------------------
// Creation de la barre de status fenetre principale:
void Do_Status (HWND hParent)
{
    int sbParts[5];
    LPINT aWidth = sbParts;
    //aWidth = sbParts;
    hStatus = CreateStatusWindow(WS_CHILD|WS_VISIBLE|SBS_SIZEGRIP,
                              "Welcome to ARFDesigner !", hParent, 200);

    sbParts[0] = 140; //pixels from left
    sbParts[1] = 340; //pixels from left
    sbParts[2] = 410; //pixels from left
    sbParts[3] = 440; //pixels from left
    sbParts[4] =  -1; //pixels from left

    SendMessage(hStatus,SB_SETPARTS,5,(LPARAM)aWidth);
}
//------------------------------------------------------------------------------
// Creation de la barre d'outils raccourcis de la fenetre principale:
void Do_Toolbar(HWND hParent)
{
  int i;
  int BitMapAry[NUMBUTTONS] = {-1, 0, 1, 2,
  										 -1, 3, 4, 5, 6, 7, 8,  //Sector
                       			 -1, 9, 10, 11, 12,     //Edit
                               -1, 13,  //Disassemble
                               -1, 14,
                               -1, 15,  //Clear
                               -1, 16,
                               -1, 17, 18,
                               -1};  // conversion, help

  for (i = 0; i < NUMBUTTONS; i++)
  {
    ToolAry[i].iBitmap   = BitMapAry[i];
    ToolAry[i].idCommand = ID_TOOLBAR + i;
    ToolAry[i].fsState = TBSTATE_ENABLED;
    ToolAry[i].fsStyle = TBSTYLE_BUTTON;
    if (BitMapAry[i] == -1)
      ToolAry[i].fsStyle = TBSTYLE_SEP;
    ToolAry[i].dwData    = 0L;
    ToolAry[i].iString   = 0;
  }

  hToolbar = CreateToolbarEx(hParent,
               WS_CHILD | WS_VISIBLE | 
               TBSTYLE_TOOLTIPS | WS_BORDER,
               ID_TOOLBAR, NUMBITMAPS,
               hInstance, TOOLBARBMP,
               //HINST_COMMCTRL, IDB_STD_SMALL_COLOR,
               ToolAry, NUMBUTTONS, 
               BTNWIDTH, BTNHEIGHT, BMPWIDTH, BMPHEIGHT,
               sizeof(TBBUTTON));
}
//------------------------------------------------------------------------------
// Check the command line passed to ARFD at the first running starting time
BOOL Get_CmdLine_FileName(void)
{
   //static char * ps;
   GetCurrentDirectory(STRSIZE,(LPTSTR) szAppPathDir);
   //ps = GetCommandLine(); just for information
   if (szTmpCmdLine[0] == '\0')
   	return FALSE;
   else
   	return TRUE;
}
//------------------------------------------------------------------------------
// Check if the filename is a *.ATR or *.atr file
BOOL Is_ATR_File(void)
{
	char *ps;
   char t1[] = "ATR";
   char t2[] = "atr";
	ps = szAtariFileName;
	while (*ps) //tant que l'on est pas en fin de chaine
   {
		if (*ps == '.')    // chercher le '.'
      {
      	ps++;
         if ((strcmp(ps,t1) == 0) || (strcmp(ps,t2) == 0))
           if (*(ps+3) == 0)
          	return TRUE;
      }
      else ps++;
   }
   return FALSE;
}
//------------------------------------------------------------------------------
// Display information on the main edit display window at the beginning
void Show_Intro_Data(HWND hwnd)
{
   char szNoFileInfo[]="[No file loaded in memory]";
	Add_EndRichText(hMainRText," Atari Rom File Designer by Philippe VUILLERME (c) PVBest 2001-2002\r\n");
   Make_Bold_Line(hMainRText,0);
	Add_EndRichText(hMainRText," \r\n ");
	//Add_RichText(hMainRText," * Please note the following:   *\r\n");
	//Add_RichText(hMainRText," * This software is a freeware  *\r\n");
   //Add_RichText(hMainRText," * Rev 1.8.0 is under beta test *\r\n");
   //Add_RichText(hMainRText," * Thanks to help me reporting  *\r\n");
	//Add_RichText(hMainRText," * the bugs you'll find! Enjoy! *\r\n");
	//Add_RichText(hMainRText," **** mailto:PVBest@free.fr  ****\r\n");
	if (bOpenCmdParamFile)
	{
		wsprintf(lpsTmpCB," Command String passed to the application (file to open):\r\n '%s'\r\n",szTmpCmdLine);
		Add_EndRichText(hMainRText,lpsTmpCB);
		strcpy(szAtariFileName,szTmpCmdLine);
		if (Open_An_Atari_File(hwnd, TRUE))
      	return;
	}
   //Pas de fichier charg  l'ouverture:
   //Afficher le texte Nom de Fichier en titre de la fenetre + StatusBar:
   Set_Windows_Title(szNoFileInfo);
}
//------------------------------------------------------------------------------
// Open the disassembly thread (waiting loop)
BOOL Open_Wait_Thread(void)
{
	hDisThread = CreateThread(
                         NULL,        //Security attribute
                         0,           //Initial Stack
                         DisThreadFunc,  //Starting address of thread
                         NULL,        // argument of thread
                         0,           // Create flags
                         &DisThreadID);  // thread ID
   if (!hDisThread)
   {
   	MessageBox(hMainWindow, "ARFD Sys Error:\nNo thread available for disassembly process!",
      	szDlgBoxMain, MB_OK|MB_ICONSTOP);
      return FALSE;
   }
   return TRUE;
}
//------------------------------------------------------------------------------
// Thread for disassembly process...
//unsigned long _stdcall DisThreadFunc(void *)
DWORD WINAPI DisThreadFunc( LPVOID )
{
   int cx; // pourcentage de progression
   while(hWaitDlg == NULL){;}  //attente que la fenetre d'attente soit OK
	Add_EndRichText(hDisEditRText,
   	"\r\n** Atari Rom File Designer Desassembly by Philippe **\r\n \r\n");
   Add_RichText(hDisEditRText,lpsTmpCB);
   Add_RichText(hDisEditRText,"\r\n \r\n");
   Dis_CSector = D_Cur.FSect;
   Dis_CMemAddr = D_Cur.FMemAdd;
   Dis_COffset = D_Cur.SOff;
   Dis_CPosFile = Get_FilePosition(Dis_CSector,Dis_COffset);
   while (ARF_Disassembly() && !bEndDisThread)
   {
       Add_RichText(hDisEditRText, lpsTmpCB);

       if  (D_Cur.DisMem)
       {
       	cx = 100 * (Dis_CMemAddr - D_Cur.FMemAdd) / (D_Cur.LMemAdd +1 - D_Cur.FMemAdd);
         SendMessage(hWaitProgress, PBM_SETPOS, (WPARAM)(cx), 0);
       }
       else
       {
       	//SendMessage(hWaitProgress, PBM_STEPIT, 0, 0);
       	cx = 100 * (Dis_CSector - D_Cur.FSect) / (D_Cur.LSect +1 - D_Cur.FSect);
         SendMessage(hWaitProgress, PBM_SETPOS, (WPARAM)(cx), 0);
       }
   }
   Add_RichText(hDisEditRText, lpsTmpCB);
   SendMessage(hWaitProgress, PBM_SETPOS, (WPARAM)(100), 0); //barre au bout FIN !
   Add_RichText(hDisEditRText,"\r\n !*!*! DONE !*!*!");
   Add_RichText(hDisEditRText,"\r\n");
   SetFocus(hChildDisWindow); //c'est pour le clavier...
   ShowWindow(hChildDisWindow, SW_SHOWNORMAL);
   UpdateWindow(hChildDisWindow);
   bEndDisThread = TRUE;
   if (hWaitDlg) SendMessage(hWaitDlg,WM_COMMAND,CM_WAITOVER,0);
  	return 0;
}
//------------------------------------------------------------------------------
// Mettre  jour le titre des fenetres avec le nom de fichier en cours
// et mettre  jour la statusbar.
void Set_Windows_Title(LPSTR lpszTitleString)
{
   //Titre de la fenetre disassembly
   // NO TITLE because the window may contain disassembly from various file
   // Cancelled:
  	//if (hChildDisWindow)
  	//{
   //   wsprintf(lpsTmpCB, "%s - %s", szChildDisWindowTitle,lpszTitleString);
   //   SetWindowText(hChildDisWindow, lpsTmpCB);
  	//}
   //title of the Edit Sector Windows
  	if (hChildEditWindow)
  	{
  		wsprintf(lpsTmpCB, "%s - %s", szChildEditWindowTitle,lpszTitleString);
      SetWindowText(hChildEditWindow, lpsTmpCB);
  	}
  	wsprintf(lpsTmpCB, "%s - %s", szMainWindowTitle, lpszTitleString);
  	SetWindowText(hMainWindow, lpsTmpCB);
  	//Initialisation de la StatusBar de la main window:
  	if (bFileMem)
  	{
  		wsprintf(lpsTmpCB,"Loaded length: $%05X (%ld) bytes",
      	iFileLength,iFileLength);
  		SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)lpsTmpCB);
      wsprintf(lpsTmpCB,"$%03X sectors",AmParam.MAXSect);
  		SendMessage(hStatus,SB_SETTEXT,2,(LPARAM)lpsTmpCB);
      SendMessage(hStatus,SB_SETTEXT,3,(LPARAM)( bATRFlag ? "ATR" : "XFD"));
  		wsprintf(lpsTmpCB,"File name: %s",lpszTitleString);
  	}
  	else wsprintf(lpsTmpCB,"Please Open a file...");
  	SendMessage(hStatus,SB_SETTEXT,4,(LPARAM)lpsTmpCB);
}
//------------------------------------------------------------------------------
//File Tracing: Traiter les erreurs,
// le fichier tant en mmoire, proposer la sauvegare.
void Finalize_Tracing(HWND hwnd, int resultat)
{
		//HANDLE hFile;
   	int br;
  		BOOL bResult;
   	char szDialogTitle[] = "Save the Atari Binary File :";
   	char AFileName[128];
   	char LFileName[STRSIZE];

   	if (resultat >= 1)
   	{
            wsprintf(sTmpSTR,"Atari binary file tracking succesful!\nWould you like to save the Atari binary file?");
            if (MessageBox(hwnd,sTmpSTR,"Atari Binary File Tracing :",MB_YESNO | MB_ICONQUESTION) == IDYES)
            {
reopen:
               strcpy(AFileName,"");
               strcpy(LFileName,"");

               memset(szFileFilter,0x00,128);
               LoadString(hInstance,STRG_FILEFILTER_BIN,szFileFilter,128);
  					bResult = Get_FileName(hwnd, (LPSTR) LFileName,
		 					szFileFilter, (LPSTR) AFileName,
       					szDialogTitle, FALSE, FALSE, 1);

  					if (bResult)
  					{
                  if (iFilterIndex == 1) //selection .com
    						if ( !( !strcmp(szFileExtension,"com") || !strcmp(szFileExtension,"COM") ) )
                  	{
           				 	strcat(AFileName,".com");
                      	strcat(LFileName,".com");
                  	}

      				if (!Create_File(hwnd, LFileName, szDialogTitle,'W', &hFile)) //return;
                  	goto reopen;

                  if (!WriteFile(hFile, lpAtariFileTmp, resultat, (LPDWORD) &br, NULL))
                  	Handle_System_Error(hwnd, szDialogTitle, "while writing data", GetLastError());
                  SetEndOfFile(hFile);
    					Close_File(&hFile);

      				wsprintf(lpsTmpCB, "ARFD Info:\nAtari binary file saved into '%s' file!",AFileName);
  						MessageBox(hwnd,lpsTmpCB,szDialogTitle,MB_OK|MB_ICONINFORMATION);
                  wsprintf(lpsTmpCB, "\r\n Atari Binary file saved into :\r\n '%s'\r\n File saved at $%05X (d%d) bytes size\r\n",LFileName, resultat, resultat);
      				Add_EndRichText(hMainRText,lpsTmpCB);

               }
            }
            return;
   	}
		switch (resultat)
      {
         case 0:
         	wsprintf(lpsTmpCB,"Operation cancelled by user!");
         	break;
         case -1:
         	wsprintf(lpsTmpCB,"End Of File Encountered...");
         	break;
         case -2:
         	wsprintf(lpsTmpCB,"Wrong Next Sector Word...");
         	break;
         case -3:
            wsprintf(lpsTmpCB,"Wrong Byte per Sector Size...");
            break;
         case -4:
         	wsprintf(lpsTmpCB,"Wrong Rom disk file format : File Tracing not possible!");
         	break;
         case -5:
         	wsprintf(lpsTmpCB,"Wrong Binary File Ending : \r\n (No more bytes to read = wrong byte per sector data with next sector data null)!");
         	break;
      }
      if (iCurOff < (SectSize - 2))  // on ne lisait pas les paramtres du secteurs ?
          iCurOff = (UWORD) (SectSize - 2 - iCurOff);
      if ((resultat != 0) && (resultat != -4))
       	wsprintf(sTmpSTR,"\r\n at Sector:$%03X - Offset/Byte Size:$%02X (file position data index = $%05X)\r\n ",
         	iCurSect, iCurOff, (iCurFilePos-1));
      else wsprintf(sTmpSTR," \r\n ");
      MessageBox(hwnd,lpsTmpCB,"ARFD Atari Binary File Tracing Error :", MB_OK | MB_ICONWARNING);
      strcat(lpsTmpCB,sTmpSTR);
      Add_EndRichText(hMainRText,"\r\n");
      Add_RichText(hMainRText,lpsTmpCB);
}
//------------------------------------------------------------------------------
void Set_Com_Default_Config()
{
   AtrCOM = 1;
   AtrDDEVIC = 1;
   AtrDTIMEOUT1 = 40;
   AtrDTIMEOUT2 = 204;
}
//------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
BOOL Convert_OnCreate(HWND hwnd, LPCREATESTRUCT lpCreatStruct)
{
   PostMessage(hwnd, WM_COMMAND, IDC_INITDIALOG, 0);
	return TRUE;
}
void Convert_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
   int TheNumber;
   char szDlgTitle[] = "Number Input Error :";
   switch(id)
   {
      case IDC_INITDIALOG:
      	SetDlgItemText(hwnd,IDC_EDIT70,"");
			SetDlgItemText(hwnd,IDC_STATIC70,"");
			SetFocus(GetDlgItem(hwnd,IDC_EDIT70));
			bUSint = FALSE;
         break;
   	case IDOK:
      case IDCANCEL:
      	PostMessage(hwnd,WM_CLOSE,0,0);
         break;
      case IDC_CHECKBOX70:
      	bUSint = ! bUSint;
         break;
      case IDC_CONVTODEC:
      	if (GetDlgItemText(hwnd,IDC_EDIT70,sTmpSTR,9) && Is_Hexa_String(sTmpSTR))
         {
         	TheNumber = iGet_Hex(sTmpSTR);
         	if (bUSint)
         		wsprintf(sTmpSTR,"%u decimal",((UINT)TheNumber));
         	else
         		wsprintf(sTmpSTR,"%d decimal",TheNumber);
         	SetDlgItemText(hwnd,IDC_STATIC70, sTmpSTR);
         }
         else
         	MessageBox(hwnd,"ARFD input Error:\nInvalid hexadecimal number!",
         		szDlgTitle,MB_OK|MB_ICONWARNING);
         Edit_SetSel(GetDlgItem(hwnd,IDC_EDIT70),0,-1);
         SetFocus(GetDlgItem(hwnd,IDC_EDIT70));
         break;
      case IDC_CONVTOHEX:
      	if (GetDlgItemText(hwnd,IDC_EDIT70,sTmpSTR,12) && Is_Dec_String(sTmpSTR))
         {
         	TheNumber = iGet_Dec(sTmpSTR);
            wsprintf(sTmpSTR,"$%X",TheNumber);
            SetDlgItemText(hwnd,IDC_STATIC70, sTmpSTR);
         }
         else
         	MessageBox(hwnd,"ARFD input Error:\nInvalid decimal number!",
            	szDlgTitle,MB_OK|MB_ICONWARNING);
         Edit_SetSel(GetDlgItem(hwnd,IDC_EDIT70),0,-1);
         SetFocus(GetDlgItem(hwnd,IDC_EDIT70));
         break;
   }

}
//------------------------------------------------------------------------------
void Convert_OnSetFocus(HWND hwnd, HWND hwndOldFocus)
{
      // Give the keyboard focus to the edit control.
      SetFocus(GetDlgItem(hwnd,IDC_EDIT70));
}
//------------------------------------------------------------------------------
void Convert_OnClose(HWND hwnd)
{
    hConvertDlg = NULL;
    DestroyWindow(hwnd);
}
//------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------
void Test3(HWND hwnd)
{
   return;
}
//==============================================================================
//
// 			SPECIAL ARFD FUNCTIONS TO RESET OR TO CLOSE OPEN WINDOWS
//
//==============================================================================

void Reset_Edit_Sector(BOOL rstsectorone)
{
   //rstsectorone == FALSE -> simple reset
   //rstsectorone == TRUE  -> reset secteur n 1
   if (hChildEditWindow)
   {
      if (rstsectorone)
         	SendMessage(hChildEditWindow,WM_COMMAND,CM_RESETSECTORONE,0);
   	else
   			SendMessage(hChildEditWindow,WM_COMMAND,CM_EDITSECTORRESET,0);
   }

}

void Close_DirDialog()
{
	if (hAtariDirDlg) SendMessage(hAtariDirDlg,WM_CLOSE,0,0L);
}



