#ifndef ARFDMain_H
#define ARFDMain_H

//------------------------------------------------------------------------------
//     Declaration des procedures windows :
//------------------------------------------------------------------------------
   // Procedure de fenetres
   LRESULT FAR PASCAL _export WndProc(HWND, UINT, WPARAM, LPARAM);
   LRESULT FAR PASCAL _export ChildDisProc(HWND, UINT, WPARAM, LPARAM);
   LRESULT FAR PASCAL _export ChildConvertProc(HWND, UINT, WPARAM, LPARAM);
   BOOL Register(HINSTANCE hInst);
   HWND Create_MainARFDWindow(HINSTANCE hInst,int nCmdShow);
   HWND Create_DisassemblyChild(HINSTANCE hInst, int nCmdShow);
   HWND Create_ConvertChild(HINSTANCE hInst, int nCmdShow);

//------------------------------------------------------------------------------
//     Declaration des Classes des fonctions Crackeur de messages :
//------------------------------------------------------------------------------
   #define ARFD_DefProc DefWindowProc
   BOOL ARFD_OnCreate(HWND hwnd, LPCREATESTRUCT lpCreatStruct);
   void ARFD_OnDestroy(HWND hwnd);
   void ARFD_OnClose(HWND hwnd);
   void ARFD_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
   void ARFD_OnSize(HWND hwnd, UINT state, int cx, int cy);
   void ARFD_OnSetFocus(HWND hwnd, HWND hwndOldFocus);
   LRESULT ARFD_OnNotify(HWND hwnd, int idFrom, NMHDR * pnmhdr);

   #define DisaWin_DefProc DefWindowProc
   void DisaWin_OnSize(HWND hwnd, UINT state, int cx, int cy);
   BOOL DisaWin_OnCreate(HWND hwnd, LPCREATESTRUCT lpCreatStruct);
   void DisaWin_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
   void DisaWin_OnClose(HWND hwnd);

   #define Convert_DefProc DefWindowProc
   BOOL Convert_OnCreate(HWND hwnd, LPCREATESTRUCT lpCreatStruct);
   void Convert_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
   void Convert_OnSetFocus(HWND hwnd, HWND hwndOldFocus);
   void Convert_OnClose(HWND hwnd);
//------------------------------------------------------------------------------
//    Autres fonctions :
//------------------------------------------------------------------------------

   // Fonction du Thread desassemblage :
   DWORD WINAPI DisThreadFunc( LPVOID );
   // Fonctions auxiliaires :
   BOOL Get_CmdLine_FileName(void);
   BOOL Open_Wait_Thread(void);
   void Show_Intro_Data(HWND hwnd);
   BOOL Open_An_Atari_File(HWND hwnd, BOOL bCommandLine);
   void Save_The_Atari_File(HWND hwnd);
   void AddMode_Menu_Check(HWND hwnd);
   void Not_Yet_Available(HWND hwnd);
   void No_File(HWND hwnd);
   void Do_Status (HWND hParent);
   void Do_Toolbar (HWND hParent);
   BOOL Is_ATR_File(void);
   void Set_Windows_Title(LPSTR lpszTitleString);
   void Data_Searching(HWND hwnd);
   void MakeCallBackProcs(void);
   void New_File(HWND hwnd);
   void Finalize_Tracing(HWND hwnd, int resultat);
   void Set_Com_Default_Config();
   void Reset_Edit_Sector(BOOL rstsectorone);
   void Close_DirDialog();

#endif