/*******************************************************************************
 NODE NAME: MONITOR.CPP
 part of the Atari Rom File Designer source files
 contains the DISASSEMBLEUR AND OTHER STUFFS... for editing the Atari Rom files
--------------------------------------------------------------------------------
(c) PVBest 2001-2002. Written by Philippe VUILLERME. ATARI IS STILL ALIVE !!
--------------------------------------------------------------------------------
This code is an update of my previous Atari Monitor monitor.cc
(REV 2.00 MAY/JUNE 2001) adapted and modify
for the Atari Rom File Designer project.
--------------------------------------------------------------------------------
ORIGINAL CODE of Monitor.cpp is *not* written by me :
It contains code from (and is based upon) the MONITOR.C from ATARI 800 EMULATOR
by David Firth and his team. Thanks for your job : my programm is yours !
--------------------------------------------------------------------------------
** MY ADDITIONAL FEATURES: **
Disassembly has been modified and updated :
- The MNEMONIC ''SYMTABLE'' base has been updated as
  there were some errors in monitor.c
  (one error : {"COLPM0",0x0012},is in 0xD012 ! )
  I have added some comments for the address distribution in the Atari memory
- The original ''INSTR6502'' text char for disassembler has been updated
- the 2 charts 'Opcodetype' and 'Instr6205' have been merged
- cycle table has been updated
- Disassembly now hows new cycles displayed with '+' for unknown extra cycles
- The instruction type is updated and Normal/Enhanced code added.
*******************************************************************************/
//
/*---------------------**| ARFD SOURCE REVISION HISTORY |**---------------------
 Date:     | What:
-----------|--------------------------------------------------------------------
 JUNE 2002 | Clean updated source code for ARFD revision 1.9.0 (public realease)
------------------------------------------------------------------------------*/


//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//    Entete :
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

#define STRICT
#include <windows.h>
#pragma hdrstop
#include <stdio.h>
#include "MesTypes.h"
#include "ARFDFunctions.h"
#include "monitor.h"
#include "EditSector.h"

//------------------------------------------------------------------------------
//    Variables externes de ARFDesigner:
//------------------------------------------------------------------------------

extern   UBYTE * lpFileBuffer;
extern   TDIS_PARAM D_Cur;
extern   TMON_PARAM AmParam;

extern 	UWORD iCurSect;
extern 	UINT  iCurFilePos;
extern 	UWORD iCurOff;
//extern 	BOOL  bATRFlag;
extern   int   iFileLength;

//extern   HWND  hMainWindow;
//extern   HWND  hChildEditWindow;
//extern   HWND  EditWin;
//extern   BOOL  bChildEditWin;
extern   BOOL  bFileModified;

extern 	void  Add_RichText(HWND hAEdit, char * lpszAddString);
extern 	void  Add_EndRichText(HWND hAEdit, char * lpszAddString);
extern   int   Get_Title_Line_Number(HWND hAEdit);
extern   void  Make_Bold_Line(HWND hRichEdit, int iLine);

extern 	char * lpsTmpCB;
extern   char sTmpSTR[];
extern 	UWORD SectSize;

extern   int   iTitleLine;
//extern   char szDlgBoxMain[];

//Global for Data searching and Replacement
//extern   BOOL  SearchInProgress;  //TRUE if there is a search in progress (F3)
extern   int   iSearchMode;       //The search mode
extern   int   nSearchDataBytes;  //Number of the data bytes search
extern   char  szSRTitle[5][36];  //Action title string

//------------------------------------------------------------------------------
//    Variables pour la fonction dsassemblage externe de ARFDesigner :
//------------------------------------------------------------------------------
extern   UWORD Dis_CMemAddr;
extern   UINT Dis_CPosFile;
extern   UWORD Dis_CSector;
extern   UWORD Dis_COffset;

//Buffer pour les fichiers Atari lus...  65536 octets maximum
extern   UBYTE * lpAtariFileTmp;

//------------------------------------------------------------------------------
//    Procdures locales :
//------------------------------------------------------------------------------
UWORD 	Show_Instruction(UWORD inad, UINT pm, int wid);
void 		Show_Disassembly(int flag_label);
int 		Show_Label(UWORD Dis_CMemAddr);
UBYTE 	Current_Instruction();

//------------------------------------------------------------------------------
//    Variables Locales :
//------------------------------------------------------------------------------
static char   	tmpstring[80];  //Buffer Temporaire
static UBYTE 	instr1,instr2,instr3; //Les 3 instructions d'une ligne dsassemble
static int 		nbinstr,typeinstr,winstr,cinstr,ehinstr;
static char 	dis_label[16];
static char 	dis_line[96]; //Buffer temporaire pour une ligne dsassemble
static int 		dflag;

BOOL 	bAtrResult;
BOOL 	endoffile;
int 	ATR_SectorCount;
int 	ATR_SectorSize;
char 	szATRMessageTitle[] = "ATR Rom File Header :";

//------------------------------------------------------------------------------
//    Initialisation tdes ypes et des structures de donnes:
//------------------------------------------------------------------------------

typedef struct {
    UWORD file_header;
    UWORD file_startaddr;
    UWORD file_endaddr;
    UWORD file_firstsect;
    UINT  file_firstpos;
    UWORD file_size;
    UWORD file_nbsect;
    } ATR_FILE;
/* Nota : From the ATR Header structure in monitor.c :
struct struct_ATR_Header {
   UBYTE Magic1, Magic2, SecCountLo, SecCountHi,
   		SecSizeLo, SecSizeHi, HiSecCountLo, HiSecCountHi;
   char Gash[8];
	} ATR_Header;
*/

UBYTE ATR_Header_Data[8];
char ATR_Header_Gash[9];

char ATR_Header_Name[9][20] = {
   "Magic #1 (0x96 ?) ",
   "Magic #2 (0x02 ?) ",
   "SectorCountLow    ",
   "SectorCountHigh   ",
   "SectorSizeLow     ",
   "SectorSizeHigh    ",
   "HiSectorCountLow  ",
   "HiSectorCountHigh ",
   "Gash (8 bytes)    "};


ATARIDOSDIRECTORY addir;

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//      DECLARATION of the VARIABLES DATA for DISASSEMBLE FUNCTIONS
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

// FOR MONITOR_HINTS : Taken for Atari 800 Emulator Monitor.c  ****************/
typedef struct {
    char name[9];  // max. 8 characters
    UWORD addr;
  } symtable_rec;

  /*SYMBOL NAMES TAKEN FROM atari.equ - part of disassembler by Erich BACHER
    and from GTIA.H, POKEY.H, PIA.H & ANTIC.H                                */
  // SYMBOL TABLE UPDATED BY MYSELF !!!
  /*Note: all symbols must be sorted by address (binary search is used).
    Maximal length of symbol name is 8 characters (can be changed above).
    If the adress has different names when reading/writting to it (GTIA ports),
    put the read name first. */
    
symtable_rec symtable[] = {
    {"LGFLAG",  0x0000}, //added
    {"NGFLAG",  0x0001}, {"CASINI",  0x0002}, {"CASINI+1",0x0003}, {"RAMLO",   0x0004},
    {"RAMLO+1", 0x0005}, {"TRAMSZ",  0x0006}, {"CMCMD",   0x0007}, {"WARMST",  0x0008},
    {"BOOT",    0x0009}, {"DOSVEC",  0x000a}, {"DOSVEC+1",0x000b}, {"DOSINI",  0x000c},
    {"DOSINI+1",0x000d}, {"APPMHI",  0x000e}, {"APPMHI+1",0x000f}, {"POKMSK",  0x0010},
    {"BRKKEY",  0x0011}, {"RTCLOK",  0x0012}, {"RTCLOK+1",0x0013}, {"RTCLOK+2",0x0014},
    {"BUFADR",  0x0015}, {"BUFADR+1",0x0016}, {"ICCOMT",  0x0017}, {"DSKFMS",  0x0018},
    {"DSKFMS+1",0x0019}, {"DSKUTL",  0x001a}, {"DSKUTL+1",0x001b}, {"ABUFPT",  0x001c},
    {"ABUFPT+1",0x001d}, {"ABUFPT+2",0x001e}, {"ABUFPT+3",0x001f},
    {"ICHIDZ",  0x0020}, {"ICDNOZ",  0x0021}, {"ICCOMZ",  0x0022}, {"ICSTAZ",  0x0023},
    {"ICBALZ",  0x0024}, {"ICBAHZ",  0x0025}, {"ICPTLZ",  0x0026}, {"ICPTHZ",  0x0027},
    {"ICBLLZ",  0x0028}, {"ICBLHZ",  0x0029}, {"ICAX1Z",  0x002A}, {"ICAX2Z",  0x002B},
    {"ICAX3Z",  0x002C}, {"ICAX4Z",  0x002D}, {"ICAX5Z",  0x002E}, {"ICAX6Z",  0x002F},
    {"STATUS",  0x0030}, {"CHKSUM",  0x0031}, {"BUFRLO",  0x0032}, {"BUFRHI",  0x0033},
    {"BFENLO",  0x0034}, {"BFENHI",  0x0035}, {"LTEMP" ,  0x0036}, {"LTEMP+1", 0x0037},
    {"BUFRFL",  0x0038}, {"RECVDN",  0x0039}, {"XMTDON",  0x003A}, {"CHKSNT",  0x003B},
    {"NOCKSM",  0x003C}, {"BPTR"  ,  0x003D}, {"FTYPE" ,  0x003E}, {"FEOF"  ,  0x003F},
    {"FREQ"  ,  0x0040}, {"SOUNDR",  0x0041}, {"CRITIC",  0x0042}, {"FMSZPG",  0x0043},
    {"FMSZPG+1",0x0044}, {"FMSZPG+2",0x0045}, {"FMSZPG+3",0x0046}, {"FMSZPG+4",0x0047},
    {"FMSZPG+5",0x0048}, {"FMSZPG+6",0x0049}, {"ZCHAIN",  0x004A}, {"ZCHAIN+1",0x004B},
    {"DSTAT" ,  0x004C}, {"ATRACT",  0x004D}, {"DRKMSK",  0x004E}, {"COLRSH",  0x004F},
    {"TEMP"  ,  0x0050}, {"HOLD1" ,  0x0051}, {"LMARGN",  0x0052}, {"RMARGN",  0x0053},
    {"ROWCRS",  0x0054}, {"COLCRS",  0x0055}, {"COLCRS+1",0x0056}, {"DINDEX",  0x0057},
    {"SAVMSC",  0x0058}, {"SAVMSC+1",0x0059}, {"OLDROW",  0x005A}, {"OLDCOL",  0x005B},
    {"OLDCOL+1",0x005C}, {"OLDCHR",  0x005D}, {"OLDADR",  0x005E}, {"OLDADR+1",0x005F},
    {"FKDEF" ,  0x0060}, {"FKDEF+1", 0x0061}, {"PALNTS",  0x0062}, {"LOGCOL",  0x0063},
    {"ADRESS",  0x0064}, {"ADRESS+1",0x0065}, {"MLTTMP",  0x0066}, {"MLTTMP+1",0x0067},
    {"SAVADR",  0x0068}, {"SAVADR+1",0x0069}, {"RAMTOP",  0x006A}, {"BUFCNT",  0x006B},
    {"BUFSTR",  0x006C}, {"BUFSTR+1",0x006D}, {"BITMSK",  0x006E}, {"SHFAMT",  0x006F},
    {"ROWAC" ,  0x0070}, {"ROWAC+1", 0x0071}, {"COLAC" ,  0x0072}, {"COLAC+1", 0x0073},
    {"ENDPT" ,  0x0074}, {"ENDPT+1", 0x0075}, {"DELTAR",  0x0076}, {"DELTAC",  0x0077},
    {"DELTAC+1",0x0078}, {"KEYDEF",  0x0079}, {"KEYDEF+1",0x007A}, {"SWPFLG",  0x007B},
    {"HOLDCH",  0x007C}, {"INSDAT",  0x007D}, {"COUNTR",  0x007E}, {"COUNTR+1",0x007F},
    {"LOMEM" ,  0x0080}, {"LOMEM+1", 0x0081}, {"VNTP"  ,  0x0082}, {"VNTP+1",  0x0083},
    {"VNTD"  ,  0x0084}, {"VNTD+1",  0x0085}, {"VVTP"  ,  0x0086}, {"VVTP+1",  0x0087},
    {"STMTAB",  0x0088}, {"STMTAB+1",0x0089}, {"STMCUR",  0x008A}, {"STMCUR+1",0x008B},
    {"STARP" ,  0x008C}, {"STARP+1", 0x008D}, {"RUNSTK",  0x008E}, {"RUNSTK+1",0x008F},
    {"TOPSTK",  0x0090}, {"TOPSTK+1",0x0091}, {"MEOLFLG", 0x0092}, {"POKADR",  0x0095},
    {"POKADR+1",0x0096}, {"DATAD" ,  0x00B6}, {"DATALN",  0x00B7}, {"DATALN+1",0x00B8},
    {"STOPLN",  0x00BA}, {"STOPLN+1",0x00BB}, {"SAVCUR",  0x00BE}, {"IOCMD" ,  0x00C0},
    {"IODVC" ,  0x00C1}, {"PROMPT",  0x00C2}, {"ERRSAVE", 0x00C3}, {"COLOUR",  0x00C8},
    {"PTABW" ,  0x00C9}, {"LOADFLG", 0x00CA}, {"FR0"   ,  0x00D4}, {"FR0+1" ,  0x00D5},
    {"FR0+2" ,  0x00D6}, {"FR0+3" ,  0x00D7}, {"FR0+4" ,  0x00D8}, {"FR0+5" ,  0x00D9},
    {"FRE"   ,  0x00DA}, {"FRE+1" ,  0x00DB}, {"FRE+2" ,  0x00DC}, {"FRE+3" ,  0x00DD},
    {"FRE+4" ,  0x00DE}, {"FRE+5" ,  0x00DF}, {"FR1"   ,  0x00E0}, {"FR1+1" ,  0x00E1},
    {"FR1+2" ,  0x00E2}, {"FR1+3" ,  0x00E3}, {"FR1+4" ,  0x00E4}, {"FR1+5" ,  0x00E5},
    {"FR2"   ,  0x00E6}, {"FR2+1" ,  0x00E7}, {"FR2+2" ,  0x00E8}, {"FR2+3" ,  0x00E9},
    {"FR2+4" ,  0x00EA}, {"FR2+5" ,  0x00EB}, {"FRX"   ,  0x00EC}, {"EEXP"  ,  0x00ED},
    {"NSIGN" ,  0x00EE}, {"ESIGN" ,  0x00EF}, {"FCHRFLG", 0x00F0}, {"DIGRT" ,  0x00F1},
    {"CIX"   ,  0x00F2}, {"INBUFF",  0x00F3}, {"INBUFF+1",0x00F4}, {"ZTEMP1",  0x00F5},
    {"ZTEMP1+1",0x00F6}, {"ZTEMP4",  0x00F7}, {"ZTEMP4+1",0x00F8}, {"ZTEMP3",  0x00F9},
    {"ZTEMP3+1",0x00FA}, {"RADFLG",  0x00FB}, {"FLPTR" ,  0x00FC}, {"FLPTR+1", 0x00FD},
    {"FPTR2" ,  0x00FE}, {"FPTR2+1", 0x00FF},
    {"STACK" ,  0x0100}, {"STACK" ,  0x01FF}, //added: /*Stack 100-1FF */
    {"VDSLST",  0x0200}, {"VDSLST+1",0x0201}, {"VPRCED",  0x0202}, {"VPRCED+1",0x0203},
    {"VINTER",  0x0204}, {"VINTER+1",0x0205}, {"VBREAK",  0x0206}, {"VBREAK+1",0x0207},
    {"VKEYBD",  0x0208}, {"VKEYBD+1",0x0209}, {"VSERIN",  0x020A}, {"VSERIN+1",0x020B},
    {"VSEROR",  0x020C}, {"VSEROR+1",0x020D}, {"VSEROC",  0x020E}, {"VSEROC+1",0x020F},
    {"VTIMR1",  0x0210}, {"VTIMR1+1",0x0211}, {"VTIMR2",  0x0212}, {"VTIMR2+1",0x0213},
    {"VTIMR4",  0x0214}, {"VTIMR4+1",0x0215}, {"VIMIRQ",  0x0216}, {"VIMIRQ+1",0x0217},
    {"CDTMV1",  0x0218}, {"CDTMV1+1",0x0219}, {"CDTMV2",  0x021A}, {"CDTMV2+1",0x021B},
    {"CDTMV3",  0x021C}, {"CDTMV3+1",0x021D}, {"CDTMV4",  0x021E}, {"CDTMV4+1",0x021F},
    {"CDTMV5",  0x0220}, {"CDTMV5+1",0x0221}, {"VVBLKI",  0x0222}, {"VVBLKI+1",0x0223},
    {"VVBLKD",  0x0224}, {"VVBLKD+1",0x0225}, {"CDTMA1",  0x0226}, {"CDTMA1+1",0x0227},
    {"CDTMA2",  0x0228}, {"CDTMA2+1",0x0229}, {"CDTMF3",  0x022A}, {"SRTIMR",  0x022B},
    {"CDTMF4",  0x022C}, {"INTEMP",  0x022D}, {"CDTMF5",  0x022E}, {"SDMCTL",  0x022F},
    {"SDLSTL",  0x0230}, {"SDLSTH",  0x0231}, {"SSKCTL",  0x0232}, {"SPARE" ,  0x0233},
    {"LPENH" ,  0x0234}, {"LPENV" ,  0x0235}, {"BRKKY" ,  0x0236}, {"BRKKY+1", 0x0237},
    {"VPIRQ" ,  0x0238}, {"VPIRQ+1", 0x0239}, {"CDEVIC",  0x023A}, {"CCOMND",  0x023B},
    {"CAUX1" ,  0x023C}, {"CAUX2" ,  0x023D}, {"TMPSIO",  0x023E}, {"ERRFLG",  0x023F},
    {"DFLAGS",  0x0240}, {"DBSECT",  0x0241}, {"BOOTAD",  0x0242}, {"BOOTAD+1",0x0243},
    {"COLDST",  0x0244}, {"RECLEN",  0x0245}, {"DSKTIM",  0x0246}, {"PDVMSK",  0x0247},
    {"SHPDVS",  0x0248}, {"PDMSK" ,  0x0249}, {"RELADR",  0x024A}, {"RELADR+1",0x024B},
    {"PPTMPA",  0x024C}, {"PPTMPX",  0x024D},
    {"LINBUF",  0x024E}, {"LINBUF",  0x026A}, //added ???
    {"CHSALT",  0x026B}, {"VSFLAG",  0x026C},
    {"KEYDIS",  0x026D}, {"FINE"  ,  0x026E}, {"GPRIOR",  0x026F}, {"PADDL0",  0x0270},
    {"PADDL1",  0x0271}, {"PADDL2",  0x0272}, {"PADDL3",  0x0273}, {"PADDL4",  0x0274},
    {"PADDL5",  0x0275}, {"PADDL6",  0x0276}, {"PADDL7",  0x0277}, {"STICK0",  0x0278},
    {"STICK1",  0x0279}, {"STICK2",  0x027A}, {"STICK3",  0x027B}, {"PTRIG0",  0x027C},
    {"PTRIG1",  0x027D}, {"PTRIG2",  0x027E}, {"PTRIG3",  0x027F}, {"PTRIG4",  0x0280},
    {"PTRIG5",  0x0281}, {"PTRIG6",  0x0282}, {"PTRIG7",  0x0283}, {"STRIG0",  0x0284},
    {"STRIG1",  0x0285}, {"STRIG2",  0x0286}, {"STRIG3",  0x0287}, {"HIBYTE",  0x0288},
    {"WMODE" ,  0x0289}, {"BLIM"  ,  0x028A}, {"IMASK" ,  0x028B}, {"JVECK" ,  0x028C},
    {"NEWADR",  0x028E}, {"TXTROW",  0x0290}, {"TXTCOL",  0x0291}, {"TXTCOL+1",0x0292},
    {"TINDEX",  0x0293}, {"TXTMSC",  0x0294}, {"TXTMSC+1",0x0295}, {"TXTOLD",  0x0296},
    {"TXTOLD+1",0x0297}, {"TXTOLD+2",0x0298}, {"TXTOLD+3",0x0299}, {"TXTOLD+4",0x029A},
    {"TXTOLD+5",0x029B}, {"CRETRY",  0x029C}, {"HOLD3" ,  0x029D}, {"SUBTMP",  0x029E},
    {"HOLD2" ,  0x029F}, {"DMASK" ,  0x02A0}, {"TMPLBT",  0x02A1}, {"ESCFLG",  0x02A2},
    {"TABMAP",  0x02A3}, {"TABMAP+1",0x02A4}, {"TABMAP+2",0x02A5}, {"TABMAP+3",0x02A6},
    {"TABMAP+4",0x02A7}, {"TABMAP+5",0x02A8}, {"TABMAP+6",0x02A9}, {"TABMAP+7",0x02AA},
    {"TABMAP+8",0x02AB}, {"TABMAP+9",0x02AC}, {"TABMAP+A",0x02AD}, {"TABMAP+B",0x02AE},
    {"TABMAP+C",0x02AF}, {"TABMAP+D",0x02B0}, {"TABMAP+E",0x02B1}, {"LOGMAP",  0x02B2},
    {"LOGMAP+1",0x02B3}, {"LOGMAP+2",0x02B4}, {"LOGMAP+3",0x02B5}, {"INVFLG",  0x02B6},
    {"FILFLG",  0x02B7}, {"TMPROW",  0x02B8}, {"TMPCOL",  0x02B9}, {"TMPCOL+1",0x02BA},
    {"SCRFLG",  0x02BB}, {"HOLD4" ,  0x02BC}, {"DRETRY",  0x02BD}, {"SHFLOC",  0x02BE},
    {"BOTSCR",  0x02BF}, {"PCOLR0",  0x02C0}, {"PCOLR1",  0x02C1}, {"PCOLR2",  0x02C2},
    {"PCOLR3",  0x02C3}, {"COLOR0",  0x02C4}, {"COLOR1",  0x02C5}, {"COLOR2",  0x02C6},
    {"COLOR3",  0x02C7}, {"COLOR4",  0x02C8}, {"RUNADR",  0x02C9}, {"RUNADR+1",0x02CA},
    {"HIUSED",  0x02CB}, {"HIUSED+1",0x02CC}, {"ZHIUSE",  0x02CD}, {"ZHIUSE+1",0x02CE},
    {"GBYTEA",  0x02CF}, {"GBYTEA+1",0x02D0}, {"LOADAD",  0x02D1}, {"LOADAD+1",0x02D2},
    {"ZLOADA",  0x02D3}, {"ZLOADA+1",0x02D4}, {"DSCTLN",  0x02D5}, {"DSCTLN+1",0x02D6},
    {"ACMISR",  0x02D7}, {"ACMISR+1",0x02D8}, {"KRPDER",  0x02D9}, {"KEYREP",  0x02DA},
    {"NOCLIK",  0x02DB}, {"HELPFG",  0x02DC}, {"DMASAV",  0x02DD}, {"PBPNT" ,  0x02DE},
    {"PBUFSZ",  0x02DF}, {"RUNAD" ,  0x02E0}, {"RUNAD+1", 0x02E1}, {"INITAD",  0x02E2},
    {"INITAD+1",0x02E3}, {"RAMSIZ",  0x02E4}, {"MEMTOP",  0x02E5}, {"MEMTOP+1",0x02E6},
    {"MEMLO" ,  0x02E7}, {"MEMLO+1", 0x02E8}, {"HNDLOD",  0x02E9}, {"DVSTAT",  0x02EA},
    {"DVSTAT+1",0x02EB}, {"DVSTAT+2",0x02EC}, {"DVSTAT+3",0x02ED}, {"CBAUDL",  0x02EE},
    {"CBAUDH",  0x02EF}, {"CRSINH",  0x02F0}, {"KEYDEL",  0x02F1}, {"CH1"   ,  0x02F2},
    {"CHACT" ,  0x02F3}, {"CHBAS" ,  0x02F4}, {"NEWROW",  0x02F5}, {"NEWCOL",  0x02F6},
    {"NEWCOL+1",0x02F7}, {"ROWINC",  0x02F8}, {"COLINC",  0x02F9}, {"CHAR"  ,  0x02FA},
    {"ATACHR",  0x02FB}, {"CH"    ,  0x02FC}, {"FILDAT",  0x02FD}, {"DSPFLG",  0x02FE},
    {"SSFLAG",  0x02FF},
    {"DDEVIC",  0x0300}, {"DUNIT"   ,0x0301}, {"DCOMND"  ,0x0302}, {"DSTATS"  ,0x0303},
    {"DBUFLO"  ,0x0304}, {"DBUFHI"  ,0x0305}, {"DTIMLO"  ,0x0306}, {"DUNUSE"  ,0x0307},
    {"DBYTLO"  ,0x0308}, {"DBYTHI"  ,0x0309}, {"DAUX1"   ,0x030A}, {"DAUX2"   ,0x030B},
    {"TIMER1"  ,0x030C}, {"TIMER1+1",0x030D}, {"ADDCOR"  ,0x030E}, {"CASFLG"  ,0x030F},
    {"TIMER2"  ,0x0310}, {"TIMER2+1",0x0311}, {"TEMP1"   ,0x0312}, {"TEMP1+1", 0x0313},
    {"TEMP2"   ,0x0314}, {"TEMP3"   ,0x0315}, {"SAVIO"   ,0x0316}, {"TIMFLG",  0x0317},
    {"STACKP",  0x0318}, {"TSTAT"   ,0x0319},
    {"HATABS",  0x031a}, {"HATABS",  0x033C}, //added : /*HATABS +0 to + $22)*/
    {"PUTBT1",  0x033d}, {"PUTBT2",  0x033e}, {"PUTBT3",  0x033f},
    {"B0-ICHID",0x0340}, {"B0-ICDNO",0x0341}, {"B0-ICCOM",0x0342}, {"B0-ICSTA",0x0343},
    {"B0-ICBAL",0x0344}, {"B0-ICBAH",0x0345}, {"B0-ICPTL",0x0346}, {"B0-ICPTH",0x0347},
    {"B0-ICBLL",0x0348}, {"B0-ICBLH",0x0349}, {"B0-ICAX1",0x034a}, {"B0-ICAX2",0x034b},
    {"B0-ICAX3",0x034c}, {"B0-ICAX4",0x034d}, {"B0-ICAX5",0x034e}, {"B0-ICAX6",0x034f},
    {"B1-ICHID",0x0350}, {"B1-ICDNO",0x0351}, {"B1-ICCOM",0x0352}, {"B1-ICSTA",0x0353},
    {"B1-ICBAL",0x0354}, {"B1-ICBAH",0x0355}, {"B1-ICPTL",0x0356}, {"B1-ICPTH",0x0357},
    {"B1-ICBLL",0x0358}, {"B1-ICBLH",0x0359}, {"B1-ICAX1",0x035a}, {"B1-ICAX2",0x035b},
    {"B1-ICAX3",0x035c}, {"B1-ICAX4",0x035d}, {"B1-ICAX5",0x035e}, {"B1-ICAX6",0x035f},
    {"B2-ICHID",0x0360}, {"B2-ICDNO",0x0361}, {"B2-ICCOM",0x0362}, {"B2-ICSTA",0x0363},
    {"B2-ICBAL",0x0364}, {"B2-ICBAH",0x0365}, {"B2-ICPTL",0x0366}, {"B2-ICPTH",0x0367},
    {"B2-ICBLL",0x0368}, {"B2-ICBLH",0x0369}, {"B2-ICAX1",0x036a}, {"B2-ICAX2",0x036b},
    {"B2-ICAX3",0x036c}, {"B2-ICAX4",0x036d}, {"B2-ICAX5",0x036e}, {"B2-ICAX6",0x036f},
    {"B3-ICHID",0x0370}, {"B3-ICDNO",0x0371}, {"B3-ICCOM",0x0372}, {"B3-ICSTA",0x0373},
    {"B3-ICBAL",0x0374}, {"B3-ICBAH",0x0375}, {"B3-ICPTL",0x0376}, {"B3-ICPTH",0x0377},
    {"B3-ICBLL",0x0378}, {"B3-ICBLH",0x0379}, {"B3-ICAX1",0x037a}, {"B3-ICAX2",0x037b},
    {"B3-ICAX3",0x037c}, {"B3-ICAX4",0x037d}, {"B3-ICAX5",0x037e}, {"B3-ICAX6",0x037f},
    {"B4-ICHID",0x0380}, {"B4-ICDNO",0x0381}, {"B4-ICCOM",0x0382}, {"B4-ICSTA",0x0383},
    {"B4-ICBAL",0x0384}, {"B4-ICBAH",0x0385}, {"B4-ICPTL",0x0386}, {"B4-ICPTH",0x0387},
    {"B4-ICBLL",0x0388}, {"B4-ICBLH",0x0389}, {"B4-ICAX1",0x038a}, {"B4-ICAX2",0x038b},
    {"B4-ICAX3",0x038c}, {"B4-ICAX4",0x038d}, {"B4-ICAX5",0x038e}, {"B4-ICAX6",0x038f},
    {"B5-ICHID",0x0390}, {"B5-ICDNO",0x0391}, {"B5-ICCOM",0x0392}, {"B5-ICSTA",0x0393},
    {"B5-ICBAL",0x0394}, {"B5-ICBAH",0x0395}, {"B5-ICPTL",0x0396}, {"B5-ICPTH",0x0397},
    {"B5-ICBLL",0x0398}, {"B5-ICBLH",0x0399}, {"B5-ICAX1",0x039a}, {"B5-ICAX2",0x039b},
    {"B5-ICAX3",0x039c}, {"B5-ICAX4",0x039d}, {"B5-ICAX5",0x039e}, {"B5-ICAX6",0x039f},
    {"B6-ICHID",0x03a0}, {"B6-ICDNO",0x03a1}, {"B6-ICCOM",0x03a2}, {"B6-ICSTA",0x03a3},
    {"B6-ICBAL",0x03a4}, {"B6-ICBAH",0x03a5}, {"B6-ICPTL",0x03a6}, {"B6-ICPTH",0x03a7},
    {"B6-ICBLL",0x03a8}, {"B6-ICBLH",0x03a9}, {"B6-ICAX1",0x03aa}, {"B6-ICAX2",0x03ab},
    {"B6-ICAX3",0x03ac}, {"B6-ICAX4",0x03ad}, {"B6-ICAX5",0x03ae}, {"B6-ICAX6",0x03af},
    {"B7-ICHID",0x03b0}, {"B7-ICDNO",0x03b1}, {"B7-ICCOM",0x03b2}, {"B7-ICSTA",0x03b3},
    {"B7-ICBAL",0x03b4}, {"B7-ICBAH",0x03b5}, {"B7-ICPTL",0x03b6}, {"B7-ICPTH",0x03b7},
    {"B7-ICBLL",0x03b8}, {"B7-ICBLH",0x03b9}, {"B7-ICAX1",0x03ba}, {"B7-ICAX2",0x03bb},
    {"B7-ICAX3",0x03bc}, {"B7-ICAX4",0x03bd}, {"B7-ICAX5",0x03be}, {"B7-ICAX6",0x03bf},
    {"PRNBUF",  0x03c0}, {"PRNBUF"  ,0x03e7}, //added: /*PRNBUF +0 to + $27 */
    {"SUPERF",  0x03e8}, {"CKEY",    0x03e9}, {"CASSBT",  0x03ea}, {"CARTCK",  0x03eb},
    {"DERRF",   0x03ec}, {"ACMVAR",  0x03ed}, {"ACMVAR",  0x03f7},//added: ??/*ACMVAR +0 to + $A*/
    {"BASICF",  0x03f8}, {"MINTLK",  0x03f9}, {"GINTLK",  0x03fa}, {"CHLINK",  0x03fb},
    {"CHLINK+1",0x03fc}, {"CASBUF",  0x03fd}, {"CASBUF",  0x047f},  /*CASBUF up to 0x047F ??*/
    /* 0480 - 04FF not used ??? */
    /* 0500 - 057F  free or spare */
    /* 0580 - 05FF tampon basic et virgule flottante LBUFF ?*/

    /* 0600 - 7FFF FREE RAM and/with
       8000 - BFFF Cartdridge 16Kb or free Ram
       A000 - BFFF ROM BASIC or Cartdridge 8Kb or free Ram*/

    //added:
    {"CARTCS",  0xbffa}, {"CARTCS+1", 0xbffb}, {"CART" ,  0xbffc}, {"CARTFG",  0xbffd},
    {"CARTAD",  0xbffe}, {"CARTAD+1", 0xbfff},  //only if cartridge.
    /* COOO - CFFF ROM O/S  with CC00 - CFFF char font rom */
    // Added : RUNUSE = read register unused !
    // added : WUNUSE = write register unused !
    /* D000 - D0FF : GTIA    */
    {"M0PF"  ,0xd000}, {"HPOSP0",0xd000}, {"M1PF"  ,0xd001}, {"HPOSP1",0xd001},
    {"M2PF"  ,0xd002}, {"HPOSP2",0xd002}, {"M3PF"  ,0xd003}, {"HPOSP3",0xd003},
    {"P0PF"  ,0xd004}, {"HPOSM0",0xd004}, {"P1PF"  ,0xd005}, {"HPOSM1",0xd005},
    {"P2PF"  ,0xd006}, {"HPOSM2",0xd006}, {"P3PF"  ,0xd007}, {"HPOSM3",0xd007},
    {"M0PL"  ,0xd008}, {"SIZEP0",0xd008}, {"M1PL"  ,0xd009}, {"SIZEP1",0xd009}, 
    {"M2PL"  ,0xd00a}, {"HPOSP2",0xd00a}, {"M3PL"  ,0xd00b}, {"HPOSP3",0xd00b},
    {"P0PL"  ,0xd00c}, {"SIZEM", 0xd00c}, {"P1PL"  ,0xd00d}, {"GRAFP0",0xd00d}, 
    {"P2PL"  ,0xd00e}, {"GRAFP1",0xd00e}, {"P3PL"  ,0xd00f}, {"GRAFP2",0xd00f},
    {"TRIG0" ,0xd010}, {"GRAFP3",0xd010}, {"TRIG1" ,0xd011}, {"GRAFM", 0xd011},
    {"TRIG2" ,0xd012}, {"COLPM0",0xd012}, {"TRIG3" ,0xd013}, {"COLPM1",0xd013},
    {"PAL"   ,0xd014}, {"COLPM2",0xd014}, {"RUNUSE",0xd015}, {"COLPM3",0xd015},
    {"RUNUSE",0xd016}, {"COLPF0",0xd016}, {"RUNUSE",0xd017}, {"COLPF1",0xd017},
    {"RUNUSE",0xd018}, {"COLPF2",0xd018}, {"RUNUSE",0xd019}, {"COLPF3",0xd019},
    {"RUNUSE",0xd01a}, {"COLBK", 0xd01a}, {"RUNUSE",0xd01b}, {"PRIOR", 0xd01b},
    {"VDELAY",0xd01c}, {"WUNUSE",0xd01c}, {"RUNUSE",0xd01d}, {"GRACTL",0xd01d},
    {"RUNUSE",0xd01e}, {"HITCLR",0xd01e}, {"CONSOL",0xd01f}, {"WUNUSE",0xd01f},
    /* D100 - D1FF : NOT USED */
    /* D200 - D2FF : POKEY    */    
    {"POT0"  ,0xd200}, {"AUDF1", 0xd200}, {"POT1"  ,0xd201}, {"AUDC1", 0xd201}, 
    {"POT2"  ,0xd202}, {"AUDF2", 0xd202}, {"POT3"  ,0xd203}, {"AUDC2", 0xd203},
    {"POT4"  ,0xd204}, {"AUDF3", 0xd204}, {"POT5"  ,0xd205}, {"AUDC3", 0xd205}, 
    {"POT6"  ,0xd206}, {"AUDF4", 0xd206}, {"POT7"  ,0xd207}, {"AUDC4", 0xd207},
    {"ALLPOT",0xd208}, {"AUDCTL",0xd208}, {"KBCODE",0xd209}, {"STIMER",0xd209}, 
    {"RANDOM",0xd20a}, {"SKREST",0xd20a}, {"RUNUSE",0xd20b}, {"POTGO", 0xd20b},
    {"SERIN", 0xd20d}, {"SEROUT",0xd20d}, {"IRQST", 0xd20e}, {"IRQEN", 0xd20e},
    {"SKSTAT",0xd20f}, {"SKCTL", 0xd20f},
    /* D300 - D3FF : PIA     */    
    {"PORTA", 0xd300}, {"PORTB", 0xd301}, {"PACTL", 0xd302}, {"PBCTL", 0xd303},
    /* D400 - D4FF : ANTIC   */       
    {"RUNUSE",0xd400}, {"DMACLT",0xd400}, {"RUNUSE",0xd401}, {"CHACTL",0xd401},
    {"DLISTL",0xd402}, {"DLISTH",0xd403},
    {"RUNUSE",0xd404}, {"HSCROL",0xd404}, {"RUNUSE",0xd405}, {"VSCROL",0xd405},
    {"RUNUSE",0xd407}, {"PMBASE",0xd407}, {"RUNUSE",0xd409}, {"CHBASE",0xd409},
    {"RUNUSE",0xd40a}, {"WSYNC", 0xd40a}, {"VCOUNT",0xd40b}, {"WUNUSE",0xd40b},
    {"PENH",  0xd40c}, {"WUNUSE",0xd40c}, {"PENL",  0xd40d}, {"WUNUSE",0xd40d},
    {"RUNUSE",0xd40e}, {"NMIEN", 0xd40e}, {"NMIST" ,0xd40f}, {"NMIRES",0xd40f},
    /* D500 - D7FF : NOT USED   */ 
    /* D800 - DFFF : ROM VIRGULE FLOTTANTE */                     
    {"AFP",   0xd800}, {"FASC",  0xd8e6}, {"IFP",   0xd9aa}, {"FPI",   0xd9d2},
    {"ZPRO",  0xda44}, {"ZF1",   0xda46}, {"FSUB",  0xda60}, {"FADD",  0xda66},
    {"FMUL",  0xdadb}, {"FDIV",  0xdb28}, {"PLYEVL",0xdd40}, {"FLD0R", 0xdd89},
    {"FLD0P", 0xdd8d}, {"FLD1R", 0xdd98}, {"FLD1P", 0xdd9c}, {"FST0R", 0xdda7},
    {"FST0P", 0xddab}, {"FMOVE", 0xddb6}, {"EXP",   0xddc0}, {"EXP10", 0xddcc},
    {"LOG",   0xdecd}, {"LOG10", 0xded1},
    /* E000 - FFFF : ROM OS E/S with E000 - E3FF char font rom */
    {"DSKIV", 0xe451},  //added
    {"DSKINV",0xe453}, {"CIOV",  0xe456}, {"SIOV",  0xe459}, {"SETVBV",0xe45c},
    {"SYSVBV",0xe45f}, {"XITVBV",0xe462}, {"SIOINV",0xe465}, {"SENDEV",0xe468},
    {"INTINV",0xe46b}, {"CIOINV",0xe46e}, {"SELFSV",0xe471}, {"WARMSV",0xe474},
    // {"SELFSV",0xe471} is also called BLKBDV ?
    {"COLDSV",0xe477}, {"RBLOKV",0xe47a}, {"CSOPIV",0xe47d}, {"PUPDIV",0xe480},
    {"SELFTSV",0xe483},{"PENTV", 0xe486}, {"PHUNLV",0xe489}, {"PHINIV",0xe48c},
    {"GPDVV", 0xe48f}
    };

int symtable_size=sizeof(symtable)/sizeof(symtable_rec);

/* 6502 Opcode type table bytes (based upon monitor.c) :
   bits 1-0 = instruction length ( 1, 2 or 3 bytes)
   bit 2    = //**** not used in monitor.c ***** (accumulator manipulation ???)
   			  // Used by me for NORMAL/ENHANCED  6502 OPCODES (written '+4')
   bit 3    = instruction writes to memory (without stack-manipulating instructions)
   bits 7-4 = adressing type:
     0 = NONE (implicit)   like NOP              /length = 1
     1 = ABSOLUTE          like JSR $4C0F        /length = 3
     2 = ZPAGE             like STA $14          /length = 2
     3 = ABSOLUTE_X        like STA $1250,X      /length = 3
     4 = ABSOLUTE_Y        like STA $1250,Y      /length = 3
     5 = INDIRECT_X        like STA ($12,X)      /length = 2
     6 = INDIRECT_Y        like STA ($12),Y      /length = 2
     7 = ZPAGE_X           like STA $40,X        /length = 2
     8 = ZPAGE_Y           like STA $40,Y        /length = 2
     9 = RELATIVE          like BNE $FE (-2)     /length = 2
     A = IMMEDIATE         like LDA #$CF         /length = 2
     B = ACCUMULATOR       like ROR  A           /length = 1
     C = STACK 2 or 3      RTI or RTS            /length = 1
     D = INDIRECT          like JMP ($FFFE) //only one opcode for the 6502 / Length = 3
     E = ESC RTS           // special opcode
     F = ESC               // special opcode
*/  

typedef struct {
    char mnemonic[4];  /* max. 3 characters */
    UBYTE optype;
  } optable6502_rec;

// So then +4 indicates that is an enhanced opcode not standard.
optable6502_rec opcode[256] =
{
/* 00 - 0F */
{"BRK", 0x01},{"ORA", 0x52},{"CIM", 0x01+4},{"ASO", 0x52+4},{"SKB", 0x01+4},{"ORA", 0x22},{"ASL", 0x2a},{"ASO", 0x22+4},
{"PHP", 0x01},{"ORA", 0xa2},{"ASL", 0xb1},{"ASO", 0xa2+4},{"SKW", 0x01+4},{"ORA", 0x13},{"ASL", 0x1b},{"ASO", 0x13+4},

/* 10 - 1F */
{"BPL", 0x92},{"ORA", 0x62},{"CIM", 0x01+4},{"ASO", 0x62+4},{"SKB", 0x01+4},{"ORA", 0x72},{"ASL", 0x7a},{"ASO", 0x72+4},
{"CLC", 0x01},{"ORA", 0x43},{"NOP", 0x01+4},{"ASO", 0x43+4},{"SKW", 0x01+4},{"ORA", 0x33},{"ASL", 0x3b},{"ASO", 0x33+4},

/* 20 - 2F */
{"JSR", 0x13},{"AND", 0x52},{"CIM", 0x01+4},{"RLA", 0x5a+4},{"BIT", 0x22},{"AND", 0x22},{"ROL", 0x2a},{"RLA", 0x2a+4},
{"PLP", 0x01},{"AND", 0xa2},{"ROL", 0xb1},{"RLA", 0xa2+4},{"BIT", 0x13},{"AND", 0x13},{"ROL", 0x1b},{"RLA", 0x1b+4},

/* 30 - 3F */
{"BMI", 0x92},{"AND", 0x62},{"CIM", 0x01+4},{"RLA", 0x6a+4},{"SKB", 0x01+4},{"AND", 0x72},{"ROL", 0x7a},{"RLA", 0x7a+4},
{"SEC", 0x01},{"AND", 0x43},{"NOP", 0x01+4},{"RLA", 0x4b+4},{"SKW", 0x01+4},{"AND", 0x33},{"ROL", 0x3b},{"RLA", 0x3b+4},

/* 40 - 4F */
{"RTI", 0xc1},{"EOR", 0x52},{"CIM", 0x01+4},{"LSE", 0x52+4},{"SKB", 0x01+4},{"EOR", 0x22},{"LSR", 0x2a},{"LSE", 0x22+4},
{"PHA", 0x01},{"EOR", 0xa2},{"LSR", 0xb1},{"ALR", 0xa2+4},{"JMP", 0x13},{"EOR", 0x13},{"LSR", 0x1b},{"LSE", 0x13+4},

/* 50 - 5F */
{"BVC", 0x92},{"EOR", 0x62},{"CIM", 0x01+4},{"LSE", 0x62+4},{"SKB", 0x01+4},{"EOR", 0x72},{"LSR", 0x7a},{"LSE", 0x72+4},
{"CLI", 0x01},{"EOR", 0x43},{"NOP", 0x01+4},{"LSE", 0x43+4},{"SKW", 0x01+4},{"EOR", 0x33},{"LSR", 0x3b},{"LSE", 0x33+4},

/* 60 - 6F */
{"RTS", 0xc1},{"ADC", 0x52},{"CIM", 0x01+4},{"RRA", 0x5a+4},{"SKB", 0x01+4},{"ADC", 0x22},{"ROR", 0x2a},{"RRA", 0x2a+4},
{"PLA", 0x01},{"ADC", 0xa2},{"ROR", 0xb1},{"ARR", 0xa2+4},{"JMP", 0xd3},{"ADC", 0x13},{"ROR", 0x1b},{"RRA", 0x1b+4},

/* 70 - 7F */
{"BVS", 0x92},{"ADC", 0x62},{"CIM", 0x01+4},{"RRA", 0x6a+4},{"SKB", 0x01+4},{"ADC", 0x72},{"ROR", 0x7a},{"RRA", 0x7a+4},
{"SEI", 0x01},{"ADC", 0x43},{"NOP", 0x01+4},{"RRA", 0x4b+4},{"SKW", 0x01+4},{"ADC", 0x33},{"ROR", 0x3b},{"RRA", 0x3b+4},

/* 80 - 8F */
{"SKB", 0x01+4},{"STA", 0x5a},{"SKB", 0x01+4},{"AXS", 0x5a+4},{"STY", 0x2a},{"STA", 0x2a},{"STX", 0x2a},{"AXS", 0x2a+4},
{"DEY", 0x01},{"SKB", 0x01+4},{"TXA", 0x01},{"XAA", 0xa2+4},{"STY", 0x1b},{"STA", 0x1b},{"STX", 0x1b},{"AXS", 0x1b+4},

/* 90 - 9F */
{"BCC", 0x92},{"STA", 0x6a},{"CIM", 0x01+4},{"AXS", 0x6a+4},{"STY", 0x7a},{"STA", 0x7a},{"STX", 0x8a},{"AXS", 0x8a+4},
{"TYA", 0x01},{"STA", 0x4b},{"TXS", 0x01  },{"XAA", 0x43+4},{"SKW", 0x01+4},{"STA", 0x3b},{"MKX", 0x13+4},{"MKA", 0x13+4},

/* A0 - AF */
{"LDY", 0xa2},{"LDA", 0x52},{"LDX", 0xa2},{"LAX", 0x52+4},{"LDY", 0x22},{"LDA", 0x22},{"LDX", 0x22},{"LAX", 0x22+4},
{"TAY", 0x01},{"LDA", 0xa2},{"TAX", 0x01},{"OAL", 0xa2+4},{"LDY", 0x13},{"LDA", 0x13},{"LDX", 0x13},{"LAX", 0x13+4},

/* B0 - BF */
{"BCS", 0x92},{"LDA", 0x62},{"CIM", 0x01+4},{"LAX", 0x62+4},{"LDY", 0x72},{"LDA", 0x72},{"LDX", 0x82},{"LAX", 0x72+4},
{"CLV", 0x01},{"LDA", 0x43},{"TSX", 0x01},{"AXA", 0x43+4},{"LDY", 0x33},{"LDA", 0x33},{"LDX", 0x43},{"LAX", 0x43+4},

/* C0 - CF */
{"CPY", 0xa2},{"CMP", 0x52},{"SKB", 0x01+4},{"DCM", 0x5a+4},{"CPY", 0x22},{"CMP", 0x22},{"DEC", 0x2a},{"DCM", 0x2a+4},
{"INY", 0x01},{"CMP", 0xa2},{"DEX", 0x01},{"SAX", 0xa2+4},{"CPY", 0x13},{"CMP", 0x13},{"DEC", 0x1b},{"DCM", 0x1b+4},

/* D0 - DF */
{"BNE", 0x92},{"CMP", 0x62},{"CIM", 0xe2+4},{"DCM", 0x6a+4},{"SKB", 0x01+4},{"CMP", 0x72},{"DEC", 0x7a},{"DCM", 0x7a+4},
{"CLD", 0x01},{"CMP", 0x43},{"NOP", 0x01+4},{"DCM", 0x4b+4},{"SKW", 0x01+4},{"CMP", 0x33},{"DEC", 0x3b},{"DCM", 0x3b+4},

/* E0 - EF */
{"CPX", 0xa2},{"SBC", 0x52},{"SKB", 0x01+4},{"INS", 0x5a+4},{"CPX", 0x22},{"SBC", 0x22},{"INC", 0x2a},{"INS", 0x2a+4},
{"INX", 0x01},{"SBC", 0xa2},{"NOP", 0x01},{"SBC", 0xa2+4},{"CPX", 0x13},{"SBC", 0x13},{"INC", 0x1b},{"INS", 0x1b+4},

/* E0 - EF */
{"BEQ", 0x92},{"SBC", 0x62},{"CIM", 0xf2+4},{"INS", 0x6a+4},{"SKB", 0x01+4},{"SBC", 0x72},{"INC", 0x7a},{"INS", 0x7a+4},
{"SED", 0x01},{"SBC", 0x43},{"NOP", 0x01+4},{"INS", 0x4b+4},{"SKW", 0x01+4},{"SBC", 0x33},{"INC", 0x3b},{"INS", 0x3b+4}
};

static int cycles[256] =
{
    7, 6, 2, 8, 3, 3, 5, 5, 3, 2, 2, 2, 4, 4, 6, 6,        // 0x
    2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7,        // 1x
    6, 6, 2, 8, 3, 3, 5, 5, 4, 2, 2, 2, 4, 4, 6, 6,        // 2x
    2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7,        // 3x

    6, 6, 2, 8, 3, 3, 5, 5, 3, 2, 2, 2, 3, 4, 6, 6,        // 4x
    2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7,        // 5x
    6, 6, 2, 8, 3, 3, 5, 5, 4, 2, 2, 2, 5, 4, 6, 6,        // 6x
    2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7,        // 7x

    2, 6, 2, 6, 3, 3, 3, 3, 2, 2, 2, 2, 4, 4, 4, 4,        // 8x
    2, 6, 2, 6, 4, 4, 4, 4, 2, 5, 2, 5, 5, 5, 5, 5,        // 9x
    2, 6, 2, 6, 3, 3, 3, 3, 2, 2, 2, 2, 4, 4, 4, 4,        // Ax
    2, 5, 2, 5, 4, 4, 4, 4, 2, 4, 2, 4, 4, 4, 4, 4,        // Bx

    2, 6, 2, 8, 3, 3, 5, 5, 2, 2, 2, 2, 4, 4, 6, 6,        // Cx
    2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7,        // Dx
    2, 6, 2, 8, 3, 3, 5, 5, 2, 2, 2, 2, 4, 4, 6, 6,        // Ex
    2, 5, 2, 8, 4, 4, 6, 6, 2, 4, 2, 7, 4, 4, 7, 7         // Fx
};


//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//  Code des procdures :
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//******************* PROCEDURES AFFICHAGE DES DONNEES ATARI *******************
//------------------------------------------------------------------------------

void Show_Symbole_Table(HWND hAEdit)
{
	int i,j;
   UWORD utmp,ntmp;
   char lname[9] = "";
   char iname[9] = "";
   char catype[12] = "READ/WRITE";
   j = 0;
   iTitleLine = Get_Title_Line_Number(hAEdit);
   strcpy(lpsTmpCB,"\r\n \r\n ATARI MEMORY ADDRESSES MNEMONIC SET LIST :\r\n");
   strcat(lpsTmpCB," Address word      = READ or WRITE   : LABEL NAME\r\n");
   strcat(lpsTmpCB," -------------------------------------------------\r\n");
	for (i=0; i<symtable_size; i++)
   {
      if (i != (symtable_size -1))
      	ntmp = symtable[i+1].addr;
      else ntmp = 0;
      utmp = symtable[i].addr;

      sprintf(tmpstring," Address $%02X \t = ",utmp);
      strcat(lpsTmpCB,tmpstring);

      if (utmp == ntmp)
      {
         strcpy(catype,"ONLY READ\t");
         strcat(lpsTmpCB,catype);
         strcpy(catype,"ONLY WRITE\t");
         j = 1;
      }
      else
      {
      	if (!j) strcpy(catype,"READ/WRITE\t");
      	strcat(lpsTmpCB,catype);
         j = 0;
      }
      strcpy(iname,symtable[i].name);
      if (strcmp(iname,lname) == 0)
         sprintf(tmpstring," : %s+%X \r\n",iname,(utmp-symtable[i-1].addr));
      else
      	sprintf(tmpstring," : %s \r\n",iname);
      strcpy(lname,iname);
      strcat(lpsTmpCB,tmpstring);
   }
   strcat(lpsTmpCB," \r\n");
   Add_EndRichText(hAEdit,lpsTmpCB);
   Make_Bold_Line(hAEdit,iTitleLine);
}

void Show_Instruction_Table(HWND hAEdit)
{
	int i;
   iTitleLine = Get_Title_Line_Number(hAEdit);
   strcpy(lpsTmpCB,"\r\n \r\n ATARI 65C02 OPCODES INSTRUCTION SET LIST :\r\n");
   strcat(lpsTmpCB," Byte: Opcode        Instruction type;     Byte nbr;	Cycle  ; Enhanced or not\r\n");
   strcat(lpsTmpCB," ------------------------------------------------------------------------------\r\n");
	for (i=0; i<256; i++)
   {
   	sprintf(tmpstring," $%02X : %s ",i,opcode[i].mnemonic);
      strcat(lpsTmpCB,tmpstring);
      Show_Instruction_Type((UBYTE) i);
      strcat(lpsTmpCB,dis_line);
      strcat(lpsTmpCB,"\t ");
      sprintf(tmpstring,"%d instr.;\t", nbinstr);
      strcat(lpsTmpCB,tmpstring);
      sprintf(tmpstring,"%d", cycles[i]);
      strcat(lpsTmpCB,tmpstring);
      if (cinstr) strcat(lpsTmpCB,"+");
        else strcat(lpsTmpCB," ");
      strcat(lpsTmpCB," cyc.;");
      if (ehinstr) strcat(lpsTmpCB," ENHANCED CODE;");
      strcat(lpsTmpCB," \r\n");
   }
   strcat(lpsTmpCB," \r\n");
   Add_EndRichText(hAEdit,lpsTmpCB);
   Make_Bold_Line(hAEdit,iTitleLine);
}

void Show_Instruction_Type(UBYTE Opcode)
{
   nbinstr = opcode[Opcode].optype & 0x03;
   ehinstr = opcode[Opcode].optype & 0x04;
   winstr = opcode[Opcode].optype & 0x08;
   cinstr = FALSE;  //instruction de branchement : nb de cycles x+ [FUTUR]
   typeinstr = (opcode[Opcode].optype & 0xF0) / 16;
   strcpy(dis_line,"\t");
   switch (typeinstr)
    {
          case 0 :
          	 sprintf(dis_line,"          Implicit;        ");
             break;
          case 12:
             sprintf(dis_line,"          Implicit + Stack;");
             break;
          case 1 :
          	 sprintf(dis_line,"$ADDR     Absolu;          ");
             break;
          case 2 :  // Z page
          	 sprintf(dis_line,"$PZ       Zero Page;       ");
             break;
          case 3 :
             cinstr = TRUE;
          	 sprintf(dis_line,"$ADDR,X   Absolu,X;        ");
             break;
          case 4 :
             cinstr = TRUE;
             sprintf(dis_line,"$ADDR,Y   Absolu,Y;        ");
             break;
          case 5 :
             sprintf(dis_line,"($PZ,X)   (Indirect,X);    ");
             break;
          case 6 :
             sprintf(dis_line,"($PZ),Y   (Indirect),Y;    ");
             break;
          case 7 :
             sprintf(dis_line,"$PZ,X     Page Zero,X;     ");
             break;
          case 8 :
             sprintf(dis_line,"$PZ,Y     Page Zero,Y;     ");
             break;
          case 9 :
             sprintf(dis_line,"$ADDR     Relative jump;   ");
             break;
          case 10:
             sprintf(dis_line,"#BYTE     Immediat;        ");
             break;
          case 11:
             sprintf(dis_line," A        Accumulator;     ");
             break;
          case 13:
				 sprintf(dis_line,"($ADDR)   Indirect;        ");
             break;
          case 14:
             sprintf(dis_line,"[ESC RTS] -Special-;       ");
             break;
          case 15:
             sprintf(dis_line,"[ESC]     -Special-;       ");
             break;
          default:
             sprintf(dis_line," ???      -UNKNOWN-;       ");
             break;
    }
}

BOOL Check_ATR(HWND hwnd)
{
   ULONG len;
   strcpy(lpsTmpCB,"\0");
   //SIO2PC ATR File Format must start with MAGIC1 = 0x96 and MAGIC2 = 0x02
	if ((ATR_Header_Data[0] == 0x96) && (ATR_Header_Data[1] == 0x02))
   {
      	sprintf(tmpstring," ARFD Info: It's a valid ATR file Header...\r\n");
         strcat(lpsTmpCB,tmpstring);
         bAtrResult = TRUE;
   }
   else
   {
        sprintf(tmpstring," ARFD Warning: This is not a valid ATR file Header (Wrong Magic1 & 2)!\r\n");
        bAtrResult = FALSE;
        MessageBox(hwnd,tmpstring,szATRMessageTitle,MB_OK | MB_ICONWARNING);
        strcat(lpsTmpCB,tmpstring);
   }
   ATR_SectorCount = (ATR_Header_Data[7]  << 24) | //header.hiseccounthi
				(ATR_Header_Data[6] << 16) |  			//header.hiseccountlo
				(ATR_Header_Data[3] << 8) |     			//header.seccounthi
				(ATR_Header_Data[2]);     			//header.seccountlo
   ATR_SectorSize = (ATR_Header_Data[5] << 8) |    //header.secsizehi
				(ATR_Header_Data[4]);						//header.secsizelo


    /*
    		// ATR header contains length in 16-byte chunks
			// First compute number of 128-byte chunks
			sectorcount[diskno - 1] = (header.hiseccounthi << 24 |
				header.hiseccountlo << 16 |
				header.seccounthi << 8 |
				header.seccountlo) >> 3; // SectorSize /= 8
			// Fix if double density from Atari Emulator...
			if (sectorsize[diskno - 1] == 256)
         {
				if (sectorcount[diskno - 1] & 1)
					sectorcount[diskno - 1] += 3;		// 128-byte boot sectors
				else
					boot_sectorsize[diskno - 1] = 256;	// 256-byte boot sectors
         	sectorcount[diskno - 1] >>= 1;
         }

         // sector size for XFD :
         if (file_length <= (1040 * 128))
				sectorsize[diskno - 1] = 128;	// single density
			else
         {
				sectorsize[diskno - 1] = 256;	// double density
				if ((file_length & 0xff) == 0)
					boot_sectorsize[diskno - 1] = 256;
			}
    */

    //En fait sectorcount contient une valeur multipli par 8
    //le vrai nombre de secteur est donc le suivant :
	 ATR_SectorCount  /= 8;
    //Test pour les secteur de taille 256:
    if (ATR_SectorSize == 256) // NOT TESTED ????????????????????????
    {
            // Compensate for first 3 sectors which must always be 128 bytes lenghth
				ATR_SectorCount += 3;
             //nombre de secteur rel = 2 fois moindre  ??????????????????
				ATR_SectorCount /= 2;
            // 16 is for the ATR header length, 3*128 for the first 3 sectors (lentgh = 128)
    			len = (ATR_SectorCount - 3) * ATR_SectorSize + 16 + 3*128;
    }
    else
    {
            //nombre de secteur rel = 2 fois moindre ????????????????????
				//ATR_SectorCount /= 2;
        		len = ATR_SectorCount * ATR_SectorSize + 16;
    }
    // ok, try to check if it's a valid SIO2PC ATR
    if (iFileLength == len)
    {
      	sprintf(tmpstring," ARFD Info: The length of the ATR File is correct...\r\n");
         strcat(lpsTmpCB,tmpstring);
    }
    else
    {
        sprintf(tmpstring," ARFD Error: The length of the file does not match!\r\n");
        bAtrResult = FALSE;
        MessageBox(hwnd,tmpstring,szATRMessageTitle,MB_OK | MB_ICONSTOP);
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring, " <Length should be %d as specified in ATR>\r\n", len);
        strcat(lpsTmpCB,tmpstring);
        return bAtrResult;
    }
    return bAtrResult;
}

/*    FOR XFD FILE [INFO ONLY - FROM SIO.C]
      { //If it is not an ATR, it's an XFD...
			format[diskno - 1] = XFD;
			// XFD might be of double density ! (PS)
         // in XFD the number of sector is calculated from the file length
         // Test the length and set the sector size :
			sectorsize[diskno - 1] = (file_length > (1040 * 128)) ? 256 : 128;
         //calculate the number of sector :
			sectorcount[diskno - 1] = file_length / sectorsize[diskno - 1];
		}

*/

void Make_ATR_Header(UWORD nSect, UWORD nSize)
{
   int a;
   a = nSect * 8;
   lpFileBuffer[7] = 0;							//header.hiseccounthi
	lpFileBuffer[6] = (UBYTE)(a >> 16);		//header.hiseccountlo
	lpFileBuffer[3] = (UBYTE)(a >> 8);   	//header.seccounthi
	lpFileBuffer[2] = (UBYTE)(a & 0xFF);   //header.seccountlo
   lpFileBuffer[0] = 0x96;
   lpFileBuffer[1] = 0x02;
   lpFileBuffer[4] = (UBYTE)(nSize & 0xFF);  //header.secsizehi
   lpFileBuffer[5] = (UBYTE)(nSize >> 8);   //header.secsizelo
}
DWORD Get_Sector_Param(char * TheString, UWORD TheSect)
{
    UWORD sz, nxtsector;
    UBYTE cks, nbyt;
    UINT fpos;
    DWORD dwReturned;
    fpos = Get_FilePosition(TheSect,0);
    sz = Size_Of_Sector(TheSect);
    cks = Get_CheckSum(TheSect);
    sprintf(tmpstring,"Checksum = $%02X,",cks);
    strcat(TheString,tmpstring);
    if ((sz == 0x7F) || (sz == 0xFF))
    {
    	nxtsector = (UWORD)((lpFileBuffer[fpos + sz - 1]+256*lpFileBuffer[fpos + sz - 2]) & 0x03FF);
    	sprintf(tmpstring," Next sector = $%03X,",nxtsector);
    	strcat(TheString,tmpstring);
      nbyt = lpFileBuffer[fpos + sz];
    	sprintf(tmpstring," Bytes per sector = $%02X",nbyt);   //?? &0x7F //&SectorSize ???
    	strcat(TheString,tmpstring);
    }
    else
    {
    	sprintf(tmpstring," Sector size = $%02X bytes (This is not an Atari Disk)",(sz+1));
    	strcat(TheString,tmpstring);
      nxtsector = 0xFFFF;
      nbyt = 0;
    }
    dwReturned = ((DWORD) nbyt << 24) | ((DWORD) nxtsector << 8) | ((DWORD) cks);
    return dwReturned;
}
int Get_Atari_File_Info(ATR_FILE * afile, UWORD asect)
{
    UINT cpos;
    cpos = Get_FilePosition(asect,0);
    afile->file_header =(UWORD) (returnFBN(&cpos) + returnFBN(&cpos) * 256);
    afile->file_startaddr =(UWORD) (returnFBN(&cpos) + returnFBN(&cpos) * 256);
    afile->file_endaddr = (UWORD) (returnFBN(&cpos) + returnFBN(&cpos) * 256);
    afile->file_firstsect = asect;
    afile->file_firstpos = cpos;
    afile->file_size = (UWORD) (afile->file_endaddr - afile->file_startaddr + 1);
    afile->file_nbsect = (UWORD) ((afile->file_size + 6) / 125 + 1);
    if (afile->file_header == 0xFFFF) return 1;
    return 0;
}

//------------------------------------------------------------------------------
// ****************************  Main procedures *******************************
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Display the ATR header :
//------------------------------------------------------------------------------
void Show_ATR_Header(HWND hAEdit)
{
	int i = 0;
   UBYTE d;

   iTitleLine = Get_Title_Line_Number(hAEdit);

   strcpy(lpsTmpCB," \r\n \r\n ATR FILE HEADER as following :\r\n");
	while (1)
   {
   	sprintf(tmpstring," Byte #%02X : ",i);
      strcat(lpsTmpCB,tmpstring);
      sprintf(tmpstring,"%s :", ATR_Header_Name[i]);
      strcat(lpsTmpCB,tmpstring);
      if (i == 8) break;
      d = lpFileBuffer[i];
      sprintf(tmpstring,"$%02X \r\n", d);
      ATR_Header_Data[i] = d;
      strcat(lpsTmpCB,tmpstring);
      i++;
   }
   for (i=8; i<16; i++)
   {
      d = lpFileBuffer[i];
   	sprintf(tmpstring,"$%02X ", d);
      strcat(lpsTmpCB,tmpstring);
      ATR_Header_Gash[(i-8)] = d;
   }
   ATR_Header_Gash[8] = 0;
   sprintf(tmpstring,"\r\n GASH[8] string = '%s' \r\n",ATR_Header_Gash);
   strcat(lpsTmpCB,tmpstring);
   strcat(lpsTmpCB," \r\n");
   Add_EndRichText(hAEdit,lpsTmpCB);
   Check_ATR(hAEdit);
   sprintf(tmpstring," <ATR file sector count = $%X (%d decimal) \r\n",
   	ATR_SectorCount, ATR_SectorCount);
   strcat(lpsTmpCB,tmpstring);
   sprintf(tmpstring," <ATR file sector size = $%X (%d decimal) \r\n",
   	ATR_SectorSize, ATR_SectorSize);
   strcat(lpsTmpCB,tmpstring);
   if (bAtrResult)
   	strcat(lpsTmpCB," DONE without any Error !\r\n");
   else
   	strcat(lpsTmpCB," ERROR in the ATR File Header, Sorry!\r\n");

   Add_EndRichText(hAEdit,lpsTmpCB);
   Make_Bold_Line(hAEdit,iTitleLine);
}

//------------------------------------------------------------------------------
// Display an Atari Disk Map with checksum:
//------------------------------------------------------------------------------
void View_DiskMap(HWND hAEdit, UWORD * TheLastNulSect)
{
    int i,count,xit;
    UBYTE ck;
    UWORD currsect, lastnulsect;

    if (hAEdit != NULL)
    	iTitleLine = Get_Title_Line_Number(hAEdit);

    sprintf(tmpstring,
        " \r\n \r\n ATARI DISK CHECKSUM MAP : %s \r\n ",AmParam.FName);
    strcpy(lpsTmpCB,tmpstring);
    sprintf(tmpstring,
        " \r\n SECTOR #>00 01 02 03 04 05 06 07 - 08 09 0A 0B 0C 0D 0E 0F");
    strcat(lpsTmpCB,tmpstring);
    sprintf(tmpstring,
        " \r\n ----------------------------------------------------------\r\n");
    strcat(lpsTmpCB,tmpstring);

    currsect = 1;
    lastnulsect = 1;
    xit = 0;
    count = 0;
    while (!xit)
    {
        sprintf(tmpstring,"  $%03X  : ", count*16);
        strcat(lpsTmpCB,tmpstring);
        for (i = 0; i < 16; i++)
        {
            if (!count && !i)
            {
               sprintf(tmpstring,"   ");
               strcat(lpsTmpCB,tmpstring);
               continue;
            }
            ck = Get_CheckSum(currsect);
            if (ck) lastnulsect = (UWORD) (currsect + 1);
            sprintf(tmpstring,"%02X ",ck);
            if (i == 7) strcat(tmpstring,"- ");
            strcat(lpsTmpCB,tmpstring);
            currsect++;
            if (currsect > AmParam.MAXSect )
            {
              xit = 1;
              break;
            }
        }
        count ++;
        sprintf(tmpstring," \r\n");
        strcat(lpsTmpCB,tmpstring);
    }
    if (lastnulsect != 1) lastnulsect -= (UWORD) 1;
    //if (lastnulsect <= AmParam.MAXSect)
    //{
    	sprintf(tmpstring,"\r\n Last Sector with data (not empty) = $%03X (d%d)",lastnulsect,lastnulsect);
    	strcat(lpsTmpCB,tmpstring);
    //}
    //else lastnulsect = AmParam.MAXSect;
    sprintf(tmpstring,"\r\n Total Number of Sector = $%03X (d%d) \r\n ",AmParam.MAXSect,AmParam.MAXSect);
    strcat(lpsTmpCB,tmpstring);
    if (TheLastNulSect != NULL) * TheLastNulSect = lastnulsect;
    if (hAEdit != NULL)
    {
    		Add_EndRichText(hAEdit,lpsTmpCB);
    		Make_Bold_Line(hAEdit,iTitleLine);
    }
}

//------------------------------------------------------------------------------
// Display the iCurSect sector :
//------------------------------------------------------------------------------
void View_Sector(HWND hAEdit)
{
    static UINT currpos;
    int i,count,nl;
    BOOL eofile;
    UWORD currsect, thedata;
    UBYTE char_ascii;
    char tmpchar[20];

    iTitleLine = Get_Title_Line_Number(hAEdit);

    currsect = iCurSect ;  // nouveau secteur courant
    iCurFilePos = Get_FilePosition(currsect,0); // Position courante dans le fichier pour le secteur
    currpos = iCurFilePos; //debut secteur

    sprintf(tmpstring,
        " \r\n \r\n VIEW SECTOR # $%03X (d%04d) \r\n  [File Offset:%05X] \r\n ",
        currsect,currsect,currpos);
    strcpy(lpsTmpCB,tmpstring);
    sprintf(tmpstring,
        " \r\n BYT#>00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F CHAR>0123456789ABCDEF");
    strcat(lpsTmpCB,tmpstring);
    sprintf(tmpstring,
        " \r\n --------------------------------------------------------------------------\r\n ");
    strcat(lpsTmpCB,tmpstring);
    eofile = FALSE;
    nl = SectSize/16 + 1;
    for (count = 0 ; count < nl; count++) // 8 lignes !!!
    {
        sprintf(tmpstring,"%02X : ", (count * 16)); // le repre offset debut de ligne
        strcat(lpsTmpCB,tmpstring);
        for (i = 0; i < 16; i++)                    // les 16 octets
        {
            if (!eofile)
            {
               thedata = returnFBN(&currpos);
               if (thedata & 0x8000)
               	eofile = TRUE;  // on a pas pu augmenter = fin de fichier (dernier octet)
            }
            if (eofile) // remplacer par des espaces...
            {
               sprintf(tmpstring,"   ");
               strcat(lpsTmpCB,tmpstring);
               tmpchar[i] = ' ';
            }
            else
            {
               sprintf(tmpstring,"%02X ", (thedata & 0x00FF));
               strcat(lpsTmpCB,tmpstring);
               char_ascii = (UBYTE) thedata;
               //cksect += char_ascii;
               //if (cksect > 255) cksect = cksect - 256 + 1;
               if (Is_Displayable(char_ascii ))
                     tmpchar[i] = (char) thedata;
               else
                     tmpchar[i] = '.';
            }
        }
        sprintf(tmpstring,"     ");                // Un espace vers ASCII
        strcat(lpsTmpCB,tmpstring);
        tmpchar[16] = '\0';
        strcat(lpsTmpCB,tmpchar);
        strcat(lpsTmpCB," \r\n ");
    }
    strcat(lpsTmpCB,"\r\n  ");
    Get_Sector_Param(lpsTmpCB, currsect);
    strcat(lpsTmpCB," \r\n ");
    Add_EndRichText(hAEdit,lpsTmpCB);
    Make_Bold_Line(hAEdit,iTitleLine);
}

//------------------------------------------------------------------------------
// Display boot sector information
//------------------------------------------------------------------------------
void Show_Boot(HWND hAEdit)
{
    UWORD stradr;
    UWORD bootini;
    UINT ipos;
    iTitleLine = Get_Title_Line_Number(hAEdit);
    ipos = Get_FilePosition(1,0);
    if (AmParam.MAXFL < 128)
    {
           sprintf(lpsTmpCB," \r\n \r\n BOOT SECTOR INFORMATION not available :");
           strcat(lpsTmpCB," This not an Atari Boot Disk file ! \r\n ");
           strcat(lpsTmpCB," (The file first sector must have at least 128 ($80) bytes) \r\n ");
    }
    else
    {
    	stradr = (UWORD) (lpFileBuffer[ipos+2] + lpFileBuffer[ipos+3]*256);
    	bootini = (UWORD) (lpFileBuffer[ipos+4] + lpFileBuffer[ipos+5]*256);
      sprintf(lpsTmpCB," \r\n \r\n BOOT SECTOR INFORMATION for the Atari Disk (in the first sector $001) :");
      	strcat(lpsTmpCB," \r\n Byte #:   LABEL:      VALUE:   COMMENTS:");
      	strcat(lpsTmpCB," \r\n -------------------------------------------------------");
    	 sprintf(tmpstring," \r\n #00:      DFLAGS      $%02X      First byte of the sector",lpFileBuffer[ipos+0]);
      strcat(lpsTmpCB,tmpstring);
    	 sprintf(tmpstring," \r\n #01:      DBSECT      $%02X      Number of sector to be read", lpFileBuffer[ipos+1]);
      strcat(lpsTmpCB,tmpstring);
    	 sprintf(tmpstring," \r\n #02-03:   BOOTAD      $%04X    Memory starting address for the loading",stradr);
      strcat(lpsTmpCB,tmpstring);
    	 sprintf(tmpstring," \r\n #04-05:   DOSINI      $%04X    Code execution starting address after a SEC+RTS",bootini);
      strcat(lpsTmpCB,tmpstring);
       sprintf(tmpstring," \r\n #06:   First instruction code to run at (BOOTAD)+6 = $%04X \r\n ",((stradr + 6) & 0xFFFF));
        strcat(lpsTmpCB,tmpstring);
    }
    Add_EndRichText(hAEdit,lpsTmpCB);
    Make_Bold_Line(hAEdit,iTitleLine);
}

//------------------------------------------------------------------------------
// Display the Atari disk directory
//------------------------------------------------------------------------------
BOOL Show_Dir(HWND hAEdit)
{
        // a verifier pour 256 octets par secteur (128 fichiers Atari??, Table alloc ?, Free blocks ??)
        UWORD tmpv;
        UBYTE tmpc;
        BOOL bResult;;
        char szTmpFName[12];
        int enhancedformat;
        UINT dpos,i,j;

        bResult = TRUE;
        iTitleLine = Get_Title_Line_Number(hAEdit);

        memset(&addir, 0, sizeof(ATARIDOSDIRECTORY));

        sprintf(lpsTmpCB, " \r\n  \r\n ATARI DISK DIRECTORY (DOS Rev. 2 & 3)\r\n Reading sectors $168 to $170 (360-368):");
        //if ((AmParam.MAXSect < 720) && ((SectSize != 0x7F) || (SectSize != 0xFF)))
        if (AmParam.MAXSect < 720)
        {
            strcat(lpsTmpCB,"\r\n  Atari disk directory is not available : This not an Atari DOS Disk file ! \r\n ");
            strcat(lpsTmpCB, " (The Atari Rom file must have at least 720 ($2D0) sectors,\r\n    and must have a size of 128/256 ($80/$100) bytes)\r\n ");
            bResult = FALSE;
            goto end;
        }
        dpos = Get_FilePosition(0x168,0);
        enhancedformat = (int) lpFileBuffer[dpos + 2];
        if (enhancedformat == 3)
        {
            strcpy(tmpstring,"\r\n Atari DOS disk format is enhanced (1040 sectors DOS formated) \r\n");
        }
        else if (enhancedformat == 2)
        {
            strcpy(tmpstring,"\r\n Atari DOS disk format is standard (720 sectors DOS formated) \r\n");
            addir.freeblocks = (UWORD) (lpFileBuffer[dpos+4] * 256 + lpFileBuffer[dpos+3]);
        }
        else
        {
        		enhancedformat = -1;
            strcat(lpsTmpCB,"\r\n This is not an Atari DOS disk format : Directory is not possible !!\r\n");
            strcat(lpsTmpCB," (Allocating table on sector $168 is wrong : It must only be a boot disk).\r\n");
            bResult = FALSE;
            goto end;
        }
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring, " \r\n FILE# Flag: Nb_block: First_sect:  Name:");
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring, " \r\n ---------------------------------------------- \r\n");
        strcat(lpsTmpCB,tmpstring);
        i = 0;
        dpos += (SectSize+1);
        while (TRUE)
        {
            if (!lpFileBuffer[dpos]) break;   //Si 00 arret...
            if (i >= 64) break;          // a verifier pour 256 octets par secteur (128 fichiers ??)
            i++;
            addir.adf[i-1].FFlag = lpFileBuffer[dpos];
            sprintf(tmpstring, " #%02X   $%02X   ",i,lpFileBuffer[dpos]);
            strcat(lpsTmpCB,tmpstring);
            tmpv = (UWORD) (lpFileBuffer[dpos+1] + lpFileBuffer[dpos+2]*256);
            addir.adf[i-1].FBlock = tmpv;
            sprintf(tmpstring,"$%04X     ",tmpv);
            strcat(lpsTmpCB,tmpstring);
            tmpv = (UWORD) (lpFileBuffer[dpos+3] + lpFileBuffer[dpos+4]*256);
            sprintf(tmpstring,"$%04X        ",tmpv);
            addir.adf[i-1].FSect = tmpv;
            strcat(lpsTmpCB,tmpstring);
            for (j=5;j<16;j++)
            {
            	 tmpc = lpFileBuffer[dpos+j];
                if (!Is_Displayable(tmpc))
                    tmpc = '.';
                szTmpFName[j-5] = tmpc;
            }
            szTmpFName[11] = '\0';
            strcat(lpsTmpCB,szTmpFName);
            strcpy(addir.adf[i-1].FName,szTmpFName);
            sprintf(tmpstring," \r\n");
            strcat(lpsTmpCB,tmpstring);
            dpos +=16;

        }
        addir.nbroffile = (UBYTE) i;
        sprintf(tmpstring, " \r\n Total number of files = $%02X (%d)  \r\n ",i,i);
        strcat(lpsTmpCB,tmpstring);
        if (enhancedformat == 3)
        {
            if (AmParam.MAXSect < 1024)  // erreur !!!
               enhancedformat = -2;
            else
            {
            	dpos = Get_FilePosition(0x400,0);
            	// secteur $400 = uniquement pour sector size 128 octets (pas de 256*1040 format !)
        			addir.freeblocks = (UWORD) (lpFileBuffer[dpos+0x7b] * 256 + lpFileBuffer[dpos+0x7a]);
            }
        }
        if (enhancedformat > 0)
        {
        		sprintf(tmpstring,
            	"Free Blocks (free sectors according to DOS) = $%03X (%d) \r\n",
             	addir.freeblocks,addir.freeblocks);
        		strcat(lpsTmpCB,tmpstring);
        }
        else  if (enhancedformat == -2)
        {
            strcat(lpsTmpCB,"WARNING !! FILE HAS BEEN UNCORRECTLY TRUNCATED :\r\n");
            strcat(lpsTmpCB," Rom File format must have at least 1024 ($400) sectors\r\n");
            strcat(lpsTmpCB," (When Enhanced Atari DOS format, the sector 1024 is needed) \r\n");
        }
end:
        Add_EndRichText(hAEdit,lpsTmpCB);
        Make_Bold_Line(hAEdit,iTitleLine);
        return bResult;
}

//------------------------------------------------------------------------------
// Display the Atari DOS binary file header
//------------------------------------------------------------------------------
int Display_Header(HWND hAEdit, UWORD FirstSect)
{       
		  ATR_FILE thefile;
        int result;
        iTitleLine = Get_Title_Line_Number(hAEdit);
        result = Get_Atari_File_Info(&thefile,iCurSect);
	     strcpy(lpsTmpCB," \r\n \r\n ATARI BINARY FILE TRACING : \r\n ");
        sprintf(tmpstring,"Atari Binary File Header on Sector $%03X information :\r\n",FirstSect);
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring," - HEADER BYTES \t= $%04X (header 2 first bytes)\r\n",thefile.file_header);
        strcat(lpsTmpCB,tmpstring);
        if (thefile.file_header != 0xFFFF) sprintf(tmpstring,"   This is not a standard executable file header:\r\n   it could be a Boot or Data in binary file.\r\n");
        else sprintf(tmpstring,"   This is a standard executable Atari binary file header (0xFFFF).\r\n");
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring," Information following are for the FIRST segment only:\r\n");
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring," - FIRSTADD \t= $%04X (Segment first memory address)\r\n", thefile.file_startaddr);
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring," - LASTADD  \t= $%04X (Segment last memory address)\r\n", thefile.file_endaddr);
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring," - FILESIZE \t= $%04X (Segment size in bytes)\r\n",thefile.file_size);
        strcat(lpsTmpCB,tmpstring);
        sprintf(tmpstring," - Expected number of sector for this Segment = $%04X\r\n",thefile.file_nbsect);
        strcat(lpsTmpCB,tmpstring);
        //sprintf(tmpstring," \r\n");
        //strcat(lpsTmpCB,tmpstring);
        Add_EndRichText(hAEdit,lpsTmpCB);
        Make_Bold_Line(hAEdit,iTitleLine);
        if (result)
        {
           if (MessageBox(hAEdit,
            	"It may be a valid Atari Binary Executable file header...\nClick OK to Continue file tracing?",
            	"Atari Binary File Tracing :",MB_OKCANCEL | MB_ICONQUESTION) != IDOK)
           		return 0; //Cancel by the user
        }
        else
        {
            if (MessageBox(hAEdit,
               "ARFD Warning:\nThis is not a standard Atari Binary Executable file header!\nThis could be a Boot or Data in binary file\nClick OK to Continue file tracing?",
            	"Atari Binary File Tracing :",MB_OKCANCEL | MB_ICONWARNING | MB_DEFBUTTON2) != IDOK)
            	 return 0; //Cancel by the user
        }
        return 1;
}

//------------------------------------------------------------------------------
// Trace the Atari DOS binary file
//------------------------------------------------------------------------------
int Trace_File(HWND hAEdit)
{
        //Nota : Block = Segment
        static UWORD FNextSect,FStartAdd,FEndAdd,nboctblock,d[3];
        static UBYTE FByte;
        int nblock, nsect;
        int OKFlag,Xit,FResult,i;
        //FResult and Trace_File returns
        //           -4 : Disk not valid (not a DOS 2 to 3 format)
        // FResult = -5 : Wrong DOS file Ending (terminate incorrectly)
        //           -2 : Wrong next sector
        //           -3 : Wrong number of bytes to read
        //            0 : Cancel by the user
        //        x > 0 : Number of bytes read for OK file
        // FResult = -1 : end of file encountered
        // FResult = 1 : normal read OK
        // FResult = 2 : normal read OK + New sector set for loading data
        // Trace_File returns FResult if negative value

        BOOL bStart,bFiB;
        UINT jpos,HeaderFlag;
        //iCurSect;
        //iCurOff = le nombre d'octet  lire dans cette fonction Trace_File
        // soit 'current offset' = SectSize - 2 - iCurOff ( = 0x7D - iCurrOff)

        bFiB = FALSE; //Boot or Data File flag (FALSE = normal executable file)
        nblock = 1;   //Premier Block
        nsect = 1;    //Premier Secteur
        jpos = 0;     //Position dans le buffer de lecture du fichier

        iTitleLine = Get_Title_Line_Number(hAEdit);
        if ((AmParam.MAXSect < 720) || ((SectSize != 0x7F) && (SectSize != 0xFF)))
        {
        		sprintf(lpsTmpCB, " \r\n  \r\n ATARI BINARY FILE TRACING not possible :");
            strcat(lpsTmpCB," This not an Atari DOS Disk file ! \r\n ");
            strcat(lpsTmpCB, " (The file must have at least 720 ($2D0) sectors of 128/256 ($80/$100) byte size) \r\n ");
            Add_EndRichText(hAEdit,lpsTmpCB);
            Make_Bold_Line(hAEdit,iTitleLine);
            return -4; // Disk Not Valid !
        }
        if (!Display_Header(hAEdit,iCurSect)) return 0;

        iCurOff = (UWORD)(SectSize - 2);  //0x7D (125) pour les secteur size de 0x80 (128)
        //lire les derniers octet du premier secteur pour lire les paramtres du fichier:
        iCurFilePos = Get_FilePosition(iCurSect,iCurOff);
        if (iCurFilePos == 0) return -1; // end of file encountered
        // lecture des paramtres du secteur et test;
        for (i = 0; i < 3; i++)
        {
        	d[i] = returnFBN(&iCurFilePos);
         if (d[i] & 0x8000) return -1;
        }
        FNextSect = (UWORD)( (d[0] & 0x03) * 256 + d[1]);  // le secteur suivant
        if ((FNextSect != 0) && ((FNextSect <= iCurSect) || (FNextSect > AmParam.MAXSect))) return -2;
        iCurOff = (UWORD) (d[2] & 0x00FF);  // nombre d'octets  lire
        if ((iCurOff>(SectSize-2)) || (iCurOff == 0)) return -3;

        // Starting binary file reading loop...
        sprintf(tmpstring,"\r\n Starting binary file reading loop...");
        Add_RichText(hAEdit,tmpstring);
        sprintf(tmpstring,"\r\n Sector #%03d : $%03X - Byte per sector: %02X - Checksum: %02X\r\n",nsect++,iCurSect,iCurOff,Get_CheckSum(iCurSect));
        Add_RichText(hAEdit,tmpstring);
        iCurFilePos = Get_FilePosition(iCurSect,0); // on se replace au dbut du premier secteur

        bStart = TRUE;        //Pour lire le premier entete FFFF
        HeaderFlag = TRUE;    //Pour lire un header de block/Segment
        nboctblock = 4;       //4 octets  lire normalement pour un block/Segment
        Xit = FALSE;  //Pour ne pas sortir de la boucle de lecture

        while (!Xit)
        ////////////////////////////////////////////////////////////////////////
        // START OF LOOP ...
        //----------------------------------------------------------------------
        {
           ////////////////////////////////////////////////////////////////////
           // Header lecture ...
           if (HeaderFlag) // != 0 Lecture de l'entete du bloc
           {
             //printf("\Entete #%d",nboctblock);
             FResult = ubyteFB(&FByte, &FNextSect);
             lpAtariFileTmp[jpos] = FByte;
             jpos++;
             nboctblock--;
             if (FResult < 0) break;
             if (nboctblock == 0) // == 0 : passage a zero : 4 octets de l'entete lus
             {
               FStartAdd = (UWORD) (lpAtariFileTmp[jpos-4] + 256 * lpAtariFileTmp[jpos-3]);
               FEndAdd = (UWORD) (lpAtariFileTmp[jpos-2] + 256 * lpAtariFileTmp[jpos-1]);
               if (FStartAdd == 0xFFFF &&FEndAdd == 0xFFFF)
               {
                   OKFlag = FALSE;
                   sprintf(tmpstring,"\r\n Wrong segment start/end address: $%04X-$%04X!!\r\n", FStartAdd, FEndAdd);
                   Add_RichText(hAEdit,tmpstring);
               }
               if ((FStartAdd == 0xFFFF) || bStart) // premier en tete
               {
                  if ((FStartAdd != 0xFFFF) && bStart) // Boot file
                  {
                  	bStart = FALSE;
                     bFiB = TRUE;
                  }
                  bStart = FALSE;
                  nboctblock = 2; // il en faut encore 2 !
                  if (!bFiB) sprintf(tmpstring," <Header : $%04X>\r\n",FStartAdd);
                  else sprintf(tmpstring," (If Boot in file: <Boot Header : $%04X> and \r\n",FStartAdd);
                  Add_RichText(hAEdit,tmpstring);
               }
               else
               {
                 nboctblock = (UWORD) (FEndAdd - FStartAdd  + 1);
                 HeaderFlag = FALSE;
                 if (!bFiB) sprintf(tmpstring," <Memory Segment #%03d : $%04X - $%04X; SIZE : $%04X Bytes>\r\n",nblock++,FStartAdd,FEndAdd,nboctblock);
                 else sprintf(tmpstring,"  <Boot Start Memory : $%04X; BOOTINI Run Address : $%04X>,\r\n  no meaning otherwise!)\r\n",FStartAdd,FEndAdd);
                 Add_RichText(hAEdit,tmpstring);

                 if ((FStartAdd > FEndAdd) && !bFiB)
                 {
                    OKFlag = FALSE;
                    sprintf(tmpstring,"\r\n Wrong Segment start/end address (Block Length: $%04X)!!\r\n", nboctblock);
                    Add_RichText(hAEdit,tmpstring);
                 }
               }
             }
           }
           ////////////////////////////////////////////////////////////////////
           // Block de donnes lecture ...
           else //header flag == 0 : lecture du block
           {
              FResult = ubyteFB(&FByte, &FNextSect);
              lpAtariFileTmp[jpos] = FByte;
              jpos++;
              nboctblock--;
              if (FResult < 0) break;
              //if (FResult == -1) : end of file encountered
           }
           ////////////////////////////////////////////////////////////////////
           // tests de fin ...
           if ((!iCurOff && !FNextSect && !nboctblock) || ((FResult == 0) && bFiB))
           // si les 3 sont a zero -> OK, c'est fini !!
           {
             Xit = TRUE;
             break;
           }
           else if (!iCurOff && !FNextSect && nboctblock && !bFiB)
           // is plus d'octet a lire et plus de secteur, mais tjrs un block -> ERREUR !
           {
             sprintf(tmpstring," ERROR : WRONG FILE ENDING !!\r\n");
             Add_RichText(hAEdit,tmpstring);
             sprintf(tmpstring," (Number of byte missing to read in the sector : $%04X)\r\n", nboctblock);
             Add_RichText(hAEdit,tmpstring);
             FResult = -5;
             break;
           }
           if (FResult == 2) //New sector has been loaded
           {
             sprintf(tmpstring," Sector #%03d : $%03X - Byte per Sector: %02X - Checksum: %02X\r\n",nsect++,iCurSect,iCurOff,Get_CheckSum(iCurSect));
             Add_RichText(hAEdit,tmpstring);
           }
           if (!nboctblock && !bFiB)
           // on est pas sorti sur fin de fichier, ou sur erreur, alors
           // on vrifie le nombre d'octet restant du block,
           // si nul -> nouveau block a lire
           {
             nboctblock = 4;
             HeaderFlag = TRUE;
           }
        }
        ////////////////////////////////////////////////////////////////////////
        // End OF LOOP ...
        //----------------------------------------------------------------------
        /*if (!OKFlag)
        {
            sprintf(tmpstring,"\r\nSorry, this was not a valid file !!\r\n");
            Add_RichText(hAEdit,tmpstring);
            //MessageBox(hAEdit,tmpstring,"Info",MB_OK);
            return 0;
        }*/
        if (Xit == TRUE)
        {
            nsect --;
            nblock --;
            sprintf(lpsTmpCB,"\r\n OK, Atari Binary file tracing succesful !!\r\n");
            sprintf(tmpstring," - Number of sector read  :  $%03X (d%d)\r\n", nsect,nsect);
            strcat(lpsTmpCB,tmpstring);
            sprintf(tmpstring," - Number of segment read :  $%03X (d%d)\r\n", nblock,nblock);
            strcat(lpsTmpCB,tmpstring);
            sprintf(tmpstring," - Number of byte read    :  $%04X (d%d)\r\n", jpos,jpos);
            strcat(lpsTmpCB,tmpstring);
            Add_RichText(hAEdit,lpsTmpCB);
            return jpos;
            //MessageBox(hAEdit,tmpstring,"Info",MB_OK);
        }
        else
        {
        		sprintf(tmpstring,"\r\n SORRY, AN ERROR HAS OCCURED ON TRACKING FILE !!!\r\n");
        		Add_RichText(hAEdit,tmpstring);
            return FResult;
        }
        //return 1;
}

//------------------------------------------------------------------------------
// Search Data
//------------------------------------------------------------------------------
// > hwnd : owner window to display message
// > lpSRData : pointer of the TSRDATA structure containing all the search/replace
//    and fill parameters (global structure)
// > bNewSearch :
//    set to TRUE if this is not a current search in progress (F3 search again)
//    set to FALSE if all the other case
BOOL Search_Data(HWND hwnd, TSRDATA * lpSRData, BOOL bNewSearch, HWND hAEdit)
{
   //Global for reminder:
   // extern   BOOL  SearchInProgress;  //TRUE if there is a search in progress (F3)
	// extern   int   iSearchMode;       //The search mode
	// extern   int   nSearchDataBytes;  //Number of the data bytes search
	// extern   char  szSRTitle[5][36];  //Action title string

	UINT ipos,pos1,pos2;
   BOOL bExit;
   int j,nb,m;
   int iResult, iOccurence;
   char szInf[] = "ARFD Info:\n";

   pos1 = Get_FilePosition(lpSRData->SR_FS,0);
   if (lpSRData->SR_LS != AmParam.MAXSect)
   	pos2 = Get_FilePosition(lpSRData->SR_LS,0) + AmParam.NBytSect;
   else
   	pos2 = iFileLength;

   if (bNewSearch) ipos = pos1;
   else
   {
   	ipos = lpSRData->iSearchPos; //uniquement pour reprendre Search par F3
	}

   Add_EndRichText(hAEdit," \r\n ");
   Add_RichText(hAEdit,szSRTitle[iSearchMode-1]);
   Add_RichText(hAEdit," \r\n ");

   nb = (int) (pos2 - pos1); //use to count bytes to search and exit loop
   bExit = FALSE; //use for the user to force the loop exiting
   iResult = IDCANCEL;
   iOccurence = 0; //reset the counter for the replaced occurence

   nSearchDataBytes = lpSRData->nSearchDB;

   //################ recherche ou recherche+remplacement ######################
   if (iSearchMode < 5) //Search or replace
   {
   	//////////////////////////////////////////////////////////////////////////////
   	// Boucle while (!xit && (ipos < pos2))
   	while (!bExit && (nb > 0))
   	{
         // On a trouv une galit
   		if (lpFileBuffer[ipos] == lpSRData->cSearchDB[0])
      	{
            //Test du nombre d'octet restant  comparer:
            m = lpSRData->nSearchDB;
            //si pas assez d'octet  comparer, on sort
            if (nb < m)
               nb = 1; //en forant nb au dernier octet compar
            //Comparaison des m octets de la chaine de recherche
      		for(j=0; j< m ;j++)
            {
            	if (lpFileBuffer[ipos+j] != lpSRData->cSearchDB[j])
               	break; //sortir si diffrent
            }
            // si on a tout compar et que c'est gal:
         	if (j == m)
         	{
                    iCurSect = Get_Sector(ipos);
                    iCurOff =  Get_Offset(ipos);

                    //View_Sector(EditWin);
              		  //ShowWindow(hwnd,SW_SHOWNORMAL);
                    SendMessage(hwnd,WM_COMMAND,CM_EDITSECTORRESET,0);
                    SendMessage(hwnd,WM_COMMAND,CM_SHOWSELECTION,0);

                    if ((lpSRData->bReplace) && (!lpSRData->bPrompt)) // replace  && no prompt
                    {
                           //No promt: act as if clicked on IDYES
                        	iResult = IDYES;
                           iOccurence ++;
                    }
                    else
                    {
                        sprintf(sTmpSTR,"Found at [sector:offset] $%03X:%02X", iCurSect, iCurOff);
                        Add_EndRichText(hAEdit,sTmpSTR);
                        Add_RichText(hAEdit," \r\n ");
            				if (!lpSRData->bReplace) // search
                    		{
                        	strcat(sTmpSTR,"\n Click OK to Continue searching?");
                        	iResult = MessageBox(hwnd,sTmpSTR,szSRTitle[iSearchMode-1],MB_OKCANCEL | MB_ICONQUESTION);
                        }
                        else // bReplace and (lpSRData->bPrompt) //Prompt on replace activated
                        {
                        	strcat(sTmpSTR,"\n Would you like to Replace this occurence?");
                        	iResult = MessageBox(hwnd,sTmpSTR,szSRTitle[iSearchMode-1],MB_YESNOCANCEL | MB_ICONQUESTION);
                        }
                    }


                    switch (iResult)
                    {
                        //QUIT REPLACE OR SEARCH
                        case IDCANCEL:
                           //positionner ipos pour la prochaine recherche
                        	ipos += m;
                           // forcer la sortie de la boucle (nb != 0)
                    			bExit = TRUE;
                           break;
                        //OK : CONTINUE SEARCH
                        case IDOK:
                        //NO : CONTINUE SEARCH WITHOUT REPLACEMENT
                        case IDNO:
                           //positionner ipos et nb pour la prochaine recherche
                           ipos += m;
                           nb -= m;
                           //continuer la boucle de recherche
                           break;
                        //YES : REPLACE AND CONTINUE SEARCH
                        case IDYES:
                           //remplacement: le fichier est modifi
                           bFileModified = TRUE;
                           //supprimer la slection trouve en cas de remplacement
                           Shift_Memory(ipos,0,-m,0);
                           //copy with insertion (TRUE)
                           //Insrer les donnes au point d'insersion
                           m = lpSRData->nReplaceDB; //databytes to put in memory
                           Copy_In_Memory((lpSRData->cReplaceDB),(UINT)(ipos),pos2,(UINT)m,TRUE);
                           ipos += m;
                           nb -= m;
                           //display the modified sector in the EditSector window
                           SendMessage(hwnd,WM_COMMAND,CM_EDITSECTORRESET,0);
                           if (lpSRData->bPrompt) Add_RichText(hAEdit,"  and Data replaced! \r\n ");
                           break;
                     }
            }
            // la comparaison des chaines  choue, passer  l'octet suivant
            else
            {
         		nb--;
         		ipos++;
            }
         }
         //pas d'galit, passer  l'octet suivant
         else
         {
         	nb--;
         	ipos++;
         }

      }
      // Fin de la boucle while
   	//////////////////////////////////////////////////////////////////////////////
   }
   //##### pas de recherche, remplacement direct (fill ou XOR) #################
   // (iSearchMode > 5)
   else //Fill or XOR
   {
      bFileModified = TRUE;
      j = 0;
      while (nb > 0)
      {
         	if (iSearchMode == 7)  // Apply XOR pattern
               lpFileBuffer[ipos++] ^= lpSRData->cSearchDB[j];
            else // iSearchMode == 5 ou 6  // fill with pattern
            	lpFileBuffer[ipos++] = lpSRData->cSearchDB[j];
         j++;
         if (j == lpSRData->nSearchDB) j = 0;
         nb --;
      }
   }

   lpSRData->iSearchPos = ipos;

   if (!bExit && (lpSRData->bReplace) && (!lpSRData->bPrompt))
   {
      sprintf(sTmpSTR,"Data Replacement done!\n (%d occurences replaced)",iOccurence);
   }
   else if (!bExit && (iSearchMode < 5))  // search and replace...
   {
      sprintf(sTmpSTR,"End of file reached: string not found anymore!");
   }
   else if ((iSearchMode == 5) || (iSearchMode == 6))
   {
      sprintf(sTmpSTR,"Filling Data in sectors completed!");
   }
   else if (iSearchMode == 7)
   {
   	sprintf(sTmpSTR,"Applying the XOR mask completed!");
   }
   else return FALSE;   // pas encore de fin de fichier... (search not completed up to end of file)

   sprintf(lpsTmpCB,"%s%s",szInf,sTmpSTR);
   MessageBox(hwnd,lpsTmpCB,szSRTitle[iSearchMode-1],MB_OK|MB_ICONINFORMATION);
   Add_EndRichText(hAEdit,sTmpSTR);
   Add_RichText(hAEdit," \r\n ");
   return TRUE; //fin du fichier atteind
 }

//------------------------------------------------------------------------------
// *** Special test 1 **********************************************************
// To verify the disassembly Atari Adress Mnemonics
// Writes pattern into memory :
// A9 AA 85 XX ; XX from 00 to FF
// A9 AA 8D XL XH ; XHXL from 0100 to 0600 and from A000 to FFFF
//------------------------------------------------------------------------------
void Test1(void)
{
        int i,j;
        j = 2;
        lpFileBuffer[0] = 0xA9;
        lpFileBuffer[1] = 0xAA;
        for (i=0;i<256;i++)
        {
            lpFileBuffer[j] = 0x85;
            lpFileBuffer[j+1] = (UBYTE) i;
            j += 2;
        }
        for (i=0x100;i<0x600;i++)
        {
            lpFileBuffer[j] = 0x8D;
            lpFileBuffer[j+1] = (UBYTE) (i & 0xFF);
            lpFileBuffer[j+2] = (UBYTE) (i >> 8);
            j += 3;
        }
        for (i=0xA000;i<0x10000;i++)
        {
            lpFileBuffer[j] = 0x8D;
            lpFileBuffer[j+1] = (UBYTE) (i & 0xFF);
            lpFileBuffer[j+2] = (UBYTE) (i >> 8);
            j += 3;
        }
}

//------------------------------------------------------------------------------
// *** Special test2 ***********************************************************
// To verify the disassembly 6502 opcodes Mnemonics
// Writes pattern into memory :
// XX XX XX XX XX XX; XX from 00 to FF
// 6 times XX because disassembly line length is 1, 2  or 3
// 6 est le plus petit multiplieur commun (lowest common multiplier)
//------------------------------------------------------------------------------
void Test2(void)
{
        int i,j,k;
        k=0;
        for (i=0;i<256;i++)
        {
            for (j=0;j<6;j++)
            {
                lpFileBuffer[k+j] = (UBYTE) i;
            }
            k += 6;
        }
}
//##############################################################################
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// FUNCTION : DISASSEMBLY IN ENHANCED 6502 CODES
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
BOOL ARF_Disassembly(void)
{
    int iLineCount;
    char ligne_ascii[4] = "   "; //ligne vide
    strcpy(lpsTmpCB,"");

    // Rappel des Variables d'entre utilises par Am_Disassemble
    // Variables :
    // # Dis_CMemAddr  -> position memoire en cours
    // # Dis_CPosFile  -> position pointeur dans la mmoire fichier en cours
    // # Dis_CSector   -> position secteur en cours
    // # Dis_COffset   -> position offset secteur en cours
    // Constantes pour le dsassemblage...
    // # D_Cur.Mnemo    	-> Utilisation des mnmoniques adresse Atari
    // # D_Cur.DisMem    	-> Arret desassemblage sur adresse mmoire (pas sur secteur)
    // # D_Cur.LSect       -> Dernier secteur  desassembler
    // # D_Cur.LMemAdd     -> Dernire adresse  desassembler
    // # D_Cur.BytPerSect  -> Nombre d'octet par secteur  desassembler


    if (D_Cur.Mnemo)
    	 dflag = 1; //Avec Mnmonique
    else
    	 dflag = 0; //Sans

    iLineCount = 1; // nombre de lignes  dsassembler...
    endoffile = FALSE; // nous ne sommes pas encore  la fin du fichier

    while (iLineCount)
    {
        //affichage de la ligne (dbut)
        if (D_Cur.ShowFilePos)
        		sprintf(dis_line,"<%05X>",Dis_CPosFile);
        else
        		sprintf(dis_line,"");
        sprintf(tmpstring,"[%03X:%02X]  $%04X",Dis_CSector,Dis_COffset,Dis_CMemAddr);
        strcat(dis_line,tmpstring);
        strcat(dis_line," \t");

        // Lire les instruction de la nouvelle ligne:
        instr1 = Current_Instruction();
        nbinstr = opcode[instr1].optype & 0x03;
        ehinstr = opcode[instr1].optype & 0x04;
        winstr = opcode[instr1].optype & 0x08;
        cinstr = FALSE;  //instruction de branchement : nb de cycles x+ [FUTUR]
        typeinstr = (opcode[instr1].optype & 0xF0) / 16;

        //affichage des octets mmoire... et prparation des quivalent ASCII
        sprintf(tmpstring,"%02X ", instr1);     //le premier octet

        if (!D_Cur.EnhancedCode && ehinstr)  // Ne pas appliquer les codes tendus...
        {
            nbinstr = 1;
        }
        strcat(dis_line,tmpstring);
        ligne_ascii[0] = (Is_Displayable(instr1) ? instr1 : '.');   // ASCII 1er octet
        if (nbinstr < 2)
        {
            strcat(dis_line,"      ");
            ligne_ascii[1] = ' ';
            ligne_ascii[2] = ' ';
        }
        else
        {
            if (!endoffile) instr2 = Current_Instruction();
            else instr2 = 0xFF;
            sprintf(tmpstring,"%02X ", instr2);
            strcat(dis_line,tmpstring);
            ligne_ascii[1] = (Is_Displayable(instr2) ? instr2 : '.');
            if (nbinstr == 3)
            {
                if (!endoffile) instr3 = Current_Instruction();
                else instr3 = 0xFF;
                sprintf(tmpstring,"%02X ", instr3);
                strcat(dis_line,tmpstring);
                ligne_ascii[2] = (Is_Displayable(instr3) ? instr3 : '.');
            }
            else
            {
                strcat(dis_line,"   ");
                ligne_ascii[2] = ' ';
            }
        }

        //afficher le mnmonique 6502 et l'oprande...
        Show_Disassembly(dflag);

        // afficher le nombre de cycles approximatifs...
        if (!D_Cur.EnhancedCode && ehinstr)
        {
            sprintf(tmpstring,"; -         ; ");
        		strcat(dis_line,tmpstring);
        }
        else
        {
            sprintf(tmpstring,"; %X", cycles[instr1]);
        		strcat(dis_line,tmpstring);
        		if (cinstr) strcat(dis_line,"+");
        		else strcat(dis_line," ");
        		strcat(dis_line," cycles ; ");
        }
        sprintf(tmpstring,"%s\t",ligne_ascii); //ajout de la chaine equivalent ASCII
        strcat(dis_line,tmpstring);

        // Ligne complete !! mettre fin de la ligne...
        strcat(dis_line," \r\n");

        //mise en place de la ligne dans le buffer Output...
        if (dflag <= 1)
        {
            strcat(lpsTmpCB,dis_line);
            iLineCount--;
        }

        //mettre  jour le pointeur mmoire (Nouvelle adresse)
        Dis_CMemAddr += (UWORD) (nbinstr & 0x03);

        //Recalcul du secteur et de l'offset  partir de Dis_CPosFile...
        Dis_CSector = Get_Sector(Dis_CPosFile); //nouveau secteur
        Dis_COffset = Get_Offset(Dis_CPosFile); //nouvel offset
        // NOTA :le pointeur fichier est mis  jour dans Current_Instruction()
    }
    //vrification fin de dsassemblage...
    if (endoffile) return FALSE;
    if (D_Cur.DisMem)
    {
      // ? Arret sur adresse mmoire :
    	if (Dis_CMemAddr <= D_Cur.LMemAdd) return TRUE;   // Pas Fini
    }
    else
    {
    	// ? Arret sur secteur :
    	if (Dis_CSector <= D_Cur.LSect) return TRUE;   // Pas Fini
    }
    return FALSE; //c'est fini !!

}

// PROCEDURES & FUNCTIONS FOR DISASSEMBLE ----------------------------------------

UBYTE Current_Instruction()   //incrmentation de Dis_CPosFile uniquement
{
    UBYTE tmp;
    tmp = lpFileBuffer[Dis_CPosFile];
    Dis_COffset ++; //on augmente l'offset
    if (Dis_COffset == D_Cur.BytPerSect) //est-il gal au maxi ?
    {
        Dis_CPosFile += (SectSize - D_Cur.BytPerSect + 2);    // si oui on change de secteur
        Dis_COffset = 0;
    }
    else Dis_CPosFile++;
    if (Dis_CPosFile >= AmParam.MAXFL)
    {
        Dis_CPosFile = 0;
        endoffile = TRUE;
    }
    return tmp;
}

void Show_Disassembly(int flag_label)
{
    UWORD value1, value2;
    int wid,i;
    char atr_dis[32];
    char atr_disi[8]="       ";
    if (!D_Cur.EnhancedCode && ehinstr)  // Appliquer les codes tendus...
    {
    		sprintf(atr_disi,"   ??? ");
    		typeinstr = 0; // on triche comme si c'tait un implicit ...
    }
    else
        sprintf(atr_disi,"   %s ", opcode[instr1].mnemonic);
    if (nbinstr == 3)
        value2 =(UWORD) (instr2 + (instr3 * 256));
    else
        value2 = (UWORD) (instr2 & 0x00FF);
    wid = 0; //initialisation
    switch (typeinstr)
    {
          case 0 :  // Implicit
          case 12:  // Stack 3 (RTI) or Stack 2 (RTS)
             sprintf(atr_dis,"                       ");
             break;
          case 1 :  // absolu
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis," %s  <$%04X>  ",dis_label,value2);
             else sprintf(atr_dis," $%04X                 ", value2);
             break;
          case 2 :  // Z page
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis," %s  <$%02X>    ",dis_label,value2);
             else sprintf(atr_dis," $%02X                   ", instr2);
             break;
          case 3 :  //Absolu,X
             cinstr = TRUE;
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis," %s,X  <$%04X>",dis_label,value2);
             else sprintf(atr_dis," $%04X,X               ", value2);
             break;
          case 4 :  //Absolu,Y
             cinstr = TRUE;
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis," %s,Y  <$%04X>",dis_label,value2);
             else sprintf(atr_dis," $%04X,Y               ", value2);
             break;
          case 5 :  //(Indirect,X)
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis,"(%s,X)  <$%02X> ",dis_label,value2);
             else sprintf(atr_dis,"($%02X,X)                ", value2);
             break;
          case 6 :  //(Indirect),Y
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis,"(%s),Y  <$%02X> ",dis_label,value2);
             else sprintf(atr_dis,"($%02X),Y                ", value2);
             break;
          case 7 :  // Z page,X
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis," %s,X  <$%02X>  ",dis_label,value2);
             else sprintf(atr_dis," $%02X,X                 ", value2);
             break;
          case 8 :  // Z page,Y
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis," %s,Y  <$%02X>  ",dis_label,value2);
             else sprintf(atr_dis," $%02X,Y                 ", value2);
             break;
          case 9 :  // saut relatif
             cinstr = TRUE;
             value1 = (UWORD) (Dis_CMemAddr + (char) instr2 + 2);
             sprintf(atr_dis," $%04X                 ", value1);
             break;
          case 10:  // immediat
             sprintf(atr_dis,"#$%02X                   ", instr2);
             break;
          case 11:
             sprintf(atr_dis,"  A                    ");
             break;
          case 13:  //(Indirect)
             wid = Show_Label(value2);
             if (flag_label && wid)
                  sprintf(atr_dis,"(%s)  <$%04X> ",dis_label,value2);
             else sprintf(atr_dis,"($%04X)             ", value2);
             break;
          case 14:
             sprintf(atr_dis," [ESC RTS]             ");
             break;
          case 15:
             sprintf(atr_dis," [ESC    ]             ");
             break;
          default:
          ;
    }
    // completer avec des espaces
    if (flag_label && wid)
        for (i = wid; i < 11; i++)
            strcat(atr_dis," ");
    strcat(dis_line,atr_disi);
    strcat(dis_line,atr_dis);
}
int find_symbol(UWORD addr)
{
  int lo,hi,mi;

  lo=0;hi=symtable_size-1;
  while (lo<hi)
  {
    mi=(lo+hi)/2;
    if (symtable[mi].addr == addr) break;
      else if (symtable[mi].addr>addr) hi=mi;
        else lo=mi+1;
  }
  if ((symtable[mi].addr == addr)&& //a colle, on a trouv !!
  	  (strcmp(symtable[mi].name,symtable[mi-1].name) != 0)) //ce n'est pas le nom 'haut'
  {
      // return the lowest index of symbol with given address
      if (mi>0 && symtable[mi-1].addr == addr)
        return mi-1;
      else return mi;
  }
  // mi pointe sur un des 2 noms, haut ou bas...
  if (symtable[mi].addr < addr) mi++; // maintenant mi pointe forcement sur le nom 'haut'
  // est-ce que mi pointe sur un nom (haut) qui est le mme que celui d'avant (bas)
  if (strcmp(symtable[mi].name,symtable[mi-1].name) == 0)
  		return (0 - mi); //OK, il s'agit d'une adresse entre nom haut et bas.
  else return -1;  //sinon non !
}

int Show_Label(UWORD addrmem)
{
     int result,wid,i,ret;
     UBYTE x;
     char stmp[4];
     wid = 8;
     i = 0;
     ret = 0;
     strcpy(dis_label,"            ");
     result = find_symbol(addrmem);
     // test 
     if (result >= 0 )
     {
          //different names when reading/writting memory
          //nota : winstr = 0 if read instruction
          if ( winstr && (symtable[result+1].addr == addrmem))
              result+=1;
          strcpy(dis_label,symtable[result].name);
          while (symtable[result].name[i++] != 0)
              ret++;
      }
      else if (result <= -2)
      {
          result = 0 - result -1;
          x = (UBYTE)(addrmem - symtable[result].addr);
          sprintf(stmp,"+%X",x);
          strcpy(dis_label,symtable[result].name);
          strcat(dis_label,stmp);
          while (dis_label[i++] != 0)
              ret++;
      }
      return ret; // nombre de caracteres du label (si 0 : pas de label)
}






