////////////////////////////////////////////////////////////////////////////////
// RTFFUNCS.CPP
// Main Text and RTF control routines
// original file DATE: 07/17/95
// original file from C.CALVERT
// modified and re-written by Philippe VUILLERME (c) PVBest 2001-2002
////////////////////////////////////////////////////////////////////////////////
/*---------------------**| ARFD SOURCE REVISION HISTORY |**---------------------
 Date:     | What:
-----------|--------------------------------------------------------------------
 JUNE 2002 | Clean updated source code for ARFD revision 1.9.0 (public realease)
------------------------------------------------------------------------------*/

#define STRICT
#include <windows.h>
#pragma hdrstop
#include <richedit.h>
//#include <stdio.h>
#include "rtffuncs.h"
#include "MesTypes.h"
#include "AmDialog.h"
#include "Resource.h"


extern HINSTANCE  hInstance;
extern HANDLE     hFile;
extern char *     lpsTmpCB;

extern char       szTextFileName[STRSIZE];
extern char       szFileExtension[128];
extern int        iFilterIndex;
extern char       szFileFilter[128];
extern char       szTextFileTitle[128];

extern LOGFONT * lpMyLogFont;

static LOGFONT LogFont;
static COLORREF FontColor;

/////////////////////////////////////////////////////////
// ChooseFont Common Dialog
/////////////////////////////////////////////////////////
// Renvoi une Structure LogFont...
BOOL ChooseAFont(HWND hwnd)
{
  CHOOSEFONT cfn;

  memset(&cfn, 0, sizeof(CHOOSEFONT));
  HDC DC = GetDC(hwnd);

  cfn.lStructSize = sizeof(CHOOSEFONT);
  cfn.hwndOwner = hwnd;
  cfn.hDC = DC;
  cfn.lpLogFont = &LogFont;
  //cfn.Flags = CF_EFFECTS | CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT;
  cfn.Flags = CF_FIXEDPITCHONLY | CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT;
  //cfn.rgbColors = FontColor;
  cfn.nFontType = SCREEN_FONTTYPE;

  BOOL Result = ChooseFont(&cfn);

  if (Result)
    LogFont = *cfn.lpLogFont;

  //FontColor = cfn.rgbColors;   //Pas de changement de couleur

  ReleaseDC(hwnd, DC);

  return Result;
}

/////////////////////////////////////////////////////////
// Make sure common dialog starts with current font
/////////////////////////////////////////////////////////
//Initialisation de LogFont avant la boite de dialogue Police
void SetUpFont(CHARFORMAT CharFormat)
{
  memset(&LogFont, 0, sizeof(LOGFONT));
  // mise en place de LogFont avant de le changer avec ChooseFont
  // FontColor = CharFormat.crTextColor;  //pas de couleur
  LogFont.lfHeight = CharFormat.yHeight / -20;
  if(CharFormat.dwEffects & CFE_BOLD)
    LogFont.lfWeight = FW_BOLD;
  else
    LogFont.lfWeight = FW_NORMAL;
  LogFont.lfItalic =(BOOL)(CharFormat.dwEffects & CFE_ITALIC);
  LogFont.lfUnderline =(BOOL)(CharFormat.dwEffects & CFE_UNDERLINE);
  LogFont.lfCharSet = CharFormat.bCharSet;
  LogFont.lfQuality = DEFAULT_QUALITY;
  LogFont.lfPitchAndFamily = CharFormat.bPitchAndFamily;
  strcpy(LogFont.lfFaceName, CharFormat.szFaceName);

}

///////////////////////////////////////
// Change the font in the selected text.
///////////////////////////////////////
void Change_Font(HWND hwnd, HWND hRichEdit)
{
  // On va appliquer ce CharFormat par la suite....
  CHARFORMAT CharFormat;

  CharFormat.cbSize = sizeof(CHARFORMAT);

  // mettre dans CharFormat les attributs de la police slectionne
  SendMessage(hRichEdit, EM_GETCHARFORMAT, TRUE, (LPARAM)&CharFormat); //Current
  //SendMessage(hRichEdit, EM_GETCHARFORMAT, FALSE, (LPARAM)&CharFormat);  //Default

  //initialiser LogFont avec les valeurs de CharFormat en cours de la selection
  SetUpFont(CharFormat);

  if (ChooseAFont(hwnd))  // OK slection faite d'une nouvelle police
  // LogFont est initialis avec la nouvelle police.
  {
    CharFormat.dwMask = CFM_FACE | CFM_CHARSET |
    							CFM_BOLD | CFM_ITALIC | CFM_SIZE;
                      //CFM_OFFSET| CFM_UNDELINE|CFM_STRIKEOUT|CFM_COLOR
    CharFormat.yHeight = LogFont.lfHeight * -20;

    CharFormat.dwEffects = 0;   // Pas d'effet au texte
    // copie de LogFont en cours dans CharFormat
    if(LogFont.lfWeight == FW_BOLD)
      CharFormat.dwEffects |= CFE_BOLD;
    if(LogFont.lfItalic)
      CharFormat.dwEffects |= CFE_ITALIC;
    if(LogFont.lfUnderline)
      CharFormat.dwEffects |= CFE_UNDERLINE;
    CharFormat.crTextColor = FontColor;
    CharFormat.bCharSet = LogFont.lfCharSet;
    CharFormat.bPitchAndFamily = LogFont.lfPitchAndFamily;
    strcpy(CharFormat.szFaceName, LogFont.lfFaceName);
    SendMessage(hRichEdit, EM_SETCHARFORMAT,
                -1, (LPARAM)&CharFormat);   // SCF_ALL = -1 : Tout le texte
  }
}

///////////////////////////////////////
// Change the ASCII text (EditSector)
//////////////////////////////////////
BOOL Change_EditSector_Ascii_Font(HWND hwnd)
{
  if (ChooseAFont(hwnd))  // OK slection faite d'une nouvelle police
  // LogFont est initialis avec la police en cours.
  {
    lpMyLogFont = &LogFont;
    return TRUE;
  }
  else return FALSE;
}
///////////////////////////////////////
// Change the size of the text
///////////////////////////////////////
/*void SetFontSize(HWND hRichEdit, int iPointChange)
{
  CHARFORMAT CharFormat;

  CharFormat.cbSize = sizeof(CHARFORMAT);

  SendMessage(hRichEdit, EM_GETCHARFORMAT, TRUE,(LPARAM)&CharFormat);

  CharFormat.dwMask      = CFM_SIZE;
  if(((CharFormat.yHeight + 20*iPointChange) <=(128*20)) &&
     ((CharFormat.yHeight + 20*iPointChange) >=(6*20)))
    CharFormat.yHeight += 20*iPointChange;

  SendMessage(hRichEdit, EM_SETCHARFORMAT,
              SCF_SELECTION, (LPARAM)&CharFormat);
}
*/
/////////////////////////////////////////////////////////
// Apply bold attribute to selected text
/////////////////////////////////////////////////////////
void Char_Bold(HWND hRichEdit, BOOL bBold)
{
  CHARFORMAT CharFormat;
  CharFormat.cbSize = sizeof(CHARFORMAT);
  SendMessage(hRichEdit, EM_GETCHARFORMAT, TRUE, (LPARAM)&CharFormat);
  CharFormat.dwMask      = CFM_BOLD;
  if (bBold) CharFormat.dwEffects  |= CFE_BOLD;      // ^= CFE_BOLD pour inverser bold<->normal;
  else CharFormat.dwEffects  &= ~CFE_BOLD;
  SendMessage(hRichEdit, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&CharFormat);
}
/////////////////////////////////////////////////////////
// Apply attributes to selected text
/////////////////////////////////////////////////////////
/*
void SetAttributes(HWND hRichEdit, DWORD dwMask, DWORD dwEffects)
{
  CHARFORMAT CharFormat; // From RICHEDIT.H

  CharFormat.cbSize = sizeof(CHARFORMAT);
  SendMessage(hRichEdit, EM_GETCHARFORMAT, 
              TRUE, (LPARAM)&CharFormat);
  CharFormat.dwMask = dwMask;
  CharFormat.dwEffects ^= dwEffects;
  SendMessage(hRichEdit, EM_SETCHARFORMAT, 
              SCF_SELECTION, (LPARAM)&CharFormat);
}
*/
/////////////////////////////////////////////////////////
// Get attributes of text
/////////////////////////////////////////////////////////
/*int GetAttributes(HWND hRichEdit, DWORD dwMask, DWORD dwEffects)
{
  CHARFORMAT CharFormat; 

  CharFormat.cbSize = sizeof(CHARFORMAT);
  SendMessage(hRichEdit, EM_GETCHARFORMAT, 
              TRUE, (LPARAM)&CharFormat);

  if(CharFormat.dwMask & dwMask)
  {
    if(CharFormat.dwEffects & dwEffects)
      return ATTRIB_TRUE;
    else
      return ATTRIB_FALSE;
  }
  else
    return ATTRIB_BOTH;
}
*/
///////////////////////////////////////
// Has file been changed?
///////////////////////////////////////
/*BOOL WasFileChanged(HWND hwnd, HWND hRichEdit)
{
  char S[350];
  int  id;

  if (SendMessage(hRichEdit, EM_GETMODIFY, 0, 0L))
  {
    if(strlen(sFileName) != 0)
      sprintf(S, "Save current file %s?", sFileName);
    else
      strcpy(S, "Save current file?");

    id = MessageBox(hwnd, S, "Information",
                    MB_YESNOCANCEL | MB_ICONQUESTION);

    switch(id)
    {
      case IDYES:
        SaveFile(hwnd, hRichEdit, TRUE);
        return TRUE;

      case IDNO:
        return TRUE;

      case IDCANCEL:
        return FALSE;
     }
  }
  return TRUE;
}
*/
/////////////////////////////////////////////////////////
// GetFileName
/////////////////////////////////////////////////////////
BOOL Get_FileName(HWND hwnd,
						LPSTR lpszTheFileName,   // Nom complet pour initialisation et retour
		 				LPSTR lpszTheFileFilter, // La chaine des filtres *.*
                  LPSTR lpszTheFileTitle,  // Nom du fichier seul sans le chemin
       				LPSTR lpszTheDialogTitle,// Titre de la dialogbox
                  BOOL bOpenFN,   // TRUE = Open, FALSE = Save File Name
                  BOOL bOverConf, // TRUE = Confirm overwritting
                  int iIndex)    // Affichage du filtre 'i' par dfaut
{
  OPENFILENAME ofn;
  BOOL bResult;

  memset(&ofn, 0, sizeof(OPENFILENAME));

  ofn.lStructSize    = sizeof(OPENFILENAME);
  ofn.hwndOwner      = hwnd;
  ofn.lpstrFilter    = lpszTheFileFilter;
  ofn.nFilterIndex   = iIndex;
  ofn.lpstrFile      = lpszTheFileName;
  ofn.nMaxFile       = STRSIZE;
  ofn.lpstrFileTitle = lpszTheFileTitle;
  ofn.nMaxFileTitle  = STRSIZE/2;    //Soit 128 caractres
  ofn.lpstrTitle     = lpszTheDialogTitle;
  ofn.lpstrDefExt    = NULL;
  ofn.Flags          = OFN_PATHMUSTEXIST;
  if (bOverConf) ofn.Flags |= OFN_OVERWRITEPROMPT; //Ask for overwritting

  if (bOpenFN)
  		bResult = GetOpenFileName(&ofn);
  else
      bResult = GetSaveFileName(&ofn);

  if (ofn.nFileExtension == 0)
  		strcpy (szFileExtension, ".");
  else if (lpszTheFileName[ofn.nFileExtension] == '\0')
      strcpy (szFileExtension, "");
  else strcpy (szFileExtension,(LPSTR)(lpszTheFileName + ofn.nFileExtension));

  iFilterIndex  = ofn.nFilterIndex;
  
  if (!bResult)
  {
     DWORD Errval;
     char buf[80]="";
     Errval = CommDlgExtendedError();
     if (Errval != 0)
     {
       wsprintf(buf, "ARFD System Error:\nGet File Name Common Dialog Extended Error: %ld", Errval);
       MessageBox(hwnd,buf,"Enter FileName Dialog Box :",MB_OK|MB_ICONERROR);
     }
  }
  return bResult;
}

/////////////////////////////////////////////////////////
// Callback for the RTF_Save function 
/////////////////////////////////////////////////////////
DWORD CALLBACK SaveCallback(DWORD dwcookie, LPBYTE Buffer,
                            LONG BufSize, LONG *NumWritten)
{
  WriteFile((HANDLE)dwcookie, Buffer,
            BufSize, (LPDWORD)NumWritten, NULL);
  return 0;
}


///////////////////////////////////////
// Save an RTF file.
///////////////////////////////////////
void Save_File_As_Text(HWND hwnd, HWND hRichEdit)
{
  //HANDLE hFile;
  EDITSTREAM Stream;
  BOOL bResult;
  BOOL bRtf = FALSE;
  char szTextDialogTitle[] = "Save Screen as Text";

  memset(szFileFilter,0x00,128);
  LoadString(hInstance,STRG_FILEFILTER_TXT,szFileFilter,128);

  bResult = Get_FileName(hwnd, szTextFileName,
		 szFileFilter, szTextFileTitle,
       szTextDialogTitle, FALSE, FALSE, 1);

  if (bResult)
  {
      if (iFilterIndex == 2)
      {
      	bRtf = TRUE;
         if (!(!strcmp(szFileExtension,"rtf") || !strcmp(szFileExtension,"RTF")))
         {
         	strcat(szTextFileName,".rtf");
            strcat(szTextFileTitle,".rtf");
         }
      }
    	else if (iFilterIndex == 1)
      {
         if (!(!strcmp(szFileExtension,"txt") || !strcmp(szFileExtension,"TXT")))
         {
				strcat(szTextFileName,".txt");
            strcat(szTextFileTitle,".txt");
         }
      }
      //else do nothing

      if (!Create_File(hwnd, szTextFileName, szTextDialogTitle,'W', &hFile)) return;

    	Stream.dwCookie =(DWORD)hFile;
    	Stream.dwError = 0;
    	Stream.pfnCallback = SaveCallback;

    	if (bRtf)
    		SendMessage(hRichEdit, EM_STREAMOUT, SF_RTF,(LPARAM)&Stream);
    	else
      	SendMessage(hRichEdit, EM_STREAMOUT, SF_TEXT,(LPARAM)&Stream);

      SetEndOfFile(hFile);
    	Close_File(&hFile);

      wsprintf(lpsTmpCB, "ARFD Info:\nScreen saved as text into '%s' file",szTextFileTitle);
  		MessageBox(hwnd,lpsTmpCB,szTextDialogTitle,MB_OK|MB_ICONINFORMATION);
    	return;
  }

  return;
}

///////////////////////////////////////
// This callback does the real work of reading the rtf file.
///////////////////////////////////////
//-----------------------
// INUTILE POUR ARFDesigner
//-----------------------
/*DWORD CALLBACK OpenCallback(DWORD Cookie, LPBYTE Buffer,
                            LONG BufSize, LONG * BytesRead)
{
  ReadFile((HANDLE)Cookie, Buffer, BufSize, (LPDWORD)BytesRead, NULL);
  return 0;
}
*/
///////////////////////////////////////
// Read a file. See OpenCallback function
///////////////////////////////////////
//-----------------------
// INUTILE POUR ARFDesigner
//-----------------------
/*BOOL OpenFile(HWND hwnd, HWND hRichEdit)
{
  HANDLE hFile;
  EDITSTREAM Stream;

  if (GetFileName(hwnd, sFileName, STRSIZE, FALSE))
  {
    hFile = CreateFile(sFileName,
              GENERIC_READ, 0, NULL, OPEN_EXISTING,
              FILE_ATTRIBUTE_ARCHIVE, NULL);

    if(hFile)
    {
      Stream.dwCookie = (DWORD)hFile;
      Stream.dwError = 0;
      Stream.pfnCallback = OpenCallback;

      //SendMessage(hRichEdit, EM_STREAMIN, SF_RTF, (LPARAM)&Stream);
      SendMessage(hRichEdit, EM_STREAMIN, SF_TEXT, (LPARAM)&Stream);

      CloseHandle(hFile);
    }
    return TRUE;
  }
  return FALSE;
}
*/

// Effacer de l'dition RichText
void Clear_RichText(HWND hAEdit)
 {
    CHARRANGE cr;
    cr.cpMin = 0;
    cr.cpMax = -1;
    SendMessage(hAEdit, WM_SETREDRAW, FALSE, 0);
    SendMessage(hAEdit, EM_EXSETSEL,   0, (LPARAM)&cr);
    SendMessage(hAEdit, WM_SETREDRAW, TRUE, 0);
    SendMessage(hAEdit, EM_REPLACESEL, 0, (LPARAM)" Atari Rom File Designer by Philippe VUILLERME (c) PVBest 2001-2002 \r\n");
    SendMessage(hAEdit, EM_SETMODIFY, FALSE, 0);
    End_Of_RichText(hAEdit);
    Char_Bold(hAEdit,FALSE);
 }

// Se placer en fin d'dition RichText
void End_Of_RichText(HWND hAEdit)
 {
    CHARRANGE cr;
    cr.cpMin = SendMessage(hAEdit,WM_GETTEXTLENGTH,0,0);
    //cr.cpMax = cr.cpMin + 1;
    cr.cpMax = cr.cpMin;
    //SendMessage(hAEdit, WM_SETREDRAW, FALSE, 0);
    SendMessage(hAEdit, EM_EXSETSEL, 0, (LPARAM)&cr);
    //SendMessage(hAEdit, WM_SETREDRAW, TRUE, 0);
    SendMessage(hAEdit, EM_SETMODIFY, FALSE, 0);
 }

// Se placer en fin d'dition RichText et ajouter du texte
void Add_EndRichText(HWND hAEdit, char * lpszAddString)
 {
    //hwnd = HWND of a RICH TEXT Edit Window...
    CHARRANGE cr;
    cr.cpMin = SendMessage(hAEdit,WM_GETTEXTLENGTH,0,0);
    //cr.cpMax = cr.cpMin + 1;
    cr.cpMax = cr.cpMin;
    //SendMessage(hAEdit, WM_SETREDRAW, FALSE, 0);
    SendMessage(hAEdit, EM_EXSETSEL, 0, (LPARAM)&cr);
   // SendMessage(hAEdit, WM_SETREDRAW, TRUE, 0);
    SendMessage(hAEdit, EM_REPLACESEL, 0, (LPARAM)lpszAddString);
    SendMessage(hAEdit, EM_SETMODIFY, FALSE, 0);
 }

// Ajouter du texte dans une dition RichText
void Add_RichText(HWND hAEdit, char * lpszAddString)
 {
    //hwnd = HWND of a RICH TEXT Edit Window...

    SendMessage(hAEdit, EM_REPLACESEL, 0, (LPARAM)lpszAddString);
    SendMessage(hAEdit, EM_SETMODIFY, FALSE, 0);
 }

// Copier tout le texte d'une dition RichText dans le ClipBoard
int Copy_RichText_To_CB(HWND hAEdit)
 {
      int a;
 		CHARRANGE cr;
      cr.cpMin = 0;
      cr.cpMax = -1;
      SendMessage(hAEdit, WM_SETREDRAW, FALSE, 0);
      SendMessage(hAEdit, EM_EXSETSEL,   0, (LPARAM)&cr);
      SendMessage(hAEdit, WM_COPY, 0, 0);
      SendMessage(hAEdit, EM_SETMODIFY, FALSE, 0);
      a = SendMessage(hAEdit,WM_GETTEXTLENGTH,0,0);
      cr.cpMin = a;
      cr.cpMax = a;
      SendMessage(hAEdit, EM_EXSETSEL,   0, (LPARAM)&cr);
      SendMessage(hAEdit, WM_SETREDRAW, TRUE, 0);
      return a;
 }

void Make_Bold_Line(HWND hRichEdit, int iLine)
{
    int a,b,c,d;
    CHARRANGE chrg;

    a = SendMessage(hRichEdit,EM_GETLINECOUNT,0,0);
    if (iLine > a) return;
    c = SendMessage(hRichEdit,EM_LINEINDEX,iLine,0);
    d = SendMessage(hRichEdit,EM_LINELENGTH,c,0);
    chrg.cpMin = c;
    chrg.cpMax = c+d;
    SendMessage(hRichEdit,EM_EXSETSEL,0,(LPARAM) (CHARRANGE FAR *) &chrg);
    Char_Bold(hRichEdit,TRUE);
    b = SendMessage(hRichEdit,WM_GETTEXTLENGTH,0,0);
    chrg.cpMin = b;
    chrg.cpMax = b;
    SendMessage(hRichEdit, EM_EXSETSEL, 0, (LPARAM) (CHARRANGE FAR *) &chrg);
    Char_Bold(hRichEdit,FALSE);
    SendMessage(hRichEdit, EM_SETMODIFY, FALSE, 0);

    //SendMessage(hRichEdit, WM_SETREDRAW, FALSE, 0);
    //SendMessage(hRichEdit, WM_SETREDRAW, TRUE, 0);
}
int Get_Title_Line_Number(HWND hRichEdit)
{
    int i;
    i = SendMessage(hRichEdit,EM_GETLINECOUNT,0,0);
    i += 1;
    return i;
}

