/* -----------------------------------------------------------------------
*                 Atari Disk Drive to PC serial port connection object    
*                          with event driven loops code                   
*                  coded by Philippe VUILLERME (c) PVBest 2001-2002
*
*       			Thanks to Thierry Schneider (thierry@tetraedre.com)
*               			 and his article which helps me
*
* ------------------------------------------------------------------------ */


#ifndef SERIALLIB_H
#define SERIALLIB_H

#define UBYTE unsigned char
#define UWORD unsigned short

#define TSERIAL_SIGNAL_NBR 8  // number of events in the thread
// signals definition for the communication thread
#define SIG_POWER_ON    0     //to activate the Com Waiting events
#define SIG_POWER_DOWN  1     //to stop the Com Waiting events & to exit loop
#define SIG_INVERT_RTS  2     //to activate/desactivate the RTS com port line
#define SIG_SET_TIMEOUT 3     //to set a timeout value
#define SIG_DATA_IN     4     //to wait for and to proceed the data receiving
#define SIG_COM_READER  5
#define SIG_DATA_OUT    6     //to start and to proceed the data sending
#define SIG_COM_WRITER  7


typedef struct { //abuff
                 UBYTE cbuffer[7];     //Commande frame buffer
                 UBYTE ackcode;        //Acknowledge code byte
                 UBYTE inbuffer[136];  //Data In Buffer
                 UBYTE outbuffer[135]; //Data Out Buffer
                 UBYTE RCHKSUM;			//checksum reue/received
               } TABUFFER;

typedef void (*TVoidFunction) (void);
typedef void (*TUBYTEFunction) (UBYTE);

// --------------------------------------------------------------------
// -----------------------------  Tserial  ----------------------------
// --------------------------------------------------------------------
class TAtariSerialSIOV
{
// ------------------------------------------------------------------- //
protected:

	 BOOL 			bConnected;
    BOOL 			bSerialReady;
    BOOL 			bRTS;
    
    DWORD   	   dwReadNbr;
    DWORD   	   dwWriteNbr;
    UBYTE *       lpOUTBufferAddress;
    UBYTE *       lpINBufferAddress;
    DWORD 			dwTotalRead;
    DWORD 			dwTotalWrite;
    BOOL          bAckCInReadDataFrame;
    BOOL          fWrite_in_progress;     // BOOL indicating if a WriteFile is  in progress
    BOOL          fRead_in_progress;      // BOOL indicating if a ReadFile is in progress

    COMMTIMEOUTS 	cto;
    HANDLE        hSerialEvent[TSERIAL_SIGNAL_NBR];
    DWORD 			dwThreadId;
    HANDLE        hCOMHandle;
    OVERLAPPED    oReader;                // Overlapped structure for ReadFile
    OVERLAPPED    oWriter;                // Overlapped structure for WriteFile

    TUBYTEFunction  AtariOnProgressFunction;
    TUBYTEFunction  AtariOnErrorFunction;

    // fonctions de bases
    void          fnStartThread      			(void);
    void				fnClearBuffers   				(void);
    void				fnSerialWait		 			(void);
    UBYTE 			fnGetCheckSum					(UBYTE * lpBuffer, int length);
    // fonctions pour declencher des process thread:
    void 			fnOnTimeOut						(void);
    void          fnSetSignal        			(long mask);
    void          fnPowerDown        			(void);
    void 			fnSetTimeOut		 			(int iTimeOut);
    void 			fnSetRTS		 					(BOOL bRTSFlag);
    void          fnSendCommandFrame    		(void);
    void 			fnSendDataFrame				(void);
    void				fnReceiveAckCode           (UBYTE SetpNbr);
    // fonctions sur evenements :
    void          fnOnDataReceived   (void);
    void          fnOnDataSent       (void);
    void          fnOnRTSSet         (BOOL bRTSOn);
    void				fnOnWaitOver       (void);
    void          fnOnConnected      (void);
    void          fnOnDisconnected   (void);
    void				fnOnProgress		 (UBYTE TheProgress);
    void				fnOnError			 (UBYTE TheError);
    void				fnOnTimeOutSet		 (void);

// ------------------------------------------------------------------- //
//        Public data and functions, viewable from external
// ------------------------------------------------------------------- //
public:
    //Atari register equivalent
	 UBYTE 			DDEVIC;
    UBYTE 			DCOMND;
	 UBYTE 			DAUX1;
    UBYTE 			DAUX2;
    UBYTE			DFRLEN;
    UBYTE			DSTATS;
    UBYTE			DERROR;
    UBYTE 			DACKCODE1;      //1er ACK CODE : ACKNOWLEDGE 'A' ou autre (voir DERROR)
    UBYTE 			DACKCODE2;      //2eme ACK CODE : COMPLETE 'C' pour read ou 'A' pour write autre code (voir DERROR)
    UBYTE 			DACKCODE3;      //3emem ACK CODE : COMPLETE 'C' pour write ou autre code  (voir DERROR)
    DWORD			DTIMEOUT1;
    DWORD			DTIMEOUT2;

    int  			iProgress;

	 DWORD         dwGetLastError;
    TABUFFER		abuff;

    TAtariSerialSIOV	 (); //Contructor
    ~TAtariSerialSIOV (); //Destructor
    
    void          AtrSerial_SendChar         (char c);     //not used yet ?
    int           AtrSerial_GetNbrOfBytes    (void);       //not used yet ?
    // communication thread :
    void          AtrSerial_Run					(void);
    // other functions :
    void          SetFunctionAtariOnProgress (TUBYTEFunction fnct);
    void          SetFunctionAtariOnError  	(TUBYTEFunction fnct);
    void          AtrSerial_WriteBadSector   (void);
    // Main functions :
    int           AtrSerial_ConnectInit      (char * lpszThePortName);
    void          AtrSerial_Disconnect       (void);
    UBYTE         AtrSerial_SendSIOVCommand  (void);

};
// -------------------------------------------------------------------

#endif SERIALLIB_H


