//******************************************************************************
// NODE NAME : MesTypes.h
// part of the Atari Rom File Designer source files
// All my common ARFD types definition...
//------------------------------------------------------------------------------
// Written by Philippe VUILLERME (c) PVBest 2001-2002
//
/*---------------------**| ARFD SOURCE REVISION HISTORY |**---------------------
 Date:     | What:
-----------|--------------------------------------------------------------------
 JUNE 2002 | Clean updated source code for ARFD revision 1.9.0 (public realease)
------------------------------------------------------------------------------*/

#ifndef MesTypes_H
#define MesTypes_H

//------------------------------------------------------------------------------
//    Types :
//------------------------------------------------------------------------------
#define UWORD 	unsigned short
#define UBYTE 	unsigned char

//------------------------------------------------------------------------------
//  Constantes :
//------------------------------------------------------------------------------
#define MAX_FILE_LENGTH 368656  	// valeur mini = 1040*256+16 max memory size
											// 360Ko + 16 = 368656 = (360 * 1024) + 16
#define STRSIZE MAX_PATH        	// = MAX_PATH = 260 characters...

//------------------------------------------------------------------------------
//    Definition des types de structures de donnes internes :
//------------------------------------------------------------------------------
  //Disassembly current parameters structure (internal use)
  typedef struct tagTDIS_PARAM {
      UWORD FSect,         // Premier secteur  dsassembler
      		SOff,          // Offset dsassemblage sur le premier secteur (0  SectSize)
            LSect,         // Dernier secteur  dsassembler
            FMemAdd,       // Adresse mmoire premier octet  dsassembler
            LMemAdd,       // Adresse mmoire dernier octet  dsassembler
            BytPerSect;    // Nombre d'octet par secteur  dsassembler (1  SectSize+1)
      BOOL 	Mnemo,         // TRUE = Utilisation des mnmoniques adresse
      		DisMem,        // TRUE = Arret dsassemblage sur adresse dernier octet (sinon sur dernier secteur)
            ShowFilePos,   // TRUE = Afficher l'index position en mmoire/fichier
            EnhancedCode;  // TRUE = Utilisation du jeux de opcodes 65C02 tendu
      } TDIS_PARAM;			// initialisation  {1,6,0x410,0x700,0xBFFF,0x80,TRUE,FALSE,FALSE,FALSE};

  //Open file current parameters structure (internal use)
  typedef struct tagTMON_PARAM {
      UWORD MAXSect,       // nombre de secteur dans le disk ROM fichier atari
      		NBytSect,      // Nombre d'octet par secteur (SectSize+1; i.e. $80 or $100) /!!\ sauf pour dernier secteur
            LSectNByte;    // Nombre d'octet du dernier secteur (pour fichier tronqu) /!!\ uniquement pour le dernier secteur
      UINT 	MAXFL;         // taille du disk ROM atari (1 mini)
      char 	FName[128];    // Nom du fichier ROM atari (sans le PATH)
      } TMON_PARAM;        // initialisation  {0x410,0x80,0x7F,0xFFFF,133120,""}

  //Sector parameters structure (internal use)
  typedef struct tagSPARAM {
    	UBYTE CheckSum;      // Checksum du secteur en cours (0-FF)
      UWORD NextSector;    // Prochain secteur = uniquement pour les fichiers binaires DOS Atari
      UBYTE BytePerSector; // Nombre d'octet par secteur : pour les fichiers bianires Atari aussi
      } SECTORPARAM;

  //Search or Replace parameters data structure (internal use)
  typedef struct tagSRDATA {
		UWORD SR_FS; //FirstSect;
   	UWORD SR_LS; //LastSect;
   	int   nSearchDB; //number of data bytes to search
   	int   nReplaceDB; //number of data bytes for replacement
   	BOOL  bReplace; // TRUE for replace, if FALSE : search
   	BOOL  bPrompt; // Prompt on replace
   	BOOL  bAscii;  // TRUE for ASCII search, if FALSE : Hex Search
   	UINT  iSearchPos; // Last Search position index
   	UBYTE  cSearchDB [16]; // search data bytes // tableau de donn  chercher pour fonction "rechercher"
   	UBYTE  cReplaceDB [16];  // replace data bytes // tableau de donn  chercher pour fonction "remplacer"
   	} TSRDATA;  // Search/Replace data structure

  //Import or Export parameters data structure (internal use)
  typedef struct tagIEDATA {
		UWORD IE_FS; //FirstSect;
   	UWORD IE_FO; //FirstOffset;
   	UWORD IE_GO; //GeneralFirstOffset;
   	UWORD IE_LB; //GeneralLastByte;
   	UWORD IE_LS; //LastSect;
   	UWORD IE_LO; //LastOffset;
   	int   IE_LengthSize;
      int   MaxDiff;
   	BOOL  bFileSize;
   	} TIEDATA;   // Import/Export data structure
   
  //Atari DOS file structure (internal use) (Atari DOS directory entry)
  typedef struct tagATARIDOSFILE{ //adf
   	UBYTE FFlag;
   	UWORD FSect;
   	UWORD FBlock;
   	char  FName[12];
   	} ATARIDOSFILE;

  //Atari DOS file directory (internal use)
  typedef struct tagATARIDOSDIRECTORY{ //addir
   	ATARIDOSFILE adf[64];
   	UBYTE nbroffile;
   	UWORD freeblocks;
   	} ATARIDOSDIRECTORY;


//------------------------------------------------------------------------------
//    Declaration des procdures type Windowx en macro personnelles :
//------------------------------------------------------------------------------
   #define Text_Enable(hwndCtl, id_Edit) \
   	((LONG)SendDlgItemMessage((hwndCtl),(id_Edit), EM_SETREADONLY, FALSE, 0L));
   #define Text_Disable(hwndCtl, id_Edit) \
   	((LONG)SendDlgItemMessage((hwndCtl),(id_Edit), EM_SETREADONLY, TRUE, 0L));


#endif
