#include "atari.h"
#include "diskled.h"

int led_status = 0;
int led_off_delay = -1;

#define DISKLED_FONT_WIDTH		5
#define DISKLED_FONT_HEIGHT		7
#define DISKLED_FONT_CHARSIZE	(DISKLED_FONT_WIDTH * DISKLED_FONT_HEIGHT)

static unsigned char DiskLED[]= {
172,172,172,172,172,
172,172,000,172,172,
172,000,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,172,172,172,
		
172,172,172,172,172,
172,000,000,172,172,
172,172,172,000,172,
172,172,000,172,172,
172,000,172,172,172,
172,000,000,000,172,
172,172,172,172,172,
		
172,172,172,172,172,
172,000,000,172,172,
172,172,172,000,172,
172,172,000,172,172,
172,172,172,000,172,
172,000,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,172,000,172,
172,172,000,000,172,
172,000,172,000,172,
172,000,000,000,172,
172,172,172,000,172,
172,172,172,172,172,

172,172,172,172,172,
172,000,000,000,172,
172,000,172,172,172,
172,000,000,000,172,
172,172,172,000,172,
172,000,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,000,172,172,
172,000,172,172,172,
172,000,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,000,000,000,172,
172,172,172,000,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,		
172,172,000,172,172,
172,000,172,000,172,
172,000,172,000,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,	/* End of read LEDs	*/

053,053,053,053,053,	/* Start of write LEDs */
053,053,000,053,053,
053,000,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,053,053,
053,053,053,000,053,
053,053,000,053,053,
053,000,053,053,053,
053,000,000,000,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,053,053,
053,053,053,000,053,
053,053,000,053,053,
053,053,053,000,053,
053,000,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,053,000,053,
053,053,000,000,053,
053,000,053,000,053,
053,000,000,000,053,
053,053,053,000,053,
053,053,053,053,053,


053,053,053,053,053,
053,000,000,000,053,
053,000,053,053,053,
053,000,000,000,053,
053,053,053,000,053,
053,000,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,053,053,
053,000,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,000,053,
053,053,053,000,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,000,053,
053,000,053,000,053,
053,000,053,000,053,
053,053,000,053,053,	
053,053,053,053,053	/* End of write LEDs	*/
};

void LED_Frame(void)
{
	if (led_off_delay >= 0)
		if (--led_off_delay < 0)
			led_status = 0;
#ifndef NO_LED_ON_SCREEN
	if (led_status) {
		UBYTE *shape = DiskLED + (led_status - 1) * DISKLED_FONT_CHARSIZE;
		UBYTE *scrn = (UBYTE *) atari_screen
					  + (screen_visible_y2 - DISKLED_FONT_HEIGHT) * ATARI_WIDTH
					  + screen_visible_x2 - DISKLED_FONT_WIDTH;
		int x;
		int y;
		for (y = 0; y < DISKLED_FONT_HEIGHT; y++) {
			for (x = 0; x < DISKLED_FONT_WIDTH; x++)
				*scrn++ = *shape++;
			scrn += ATARI_WIDTH - DISKLED_FONT_WIDTH;
		}
	}
#endif /* NO_LED_ON_SCREEN */
}
