/****************************************************************************
File    : WinConfig.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Windows project configuration flags
@(#) #BY# Harry
@(#) #LM# 15.04.2000
*/

#ifndef __WIN_CONFIG_H__
#define __WIN_CONFIG_H__

#include "config.h" /* Include Atari800 configuration file */

/* WIN_USE_PERF_COUNTER - Uses QueryPerformanceCounter() instead of timeGetTime().
   Generally faster, but requires a lot more code to watch for rollovers. */
#define WIN_USE_PERF_COUNTER

/* WIN_INLINE_ASM - Uses inline routines made in assembler. */
#define WIN_INLINE_ASM

/* WIN_TRANSLATE_ERRORS - Gives full description with DirectX/MM errors. Very nice,
   but the size of generated exe file is ~12KB smaller until that flag isn't set. */
#define WIN_TRANSLATE_ERRORS

/* WIN USE_FLIP_BUFFER - This doesn't buy us anything. It's actually slower than
   blitting directly from system memory to the primary buffer (which is how
   we have to render because the Atari screen is drawn pixel by pixel). */
#define WIN_USE_FLIP_BUFFER

/* WIN_USE_DSOUND - Enables DirectSound code. Should work but hasn't been turned on
   in a while; DirectSound was a wildly inconsistent performer for the user base
   and didn't always work, whereas the current Multimedia layer sound work fine. */
//#define WIN_USE_DSOUND


#ifdef _DEBUG
#define WIN_TRANSLATE_ERRORS
#endif

#endif //__WIN_CONFIG_H__
