/****************************************************************************
File    : registry.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Registry public methods and objects prototypes
@(#) #BY# Richard Lawrence, Harry
@(#) #LM# 08.04.2000
*/

#ifndef __REGISTRY_H__
#define __REGISTRY_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Const declarations */

#define	REGNAME					"Software\\Atari800Win"
#define	READ_REG_FAIL			999999

/* Whenever any value is changed/deleted/added in this file,
   change CURRENT_REV */
#define CURRENT_REV				31

#define	REG_REFRESH_RATE		"REFRESH_RATE"
#define	REG_DEFAULT_SYSTEM		"EMULATED_SYSTEM"
#define	REG_DEFAULT_TV_MODE		"TV_MODE"
#define	REG_HOLD_OPTION			"HOLD_OPTION"
#define	REG_ENABLE_C000_RAM		"ENABLE_C000_RAM"
#define REG_ENABLE_SIO_PATCH	"ENABLE_SIO_PATCH"
#define REG_ENABLE_ROM_PATCH	"ENABLE_ROM_PATCH"
#define REG_USE_NEW_BINLOAD		"USE_NEW_BINLOAD"
#define REG_USE_VOLUME_ONLY		"USE_VOLUME_ONLY"
#define REG_ENABLE_STEREO		"ENABLE_STEREO"
#define REG_ARTIF_MODE			"ARTIFACT_MODE"

#define REG_OSA_ROM				"ROM_OSA"
#define REG_OSB_ROM				"ROM_OSB"
#define REG_XLXE_ROM			"ROM_XLXE"
#define REG_5200_ROM			"ROM_5200"
#define REG_BASIC_ROM			"ROM_BASIC"
#define REG_OTHER_ROM			"ROM_CARTRIDGE"
#define REG_CURRENT_ROM			"ROM_CURRENT"
#define REG_CART_TYPE			"CART_TYPE"
#define REG_KEY_TEMPLATE		"KEY_TEMPLATE"
#define REG_EXT_PALETTE			"EXT_PALETTE"

#define	REG_KEYSET_A1			"KEYSET_A1"
#define	REG_KEYSET_A2			"KEYSET_A2"
#define	REG_KEYSET_A3			"KEYSET_A3"
#define	REG_KEYSET_B1			"KEYSET_B1"
#define	REG_KEYSET_B2			"KEYSET_B2"
#define	REG_KEYSET_B3			"KEYSET_B3"

#define	REG_DRIVE1				"D1"
#define REG_DRIVE2				"D2"
#define	REG_DRIVE3				"D3"
#define REG_DRIVE4				"D4"
#define	REG_DRIVE5				"D5"
#define	REG_DRIVE6				"D6"
#define	REG_DRIVE7				"D7"
#define	REG_DRIVE8				"D8"

#define REG_HD1					"H1"
#define REG_HD2					"H2"
#define REG_HD3					"H3"
#define	REG_HD4					"H4"

#define REG_EXE_PATH			"EXE_PATH"

#define REG_JOYSTICKS			"STICKS"
#define REG_STICK_REPEAT		"STICK_REPEAT"
#define REG_STICK_SKIP			"STICK_SKIP"

#define	REG_START_XPOS			"START_XPOS"
#define	REG_START_YPOS			"START_YPOS"

#define REG_DDRAW_MODE			"SCREEN_MODE"

#define REG_FILE_ASSOCIATIONS	"FILE_ASSOCIATIONS"

#define REG_SOUND_STATE			"SOUND_STATE"
#define REG_SOUND_RATE			"SOUND_RATE"
#define REG_SOUND_VOLUME		"SOUND_VOLUME"

#define REG_DONT_SHOW			"DONT_SHOW_FLAGS"

#define REG_MISC_STATES			"MISC_STATES"

#define REG_CURRENT_REV			"VERSION"

/* Exported methods */

/* These are functions to handle initialization and reading/writing to the 
   registry of persistent data elements */

void  InitialiseRegistry    ( HKEY hkInput, BOOL bErasePaths );
BOOL  HandleRegistry        ( void );
void  WriteAtari800Registry ( HKEY hkInitKey );

int   ReadRegDWORD          ( HKEY hkInput, char *item, DWORD *date, BOOL bShowError );
DWORD ReadRegBinary         ( HKEY hkInput, char *item, char *buffer, unsigned long maxsize, BOOL bShowError );
void  ReadRegDrives         ( HKEY hkInput );
int   ReadRegKeyset         ( HKEY hkInput, int nKeyset );

void  WriteRegDWORD         ( HKEY hkInput, char *item, DWORD value);
void  WriteRegBinary        ( HKEY hkInput, char *item, unsigned char *data, int size );
void  WriteRegString        ( HKEY hkInput, char *item, char *data );
void  WriteRegDrives        ( HKEY hkInput );
void  WriteRegKeyset		( HKEY hkInput, int nKeyset );
void  WriteRegFileExt       ( char *pszAppDir, char *pszAppName, struct FileExtInfo_t *pFileExtInfo, int nFileExtInfoNo );

void  DeleteAllRegKeys      ( HKEY hkInput, char *name );

#ifdef __cplusplus
}
#endif

#endif /*__REGISTRY_H__*/
