/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// DriveSmallDlg.cpp : implementation file
//

#include "StdAfx.h"
#include "Atari800Win.h"
#include "FileSmallDlg.h"
#include "DriveSmallDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDriveSmallDlg dialog


CDriveSmallDlg::CDriveSmallDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDriveSmallDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDriveSmallDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CDriveSmallDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDriveSmallDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDriveSmallDlg, CDialog)
	//{{AFX_MSG_MAP(CDriveSmallDlg)
	ON_BN_CLICKED(IDC_DRIVE_SMALL_CLEAR, OnDriveclearSmall)
	ON_BN_CLICKED(IDC_DRIVE_SMALL_CHECK, OnDrivecheckSmall)
	ON_CBN_SELCHANGE(IDC_DRIVE_SMALL_COMBO, OnSelchangeDrivecomboSmall)
	ON_BN_CLICKED(IDC_DRIVE_SMALL_FINDFILE, OnDrivesmallFindfile)
	ON_EN_KILLFOCUS(IDC_DRIVE_SMALL_EDIT, OnKillfocusDrivesmallEdit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDriveSmallDlg message handlers

BOOL CDriveSmallDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	for( int i = 0; i < MAX_DRIVES; i++ )
		strcpy( temp_sio_filename[ i ], sio_filename[ i ] );

	ComboBox = (CComboBox *)GetDlgItem( IDC_DRIVE_SMALL_COMBO );
	
	if( !ComboBox )
		return FALSE;

	ComboBox->SetCurSel( 0 );
	SetDlgItemText( IDC_DRIVE_SMALL_EDIT, temp_sio_filename[ 0 ] );

	cbCheckBox = (CButton *)GetDlgItem( IDC_DRIVE_SMALL_CHECK );
	if( !cbCheckBox )
		return FALSE;

	if( strcmp( temp_sio_filename[ 0 ], "Off" ) )
		cbCheckBox->SetCheck( 1 );

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CDriveSmallDlg::OnDriveclearSmall() 
{
	for( int i = 0; i < MAX_DRIVES; i++ )
		strcpy( temp_sio_filename[ i ], "Empty" );
	SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Empty" );
}

void CDriveSmallDlg::OnDrivecheckSmall() 
{
	int	drive = ComboBox->GetCurSel();

	if( drive == CB_ERR )
	{
		cbCheckBox->SetCheck( 0 );
		return;
	}

	if( strcmp( temp_sio_filename[drive], "Off" ) != 0 )
	{
		strcpy( temp_sio_filename[drive], "Off" );
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Off" );
		cbCheckBox->SetCheck( 0 );
	}
	else
	{
		strcpy( temp_sio_filename[drive], "Empty" );
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Empty" );
		cbCheckBox->SetCheck( 1 );
	}
}

void CDriveSmallDlg::OnSelchangeDrivecomboSmall() 
{
	int	nDrive = ComboBox->GetCurSel();

	if( nDrive == CB_ERR )
	{
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, "Not a drive" );
		cbCheckBox->SetCheck( 0 );
		return;
	}

	SetDlgItemText( IDC_DRIVE_SMALL_EDIT, temp_sio_filename[nDrive] );
	if( strcmp( temp_sio_filename[nDrive], "Off" ) )
		cbCheckBox->SetCheck( 1 );
	else
		cbCheckBox->SetCheck( 0 );
}

void CDriveSmallDlg::OnDrivesmallFindfile() 
{
	CFileSmallDlg	smallFileDlg;
	CString	strName;

	if( smallFileDlg.DoModal() == IDOK )
	{
		int drive = ComboBox->GetCurSel();

		strName = smallFileDlg.GetPathName();
		SetDlgItemText( IDC_DRIVE_SMALL_EDIT, (LPSTR)(LPCSTR)strName );
		if( drive != CB_ERR )
			strcpy( temp_sio_filename[ drive ], strName );
	}
	return;
}

void CDriveSmallDlg::OnOK() 
{
	int i;
	for( i=0; i < 8; i++ )
	{
		if( strcmp( temp_sio_filename[i], sio_filename[i] ) )
		{
			WriteRegString( NULL, g_apszDriveRegID[i], sio_filename[i] );
			
			if( !strcmp( temp_sio_filename[i], "Off" ) )
				SIO_DisableDrive( i + 1 );
			else if( !strcmp( temp_sio_filename[i], "Empty" ) )
				SIO_Dismount( i + 1 );
			else
			{
				SIO_Dismount( i + 1 );
				SIO_Mount( i + 1, temp_sio_filename[i] );		
			}
		}

	}

	CDialog::OnOK();
}

void CDriveSmallDlg::OnKillfocusDrivesmallEdit() 
{
	int	drive = ComboBox->GetCurSel();

	if( drive != CB_ERR )
		GetDlgItemText( IDC_DRIVE_SMALL_EDIT, temp_sio_filename[drive], MAX_PATH );
}
