/****************************************************************************
File    : FileAssociationsDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CFileAssociationsDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 20.02.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "FileAssociationsDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Static objects

static struct FileExtInfo_t s_aFileExtInfo[] =
{
	{ FALSE, FILE_ATR, IDC_FILEASSOCIATIONS_ATR, ".atr" }, 
	{ FALSE, FILE_XFD, IDC_FILEASSOCIATIONS_XFD, ".xfd" }, 
	{ FALSE, FILE_DCM, IDC_FILEASSOCIATIONS_DCM, ".dcm" }, 
	{ FALSE, FILE_ATZ, IDC_FILEASSOCIATIONS_ATZ, ".atz" }, 
	{ FALSE, FILE_XFZ, IDC_FILEASSOCIATIONS_XFZ, ".xfz" }, 
	{ TRUE,  FILE_XEX, IDC_FILEASSOCIATIONS_XEX, ".xex" }
};

static const int s_nFileExtInfoNo = sizeof(s_aFileExtInfo)/sizeof(s_aFileExtInfo[0]);


/////////////////////////////////////////////////////////////////////////////
// CFileAssociationsDlg Dialog

BEGIN_MESSAGE_MAP(CFileAssociationsDlg, CDialog)
	//{{AFX_MSG_MAP(CFileAssociationsDlg)
	ON_BN_CLICKED(IDC_FILEASSOCIATIONS_REMOVEALL, OnRemoveAll)
	ON_BN_CLICKED(IDC_FILEASSOCIATIONS_SELECTALL, OnSelectAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*========================================================
Method   : CFileAssociationsDlg::CFileAssociationsDlg
=========================================================*/
/* #FN#
   Standard constructor */
CFileAssociationsDlg::
CFileAssociationsDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
	: CDialog( CFileAssociationsDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CFileAssociationsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CFileAssociationsDlg::CFileAssociationsDlg */

/*========================================================
Method   : CFileAssociationsDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CFileAssociationsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CFileAssociationsDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CFileAssociationsDlg implementation

/*========================================================
Method   : CFileAssociationsDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
SetDlgState()
{
	CButton *pButton = NULL;
	for( int i = 0; i < s_nFileExtInfoNo; i++ )
	{
		if( g_ulFileAssociations & s_aFileExtInfo[ i ].dwRegFlag )
		{
			pButton = (CButton*)GetDlgItem( s_aFileExtInfo[ i ].nCtrlId );
			ASSERT(pButton);
			pButton->SetCheck( 1 );
		}
	}
} /* #OF# CFileAssociationsDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CFileAssociationsDlg message handlers

/*========================================================
Method   : CFileAssociationsDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CFileAssociationsDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CFileAssociationsDlg::OnInitDialog */

/*========================================================
Method   : CFileAssociationsDlg::OnSelectAll
=========================================================*/
/* #FN#
   Sets all the check-boxes to 'checked' state */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
OnSelectAll() 
{
	CButton *pButton = NULL;
	for( int i = 0; i < s_nFileExtInfoNo; i++ )
	{
		pButton = (CButton*)GetDlgItem( s_aFileExtInfo[ i ].nCtrlId );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
} /* #OF# CFileAssociationsDlg::OnSelectAll */

/*========================================================
Method   : CFileAssociationsDlg::OnRemoveAll
=========================================================*/
/* #FN#
   Sets all the check-boxes to 'unchecked' state */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
OnRemoveAll() 
{
	CButton *pButton = NULL;
	for( int i = 0; i < s_nFileExtInfoNo; i++ )
	{
		pButton = (CButton*)GetDlgItem( s_aFileExtInfo[ i ].nCtrlId );
		ASSERT(pButton);
		pButton->SetCheck( 0 );
	}
} /* #OF# CFileAssociationsDlg::OnRemoveAll */

/*========================================================
Method   : CFileAssociationsDlg::OnOK
=========================================================*/
/* #FN#
   Handles the pressing OK button event */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
OnOK() 
{
	char  szCurDir[ MAX_PATH ];
	ULONG ulAssociations = g_ulFileAssociations;

	CButton *pButton = NULL;
	for( int i = 0; i < s_nFileExtInfoNo; i++ )
	{
		pButton = (CButton*)GetDlgItem( s_aFileExtInfo[ i ].nCtrlId );
		ASSERT(pButton);
		if( pButton->GetCheck() )
			g_ulFileAssociations |= s_aFileExtInfo[ i ].dwRegFlag;
		else
			g_ulFileAssociations &= ~s_aFileExtInfo[ i ].dwRegFlag;
	}
	/* Write dialog status only if necessary */
	if( ulAssociations != g_ulFileAssociations )
		WriteRegDWORD( NULL, REG_FILE_ASSOCIATIONS, g_ulFileAssociations );

	/* Always modify file associations */
	GetCurrentDirectory( MAX_PATH, szCurDir );
	WriteRegFileExt( szCurDir, g_szCmdLine, s_aFileExtInfo, s_nFileExtInfoNo );

	CDialog::OnOK();
} /* #OF# CFileAssociationsDlg::OnOK */
