/****************************************************************************
File    : GraphicsSmallDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CGraphicsSmallDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 18.04.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"
#include "GraphicsAdvDlg.h"
#include "GraphicsSmallDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CGraphicsSmallDlg dialog

BEGIN_MESSAGE_MAP(CGraphicsSmallDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphicsSmallDlg)
	ON_CBN_SELCHANGE(IDC_GRAPHICS_SMALL_COMBO, OnSelchangeGraphicsComboSmall)
	ON_BN_CLICKED(IDC_GRAPHICS_SMALL_NODDRAW, OnNoddrawSmall)
	ON_BN_CLICKED(IDC_GRAPHICS_SMALL_ADVSETTING, OnAdvSetting)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CGraphicsSmallDlg::
CGraphicsSmallDlg( CWnd *pParent /*=NULL*/ )
	: CDialog( CGraphicsSmallDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CGraphicsSmallDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void
CGraphicsSmallDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CGraphicsSmallDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// CGraphicsSmallDlg message handlers

void
CGraphicsSmallDlg::
SetDlgState( void )
{
	HANDLE	 hIcon   = NULL;
	int      iSelect = 0;
	CButton *pButton = NULL;
	CStatic *pStatic = (CStatic *)GetDlgItem( IDC_GRAPHICS_SMALL_ICON );

	if( m_ulScreenMode & SM_MODE_FULL )
	{
		hIcon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
		iSelect = 4;	/* Default case (640 x 480) */

		if( m_ulScreenMode & SM_FRES_320_200 )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
			iSelect = 0;
		}
		if( m_ulScreenMode & SM_FRES_320_240 )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
			iSelect = 1;
		}
		if( m_ulScreenMode & SM_FRES_512_384 )
		{
			iSelect = 2;
		}
		if( m_ulScreenMode & SM_FRES_640_400 )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
			iSelect = 3;
		}
		if( m_ulScreenMode & SM_FRES_640_480 )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
			iSelect = 4;
		}
		if( m_ulScreenMode & SM_FRES_1024_768 )
		{
			iSelect = 6;
		}
	}
	else
	{
		if( m_ulScreenMode & SM_WRES_NORMAL )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
			iSelect = 7;
		}
		else
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );
			iSelect = 8;
		}
	}
	pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_SMALL_NODDRAW );
	ASSERT( pButton );
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_USE_GDI) != 0 );

	m_pComboBox->SetCurSel( iSelect );
	if( hIcon && pStatic )
		pStatic->SetIcon( (HICON)hIcon );
}

BOOL
CGraphicsSmallDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_ulScreenMode = g_ulScreenMode;

	if( !(m_pComboBox = (CComboBox *)GetDlgItem( IDC_GRAPHICS_SMALL_COMBO )) )
		return FALSE;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CGraphicsSmallDlg::
OnSelchangeGraphicsComboSmall() 
{
	switch( m_pComboBox->GetCurSel() )
	{
		case 0:
		{
			int nResult = IDOK;
			if( !(g_ulDontShowFlags & DONT_SHOW_MENU_WARN) )
			{
				char szMessage[ LOADSTRING_STRING_SIZE ];
				CWarningDlg dlgWarning;

				LoadString( NULL, IDS_WARNING_NO_MENU, szMessage, LOADSTRING_STRING_SIZE );
				dlgWarning.m_strWarnText = szMessage;
				dlgWarning.m_ulWarnBit   = DONT_SHOW_MENU_WARN;
				nResult = dlgWarning.DoModal();
			}
			if( nResult == IDOK )
			{
				m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
				m_ulScreenMode |= SM_FRES_320_200 | SM_MODE_FULL;
			}
			break;
		}

		case 1:
			m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
			m_ulScreenMode |= SM_FRES_320_240 | SM_MODE_FULL;
			break;

		case 2:
			m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
			m_ulScreenMode |= SM_FRES_512_384 | SM_MODE_FULL;
			break;

		case 3:
		{
			if( !(g_ulDontShowFlags & DONT_SHOW_MENU_WARN) )
			{
				char szMessage[ LOADSTRING_STRING_SIZE ];
				CWarningDlg dlgWarning;

				LoadString( NULL, IDS_WARNING_NO_MENU, szMessage, LOADSTRING_STRING_SIZE );
				dlgWarning.m_strWarnText = szMessage;
				dlgWarning.m_ulWarnBit   = DONT_SHOW_MENU_WARN;
				dlgWarning.m_bCancel     = FALSE;
				dlgWarning.DoModal();
			}
			m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
			m_ulScreenMode |= SM_FRES_640_400 | SM_MODE_FULL;
			break;
		}

		case 4:
			m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
			m_ulScreenMode |= SM_FRES_640_480 | SM_MODE_FULL;
			break;

		case 5:
			m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
			m_ulScreenMode |= SM_FRES_800_600 | SM_MODE_FULL;
			break;

		case 6:
			m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
			m_ulScreenMode |= SM_FRES_1024_768 | SM_MODE_FULL;
			break;

		case 7:
			m_ulScreenMode &= ~(SM_WRES_MASK | SM_MODE_MASK);
			m_ulScreenMode |= SM_WRES_NORMAL | SM_MODE_WIND;
			break;

		case 8:
		{
			int nResult = IDOK;
			if( !(g_ulDontShowFlags & DONT_SHOW_GRAPHICS_WARN) )
			{
				char szMessage[ LOADSTRING_STRING_SIZE ];
				CWarningDlg	dlgWarning;

				LoadString( NULL, IDS_WARNING_GRAPHICS_WINDOW, szMessage, LOADSTRING_STRING_SIZE );
				dlgWarning.m_strWarnText = szMessage;
				dlgWarning.m_ulWarnBit   = DONT_SHOW_GRAPHICS_WARN;
				nResult = dlgWarning.DoModal();
			}
			if( nResult == IDOK )
			{
				m_ulScreenMode &= ~(SM_WRES_MASK | SM_MODE_MASK);
				m_ulScreenMode |= SM_WRES_STRETCH | SM_MODE_WIND;
			}
			break;
		}

		default:
			m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
			m_ulScreenMode |= SM_FRES_640_480 | SM_MODE_FULL;
			break;
	}
	SetDlgState();
}

void
CGraphicsSmallDlg::
OnNoddrawSmall() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_SMALL_NODDRAW );
	if( pButton )
	{
		if( pButton->GetCheck() )
			m_ulScreenMode |= SM_OPTN_USE_GDI;
		else
			m_ulScreenMode &= ~SM_OPTN_USE_GDI;
	}
	SetDlgState();
}

/*========================================================
Method   : CGraphicsSmallDlg::OnAdvSetting
=========================================================*/
/* #FN#
   Displays "Advanced Graphics Options" dialog box */
void
/* #AS#
   Nothing */
CGraphicsSmallDlg::
OnAdvSetting()
{
	CGraphicsAdvDlg dlgGraphicsAdv( &m_ulScreenMode, this );

	dlgGraphicsAdv.DoModal();
} /* #OF# CGraphicsSmallDlg::OnAdvSetting */

/*========================================================
Method   : CGraphicsSmallDlg::OnOK
=========================================================*/
/* #FN#
   Handles the pressing OK button event */
void
/* #AS#
   Nothing */
CGraphicsSmallDlg::
OnOK() 
{
	if( m_ulScreenMode != g_ulScreenMode )
	{
		ULONG ulSavedMode = g_ulScreenMode;

		g_ulScreenMode = m_ulScreenMode;

		if( !InitialiseScreen( FALSE ) )
		{
			g_ulScreenMode = ulSavedMode;
			InitialiseScreen( FALSE );
		}
		WriteRegDWORD( NULL, REG_DDRAW_MODE, g_ulScreenMode );
	}
	CDialog::OnOK();
} /* #OF# CGraphicsSmallDlg::OnOK */
