/****************************************************************************
File    : SoundDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CSoundDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 24.03.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"
#include "SoundDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Static objects

static int s_anSoundRates[ 7 ] =
{
	8000, 11025, 21280, 22050, 31920, 44100, 48000
};

static int s_anLowLimits[ 7 ] =
{
	6, 4, 2, 2, 2, 1, 1
};


/////////////////////////////////////////////////////////////////////////////
// CSoundDlg dialog

BEGIN_MESSAGE_MAP(CSoundDlg, CDialog)
	//{{AFX_MSG_MAP(CSoundDlg)
	ON_BN_CLICKED(IDC_SOUND_MMSOUND, OnSoundMmsound)
	ON_BN_CLICKED(IDC_SOUND_DIRECTSOUND, OnSoundDirectsound)
	ON_BN_CLICKED(IDC_SOUND_NOSOUND, OnSoundNosound)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SOUND_SPINPOKEYDIVISOR, OnDeltaposPokeyDivisorSpin)
	ON_CBN_SELCHANGE(IDC_SOUND_PLAYBACK, OnSelchangeSoundPlayback)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SOUND_VOLUMESLIDER, OnReleasedcaptureVolumeSlider)
	ON_BN_CLICKED(IDC_SOUND_VOLUMEONLY, OnSoundVolumeOnly)
	ON_BN_CLICKED(IDC_SOUND_STEREO, OnSoundStereo)
	ON_EN_KILLFOCUS(IDC_SOUND_EDITPOKEYDIVISOR, OnKillfocusPokeyDivisor)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*========================================================
Method   : CSoundDlg::CSoundDlg
=========================================================*/
/* #FN#
   Standard constructor */
CSoundDlg::
CSoundDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
	: CDialog( CSoundDlg::IDD, pParent )
{
	m_nLowSkipLimit      = 1;
	m_nHighSkipLimit     = 262;
	m_ulSoundState       = SOUND_MMSOUND | SOUND_CUSTOM_RATE;
	m_nSoundRate         = 44100;
	m_nSoundVol          = 0;
	m_nSkipUpdateDefault = POKEY_UPDATE_DIVISOR_DEFAULT;
	m_bUseVolumeOnly     = FALSE;
	m_bEnableStereo      = FALSE;

	//{{AFX_DATA_INIT(CSoundDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CSoundDlg::CSoundDlg */

/*========================================================
Method   : CSoundDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CSoundDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CSoundDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CSoundDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CSoundDlg implementation

/*========================================================
Method   : CSoundDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CSoundDlg::
SetDlgState( void )
{
	CButton		*pButton = NULL;
	CSliderCtrl	*pSlider = NULL;
	CComboBox	*pCombo  = NULL;

	m_nHighSkipLimit = (default_tv_mode == 1 ? 262 : 312);

	pSlider = (CSliderCtrl *)GetDlgItem( IDC_SOUND_VOLUMESLIDER );
	ASSERT(pSlider != NULL);

	pSlider->EnableWindow( Sound_VolumeCapable() );
	pSlider->SetRange( 0, 100, FALSE );
	pSlider->SetTicFreq( 10 );
	pSlider->SetPageSize( 10 );
	pSlider->SetPos( 100 + m_nSoundVol );

	/* Set up Output Type buttons */
	CheckRadioButton( IDC_SOUND_NOSOUND, IDC_SOUND_DIRECTSOUND,
		 m_ulSoundState & SOUND_NOSOUND ? IDC_SOUND_NOSOUND :
		(m_ulSoundState & SOUND_MMSOUND ? IDC_SOUND_MMSOUND : IDC_SOUND_DIRECTSOUND) );

	pButton = (CButton *)GetDlgItem( IDC_SOUND_VOLUMEONLY );
	ASSERT(pButton != NULL);
	pButton->SetCheck( m_bUseVolumeOnly );
#ifdef NO_VOL_ONLY
	pButton->EnableWindow( FALSE );
#endif

	pButton = (CButton *)GetDlgItem( IDC_SOUND_STEREO );
	ASSERT(pButton != NULL);
	pButton->SetCheck( m_bEnableStereo );
#ifndef STEREO
	pButton->EnableWindow( FALSE );
#endif

#ifndef WIN_USE_DSOUND
	GetDlgItem( IDC_SOUND_DIRECTSOUND )->EnableWindow( FALSE );
#endif

	pCombo = (CComboBox *)GetDlgItem( IDC_SOUND_PLAYBACK );
	ASSERT(pCombo != NULL);

	switch( m_nSoundRate )
	{
		case 8000:
			pCombo->SetCurSel( 0 );
			m_nLowSkipLimit = 6;
			break;

		case 11025:
			pCombo->SetCurSel( 1 );
			m_nLowSkipLimit = 4;
			break;

		case 21280:
			pCombo->SetCurSel( 2 );
			m_nLowSkipLimit = 2;
			break;

		case 22050:
			pCombo->SetCurSel( 3 );
			m_nLowSkipLimit = 2;
			break;

		case 31920:
			pCombo->SetCurSel( 4 );
			m_nLowSkipLimit = 2;
			break;

		case 44100:
			pCombo->SetCurSel( 5 );
			m_nLowSkipLimit = 1;
			break;

		case 48000:
			pCombo->SetCurSel( 6 );
			m_nLowSkipLimit = 1;
			break;

		default:
			pCombo->SetCurSel( 5 );
			m_nSoundRate = 44100;
			m_nLowSkipLimit = 1;
	}
	SetPokeyDivisor();
} /* #OF# CSoundDlg::SetDlgState */

/*========================================================
Method   : CSoundDlg::SetPokeyDivisor
=========================================================*/
/* #FN#
   Sets the proper Pokey update divisor value */
void
/* #AS#
   Nothing */
CSoundDlg::
SetPokeyDivisor( void )
{
	char szDigits[ 16 ];

	if( m_nSkipUpdateDefault < m_nLowSkipLimit )
		m_nSkipUpdateDefault = m_nLowSkipLimit;
	if( m_nSkipUpdateDefault > m_nHighSkipLimit )
		m_nSkipUpdateDefault = m_nHighSkipLimit;

	itoa( m_nSkipUpdateDefault, szDigits, 10 );
	SetDlgItemText( IDC_SOUND_EDITPOKEYDIVISOR, szDigits );
} /* #OF# CSoundDlg::SetPokeyDivisor */


/////////////////////////////////////////////////////////////////////////////
// CSoundDlg message handlers

BOOL
CSoundDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_ulSoundState       = g_ulSoundState;
	m_nSoundRate         = g_nSoundRate;
	m_nSoundVol          = g_nSoundVol;
	m_nSkipUpdateDefault = g_nSkipUpdateDefault;
	m_bUseVolumeOnly     = (BOOL)use_volume_only;
	m_bEnableStereo      = (BOOL)stereo_enabled;

	SetDlgState();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CSoundDlg::
OnSelchangeSoundPlayback() 
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_SOUND_PLAYBACK );
	ASSERT(pCombo != NULL);

	m_nLowSkipLimit = s_anLowLimits [ pCombo->GetCurSel() ];
	m_nSoundRate    = s_anSoundRates[ pCombo->GetCurSel() ];
	SetPokeyDivisor();

	if( m_nSoundRate == 22050 )
		m_ulSoundState &= ~SOUND_CUSTOM_RATE;
	else
		m_ulSoundState |= SOUND_CUSTOM_RATE;
}

void
CSoundDlg::
OnSoundNosound() 
{
	m_ulSoundState |= SOUND_NOSOUND;
//	m_ulSoundState &= ~(SOUND_DIRECTSOUND | SOUND_MMSOUND); /* Sound/Mute wants this */
}

void
CSoundDlg::
OnSoundMmsound() 
{
	m_ulSoundState |= SOUND_MMSOUND;
	m_ulSoundState &= ~(SOUND_DIRECTSOUND | SOUND_NOSOUND);
}


void
CSoundDlg::
OnSoundDirectsound() 
{
	m_ulSoundState |= SOUND_DIRECTSOUND;
	m_ulSoundState &= ~(SOUND_MMSOUND | SOUND_NOSOUND);
}

void
CSoundDlg::
OnKillfocusPokeyDivisor() 
{
	BOOL bResult;

	ASSERT(GetDlgItem( IDC_SOUND_EDITPOKEYDIVISOR ));
	m_nSkipUpdateDefault = GetDlgItemInt( IDC_SOUND_EDITPOKEYDIVISOR, &bResult, FALSE );

	SetPokeyDivisor();
}

void
CSoundDlg::
OnDeltaposPokeyDivisorSpin( NMHDR *pNMHDR, LRESULT *pResult )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN *)pNMHDR;
	m_nSkipUpdateDefault -= pNMUpDown->iDelta;

	SetPokeyDivisor();

	*pResult = m_nSkipUpdateDefault;
}

void
CSoundDlg::
OnReleasedcaptureVolumeSlider( NMHDR *pNMHDR, LRESULT *pResult )
{
	CSliderCtrl	*pSlider = (CSliderCtrl *)GetDlgItem( IDC_SOUND_VOLUMESLIDER );
	ASSERT(pSlider != NULL);
	m_nSoundVol = pSlider->GetPos() - 100;
	
	*pResult = 0;
}

void
CSoundDlg::
OnSoundVolumeOnly() 
{
	CButton *pButton = (CButton*)GetDlgItem( IDC_SOUND_VOLUMEONLY );
	ASSERT(pButton != NULL);
	m_bUseVolumeOnly = pButton->GetCheck();
}

void
CSoundDlg::
OnSoundStereo() 
{
	CButton *pButton = (CButton*)GetDlgItem( IDC_SOUND_STEREO );
	ASSERT(pButton != NULL);
	m_bEnableStereo = pButton->GetCheck();
}

void
CSoundDlg::
OnOK() 
{
	BOOL bChanged = FALSE;

	CDialog::OnOK();

	if( m_ulSoundState != g_ulSoundState )
	{
		g_ulSoundState = m_ulSoundState;
		WriteRegDWORD( NULL, REG_SOUND_STATE, g_ulSoundState );
		bChanged = TRUE;
	}
	if( m_nSoundRate != g_nSoundRate )
	{
		g_nSoundRate = m_nSoundRate;
		WriteRegDWORD( NULL, REG_SOUND_RATE, g_nSoundRate );
		bChanged = TRUE;
	}
	if( m_nSkipUpdateDefault != g_nSkipUpdateDefault )
	{
		g_nSkipUpdateDefault = m_nSkipUpdateDefault;
		bChanged = TRUE;
	}
	if( m_bUseVolumeOnly != (BOOL)use_volume_only )
	{
		use_volume_only = m_bUseVolumeOnly;
		WriteRegDWORD( NULL, REG_USE_VOLUME_ONLY, use_volume_only );
		bChanged = TRUE;
	}
	if( m_bEnableStereo != (BOOL)stereo_enabled )
	{
		stereo_enabled = (int)m_bEnableStereo;
		WriteRegDWORD( NULL, REG_ENABLE_STEREO, stereo_enabled );
		bChanged = TRUE;
	}

	if( bChanged )
	{
		ClearSound( TRUE );
		InitialiseSound();
	}
	/* Set new sound volume */
	if( m_nSoundVol != g_nSoundVol )
	{
		g_nSoundVol = m_nSoundVol;
		WriteRegDWORD( NULL, REG_SOUND_VOLUME, g_nSoundVol );
		Sound_SetVolume();
	}
}
