{Alle Routinen des Taschenrechners in CODESYS/HEXEDIT}

PROCEDURE DoCalculator;

VAR
TempS1, TempS2 : STRING[8];
Operand : CHAR;
Mode : BYTE;
L1, OpCode1, OpCode2, Temp : LONGINT;
Negative, Res: BOOLEAN;

PROCEDURE InitView;

BEGIN
InfoBar(Calc1);
FoldOffWindow(' Calculator ', 24, 7, 66, 23, LightCyan, Blue, 1);
TextBackGround(LightCyan);
TextColor(Black);
GotoXY(26, 13);
Write('Operand: ');
GotoXY(26, 9);
Write('Result: ');
TextBackGround(Blue);
GotoXY(34, 9);
Write('           ');
TextBackGround(Blue);
TextColor(White);
GotoXY(27, 15);
Write(' 1 ');
GotoXY(31, 15);
Write(' 2 ');
GotoXY(35, 15);
Write(' 3 ');
GotoXY(39, 15);
Write(' A ');
GotoXY(43, 15);
Write(' B ');
GotoXY(27, 17);
Write(' 4 ');
GotoXY(31, 17);
Write(' 5 ');
GotoXY(35, 17);
Write(' 6 ');
GotoXY(39, 17);
Write(' C ');
GotoXY(43, 17);
Write(' D ');
GotoXY(27, 19);
Write(' 7 ');
GotoXY(31, 19);
Write(' 8 ');
GotoXY(35, 19);
Write(' 9 ');
GotoXY(39, 19);
Write(' E ');
GotoXY(43, 19);
Write(' F ');
GotoXY(27, 21);
Write(' 0 ');
GotoXY(31, 21);
Write(' +/- ');
TextBackGround(Red);
GotoXY(39, 21);
Write(' CLEAR ');
GotoXY(61, 21);
Write(' = ');
TextBackGround(Green);
GotoXY(61, 15);
Write(' + ');
GotoXY(61, 17);
Write(' - ');
GotoXY(61, 19);
Write(' * ');
GotoXY(55, 15);
Write(' AND ');
GotoXY(49, 17);
Write(' DIV ');
GotoXY(49, 15);
Write(' MOD ');
GotoXY(55, 17);
Write(' XOR ');
GotoXY(49, 19);
Write(' SHL ');
GotoXY(49, 21);
Write(' SHR ');
GotoXY(55, 21);
Write(' OR ');
GotoXY(55, 19);
Write(' NOT ');
TextColor(Black);
GotoXY(41, 21);
TextBackGround(Red);
Write('L');
TextBackGround(Green);
GotoXY(50, 15);
Write('M');
GotoXY(51, 17);
Write('I');
GotoXY(51, 19);
Write('H');
GotoXY(52, 21);
Write('R');
GotoXY(57, 15);
Write('N');
GotoXY(56, 17);
Write('X');
GotoXY(56, 21);
Write('O');
GotoXY(58, 19);
Write('T');
END;

PROCEDURE UpDateView;

VAR
S : ARRAY[1..3] OF STRING[8];
TS : STRING[8];
TSB : STRING[11];
TL : LONGINT;
I : BYTE;

BEGIN
TextBackGround(Blue);
TextColor(Yellow);
GotoXY(35, 9);
CASE Negative OF
FALSE : Write(' ')
ELSE
Write('-');
END;
GotoXY(36, 9);
Write('        ');
TextBackGround(LightCyan);
GotoXY(36, 10);
Write('        ');
GotoXY(36, 11);
Write('        ');
TextBackGround(Blue);
CASE Operand OF
' ' :
BEGIN
TS := TempS1;
TL := Abs(OpCode1);
END
ELSE
TS := TempS2;
TL := Abs(OpCode2);
END;
CASE Mode OF
0 :
BEGIN
TSB := Long2Hex(TL, TRUE);
Move(TSB[4], S[3][1], 8);
S[3][0] := #8;
S[1] := '';
IF TL < 256 THEN
WHILE TL > 0 DO
BEGIN
S[1] := Chr((TL MOD 2)+48) + S[1];
TL := TL DIV 2;
END
ELSE
S[1] := '   --   ';
S[2] := TS;
END;
1 :
BEGIN
S[1] := TS;
TSB := Long2Hex(TL, TRUE);
Move(TSB[4], S[3][1], 8);
S[3][0] := #8;
S[2] := '';
IF TL < 256 THEN
WHILE TL > 0 DO
BEGIN
S[2] := Chr((TL MOD 2)+48) + S[2];
TL := TL DIV 2;
END
ELSE
S[2] := '   --   ';
END;
2 :
BEGIN
S[1] := Long2Hex(TL, FALSE);
S[3] := TS;
IF TL > 99999999 THEN
S[3] := '   --   ';
S[2] := '';
IF TL < 256 THEN
WHILE TL > 0 DO
BEGIN
S[2] := Chr((TL MOD 2)+48) + S[2];
TL := TL DIV 2;
END
ELSE
S[2] := '   --   ';
END;
END;
IF ((Operand = ' ') AND (OpCode1 = 0)) OR ((Operand <> ' ') AND (OpCode2 = 0)) THEN
S[1] := '';
IF S[2][0] < #8 THEN
BEGIN
FOR I := Length(S[2])+1 TO 8 DO
S[2] := '0' + S[2];
S[2][0] := #8;
END;
IF S[3][0] < #8 THEN
BEGIN
FOR I := Length(S[3])+1 TO 8 DO
S[3] := '0' + S[3];
S[3][0] := #8;
END;
IF Res = FALSE THEN
BEGIN
S[1] := '   --   ';
S[2] := '   --   ';
S[3] := '   --   ';
END;
IF S[1] = '' THEN
S[1] := '0';
GotoXY(36, 9);
Write(S[1]);
TextBackGround(LightCyan);
TextColor(Black);
GotoXY(36, 10);
Write(S[2]);
GotoXY(36, 11);
Write(S[3]);
CASE Mode OF
0 :
BEGIN
GotoXY(46, 9);
Write('b');
GotoXY(46, 10);
Write('d');
GotoXY(46, 11);
Write('h');
END;
1 :
BEGIN
GotoXY(46, 9);
Write('d');
GotoXY(46, 10);
Write('b');
GotoXY(46, 11);
Write('h');
END;
2 :
BEGIN
GotoXY(46, 9);
Write('h');
GotoXY(46, 10);
Write('b');
GotoXY(46, 11);
Write('d');
END;
END;
TextColor(Blue);
GotoXY(35, 13);
CASE Operand OF
' ' : Write('              ');
'+' : Write('Addition      ');
'-' : Write('Subtraktion   ');
'*' : Write('Multiplikation');
'N' : Write('Logical AND   ');
'O' : Write('Logical OR    ');
'X' : Write('Logical XOR   ');
'T' : Write('Logical NOT   ');
'H' : Write('Shift -> Left ');
'R' : Write('Shift -> Right');
'I' : Write('Division - DIV');
'M' : Write('Division - MOD');
END;
END;

PROCEDURE CalcNumbers;

VAR
I, J, K, L : BYTE;
TempB : BOOLEAN;
S1 : STRING[8];

BEGIN
Temp := 0;
CASE Operand OF
' ' : S1 := TempS1
ELSE
S1 := TempS2;
END;
IF S1 <> '' THEN
BEGIN
REPEAT
IF (S1[1] = '0') THEN
BEGIN
FOR I := 2 TO Length(S1) DO
S1[I-1] := S1[I];
Dec(S1[0]);
END;
UNTIL (S1[1] <> '0') OR (S1[0] = #0);
TempB := FALSE;
L1 := 0;
FOR I := 1 TO Length(S1) DO
BEGIN
L1 := 1;
FOR J := 2 TO I DO
L1 := L1*10;
IF I = 1 THEN
L1 := 1;
Temp := Temp+L1*(Ord(S1[Length(S1)+1-I])-48);
IF TempB AND (I = Length(S1)) THEN
BREAK;
END;
END;
CASE Operand OF
' ' : OpCode1 := Temp
ELSE
OpCode2 := Temp;
END;
END;

PROCEDURE GetResult;

VAR
Result : LONGINT;
TempS : STRING;

BEGIN
CASE Operand OF
'+' :
BEGIN
Result := OpCode1 + OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
IF TempS[0] > #8 THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END
ELSE
TempS1 := TempS;
END;
'-':
BEGIN
Result := OpCode1 - OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
IF TempS[0] > #8 THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END
ELSE
TempS1 := TempS;
END;
'I' :
IF OpCode2 <> 0 THEN
BEGIN
Result := OpCode1 DIV OpCode2;
OpCode1 := Result;
Str(Abs(Result), TempS1);
TempS2 := '';
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
Res := TRUE;
Operand := ' ';
OpCode2 := 0;
END;
'M' :
BEGIN
IF OpCode2 <> 0 THEN
Result := OpCode1 MOD OpCode2;
OpCode1 := Result;
Str(Abs(Result), TempS1);
TempS2 := '';
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
Res := TRUE;
Operand := ' ';
OpCode2 := 0;
END;
'X' :
BEGIN
Result := OpCode1 XOR OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
IF TempS[0] > #8 THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END
ELSE
TempS1 := TempS;
END;
'O' :
BEGIN
Result := OpCode1 OR OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
IF TempS[0] > #8 THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END
ELSE
TempS1 := TempS;
END;
'N' :
BEGIN
Result := OpCode1 AND OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
IF TempS[0] > #8 THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END
ELSE
TempS1 := TempS;
END;
'T' :
BEGIN
Result := NOT OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
IF TempS[0] > #8 THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END
ELSE
TempS1 := TempS;
END;
'R' :
BEGIN
Result := OpCode1 SHR OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
IF TempS[0] > #8 THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END
ELSE
TempS1 := TempS;
END;
'H' :
BEGIN
Result := OpCode1 SHL OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
IF TempS[0] > #8 THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END
ELSE
TempS1 := TempS;
END;
'*' :
BEGIN
Result := OpCode1 * OpCode2;
Operand := ' ';
Res := TRUE;
IF Result < 0 THEN
Negative := TRUE
ELSE
Negative := FALSE;
TempS2 := '';
OpCode1 := Result;
Str(Abs(Result), TempS);
TempS1 := TempS;
IF (Abs(Result) < Abs(OpCode1)) OR (Abs(Result) < Abs(OpCode2)) OR
(Length(TempS) > 8) THEN
BEGIN
Res:= FALSE;
OpCode1 := 0;
OpCode2 := 0;
TempS1 := '';
Negative := FALSE;
END;
END;
END;
END;

PROCEDURE IncBinary(TC : CHAR);

VAR
TB1, TB2, I, J, K : BYTE;
S : ARRAY[1..8] OF CHAR;

BEGIN
CASE Operand OF
' ' : I := BYTE(OpCode1)
ELSE
I := BYTE(OpCode2);
END;
IF (Abs(I) < 128) THEN
BEGIN
IF Negative THEN
CASE Operand OF
' ' : OpCode1 := OpCode1 * -1
ELSE
OpCode2 := OpCode2 * -1
END;
CASE Operand OF
' ' : TB1 := BYTE(OpCode1)
ELSE
TB1 := BYTE(OpCode2);
END;
TB2 := TB1;
FOR I := 2 TO 8 DO
BEGIN
S[I] := Chr((TB1 MOD 2)+48);
TB1 := TB1 DIV 2;
IF TB1 = 0 THEN
BREAK;
END;
IF TB2 = 0 THEN
Dec(I);
S[1] := C;
TB1 := 0;
FOR J := I DOWNTO 1 DO
BEGIN
TB2 := 1;
FOR K := 1 TO J-1 DO
TB2 := TB2*2;
TB1 := TB1+((Ord(S[J])-48)*TB2);
END;
CASE Operand OF
' ' :
BEGIN
OpCode1 := TB1;
Str(TB1, TempS1);
END
ELSE
BEGIN
OpCode2 := TB1;
Str(TB1, TempS2);
END;
END;
END;
END;

PROCEDURE IncHexa(TC : CHAR);

VAR
TB1, TB2, I, J, K : LONGINT;
S : ARRAY[1..8] OF CHAR;

BEGIN
CASE Operand OF
' ' : I := OpCode1
ELSE
I := OpCode2;
END;
IF (Abs(I) < $100000) THEN
BEGIN
IF Negative THEN
CASE Operand OF
' ' : OpCode1 := OpCode1 * -1
ELSE
OpCode2 := OpCode2 * -1
END;
CASE Operand OF
' ' : TB1 := OpCode1
ELSE
TB1 := OpCode2;
END;
TB2 := TB1;
FOR I := 2 TO 8 DO
BEGIN
IF (TB1 MOD 16) IN [0..9] THEN
S[I] := Chr((TB1 MOD 16)+48)
ELSE
S[I] := Chr((TB1 MOD 16)+55);
TB1 := TB1 DIV 16;
IF TB1 = 0 THEN
BREAK;
END;
IF TB2 = 0 THEN
Dec(I);
S[1] := UpCase(C);
TB1 := 0;
FOR J := I DOWNTO 1 DO
BEGIN
TB2 := 1;
FOR K := 1 TO J-1 DO
TB2 := TB2*16;
IF S[J] IN ['0'..'9'] THEN
TB1 := TB1+((Ord(S[J])-48)*TB2)
ELSE
TB1 := TB1+((Ord(S[J])-55)*TB2)
END;
CASE Operand OF
' ' :
BEGIN
OpCode1 := TB1;
Str(TB1, TempS1);
END
ELSE
BEGIN
OpCode2 := TB1;
Str(TB1, TempS2);
END;
END;
END;
END;

BEGIN
SaveScreen;
HideCursor;
InitView;
Mode := 1;
Operand := ' ';
TempS1 := '';
TempS2 := '';
OpCode1 := 0;
OpCode2 := 0;
Negative := FALSE;
Res:= TRUE;
REPEAT
UpDateView;
C := ReadKey;
IF C = #0 THEN
BEGIN
 C := ReadKey;
C := #0;
END;
CASE C OF
'0'..'1' :
CASE Mode OF
0 : IncBinary(C);
2 : IncHexa(C);
1 :
BEGIN
IF ((Operand = ' ') AND (Length(TempS1) < 8)) OR ((Operand <> ' ') AND (Length(TempS2) < 8)) THEN
BEGIN
CASE Operand OF
' ' :
BEGIN
IF TempS1 <> '0' THEN
TempS1 := TempS1 + C
ELSE
TempS1 := C;
END
ELSE
IF TempS2 <> '0' THEN
TempS2 := TempS2 + C
ELSE
TempS2 := C;
END;
END;
END;
END;
'2'..'9' :
IF (Mode > 0) THEN
BEGIN
CASE Mode OF
1 :
BEGIN
IF ((Operand = ' ') AND (Length(TempS1) < 8)) OR ((Operand <> ' ') AND (Length(TempS2) < 8)) THEN
BEGIN
CASE Operand OF
' ' :
BEGIN
IF TempS1 <> '0' THEN
TempS1 := TempS1 + C
ELSE
TempS1 := C;
END
ELSE
IF TempS2 <> '0' THEN
TempS2 := TempS2 + C
ELSE
TempS2 := C;
END;
END;
END;
2 : IncHexa(C);
END;
END;
'A'..'F', 'a'..'f' :
IF (Mode = 2) THEN
IncHexa(C);
'S', 's' : Negative := NOT Negative;
'*', '+', '-', 'N', 'O', 'X', 'T', 'H', 'R', 'I', 'M',
'n', 'o', 'x', 't', 'h', 'r', 'i', 'm' :
BEGIN
IF Res THEN
BEGIN
Operand := UpCase(C);
Negative := FALSE;
END;
END;
#9 :
BEGIN
Inc(Mode);
IF Mode = 3 THEN
Mode := 0;
CASE Operand OF
' ' :
BEGIN
TempS1 := '';
OpCode1 := 0;
END
ELSE
BEGIN
TempS2 := '';
OpCode2 := 0;
END;
END;
Negative := FALSE;
Res:= TRUE;
END;
'L', 'l' :
BEGIN
CASE Operand OF
' ' : TempS1 := ''
ELSE
TempS2 := '';
END;
Negative := FALSE;
Res:= TRUE;
END;
#13, '=' :
IF Operand <> ' ' THEN
GetResult;
END;
CalcNumbers;
IF Negative THEN
CASE Operand OF
' ' : OpCode1 := OpCode1 * -1
ELSE
OpCode2 := OpCode2 * -1
END;
UNTIL C = #27;
ShowCursor;
RestoreScreen;
END;
