{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit NetTypes;
{ **************************************************************************
  27.05.1996 : Ich habe den Typ "tAddressChain" und den korrespondierenden
               Zeiger "pAddressChain" hinzugefgt.
  ************************************************************************** }

INTERFACE
{ ************************************************************************** }
{ *** Konstanten                                                   (IPX) *** }
{ ************************************************************************** }
Type
 tStr12 = String[12];
 pStr12 = ^tStr12;
Const
                          PROT_IPX = 1;          { Das IPX-Protokoll }
                      PROT_NETBIOS = 2;          { Das NetBIOS-Protokoll }
                PROT_ETHERIIPACKET = 3;          { Das Ethernet-II-Packet-Protokoll }

                       NetAddrSize = 20;

Type
{ ************************************************************************** }
{ *** NetBIOS-Spezifische Typen                                          *** }
{ ************************************************************************** }

   tWordRec = Record
        Hi, Lo : Byte;
              End;

 tIPAddress = Record
        Hi, Lo : tWordRec;
              End;

 tNetBiosName = Array[1..16] of Char;
 pNetBiosName = ^tNetBiosName;

 tExtNetBiosName = Record
                   Name : tNetBiosName;
             NameNumber : Byte;
             NameStatus : Byte; { Bit patterns are:
                                   *  G----000 - name add in progress
                                   *  G----100 - active name
                                   *  G----101 - delete pending
                                   *  G----110 - improper duplicate name
                                   *  G----111 - duplicate name, delete
                                                 pending }
                   End;


        pByteArray = ^tByteArray;
        tByteArray = Array[0..0] of Byte;        { Ein Zeiger auf ein Byte-Array }


    pNode = ^tNode;
    tNode = Array[0..5] of Byte;

   tNetWork = LongInt;
    tSocket = Word;
 pIpxPacket = ^tIpxPacket;


    tIPXFragment = Record
            Data : pIpxPacket;
            Size : Word;
                End;

 pIpxIdStruct = ^tIpxIdStruct;
 tIpxIdStruct = Record
         Network : tNetWork;
            Node : tNode;
          Socket : tSocket;
                End;


 pNetBIOSIdStruct = ^tNetBIOSIdStruct;
 tNetBIOSIdStruct = Record
                             NetBiosName : tNetBIOSName;
                     MainGroupNameNumber : Byte;
                         IsTrueGroupName : Boolean;
                            MyNameNumber : Byte;

                End;


{ ************************************************************************** }
{ *** Dieser Datentyp wird verwendet um EINE Addresse zu speichern       *** }
{ ************************************************************************** }


 pNetworkIDStruct = ^tNetworkIdStruct;
 tNetWorkIDStruct = Record
                     Case NetType : Byte of
                    FALSE : (  FirstByteOfAddress : Byte );
                 Prot_IPX : ( IpxAddress : tIpxIdStruct;
                             IpxTagBytes : Array[1..8] of Byte);
             Prot_NetBIOS : ( NetBIOSAddress : tNetBIOSIdStruct;
                              NetBIOSTagByte : Byte);
       PROT_EtherIIPacket : ( EtherIIAddress : tNode;
                            EtherIITagBytes : Array[1..14] of Byte);

                    End;

{ ************************************************************************** }
{ *** Dieser Typ wird verwendet, um ALLE Addressen einer Station zu speichern}
{ ************************************************************************** }

 tByteArray20 = Array[1..20] of Byte;
 pCompleteNetworkIDStruct = ^tCompleteNetworkIDStruct;
 tCompleteNetworkIDStruct = Record
 Case Boolean of
  1 : (        IpxAddress : tIpxIDStruct;
              IpxTagBytes : Array[1..8] of Byte;

           NetBIOSAddress : tNetBIOSIdStruct;
           NetBIOSTagByte : Byte;

           EtherIIAddress : tNode;
          EtherIITagBytes : Array[1..14] of Byte;
           );
  2 : ( Addresses : Array[1..3]  of tByteArray20 );
                    End;


{ ************************************************************************** }
{ *** Dies wird verwendet, um mehrere Stationsaddressen zu speichern    **** }
{ ************************************************************************** }
   pAddressChain = ^tAddressChain;
   tAddressChain = Record
                 pNext : pAddressChain;
               Address : tCompleteNetworkIDStruct;
            MiscNumber : Word;
                   End;

{ ************************************************************************** }
{ *** Die Header-Typen                                                  *** }
{ ************************************************************************** }
      tIPXHeader = Record
              CheckSum : Word;
                Length : Word;
      TransportControl : Byte;
            PacketType : Byte;
        DestinationNet : tIpxIdStruct;
             SourceNet : tIpxIdStruct;
                End;

    pIpHeader = ^tIpHeader;
    tIPHeader = Record
  VersionAndHeaderLength : Byte;                 { Version & Headerlnge (Lo-Nibble : Version, Hi-Nibble : Lnge) }
           TypeOfService : Byte;                 { Der Type Of Service (TOS) }
            PacketLength : Word;                 { Meine gesamte Paket-Lnge }
          Identification : LongInt;              { ID des Pakets ! }
  FlagsAndFragmentOffset : Word;                 { Bits 1 - 3 -> Flags, Bits 4-16 -> Fragment-Offset }
              TimeToLive : Byte;                 { ES LEBT !}
{ Anm. Klein halten da ich viel Broadcaste ... }
                ProtoCol : Byte;                 { Das Protokoll (Bei mir UDP (17)) }
                CheckSum : Word;                 { Die Header-Checksumme }
                SourceIP : tIPAddress;           { Die Quell-IP-Addresse }
                  DestIP : tIpAddress;           { Die Ziel-IP-Addresse }
              End;

 pUDPHeader = ^tUDPHeader;
 tUDPHeader = Record                             { Wie entsetzlich komplex er doch ist .. }
        IPHeader : tIPHeader;
   UdpSourcePort : Word;
     UdpDestPort : Word;
       UdpLength : Word;
     UdpCheckSum : Word;
              End;


  tEtherIIHeader = Record
          Destination : tNode;
           SourceNode : tNode;
           PacketType : Word;
                   End;


    pProgramHeader = ^tProgramHeader;
    tProgramHeader = Record
                  MyID : Word;                   { Die IDs sind von mir ! }
            DataLength : Word;                   { Die Lnge meines Datenbereiches }
         FromWorkGroup : Word;                   { Das Workgroup-ID des Senders }
   IsIDChar1,ISIDChar2 : Char;                   { Eine Art "Paketerkennung" }
           WhoIsSender : tNetWorkIDStruct;
                     End;



{ ************************************************************************** }
{ *** Die Paket-Typen                                                    *** }
{ ************************************************************************** }



     tIpxPacket = Record
                Header : tIPXHeader;
         ProgramHeader : tProgramHeader;
                  Data : Array[0..0] of Byte;
                  End;

Const
 OFFSET_ISUSED = SizeOf(TEtherIIHeader);         { Der Offset des "IsUsed"-Feldes innerhalb des Paketes }

Type
 pEtherIIPacket = ^tEtherIIPacket;
 tEtherIIPacket = Record
                Header : tEtherIIHeader;
                IsUsed : Byte;                   { Brauch ich, da das Net-Interface sowas nicht hat. }
         ProgramHeader : tProgramHeader;
                  Data : Array[0..0] of Byte;
                  End;

 pNetBIOSPacket = ^tNetBIOSPacket;
 tNetBiosPacket = Record
         ProgramHeader : tProgramHeader;
                  Data : Array[0..0] of Byte;
                 End;

{ ************************************************************************** }
{ *** Die Aufrufstrukturen fr die einzelnen Netzwerktypen               *** }
{ ************************************************************************** }

      pNCB = ^tNCB;
      tNCB = Record
              Command : Byte;                    { Der Netbios-Kommando-Modus }
              RetCode : Byte;                    { Der Return-Code wg. Fehlern }
                  Lsn : Byte;                    { Session-Nummer }
              NameNum : Byte;                    { Namensnummer }
               Buffer : pNetBIOSPacket;          { Zeiger auf den Datenpuffer }
               BufLen : Word;                    { Grsse des Datenpuffers }
             CallName : tNetBiosName;
               MyName : tNetBiosName;
          RecvTimeOut : Byte;
          SendTimeOut : Byte;
          PostRoutine : Pointer;                 { Zeiger auf die Event-Routine }
           AdapterNum : Byte;                    { Adapternummer }
              cmdDone : Byte;                    { $FF bis Kommando ok. }
             Reserved : Array[1..14] of Byte;    { Reserviert }
             End;


    pIpxECbBlock = ^tIpxECbBlock;
    tIpxECbBlock = Record
           LinkAddress : Pointer;   {0}
            EsrAddress : Pointer;   {4}
             InUseFlag : Byte;      {8}
             ErrorCode : byte;      {9}
             SocketNum : tSocket;   {10}
          IPXWorkSpace : LongInt;
       DriverWorkSpace : Array[1..12] of Byte;
      ImmediateAddress : tNode;     {28}
         FragmentCount : Word;      {34}
             Fragments : Array[0..0] of tIPXFragment; {36} {38}
                End;

Const
     IpxEcbStructOfs_Linkaddress = 0;            { Die Offsets der einzelnen Elemente innerhalb des ECB-Blocks }
      IpxEcbStructOfs_Esraddress = 4;
   IpxECBStructOfs_FragmentCount = 34;
IpxECBStructOfs_ImmediateAddress = 28;
       IpxECBStructOfs_SocketNum = 10;

           Fragment0_DataPointer = 38;

Type
 pIPXEcbArray = ^tIPXEcbArray;
 tIPXEcbArray = Array[1..1] of pIpxECbBlock;

Const
 IpxIDStructSizeInWords = 6;
 IpxHeaderOffsetDestiNationNet = 6;


{ ************************************************************************** }
{ *** Maximale Paketgrssenkonstanten                                    *** }
{ ************************************************************************** }

{ ************************************************************************** }




IMPLEMENTATION

End.