{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
; Gendert : "Indos" auch ins Turbo-DS
; Auf passives TSR umgestellt

DATA   segment word public        ;Turbo-Datensegment


DATA       ends                   ;Ende des Datensegments

;== Konstanten =========================================================

I2F_FKT_0  equ 0AAh               ;Code fr INT 2F, Funktion 0 Inst-Check
I2F_FKT_1  equ 0BBh               ;Code fr INT 2F, Funktion 1
I2F_FKT_2 equ 0CCh

TIME_OUT   equ 9                 ;Time-Out fr Aktivierung in Ticks
MYINSTCODE equ 1

;== Programm ===========================================================

CODE       segment byte public    ;das Turbo-Codesegment

           assume cs:CODE, ds:DATA

;-- Public-Deklarationen interner Funktionen ---------------------------

public     tsrinit                ;ermglicht Aufruf aus Turbo-Programm
public     TsrIsInst
public     TSRUNinst
public     TsrCanuninst
public     TsrSetPtr
public     tsrcall


tsraktiv db 0
;-- Variablen fr die Interrupt-Handler --------------------------------
;-- (nur ber das Codesegment zugnglich) ------------------------------

call_ptr   equ this dword
call_ofs   dw 0                   ;Offsetadresse fr TSRCall
call_seg   dw 0                   ;Segmentadresse noch nicht initial.


ds_save    dw 0                   ;Sichern von DS whrend TSR-Call
rptr_save  equ this dword         ;FAR-Pointer fr Rckehr aus TSR-CALL
rip_save   dw 0                   ;Sichern der Rcksprungadresse bei
rcs_save   dw 0                   ;TSR-Call
ret_ax     dw 0                   ;Sichern des Funktionsergebnisses bei
ret_dx     dw 0                   ;TsrCall

;-- Variablen, die zur Aktivierung des Turbo-Prg. bentigt werden ------
                                                                        
t_ss       dw 0                   ;Turbo-Stacksegment
t_sp       dw 0                   ;Turbo-Stackpointer
t_ds       dw 0                   ;Turbo-Datensegment
t_es       dw 0                   ;Turbo-Extrasegment

t_psp      dw 0                   ;Segmentadresse des PSP des Turbo-Prg.

;-- Variablen, zum Test auf die Bettigung des Hotkey ------------------

i2F_code   db 0                   ;Funktionsnummer fr INT 2F

;-- Variablen fr die TSR-Aktivierung ----------------------------------

;-- die folgenden Variablen nehmen die alten Adressen der Interrupt- ---
;-- Handler auf, die durch neue Interrupt-Handler ersetzt wurden     ---

int2F_ptr  equ this dword         ;alter Interrupt-Vektor 2Fh
int2F_ofs  dw 0                   ;Offsetadresse des alten Handlers
int2F_seg  dw 0                   ;Segmentadresse des alten Handlers

;-- Variablen, die Informationen ber das unterbrochene Programm -------
;-- aufnehmen                                                    -------

uprg_ss    dw 0                   ;SS und SP des unterbrochenen Prg.
uprg_sp    dw 0

;-----------------------------------------------------------------------
;-- tsrinit: beendet das Turbo-Programm und aktiviert die neuen  -------
;--          Interrupt-Handler
;-- Aufruf von Turbo: procdure tsrinit( PrzPtr   : word; PrzPtr2 : Word
;--                                     ResPara  : word );

tsrinit    proc    near

sframe0    struc                  ;Struktur zum Zugriff auf den Stack
bp0        dw ?                   ;nimmt BP auf
ret_adr0   dw ?                   ;Rcksprungadresse
respara0   dw ?                   ;Anzahl zu reservierender Paragraphen
przptr0    dd ?                   ;Offset der Turbo-TSR-Prozedur
sframe0    ends                   ;Ende der Struktur

frame      equ [ bp - bp0 ]

           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen
           push es                ;ES auf dem Stack sichern

           ;-- die Turbo-Segmentregister sichern -----------------------

           mov  t_ss,ss           ;die Register in den entsprechenden
           mov  t_sp,sp           ;Variablen merken
           mov  t_es,es
           mov  t_ds,ds


           mov  bx,cs             ;CS nach BX trasferieren
           sub  bx,10h            ;10h Paragraphen = 256 Byte abziehen
           mov  t_psp,bx          ;Segmentadresse merken
           ;-- Adresse des INDOS-Flags ermitteln -----------------------
           mov ax, word ptr przptr0
           mov bx, word ptr przptr0 + 2;
;           mov word ptr pasProc, ax
;           mov word ptr PasProc+2, bx


           mov  ah,34h            ;Fkt.nr.: Adresse INDOS-Flag holen
           int  21h               ;DOS-Interrupt aufrufen
           push ds
           mov ds, t_ds
           pop ds
                                                                        
           ;-- die Adressen der umzuleitenden Interrupt-Handler holen --
                                                                        
           mov  ax,352Fh          ;Interrupt-Vektor 2Fh holen
           int  21h               ;DOS-Interrupt aufrufen
           mov  int2F_ofs,bx      ;Adresse des Handlers in den ent-
           mov  int2F_seg,es      ;sprechenden Variablen merken


           ;-- die neuen Interrupt-Handler installieren ----------------

           push ds                ;Datensegment merken
           mov  ax,cs             ;CS nach AX und dann nach DS laden
           mov  ds,ax
                                                                        
           mov  ax,252Fh          ;Fkt.nr.: Interrupt 2Fh setzen
           mov  dx,offset int2F   ;DS:DX nimmt Adresse des Handler auf
           int  21h               ;DOS-Interrupt aufrufen

           pop  ds                ;DS wieder vom Stack kholen
                                                                        
           ;-- Programm resident beenden -------------------------------
                                                                        
           mov  ax,3100h          ;Fkt.nr.: Programm resident beenden
           mov  dx,frame.respara0 ;Anzahl der reservierten Para. holen
           int  21h               ;DOS-Interrupt aufrufen und damit das
                                  ;Programm beenden
                                                                        
tsrinit  endp
                                                                        
;-----------------------------------------------------------------------
;-- TsrIsInst: stellt fest, ob das Programm bereits installiert ist ----
;-- Aufruf von Turbo: function TsrIsInst( i2f_fktnr : byte ) : boolean;
;-- Return-Wert : TRUE, wenn das Programm bereits installiert war,
;--               sonst FALSE

TsrIsInst  proc    near
                                                                        
sframe2    struc                  ;Struktur zum Zugriff auf den Stack
bp2        dw ?                   ;nimmt BP auf
ret_adr2   dw ?                   ;Rcksprungadresse
i2F_code2  dw ?                   ;Funktionsnummer fr INT 2F
sframe2    ends                   ;Ende der Struktur

frame      equ [ bp - bp2 ]

           push bp                ;BP auf dem Stack sichern
           mov  bp,sp             ;SP nach BP bertragen

           mov  ah,byte ptr frame.i2F_code2 ;Fktnr. fr INT 2F
           mov  i2F_code,ah                 ;und sichern
           mov  al,I2F_FKT_0                ;Unterfktnr.
           mov bx, MYINSTCODE
           int  2Fh
           cmp bx, 0FFh
           mov ax, 0
           jne isi_end

           ;-- Segmentadresse der bereits installierten Kopie ermitteln
           mov  ah,i2f_code       ;Nein, Segmentadresse ber INT 2Fh
           mov  al,I2F_FKT_1      ;Unterfunktion 01h laden
           mov bx, MYINSTCODE
           int  2Fh
           mov  call_seg,ax       ;und in Variablen merken
           mov  ax,-1             ;ist installiert

isi_end:   pop  bp                ;BP wieder vom Stack
           ret  2                 ;zurck und Argumente vom Stack

TsrIsInst  endp                   ;Ende der Prozedur

;------------------------------------------------------------MPWnd; Window1:=p^.HWindow; DDC1:=GetDC(Window1);
    x:=round(PntArr[PntNo].destx); y:=round(PntArr[PntNo].desty);
  end;
  SDC:=CreateCompatibleDC(DDC1);
  ThisBMP:=SelectObject(SDC,MorphApp.PntMaskBMP);
  BitBlt(DDC1,x-5-p^.Scroller^.XPos,y-5-p^.Scroller^.YPos,11,11,SDC,0,0,SRCAND);
  if RGBMPWnd<>NIL then begin
    Window2:=RGBMPWnd^.HWindow; DDC2:=GetDC(Window2);
    BitBlt(DDC2,x-5-RGBMPWnd^.Scroller^.XPos,
                y-5-RGBMPWnd^.Scroller^.YPos,11,11,SDC,0,0,SRCAND);
  end;
  ThisBMP:=SelectObject(SDC,BMPH);
  BitBlt(DDC1,x-5-p^.Scroller^.XPos,y-5-p^.Scroller^.YPos,11,11,SDC,0,0,SRCPAINT);
  if RGBMPWnd<>NIL then begin
    BitBlt(DDC2,x-5-RGBMPWnd^.Scroller^.XPos,
                y-5-RGBMPWnd^.Scroller^.YPos,11,11,SDC,0,0,SRCPAINT);
    if Which=DestWindow then begin
      { Draw a dotted line marking the conection between source and dest. point}
      SetROP2(DDC2, r2_MergePen);
      SelectObject(DDC2, MorphApp.ThePen);
      SelectObject(DDC2, GetStockObject(Null_Brush));
      MoveTo(DDC2,round(PntArr[PntNo].srcx)-RGBMPWnd^.Scroller^.XPos,
                  round(PntArr[PntNo].srcy)-RGBMPWnd^.Scroller^.YPos);
      LineTo(DDC2,round(PntArr[PntNo].destx)-RGBMPWnd^.Scroller^.XPos,
                  round(PntArr[PntNo].desty)-RGBMPWnd^.Scroller^.YPos);
    end;
    ReleaseDC(Window2,DDC2);
  end;
  ReleaseDC(Window1,DDC1);
  DeleteDC(SDC);
end;

procedure TMorphWindow.ShowPnts(PntNo:integer; BMPHS,BMPHD: HBitMap);
(* Shows the source and the destination control point with bitmaps BMPHS,BMPHD *)
begin
  ShowPnt(SrcWindow,PntNo,BMPHS);
  ShowPnt(DestWindow,PntNo,BMPHD);
end;

procedure TMorphWindow.ShowAllPnts(BMPHS,BMPHD: HBitMap);
(* Shows all control points *)
var i:integer;
begin
  for i:=0 to NoOfPnts-1 do ShowPnts(i,BMPHS,BMPHD);
end;

procedure TMorphWindow.RedrawAll;
(* Redraws all defined bitmap windows *)
begin
  if SrcBMPWnd<>NIL then SrcBMPWnd^.Redraw(Nil);
  if DestBMPWnd<>NIL then DestBMPWnd^.Redraw(Nil);
  if RGBMPWnd<>NIL then RGBMPWnd^.Redraw(Nil);
  if MorphBMPWnd<>NIL then MorphBMPWnd^.Redraw(Nil);
end;


procedure TMorphWindow.SetPercentage(per:single);
(* Sets the window title to "Morph (Frame xx of yy: zz%)", where
   xx=FrameNo, yy=FramesToCalc and zz=per. IF per is less than 0,
   the window title is set to "morph". *)
var s,buf:string;
    peri:integer;
const oldper:integer=-1;
begin
  peri:=round(per);
  if peri<>oldper then begin
    if peri<0 then buf:='Morph'+#0
    else begin
      str(FrameNo,s);
      str(FramesToCalc,buf);
      s:='Morph (Frame '+s+' of '+buf+':';
      str(peri:3,buf);
      buf:=s+buf+'%)'+#0;
    end;
    SetWindowText(HWindow,@Buf[1]);
    oldper:=peri;
  end;
end;

PROCEDURE TMorphWindow.CalculateCPAlphaAndR;
(* Calculates the interpolated control points, the "R"s of the
   multiquadratics and the alphas. The results are stored in PntArr.  *)

  FUNCTION CalcSqrR(x,y:SINGLE; i: INTEGER): SINGLE;
  (* Gets the "R"^2 of the multiquadratic *)
  VAR  r,min:SINGLE; j:INTEGER;
  BEGIN
    min:=1E20;
    FOR j:=0 TO NoOfPnts-1 DO IF j<>i THEN WITH PntArr[j] DO BEGIN
      r:=sqr(x-betwx)+sqr(y-betwy); IF r<min THEN min:=r;
    END;
    IF min<10 THEN calcSqrR:=10 ELSE calcSqrR:=min;
  END;

VAR i,j:INTEGER;
    (* arrays to hold variables and "right side" of equations: *)
    alfArr,fArrx,farry:array[0..MaxNoOfPnts-1] of SINGLE;
    A_ij:LONGINT;          (* "Address" into equation matrix          *)
    A: POINTER;            (* Base address of equation matrix         *)
    AHnd: THandle;         (* Handle of memory for equation matrix    *)
BEGIN
  (* Get the memory for the equation matrix:    *)
  AHnd:= GlobalAlloc(gmem_Moveable, NoOfPnts*NoOfPnts*sizeof(SINGLE));
  IF AHnd<>0 THEN BEGIN
    A := GlobalLock(AHnd);
    (* calculate interpolated control points: *)
    FOR i:=0 TO NoOfPnts-1 DO WITH PntArr[i] DO BEGIN
      betwx:=SrcCPWeight*srcx + DestCPWeight*destx;
      betwy:=SrcCPWeight*srcy + DestCPWeight*desty;
    END;
    (* calculate "R"^2: *)
    IF NoOfPnts=1 THEN PntArr[0].SqrR:=sqr(MorphBMPWnd^.width)
    ELSE FOR i:=0 TO NoOfPnts-1 DO WITH PntArr[i] DO
      SqrR:=calcSqrR(betwx,betwy,i);
    (* set up matrix and vectors to solve *)
    A_ij:=LONGINT(A);                           (* initialise address *)
    FOR i:=0 TO NoOfPnts-1 DO WITH PntArr[i] DO BEGIN
      fArrx[i]:=srcx-betwx;        (* the "b" of Ax=b for x component *)
      fArry[i]:=srcy-betwy;        (* the "b" of Ax=b for y component *)
      FOR j:=0 TO NoOfPnts-1 DO BEGIN           (* the A[i,j] of Ax=b *)
        fptr(A_ij)^:= 1/(SqrR+sqr(betwx-PntArr[j].betwx)+
                              sqr(betwy-PntArr[j].betwy));
        INC(A_ij,sizeof(SINGLE));               (* increment pointer  *)
      END;
    END;
    (* solve the equations and copy results to PntArr[i].alfxS,alfyS  *)
    IF Solve(NoOfPnts,A,@fArrx,@alfArr) THEN
      FOR i:=0 TO NoOfPnts-1 DO PntArr[i].alfxS:=alfArr[i];
    IF Solve(NoOfPnts,A,@fArry,@alfArr) THEN
      FOR i:=0 TO NoOfPnts-1 DO PntArr[i].alfyS:=alfArr[i];

    IF NOT onlywarp THEN BEGIN
      (* Same procedure for mapping to dest. picture. Solve the
         equations and copy results to PntArr[i].alfxD,alfyD          *)
      FOR i:=0 TO NoOfPnts-1  DO BEGIN
        fArrx[i]:=PntArr[i].destx-PntArr[i].betwx;
        fArry[i]:=PntArr[i].desty-PntArr[i].betwy;
      END;
      IF Solve(NoOfPnts,A,@fArrx,@alfArr) THEN
        FOR i:=0 TO NoOfPnts-1 DO PntArr[i].alfxD:=alfArr[i];
      IF Solve(NoOfPnts,A,@fArry,@alfArr) THEN
        FOR i:=0 TO NoOfPnts-1 DO PntArr[i].alfyD:=alfArr[i];

    END;
    GlobalUnlock(AHnd); GlobalFree(AHnd);   (* release windows memory *)
  END; (* AHnd<>0 *)
END;

destructor TMorphWindow.done;
(* Kills existing children and itself *)
begin
  TileChildren; (* If not, program hangs up, if one child is maximized.
                   I dont know why, maybe a bug in Windows. *)
  if SrcBMPWnd<>Nil then SrcBMPWnd^.Done;
  if DestBMPWnd<>Nil then DestBMPWnd^.Done;
  if RGBMPWnd<>Nil then RGBMPWnd^.Done;
  if MorphBMPWnd<>Nil then MorphBMPWnd^.Done;
  inherited done;
end;

{ ----------------------------------- Methods of TMorphApp -----------------------------------------}

procedure TMorphApp.InitMainWindow;
{ Create the application's main window. }
begin
  MainWindow := New(PMorphWindow, Init('Morph',LoadMenu(HInstance, 'MainMenu')));
  SrcCursor:=LoadCursor(HInstance,'SrcCursor');
  DestCursor:=LoadCursor(HInstance,'DestCursor');
  SrcPntBMP:=LoadBitMap(HInstance,'SrcPntBitMap');
  DestPntBMP:=LoadBitMap(HInstance,'DestPntBitMap');
  MarkPntBMP:=LoadBitMap(HInstance,'MarkPntBitMap');
  SelectPntBMP:=LoadBitMap(HInstance,'SelectPntBitMap');
  PntMaskBMP:=LoadBitMap(HInstance,'PntMaskBitMap');
  ThePen := CreatePen(ps_Solid, 1, $00FFFFFF);
end;

function TMorphApp.IdleAction: boolean;
(* If background working needed, call the morph process for one line, else do not! *)
begin
  with PMorphWindow(MainWindow)^ do begin
    if IsCalculatingMorph then begin
      CalculateOneMorphLine;
      IdleAction:=true;
    end else  IdleAction:=false;
  end;
end;

destructor TMorphApp.Done;
begin
  DestroyCursor(SrcCursor);
  DestroyCursor(DestCursor);
  DeleteObject(SrcPntBMP);
  DeleteObject(DestPntBMP);
  DeleteObject(MarkPntBMP);
  DeleteObject(PntMaskBMP);
  DeleteObject(SelectPntBMP);
  DeleteObject(ThePen);
  inherited done;
end;


begin
  MorphApp.Init('MORPH');
  MorphApp.Run;
  MorphApp.Done;
end.
                                          EUtM 6 >    3P  6   t   3ҨuBuB  ]M˸L!Y[33ۣ tt&    >  tF   t6
  2 M    A   8 3P SPPP   L! t3    PS30:rKuPortions Copyright (c) 1983,92 BorlandEUF ]Mr  EUFN^
]Mr  EU P   &  &
 ; u]MEU3PP  u &; s& &
 ; u]MtP~; rH sE>  t ~ ;wH C s&~!