{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit SoundRec;
INTERFACE
Uses Dos,
     Crt,
   SbDsp,
ProgVars,
SendProc,
   Video,
 Screens;



Const
        SoundNullByte = 128;                     { Das Byte fr die SB, das "0" (Aus) ist ! }

             SND_NONE = 0;
             SND_IDLE = 0;                       { Das Sound-System ist inaktiv }
          SND_PLAYING = 1;                       { Das Sound-System spielt Daten ab }
        SND_RECORDING = 2;                       { Das Sound-System nimmt Daten auf }
       SND_PLAYRECORD = 3;


             DST_NONE = 0;                       { Mgliche Ziele einer Aufnahme }
              DST_HDD = 1;
     DST_NETBROADCAST = 2;

             SRC_NONE = 0;                       { Mgliche Quellen eines abgespielten Blockes }
              SRC_HDD = 1;
     SRC_NETBROADCAST = 2;



       Snd_CurrentJob : Byte = SND_IDLE;         { Das Sound-System ist im Begriff nichts zu machen ... }
       SND_CurrSource : Byte = SRC_NONE;
         SND_CurrDest : Byte = DST_NONE;


{        DataBlockSize : Word = SmallestDriverMTU;{ Die minimalste MTU entspricht dem Datenblockumfang }
        DataBlockSize = 480;


             MaxBlock = 4;
            UsedBlock : Array[1..MaxBlock] of Boolean = (FALSE,FALSE,FALSE,FALSE);
      WriteOKForBlock : Array[1..MaxBlock] of Boolean = (FALSE,FALSE,FALSE,FALSE);

            CurrBlock : Byte = 1;
           WriteBlock : Byte = 1;


             DataFreq = 8000;
       STD_SAMPLEFREQ = 8000;


Type
  tByteArray  = Array[1..DataBlockSize] of Byte;
  pByteArray  = ^tByteArray;


Var
 RecordDataBLocks : Array[1..MaxBlock] of pByteArray;
   PlayDataBLocks : Array[1..MaxBlock] of pByteArray;

Var
      RecBytePtr : ^Byte;                        { Zeiger auf ein Byte (Aufnehmen) }
      PlyBytePtr : ^Byte;                        { Zeiger auf ein Byte (Abspielen) }

  RecInBlockPosition : Word;                        { ein Zhler }
  PLyInBlockPosition : Word;                        { ein Zhler }

 CurrentRecBuffer : Byte;                        { Der gerade aktive Aufnahme-Puffe r}
         TimerOld : Pointer;                     { Zeiger auf die alte Timer-Interruptroutine }



PROCEDURE StartReadData(Destination : Byte );
Procedure StopReadData;

Procedure StartPLayData( Source : Byte );
Procedure StopPLayData;


IMPLEMENTATION

 {$F+}
Var
 RecBytePtr2 : ^Byte;



PROCEDURE TimerInterruptForRecord; Interrupt;
Var
 TempBuffer : Byte;
Begin
 RecBytePtr^ := MyReadDirect;


 If (RecBytePtr2^ - RecBytePtr^) < -10 then RecBytePtr^ := RecBytePtr^ - 5;
 If (RecBytePtr2^ - RecBytePtr^) > 10 then RecBytePtr^ := RecBytePtr^ + 5;

 IF RecInBlockPosition = DataBlockSize THEN                       { Datenblock abgespielt? }
  Begin
   RecInBlockPosition := 0;
   TempBuffer := CurrentRecBuffer;

   CurrentRecBuffer := (1 - CurrentRecBuffer) + 1;

   RecBytePtr := @(RecordDataBlocks[CurrentRecBuffer]^[1]);
   Case Snd_CurrDest of
              DST_HDD : Begin
                         WriteOkForBlock[TempBuffer] := TRUE;
                        ENd;
     DST_NETBROADCAST : Begin
                         SendAll(SPEECHDATA,NIL,@RecordDataBlocks[TempBuffer]^[1],DataBlockSize);
                        End;
   End;
  End
 ELSE                                                               { nein }
  BEGIN
    Inc(RecInBlockPosition);                                         { Zhler erhhen }
    RecBytePtr2 := Pointer(RecBytePtr);
    RecBytePtr := Ptr(Seg(RecBytePtr^), Ofs(RecBytePtr^)+1); { nchstes Byte holen }
   END;

 Port[$20] := $20;                              { Interruptroutine beenden }
 If TimerCount > 0 then
  Begin
   Dec(TimerCount);
  End
 Else
   Begin
   TimerCount := TimerCountFrom;
   asm
    pushf
    call [TimerOld]
   End;
  End;
END;

Procedure TimerInterruptForPlay; Interrupt;
BEGIN
 If UsedBlock[CurrBlock] then
 Begin
  MyWriteDirect(PlyBytePtr^);

  IF PlyInBlockPosition = DataBlockSize - 1 THEN                  { Datenblock abgespielt? (-1, da letztes Byte immer = 0) }
   Begin
    UsedBlock[CurrBlock] := FALSE;
    If CurrBlock = MaxBlock then CurrBlock := 1 else Inc(CurrBlock);
    PLyBytePtr := @PlayDataBlocks[CurrBlock]^[1];
    PlyInBlockPosition := 0;
   End
  ELSE                                           { nein }
   BEGIN
    Inc(PlyInBlockPosition);                                 { Zhler erhhen }
    Inc(LongInt(PlyBytePtr));                       { nchstes Byte holen (auch korrekt mit Segmentbertrag !) }
   END;
  End
 else
  Begin
   If CurrBlock = MaxBlock then CurrBlock := 1 else Inc(CurrBlock);
   PlyBytePtr := @PlayDataBlocks[CurrBlock]^[1];
   WriteDirect(128)
  End;

 Port[$20] := $20;                              { Interruptroutine beenden }
 If TimerCount > 0 then
  Begin
   Dec(TimerCount);
  End
 Else
  Begin
   TimerCount := TimerCountFrom;
   asm
    sti
    pushf
    call [TimerOld]
   End;
  End;
END;


Procedure StopReadData;
Var
 Lauf1 : Word;
Begin

 If Snd_CurrentJob = SND_RECORDING then
  Begin
   Snd_CurrentJob := SND_IDle;
   SetOrigFreq;             { Original-Frequenz fr den Timer einstellen }
{   SetTimerWord(OldTimerValue); { Dem alten Timer-Wert wiederherstellen }
   SetIntVec($08, TimerOld);                 { alte Timer-Routine setzen }
   Speaker_Off;                              { Lautsprecher aus }
   Case Snd_CurrDest of
              DST_HDD : Begin
                        ENd;
     DST_NETBROADCAST : Begin
                         SendAll(SPEECHDATASTOP,NIL,NIL,0);
                        End;
   End;

   For Lauf1 := 1 to 4 do FreeMem(RecordDataBlocks[Lauf1],SizeOf(tByteArray));
  End
 Else
  Begin
   MessageBox(10,3,60,3,'Das Sound-System ist nicht aktiv !');
   ReadKey;
  End;
End;

PROCEDURE StartReadData(Destination : Byte );
Var
 Lauf1 : Word;
BEGIN
 If Snd_CurrentJob = SND_IDLE then
  Begin
   For Lauf1 := 1 to 4 do GetMem(RecordDataBlocks[Lauf1],SizeOf(tByteArray));
   Snd_CurrentJob := SND_Recording;
     Snd_CurrDest := Destination;

   { *** Je nach Ziel der bertragung unterschiedliche INitialisierung *** }
   Case Destination of
              DST_HDD : Begin
                        ENd;
     DST_NETBROADCAST : Begin
                         SendAll(SPEECHDATASTART,NIL,NIL,0);
                        End;
   End;

   CurrentRecBuffer := 1;
   InitDSP;                                      { DSP initialisieren }
   Speaker_On;                                   { Lautsprecher ein }
   GetIntVec($08, TimerOld);                     { alten Timer-Interrupt sichern }
   SetIntVec($08, @TimerInterruptForRecord);     { Timer-Interrupt umlenken }
   SetTimerFreq(STD_SAMPLEFREQ);                 { Timer-Frequenz einstellen }
   RecBytePtr := @RecordDataBlocks[1]^[1];

   RecInBlockPosition := 0;
   { Nun den Faktor berechnen, mit dem der alte Interrupt aufgerufen werden soll. }
   TimerCountFrom := STD_SAMPLEFREQ div 18;  { 18 -> Alte Frequenz ... }
   TimerCount := TimerCountFrom;
  End
 Else
  Begin
   MessageBox(10,3,60,3,'Das Sound-System ist bereits aktiv !');
   Readkey;
  End;
END;


Procedure StartPLayData( Source : Byte );
Var
 Lauf1 : Word;
Begin
 For Lauf1 := 1 to 4 do
  Begin
   GetMem(PlayDataBlocks[Lauf1],SizeOf(tByteArray));
   FillChar(PLayDataBlocks[Lauf1]^,SizeOf(tByteArray),SoundNullByte);
  End;
 Snd_CurrentJob := SND_PLaying;
 InitDSP;                                        { DSP initialisieren }
 Speaker_On;                                     { Lautsprecher ein }
 GetIntVec($08, TimerOld);                       { alten Timer-Interrupt sichern }
 SetTimerFreq(DataFreq);                         { Timer-Frequenz einstellen }
 PlyBytePtr := @PlayDataBlocks[1]^[1];
 PlyInBlockPosition := 0;
 TimerCountFrom := DataFreq div 18;  { 18 -> Alte Frequenz ... }
 TimerCount := TimerCountFrom;
 SetIntVec($08, @TimerInterruptForPLay);              { Timer-Interrupt umlenken }
End;

Procedure StopPLayData;
Var
 Lauf1 : Word;
begin
 Snd_CurrentJob := SND_IDle;

{ SetTimerWord(OldTimerValue);                    { Dem alten Timer-Wert wiederherstellen }
 SetIntVec($08, TimerOld);                       { alte Timer-Routine setzen }
 Speaker_Off;                                    { Lautsprecher aus }
 For Lauf1 := 1 to 4 do FreeMem(PlayDataBlocks[Lauf1],SizeOf(tByteArray));
End;



End.

