{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{ **************************************************************************
 Enthlt Routinen, die spezielle Eigenschaften von VideoModi beeinflussen
 Enthalten sind :

  Procedure SetVideoMode( Mode : Word; ClearVideo : Boolean );
  -> Setzt einen bestimmten VideoModus

  Function GetVideoMode : Word;
  -> Liefert den aktuellen Modus zurck

  Function IsTextMode : Boolean;
  -> Ist es ein Textmodus ???

  Function IsVesaMode( Mode : Word ) : Boolean;
  -> Ist es ein VESA-Modus ???
  
 ************************************************************************** }

Procedure SetVideoMode( Mode : Word; ClearVideo : Boolean );
Begin
 If Mode <> $9 then
  Begin
Asm
 Cmp Mode, 256
 JB @KeinVESAModus                          { JB mit unsigned Jump Below }
 Jmp @VESAMODUS                             { Inveser Sprung, da mehr als 127 Bytes }
 @KeinVESAModus:
 Mov Ax, Mode
 And Ax, BIT_7
 Cmp Ax, 0
 Je @PruefenObClearVideoWahr
 Cmp ClearVideo, 0
 Jne @NichtsSetzen
 Jmp @BIT7Setzen
 @PruefenObClearVideoWahr:
 Cmp ClearVideo, 0
 Je @NichtsSetzen
 @BIT7Setzen:
 Mov Ax, Mode
 Or Ax, BIT_7
 @NichtsSetzen:
{ Konstrukt entspricht :
   If ((Mode and BIT_7 = 0) and (ClearVideo = TRUE)) or
      ((Mode and BIT_7 <> 0) and (ClearVideo = FALSE)) then Mode := Mode or BIT_7; }

 Mov Ah, 0                                  { AH = 0 -> Modus setzen }
 Mov Al, Byte Ptr Mode
 Int $10
 Jmp @AllesZuEnde
 @VESAModus:
 Mov Ax, Mode
 And Ax, BIT_15
 Cmp Ax, 0
 Je @PruefenObClearVideoWahrVESA
 Cmp ClearVideo, 0
 Jne @NichtsSetzenVESA
 Jmp @BIT15SetzenVESA
 @PruefenObClearVideoWahrVESA:
 Cmp ClearVideo, 0
 Je @NichtsSetzenVESA
 @BIT15SetzenVESA:
 Mov Ax, Mode
 Or Ax, BIT_15
 @NichtsSetzenVESA:
{ Konstrukt enstricht :
   If ((Mode and BIT_15 = 0) and (ClearVideo = TRUE)) or
      ((Mode and BIT_15 <> 0) and (ClearVideo = FALSE)) then Mode := Mode or BIT_15; }
 Mov AX, $4F02                                { AX = $4F02 -> Super VGA Modus setzen }
 Mov Bx, Mode
 Int $10
 @AllesZuEnde:
 Mov Ax, Mode
 Mov LastVideoMode, Ax
 End;
 End
Else
 Begin
  SetVideoMode($13,ClearVideo);
  WriteReg(GC_INDEX,GC_GRAPH_MODE,GetReg(GC_INDEX,GC_GRAPH_MODE) and Not(BIT_4));
  WriteReg(GC_INDEX,GC_MISC,GetReg(GC_INDEX,GC_MISC) and Not(BIT_1));
  WriteReg(SC_INDEX,SC_MEM_MODE,GetReg(SC_INDEX,SC_MEM_MODE) and Not(BIT_4));

  WriteReg(REG_CRT,$14,GetReg(REG_CRT,$14) and Not(BIT_6));
  WriteReg(REG_CRT,$17,GetReg(REG_CRT,$17) and BIT_6);


 End;
End;

Function GetVideoMode : Word;
Var
 X : Word;
Begin
 GetVideoMode := XLastVideoMode;
End;

Function GetRealVideoMode : Word;
Begin
 ASM
  cmp VesaSupported, 1                                  { Habe ich eine SVGA-Karte ? }
  jne @NormalerTest
  mov bx, 0
  mov ah, 4Fh                                   { Bei VESA mit VESA-Funktionen den Modus erlangen (Ah = 4F -> VESA fkt.)}
  mov al, 03h                                   { VESA-Modus-Abfrage -> al = 03h }
  Int 10h                                       { Aufrufen ... }
  cmp al, 4Fh                                   { Al = 4Fh -> Fkt. Ok, Al <> $4F -> Fkt. nicht untersttzt }
  jne @NormalerTest                             { Funktion wird nicht untersttzt, normaler Test ! }
  cmp ah, 00h                                   { AH <> 00 -> Funktion nicht erfolgreich. }
  jne @NormalerTest

  Mov LastVideoMode, bx
  mov @result, Bx                             { und den Modus sichern ! }
  Mov Ah, $0F                                   { $0F -> Jetzt die Bildschirmseite "Abfangen" }
  Int 10h
  Mov ah, 0                                     { Hi-Byte lschen }

  jmp @ALLESKLAR
  @NormalerTest:                                 { Dieser Test arbeitet mit den normalen Funktionen }
  Mov Ah, $0F                                    { $0F -> Videomodus (normal) bekommen }
  Int 10h
  Mov ah, 0                                      { Hi-Byte lschen }
  Mov LastVideoMode, Ax
  Mov @Result, ax                              { und in den Videomodus kopieren }
  @ALLESKLAR:
 End;
end;

Function IsTextMode : Boolean;
{ Gibt zurck, ob gerade ein Textmodus (TRUE) oder ein Graphikmodus (FALSE) gesetzt ist.
  Dies wird ber GC, Register Miscellaneous, Bit 0 gemacht }
Begin
 IsTextMode := (GetREG(GC_INDEX,GC_MISC) and BIT_0) = 0;
End;

Function IsVesaMode( Mode : Word ) : Boolean;
Begin
 IsVesaMode := (Mode >= $100) and (Mode <= $11B);
End;

