{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit Video;
INTERFACE

Procedure SaveScreen;
Procedure RestoreScreen;

Type
        pVram = ^VRAm;
         VRam = Array[1..80,1..25] of Word;

Var
       CBuf   : Byte absolute $B800:0000;           { der color Video-RAM }
         Sptr : pVRam;

Const
              REG_CRT = $3D4;                    { Das Indexregister des CRT-Controllers }

Procedure CursorOff;
Procedure CursorOn;

IMPLEMENTATION

Procedure WriteReg( Reg, SubReg : Word; Data : Byte );
Var
 SavReg : Byte;
Begin
 SavReg := Port[Reg];
 Port[Reg] := SubReg;
 Port[Reg+1] := Data;
 Port[Reg] := SavReg;
End;

Function GetReg( Reg, SubReg : Word ) : Byte;
Var
 SavReg : Byte;
Begin
 SavReg := Port[Reg];
 Port[Reg] := SubReg;
 GetReg := Port[Reg+1];
 Port[Reg] := SavReg;
End;
Procedure ModifyCursor(StartScan,StopScan :Byte);
Begin
 WriteReg(REG_CRT,$0A,StartScan );
 WriteReg(REG_CRT,$0B,StopScan);
end;

Procedure CursorOff;
begin
 ModifyCursor(32,0);
end;

Procedure CursorOn;
begin
 ModifyCursor(8,31);   (* default scanning for color adapter set by DOS *)
end;

Function GetStartScanLine : Byte;
Begin
 GetStartScanLine := GetReg(REG_CRT,$0A);
End;

Function GetStopScanLine : Byte;
Begin
 GetStopScanLine := GetReg(REG_CRT,$0B);
End;

Procedure SaveScreen;
Begin
 GetMem(Sptr,SizeOf(VRam));
 Move(Cbuf,Sptr^,4000);
End;

Procedure RestoreScreen;
Begin
 Move(Sptr^,CBuf,4000);
 FreeMem(Sptr,SizeOf(VRam));
End;

End.