{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit PktUnit;
{ ************************************************************************* }
{ ***          Packet Driver Interface Unit for Lantsr (C)              *** }
{ ***                 (C) Daniel von Dincklage                          *** }
{ ************************************************************************* }
{ ***                                                                   *** }
{ *** 10.11.1996 : Unit erstellt.                                       *** }
{ *** 11.11.1996 : Das Erhalten von Paketen ist implementiert.          *** }
{ ***                                                                   *** }
{ ************************************************************************* }
INTERFACE
Uses Dos,Crt,NetTypes,WritePro,FastCop;

{ ************************************************************************* }
{ *** Implementierte Treibeklassen :                                    *** }
{ ***    1 = Ethernet II                                                *** }
{ *******************************************< Ethernet II-Paketaufbau >*** }
{ ***            Byte         Datum                                    *** }
{ ****** }
{ ***             0-5         Zieladdresse                             *** }
{ ***             6-11        Quelladdresse                            *** }
{ ***            12-13        Protokoll-ID                       (!!!) *** }
{ ************************************************************************* }
{ *** Zu implementierende Treibeklassen :                               *** }
{ ***   11 = IEEE 802.3 mit 802.2 Headern  (Funktioniert noch nicht !)  *** }
{ ********************************************< IEEE 802.3-Paketaufbau >*** }
{ ***            Byte         Datum                                    *** }
{ ****** }
{ ***             0-5         Zieladdresse                             *** }
{ ***             6-11        Quelladdresse                            *** }
{ ***            12-13        Paketlnge                         (!!!) *** }
{ ***             14          DSAP-Protokoll-ID                        *** }
{ ***             15          SSAP                                     *** }
{ ***             16          Control                                  *** }
{ ************************************************************************* }
Type

   pBlockArray = ^tBlockArray;
   TBlockArray = Array[1..1] of pEtherIIPacket;

    TCharArray = Array[1..8] of Char;
   tDriverINfo = Record
          DrvFunction : Byte;
              DrvType : Word;
             DrvClass : Byte;
               DrvVer : Word;
               DrvNum : Byte;
              DrvText : pChar;
                 End;

Const
 IDChar1 = 'L';                                  { Identifikationszeichen 1 }
 IDChar2 = 'S';                                  { Identifikationszeichen 2 }

                USED = 1;
                FREE = 0;

{ *** Anders als bei anderen Protokollen sind diese beiden Gren fest ! *** }
  EtherNetPacketSize = 1514;                     { Immer diese Gre bei Ethernet !!! }
    EtherNetDataSize = EtherNetPacketSize - SizeOf(tEtherIIPacket);

   EtherNetIIPacketID : Word = $1234;            { Mein Pakettyp fr Ethernet II }
   EtherNet802p3      : Byte = $12;              { Mein Pakettyp fr Ethernet 802.3 mit 802.2 Headern }

            DriverInt : Byte = 0;                { Mein Paket-Treiber-Interrupt }
 PacketDriverID : TCharArray = ('P','K','T',' ','D','R','V','R'); { Das ID eines Packet-Drivers }

         SendblockNum = 5;                       { Die Anzahl an Sende-Blcken }
      RecieveBlockNum = 5;

           ProcToCall : Pointer = NIL;           { Die aufzurufende Prozedur }

Var

    SwapDirName : tStr12;
     DriverInfo : tDriverInfo;                   { Informationen ber den Paket-Treiber }
         MyNode : tNode;                         { Mein aktueller Node }
       MyHandle : Word;
     SendBlocks : pBlockArray;                   { Die Sende-Strukturen }
  RecieveBlocks : pBlockArray;                   { Die Empfangs-Strukturen }



Procedure CallPacket( Func : Byte; Var Regs : Registers );
{ *** Aufruf des Paket-Treibers fr Funktion "Func" mit dem zu           *** }
{ *** bergebenden Registersatz "Regs"                                   *** }
Procedure WriteDriverInformation;
{ *** Schreibt die Treiberinformationen                                  *** }
Procedure GetPKtInformation;
{ *** Erlangt die Treiberinformationen                                   *** }
Procedure GetAddress( MyHandle : Word; Var MyNode : tNode );
{ *** Kopiert die hiesige Addresse in "MyNode"                           *** }
Procedure WriteAddress( MyHandle : Word );
{ *** Schreibt die Addresse des hiesigen Nodes !                         *** }
Function Send( DataPointer : Pointer; Length : Word  ) : Word;
{ *** Schickt ein Paket mit Daten mit der Lnge "Length" ab. ACHTUNG !!! *** }
{ *** Die Addresssen (Quell+Zieladdresse) und sonstige Infos mssen      *** }
{ *** bereits korrekt eingetragen sein !                                 *** }
{ *** Die Daten des Paketes sind an der Stelle "DataPointer" gesichert.  *** }
Function SendEtherIIPacket(IDNumber:Word;Address:pAddressChain;DataPointer:Pointer;DataLength:Word;WorkGroupBool:Word):Word;
{ *** Schickt eine Ethernet II -Paketsammlung ab                         *** }
Function SendOneEtherIIPacket(IDNumber:Word;Address:pAddressChain;DataPointer:Pointer;DataLength:Word;WorkGroupBool:Word):
                                                                                                                    Word;
{ *** Schickt ein Ethernet II -Paket ab                                  *** }
Procedure InitEtherII;
{ *** Initilaisiert das Ethernet II - System                             *** }
Procedure CloseAccessForEtherNetII( HandleToClose : Word );
{ *** Schliesst ein Handle                                               *** }
Procedure CloseEtherII;
{ *** Schliesst den Lantsr-Treiber                                       *** }
Function CompareEtherIIIDs( ID1, ID2 : pointer ) : Boolean;
{ *** Vergleicht zwei Ethernet - II Addressen                            *** }



IMPLEMENTATION

Function LocateTcpInterrupt : Byte;
{ *** Achtung ! Nur Unit-Intern verwenden !                              *** }
Var
  Lauf1 : Word;
 TestPt : Pointer;
 Regs : Registers;
Begin
 LocateTcpInterrupt := 0;
 For Lauf1 := $60 to $80 do
  Begin
   GetIntVec(Lauf1,TestPt);
   Inc(LongInt(TestPt),3);
   If TCharArray(TestPt^) = PacketDriverID then
    Begin
     { Da ist also ein Treiber. Nun mal sehen, ob er die richtige Klasse hat (1 oder 11) }
     Regs.Ah := 1;
     Regs.Al := $FF;
     Intr(Lauf1,Regs);
     If (Regs.Ch = 1) {or (Regs.Ch = 11)} then
      Begin { Hat die richtige Klasse ! }
       LocateTcpInterrupt := Lauf1;
       Lauf1 := $80;
      End;
    End;
  End;
End;

Procedure CallPacket( Func : Byte; Var Regs : Registers );
Begin
 Regs.Ah := Func;
 Intr(DriverInt,Regs);
End;

Procedure WriteDriverInformation;
Var
 TestPt : Pointer;
  Lauf1 : Word;

Begin
 Writeln('                         --- Treiberinformationen ---');
 With DriverInfo do
  Begin
   Writeln('    Version : ',DrvVer);
   Writeln('     Klasse : ',DrvClass);
   Writeln('        Typ : ',DrvType);
   Writeln('     Nummer : ',DrvNum);
   Writeln(' Funktionen : ',DrvFunction);
  End;
    {	1 == basic functions present.
        2 == basic and extended present.
	5 == basic and high-performance.
	6 == basic, high-performance, extended.
      255 == not installed. }

 Write('       Name : ');
 TestPt := DriverInfo.DrvText;
 Lauf1 := 1;
 While Byte(TCharArray(TestPt^)[Lauf1]) <> 0 do
  Begin
   Write(TCharArray(TestPt^)[Lauf1]);
   Inc(Lauf1);
  End;
 Writeln;
EnD;

Procedure GetPKtInformation;
Var
 MyRegs : Registers;
Begin
 MyRegs.Al := $FF;
 CallPacket(1,MyRegs);
 With MyRegs do
  Begin
   With DriverInfo do
    begin
     DrvFunction := Al;
     DrvType := Dx;
     DrvClass :=Ch;
     DrvVer :=Bx;
     DrvNum := Cl;
     DrvText := Ptr(DS,Si);
    End;
  End;
End;


Procedure GetAddress( MyHandle : Word; Var MyNode : tNode );
Var
 Regs : registers;
Begin
 With Regs do
  Begin
   Bx := MyHandle;
   Cx := 6;
   Es := Seg(MyNode);
   Di := Ofs(MyNode);
   CallPacket(6,Regs);
  End;
End;

Procedure WriteAddress( MyHandle : Word );
Var
  Lauf1 : Word;
Begin
 GetAddress(MyHandle,MyNode);
 Write('   Addresse : ');
 For Lauf1 := 0 to 5 do WriteByte(MyNode[Lauf1]);
End;

{ *** Schickt ein Paket mit Daten mit der Lnge "Length" ab. ACHTUNG !!! *** }
{ *** Die Addresssen (Quell+Zieladdresse) und sonstige Infos mssen      *** }
{ *** bereits korrekt eingetragen sein !                                 *** }
{ *** Die Daten des Paketes sind an der Stelle "DataPointer" gesichert.  *** }
Function Send( DataPointer : Pointer; Length : Word  ) : Word;
Var
 Regs : Registers;
Begin
 With Regs do
  Begin
   DS := Seg(DataPointer^);                      { ES:SI -> Der Puffer }
   Si := Ofs(DataPointer^);
   Cx := Length;                                 { CX -> Lnge }
  End;
 pEtherIIPacket(DataPointer)^.IsUsed := USED;
 CallPacket(4,Regs);                             { Und weg ... }
 pEtherIIPacket(DataPointer)^.IsUsed := FREE;
 If Regs.Flags and fCarry = 0 then Send := 0 else
  Begin
   Send := Regs.Dh;
  End;
End;

Procedure SetRecieveMode( Handle : Word; Mode : Byte );
{ Setzt den Recieve-Mode fr ein bestimmtes Handle (Am besten 6, Alle Pakete) }
Var
 Regs : Registers;
Begin
 With Regs do
  Begin
   Bx := Handle;
   Cx := Mode;
  End;
 CallPacket(20,Regs);
End;

Function StandardGetMemProc( DataSize : Word ) : Pointer; Far;
Var
 Lauf1 : Word;
Begin { Diese Porzedur gibt die Addresse eines freien Blocks zurck. }
{ Write('IN Get. '); }
 If DataSize > EtherNetPacketSize then
  Begin
   StandardGetMemProc := NIL;
   Exit;
  End;

 StandardGetMemProc := NIL;
 For Lauf1 := 1 to RecieveBlockNum do
  Begin
   If RecieveBlocks^[Lauf1]^.IsUsed = FREE then
    Begin
     StandardGetMemProc := RecieveBlocks^[Lauf1];
     RecieveBlocks^[Lauf1]^.IsUsed := USED;
     Lauf1 := RecieveBlockNum;
{     Write('Find !'); }
    End;
  End;

End;

Function CompareEtherIIIDs( ID1, ID2 : pointer ) : Boolean;
Var
 Lauf1 : Word;
 OldDS : Word;

Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

 CompareEtherIIIDs := TRUE;

 For Lauf1 := 0 to 5 do If pNode(ID1)^[Lauf1] <> pNode(ID2)^[Lauf1] then
  Begin
   CompareEtherIIIDs := FALSE;
  ENd;

 Asm
  Mov Ds ,OldDS
 End;
End;


Procedure EtherIIStage1CallGate( IncomingPacket : pEtherIIPacket ); Far;
Var
 Pointer1, Pointer2 : Pointer;
Begin
{   Writeln(' OK -> 1 '); }
 If (ProcToCall <> NIL) and Not(CompareEtherIIIds(@IncomingPacket^.Header.SourceNode,@MyNode)) then
  Begin
{   Writeln(' OK -> 2 ');   }
   Pointer1 := @(IncomingPacket^.ProgramHeader);
   Pointer2 := @(IncomingPacket^.Data);
   Asm
    Push Ds
    Push Es
    Pusha

    Mov Ax, Word Ptr Pointer1
    Mov Bx, Word Ptr Pointer1 + 2
    Mov Cx, Word Ptr Pointer2
    Mov Dx, Word Ptr Pointer2 + 2
    Call ProcToCall

    Popa
    Pop es
    Pop ds
   End;
  End;
 IncomingPacket^.IsUsed := FREE;
End;

{ Die Prozedur, die vom Trteiber aufgerufen wird, wenn etwas anliegt }
Procedure MyCallProc; Far; Assembler;
Asm

 Cmp Ax, 0                                       { Sind die Daten da oder soll Speicher gegeben werden ? }
 Jne @DatenDa                                    { AX <> 0 -> Daten sind da ! }

{ *** Abschnitt 1, Speicher zurckliefern                                *** }
   Mov Ax, seg @Data                             { Ersteinmal das Datensegment initialisieren }
   Mov Ds, Ax
   { CX -> Datenge  }
   Push Cx                                     { Words werden so ber den Stack bergeben }
   Call [StandardGetMemProc]
   { Fkt. Erg ist in DX:AX, mu nach ES:DI }
   Mov Es, Dx
   Mov Di, Ax
   Jmp @Ende                                     { Und Raus ! }

 @DatenDa:
  { Mal schauen, ob berhaupt eine Reciever-Proc da ist. }
   Push Ds                                        { DS retten, da Packet-Treiber Daten in DS:SI zurckgibt }
   Push Si
   Mov Ax, Seg @Data
   Mov Ds, Ax
   Call  [EtherIIStage1CallGate]
 @Ende:
End;

Function OpenAccessForEtherNetII : Word;
Var
 Regs : Registers;
Begin
 With Regs do
  Begin
   With DriverInfo do
    Begin
     Al := DrvClass;
     Bx := DrvType;
     Dl := DrvNum;
     Es := Seg(MyCallproc);
     Di := ofs(MyCallProc);
     Cx := 0;
    End;
  End;
 CallPacket(2,Regs);

 OPenAccessForEtherNetII := Regs.Ax;
End;

Procedure CloseAccessForEtherNetII( HandleToClose : Word );
Var
 Regs : Registers;
Begin
 With Regs do
  Begin
   Bx := HandleToClose;
  End;

 CallPacket(3,Regs);
End;



Function SendOneEtherIIPacket(IDNumber:Word;Address:pAddressChain;DataPointer:Pointer;DataLength:Word;WorkGroupBool:Word):
                                                                                                                     Word;
Var
        Lauf1 : Word;
 CurrentBlock : pEtherIIPacket;
Begin
 CurrentBlock := NIL;
 For Lauf1 := 1 to SendBlockNum do
  Begin
   If SendBlocks^[Lauf1]^.IsUsed = FREE then
    Begin
     SendBlocks^[Lauf1]^.IsUsed := USED;
     CurrentBlock := SendBlocks^[Lauf1];
     Lauf1 := SendBlockNum;
    End;
  End;
 If CurrentBlock = NIL then
  Begin
   SendOneEtherIIPacket := 1;                    { Kein Paket gefunden. Fehlschlag ! }
   Exit;
  end
 Else With CurrentBlock^ do
  Begin
   Header.Destination := Address^.Address.EtherIIAddress; { Das Sendeziel eintragen }
   With ProgramHeader do
    Begin
     MyID := IDNumber;
     FromWorkGroup := WorkGroupBool;
     IsIDChar1 := IdChar1;
     IsIDChar2 := IdChar2;
     With WhoIsSender do                       { Den Sender noch eintragen ... }
      Begin
       NetType := Prot_EtherIIPacket;          { Ich bin ein Ethernet-II-Paket ! }
       WhoIsSender.EtherIIAddress := MyNode;
      End;
    End;
   FastCopy(DataPointer^,Data[0],DataLength); { Nun die bereitgestellten Daten in den ECB kopieren }
   SendOneEtherIIPacket := Send(CurrentBlock,SizeOf(tEtherIIPacket) + DataLength);
  End;
End;

Function SendEtherIIPacket(IDNumber:Word;Address:pAddressChain;DataPointer:Pointer;DataLength:Word;WorkGroupBool:Word):Word;
Var
  Lauf1 : Word;
  OldDS : Word;
Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;
 If Address = NIL then                           { Soll an alle etwas gesendet werden ? }
  Begin
   SendEtherIIPacket := SendOneEtherIIPacket(IdNumber,NIL,DataPointer,DataLength,WorkGroupBool);
  End
 Else
  Begin
   SendEtherIIPacket := 0;
   While Address <> NIL do                       { Alle Addressen abarbeiten }
    Begin
     Lauf1 := SendOneEtherIIPacket(IdNumber,Addr(Address^.Address.EtherIIAddress),DataPointer,DataLength,WorkGroupBool);
     If Lauf1 <> 0 then
      Begin
       SendEtherIIPacket := Lauf1;
       Exit;
      End;
     Address := Address^.pNext;
    End;
  End;
 Asm
  Mov Ds ,OldDS
 End;
End;

Procedure SetSwapDirName;
Const
 hex:array[0..15] of char='0123456789ABCDEF';
Var
 Lauf1 : Word;

Begin
 SwapDirName := '';
 For Lauf1 := 1 to 5 do
  Begin
   SwapDirName := SwapDirName +(hex[(MyNode[Lauf1] shr 4) and $F]);
   SwapDirName := SwapDirName +(hex[MyNode[Lauf1] and $F]);
   If Lauf1 = 4 then SwapDirName := SwapDirName + '.';
  End;
 SwapDirName := SwapDirName + (hex[(MyNode[5] shr 4) and $F]);
End;


Procedure InitEtherII;
Var
  Lauf1 : Word;
  OldDS : Word;
Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

 GetMem(SendBlocks, SendBlockNum * SizeOf(Pointer));
 GetMem(RecieveBlocks, RecieveBlockNum * SizeOf(Pointer));
 For lauf1 := 1 to SendBlockNum do
  Begin
   GetMem(SendBlocks^[Lauf1],EtherNetPacketSize);
   FillChar(SendBlocks^[Lauf1]^,EtherNetPacketSize,0);

   SendBlocks^[Lauf1]^.Header.SourceNode := MyNode;
   SendBlocks^[Lauf1]^.Header.PacketType := EtherNetIIPacketID;
  End;

 For Lauf1 := 1 to RecieveBlockNum do
  Begin
   GetMem(RecieveBlocks^[Lauf1],EtherNetPacketSize);
   FillChar(RecieveBlocks^[Lauf1]^,EtherNetPacketSize,0);
  End;



 GetPktInformation;

 MyHandle := OpenAccessForEtherNetII;            { Und listenen ... }
 SetRecieveMode(MyHandle,6);

 GetAddress(MyHandle,MyNode);

 SetSwapDirName;

 Asm
  Mov Ds ,OldDS
 End;
End;

Procedure CloseEtherII;
Var
  Lauf1 : Word;
  OldDS : Word;
Begin
 Asm
  Mov OldDs, DS
  mov ax,seg @Data                              { DS wieder herstellen, da es durch das Programm nicht OK ist !  }
  Mov Ds, ax
 End;

 CloseAccessForEtherNetII(MyHandle);

 For lauf1 := 1 to SendBlockNum do FreeMem(SendBlocks^[Lauf1],EtherNetPacketSize);
 For Lauf1 := 1 to RecieveBlockNum do FreeMem(RecieveBlocks^[Lauf1],EtherNetPacketSize);

 FreeMem(SendBlocks, SendBlockNum * SizeOf(Pointer));
 FreeMem(RecieveBlocks, RecieveBlockNum * SizeOf(Pointer));

 Asm
  Mov Ds ,OldDS
 End;
End;

{ ************************************************************************* }
Begin
 DriverInt := LocateTCPInterrupt;
 If DriverInt = 0 then
  Begin
   Writeln(' Konnte keinen kompatiblen Paket-Treiber (Typ 1) finden ! ');
   Halt(1);
  End;
End.